/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.FontKit;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewKit;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.Word;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.BNView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LeafView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LineView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageRoot;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ParagraphView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ViewFactory;

public class LayoutKit {
    private static LayoutKit kit = new LayoutKit();

    private LayoutKit() {
    }

    public static LayoutKit instance() {
        return kit;
    }

    public void layoutAllPage(PageRoot root, float zoom) {
        if (root == null || root.getChildView() == null) {
            return;
        }
        Word word = (Word)root.getContainer();
        int dx = 5;
        int dy = 5;
        IView pv = root.getChildView();
        int width = pv.getWidth();
        int visibleWidth = word.getWidth();
        int n = visibleWidth = visibleWidth == 0 ? word.getWordWidth() : visibleWidth;
        if ((float)visibleWidth > (float)width * zoom) {
            dx += (int)((float)visibleWidth / zoom - (float)width - 10.0f) / 2;
        }
        while (pv != null) {
            pv.setLocation(dx, dy);
            dy += pv.getHeight() + 5;
            pv = pv.getNextView();
        }
        root.setSize(width + 10, dy);
        ((Word)root.getContainer()).setSize(width + 10, dy);
    }

    public int layoutPara(IControl control, IDocument doc, DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, ParagraphView para, long startOffset, int x, int y, int w, int h, int flag) {
        int breakType = 0;
        int dx = paraAttr.leftIndent;
        int dy = 0;
        int spanW = w - paraAttr.leftIndent - paraAttr.rightIndent;
        spanW = spanW < 0 ? w : spanW;
        int spanH = h;
        int paraHeight = 0;
        int maxWidth = ViewKit.instance().getBitValue(flag, 3) ? 0 : w;
        boolean firstLine = true;
        IElement elem = para.getElement();
        long lineStart = startOffset;
        long elemEnd = elem.getEndOffset();
        IView prePara = para.getPreView();
        if (prePara == null) {
            spanH -= paraAttr.beforeSpace;
            para.setTopIndent(paraAttr.beforeSpace);
            para.setBottomIndent(paraAttr.afterSpace);
            para.setY(para.getY() + paraAttr.beforeSpace);
        } else {
            if (paraAttr.beforeSpace > 0) {
                int beforeSpace = paraAttr.beforeSpace - prePara.getBottomIndent();
                beforeSpace = Math.max(0, beforeSpace);
                spanH -= beforeSpace;
                para.setTopIndent(beforeSpace);
                para.setY(para.getY() + beforeSpace);
            }
            spanH -= paraAttr.afterSpace;
            para.setBottomIndent(paraAttr.afterSpace);
        }
        boolean keepOne = ViewKit.instance().getBitValue(flag, 0);
        if (spanH < 0 && !keepOne) {
            return 1;
        }
        LineView line = (LineView)ViewFactory.createView(control, elem, elem, 6);
        line.setStartOffset(lineStart);
        para.appendChlidView(line);
        flag = ViewKit.instance().setBitValue(flag, 0, true);
        boolean ss = ViewKit.instance().getBitValue(flag, 1);
        BNView bnView = null;
        int bnViewWidth = -1;
        while (spanH > 0 && lineStart < elemEnd && breakType != 3) {
            if (firstLine && startOffset == elem.getStartOffset() && (bnView = this.createBNView(control, doc, docAttr, pageAttr, paraAttr, para, dx, dy, spanW, spanH, flag)) != null) {
                bnViewWidth = bnView.getWidth();
            }
            int lineIndent = this.getLineIndent(control, bnViewWidth, paraAttr, firstLine);
            if (bnView != null && lineIndent + paraAttr.leftIndent == paraAttr.tabClearPosition && (AttrManage.instance().hasAttribute(elem.getAttribute(), (short)4104) && AttrManage.instance().getParaSpecialIndent(elem.getAttribute()) < 0 || AttrManage.instance().hasAttribute(elem.getAttribute(), (short)4097))) {
                bnView.setX(0);
                lineIndent = bnViewWidth;
                dx = 0;
            }
            line.setLeftIndent(lineIndent);
            line.setLocation(dx + lineIndent, dy);
            breakType = this.layoutLine(control, doc, docAttr, pageAttr, paraAttr, line, bnView, dx, dy, spanW - lineIndent, spanH, elemEnd, flag);
            int lineHeight = line.getLayoutSpan((byte)1);
            if (!(ss || keepOne || spanH - lineHeight >= 0 && line.getChildView() != null && spanW - lineIndent > 0)) {
                breakType = 1;
                para.deleteView(line, true);
                break;
            }
            paraHeight += lineHeight;
            dy += lineHeight;
            lineStart = line.getEndOffset(null);
            maxWidth = Math.max(maxWidth, line.getLayoutSpan((byte)0));
            if (lineStart < elemEnd && (spanH -= lineHeight) > 0) {
                line = (LineView)ViewFactory.createView(control, elem, elem, 6);
                line.setStartOffset(lineStart);
                para.appendChlidView(line);
            }
            keepOne = false;
            firstLine = false;
            bnView = null;
        }
        para.setSize(maxWidth, paraHeight);
        para.setEndOffset(lineStart);
        return breakType;
    }

    public int buildLine(IDocument doc, ParagraphView para) {
        int breakType = 0;
        return breakType;
    }

    public int layoutLine(IControl control, IDocument doc, DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, LineView line, BNView bnView, int x, int y, int w, int h, long maxEnd, int flag) {
        IElement run;
        int leafWidth;
        long start;
        int breakType = 0;
        int dx = 0;
        int dy = 0;
        long pos = start = line.getStartOffset(null);
        IElement elem = line.getElement();
        LeafView leaf = null;
        int lineWidth = 0;
        int lineHeigth = 0;
        int lineHeigthExceptShape = 0;
        boolean keepOne = ViewKit.instance().getBitValue(flag, 0);
        for (int spanW = w; (spanW > 0 && pos < maxEnd || keepOne) && (run = doc.getLeaf(pos)) != null; spanW -= leafWidth) {
            leaf = (LeafView)ViewFactory.createView(control, run, elem, 7);
            line.appendChlidView(leaf);
            leaf.setStartOffset(pos);
            leaf.setLocation(dx, dy);
            breakType = leaf.doLayout(docAttr, pageAttr, paraAttr, dx, dy, spanW, h, maxEnd, flag);
            if ((leaf.getType() == 8 || leaf.getType() == 13) && breakType == 1) {
                line.deleteView(leaf, true);
                breakType = 0;
                break;
            }
            pos = leaf.getEndOffset(null);
            line.setEndOffset(pos);
            leafWidth = leaf.getLayoutSpan((byte)0);
            lineWidth += leafWidth;
            dx += leafWidth;
            lineHeigth = Math.max(lineHeigth, leaf.getLayoutSpan((byte)1));
            if (leaf.getType() != 8 && leaf.getType() != 13) {
                lineHeigthExceptShape = Math.max(lineHeigthExceptShape, leaf.getLayoutSpan((byte)1));
            }
            if (breakType == 1 || breakType == 2 || breakType == 3) break;
            flag = ViewKit.instance().setBitValue(flag, 0, false);
            keepOne = false;
        }
        line.setSize(lineWidth, lineHeigth);
        line.setHeightExceptShape(lineHeigthExceptShape);
        if (breakType == 1) {
            String str = elem.getText(doc);
            long paraStart = elem.getStartOffset();
            str = str.substring((int)(start - paraStart));
            long newPos = (long)FontKit.instance().findBreakOffset(str, (int)(pos - start)) + start;
            this.adjustLine(line, newPos);
        }
        line.layoutAlignment(docAttr, pageAttr, paraAttr, bnView, w, flag);
        return breakType;
    }

    private BNView createBNView(IControl control, IDocument doc, DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, ParagraphView para, int x, int y, int w, int h, int flag) {
        if (paraAttr.listID >= 0 && paraAttr.listLevel >= 0 || paraAttr.pgBulletID >= 0) {
            BNView bnView = (BNView)ViewFactory.createView(control, null, null, 13);
            bnView.doLayout(doc, docAttr, pageAttr, paraAttr, para, x, y, w, h, flag);
            para.setBNView(bnView);
            return bnView;
        }
        return null;
    }

    private void adjustLine(LineView line, long newPos) {
        IView view = line.getLastView();
        int lineWidth = line.getWidth();
        while (view != null && view.getStartOffset(null) >= newPos) {
            IView temp = view.getPreView();
            lineWidth -= view.getWidth();
            line.deleteView(view, true);
            view = temp;
        }
        int leafWidth = 0;
        if (view != null && view.getEndOffset(null) > newPos) {
            view.setEndOffset(newPos);
            lineWidth -= view.getWidth();
            leafWidth = (int)((LeafView)view).getTextWidth();
            view.setWidth(leafWidth);
            lineWidth += leafWidth;
        }
        line.setEndOffset(newPos);
        line.setWidth(lineWidth);
    }

    private int getLineIndent(IControl control, int bnViewWidth, ParaAttr paraAttr, boolean firstLine) {
        if (firstLine) {
            int bnWidth;
            int n = bnWidth = bnViewWidth <= 0 ? 0 : bnViewWidth;
            if (paraAttr.specialIndentValue > 0) {
                return paraAttr.specialIndentValue + bnWidth;
            }
            return bnWidth;
        }
        if (!firstLine && paraAttr.specialIndentValue < 0) {
            if (bnViewWidth > 0 && control.getApplicationType() == 2) {
                return bnViewWidth;
            }
            return -paraAttr.specialIndentValue;
        }
        return 0;
    }
}

