/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LeafView;

public class EncloseCharacterView
extends LeafView {
    protected Paint enclosePaint;
    protected Path path;

    public EncloseCharacterView() {
    }

    public EncloseCharacterView(IElement paraElem, IElement elem) {
        super(paraElem, elem);
    }

    @Override
    public short getType() {
        return 14;
    }

    @Override
    public void initProperty(IElement elem, IElement paraElem) {
        super.initProperty(elem, paraElem);
        this.enclosePaint = new Paint();
        this.enclosePaint.setColor(this.charAttr.fontColor);
        this.enclosePaint.setStyle(Paint.Style.STROKE);
        this.enclosePaint.setAntiAlias(true);
        this.path = new Path();
    }

    @Override
    public void draw(Canvas canvas, int originX, int originY, float zoom) {
        super.draw(canvas, originX, originY, zoom);
        this.drawEnclose(canvas, originX, originY, zoom);
    }

    private void drawEnclose(Canvas canvas, int originX, int originY, float zoom) {
        int dX = (int)((float)this.x * zoom) + originX;
        int dY = (int)((float)this.y * zoom) + originY;
        int w = (int)((float)this.getWidth() * zoom);
        int h = (int)((float)this.getHeight() * zoom);
        if (this.charAttr.encloseType == 0) {
            canvas.drawArc(new RectF((float)dX, (float)dY, (float)(dX + w), (float)(dY + h)), 0.0f, 360.0f, false, this.enclosePaint);
        } else if (this.charAttr.encloseType == 1) {
            canvas.drawRect((float)dX, (float)dY, (float)(dX + w), (float)(dY + h), this.enclosePaint);
        } else if (this.charAttr.encloseType == 2) {
            this.path.reset();
            this.path.moveTo((float)(dX + w / 2), (float)dY);
            this.path.lineTo((float)dX, (float)(dY + h));
            this.path.lineTo((float)(dX + w), (float)(dY + h));
            this.path.close();
            canvas.drawPath(this.path, this.enclosePaint);
        } else if (this.charAttr.encloseType == 3) {
            this.path.reset();
            this.path.moveTo((float)(dX + w / 2), (float)dY);
            this.path.lineTo((float)dX, (float)(dY + h / 2));
            this.path.lineTo((float)(dX + w / 2), (float)(dY + h));
            this.path.lineTo((float)(dX + w), (float)(dY + h / 2));
            this.path.close();
            canvas.drawPath(this.path, this.enclosePaint);
        }
    }

    @Override
    public void free() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.paint = null;
    }
}

