/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.dialog;

import android.content.Context;
import android.content.res.Configuration;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IDialogAction;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.ADialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class TXTEncodingDialog
extends ADialog {
    public static final String BACK_PRESSED = "BP";
    public static final String[] ENCODING_ITEMS = new String[]{"GBK", "GB2312", "BIG5", "Unicode", "UTF-8", "UTF-16", "UTF-16LE", "UTF-16BE", "UTF-7", "UTF-32", "UTF-32LE", "UTF-32BE", "US-ASCII", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-10", "ISO-8859-11", "ISO-8859-13", "ISO-8859-14", "ISO-8859-15", "ISO-8859-16", "ISO-2022-JP", "ISO-2022-KR", "ISO-2022-CN", "ISO-2022-CN-EXT", "UCS-2", "UCS-4", "Windows-1250", "Windows-1251", "Windows-1252", "Windows-1253", " Windows-1254", "Windows-1255", "Windows-1256", "Windows-1257", "Windows-1258", "KOI8-R", "Shift_JIS", "CP864", "EUC-JP", "EUC-KR", "BOCU-1", "CESU-8", "SCSU", "HZ-GB-2312", "TIS-620", "macintosh", "x-UTF-16LE-BOM", "x-iscii-as", "x-iscii-be", "x-iscii-de", "x-iscii-gu", "x-iscii-ka", "x-iscii-ma", "x-iscii-or", "x-iscii-pa", "x-iscii-ta", "x-iscii-te", "x-mac-cyrillic"};
    private Spinner spinner;
    private WebView previewText;
    private char[] buffer = new char[1024];
    private ScrollView scrollView;

    public TXTEncodingDialog(IControl control, Context context, IDialogAction action, Vector<Object> model, int dialogID) {
        super(control, context, action, model, dialogID, action.getControl().getMainFrame().getLocalString("DIALOG_ENCODING_TITLE"));
        this.init(context);
    }

    public void init(Context context) {
        ArrayAdapter adapter = new ArrayAdapter(context, 17367048, (Object[])ENCODING_ITEMS);
        adapter.setDropDownViewResource(0x1090009);
        this.spinner = new Spinner(context);
        this.spinner.setAdapter((SpinnerAdapter)adapter);
        this.spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                String codeNew = TXTEncodingDialog.this.spinner.getSelectedItem().toString();
                if (codeNew != null) {
                    TXTEncodingDialog.this.setPreviewText(codeNew);
                }
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        this.dialogFrame.addView((View)this.spinner);
        this.previewText = new WebView(context);
        this.previewText.setPadding(5, 2, 5, 2);
        this.scrollView = new ScrollView(context);
        this.scrollView.setFillViewport(true);
        this.scrollView.addView((View)this.previewText);
        this.dialogFrame.addView((View)this.scrollView);
        this.ok = new Button(context);
        String okStr = this.action.getControl().getMainFrame().getLocalString("BUTTON_OK");
        this.ok.setText((CharSequence)okStr);
        this.ok.setOnClickListener((View.OnClickListener)this);
        this.dialogFrame.addView((View)this.ok);
    }

    @Override
    public void doLayout() {
        int mWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        int mHeight = this.getContext().getResources().getDisplayMetrics().heightPixels;
        mHeight -= this.getWindow().getDecorView().getHeight() - this.dialogFrame.getHeight();
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams((mWidth -= 50) - 10, (mHeight -= 50) - this.spinner.getBottom() - this.ok.getHeight());
        params.leftMargin = 5;
        params.rightMargin = 5;
        params.bottomMargin = 5;
        this.scrollView.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.doLayout();
    }

    @Override
    public void onClick(View v) {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.spinner.getSelectedItem().toString());
        this.action.doAction(this.dialogID, vector);
        this.dismiss();
    }

    @Override
    public void onBackPressed() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(BACK_PRESSED);
        this.action.doAction(this.dialogID, vector);
        super.onBackPressed();
    }

    private void setPreviewText(String code) {
        try {
            if (code != null) {
                File file = new File(this.model.get(0).toString());
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), code));
                int len = br.read(this.buffer);
                if (len > 0) {
                    String str = "<a>" + new String(this.buffer, 0, len) + "</a>";
                    this.previewText.loadDataWithBaseURL(null, str.replaceAll("\\r\\n", "<br />"), "text/html", "UTF-8", null);
                }
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.spinner = null;
        this.previewText = null;
        this.buffer = null;
        this.scrollView = null;
    }
}

