/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.control;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListItem;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageRoot;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageView;

public class WPPageListItem
extends APageListItem {
    private static final int BACKGROUND_COLOR = -1;
    private boolean isInit = true;
    private PageRoot pageRoot;

    public WPPageListItem(APageListView listView, IControl control, int pageWidth, int pageHeight) {
        super(listView, pageWidth, pageHeight);
        this.control = control;
        this.pageRoot = (PageRoot)listView.getModel();
        this.setBackgroundColor(-1);
    }

    public void onDraw(Canvas canvas) {
        PageView pv = this.pageRoot.getPageView(this.pageIndex);
        if (pv != null) {
            float zoom = this.listView.getZoom();
            canvas.save();
            canvas.translate((float)(-pv.getX()) * zoom, (float)(-pv.getY()) * zoom);
            pv.drawForPrintMode(canvas, 0, 0, zoom);
            canvas.restore();
        }
    }

    @Override
    public void setPageItemRawData(int pIndex, int pageWidth, int pageHeight) {
        super.setPageItemRawData(pIndex, pageWidth, pageHeight);
        if ((int)(this.listView.getZoom() * 100.0f) == 100 || this.isInit && pIndex == 0) {
            this.listView.exportImage(this, null);
        }
        this.isInit = false;
    }

    @Override
    protected void addRepaintImageView(Bitmap bmp) {
        this.postInvalidate();
        this.listView.exportImage(this, null);
    }

    @Override
    protected void removeRepaintImageView() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.control = null;
        this.pageRoot = null;
    }
}

