/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.control;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.ahmadullahpk.alldocumentreader.xs.common.IOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.SysKit;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListItem;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListView;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.IPageListViewListener;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.WPFind;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.WPPageListItem;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.Word;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageRoot;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageView;

public class PrintWord
extends FrameLayout
implements IPageListViewListener {
    private int preShowPageIndex = -1;
    private int prePageCount = -1;
    private IControl control;
    private APageListView listView;
    private Paint paint;
    private PageRoot pageRoot;
    private Rect pageSize = new Rect();

    public PrintWord(Context context) {
        super(context);
    }

    public PrintWord(Context context, IControl control, PageRoot pageRoot) {
        super(context);
        this.control = control;
        this.pageRoot = pageRoot;
        this.listView = new APageListView(context, this);
        this.addView((View)this.listView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setTypeface(Typeface.SANS_SERIF);
        this.paint.setTextSize(24.0f);
    }

    public void setBackgroundColor(int color2) {
        super.setBackgroundColor(color2);
        if (this.listView != null) {
            this.listView.setBackgroundColor(color2);
        }
    }

    public void setBackgroundResource(int resid) {
        super.setBackgroundResource(resid);
        if (this.listView != null) {
            this.listView.setBackgroundResource(resid);
        }
    }

    public void setBackgroundDrawable(Drawable d) {
        super.setBackgroundDrawable(d);
        if (this.listView != null) {
            this.listView.setBackgroundDrawable(d);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            // empty if block
        }
        this.exportImage(this.listView.getCurrentPageView(), null);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.drawPageNubmer(canvas);
    }

    public void init() {
    }

    public void setZoom(float zoom, int pointX, int pointY) {
        this.listView.setZoom(zoom, pointX, pointY);
    }

    public void setFitSize(int value) {
        this.listView.setFitSize(value);
    }

    public int getFitSizeState() {
        return this.listView.getFitSizeState();
    }

    public float getZoom() {
        return this.listView.getZoom();
    }

    public float getFitZoom() {
        return this.listView.getFitZoom();
    }

    public int getCurrentPageNumber() {
        return this.listView.getCurrentPageNumber();
    }

    public APageListView getListView() {
        return this.listView;
    }

    public void nextPageView() {
        this.listView.nextPageView();
    }

    public void previousPageview() {
        this.listView.previousPageview();
    }

    public void showPDFPageForIndex(int index) {
        this.listView.showPDFPageForIndex(index);
    }

    public long viewToModel(int x, int y, boolean isBack) {
        int pageIndex = this.listView.getCurrentPageNumber() - 1;
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return 0L;
        }
        return this.pageRoot.viewToModel(x, y, isBack);
    }

    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        int pageIndex = this.listView.getCurrentPageNumber() - 1;
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return rect;
        }
        return this.pageRoot.modelToView(offset, rect, isBack);
    }

    @Override
    public int getPageCount() {
        return Math.max(this.pageRoot.getChildCount(), 1);
    }

    @Override
    public APageListItem getPageListItem(int position, View convertView, ViewGroup parent) {
        Rect rect = this.getPageSize(position);
        return new WPPageListItem(this.listView, this.control, rect.width(), rect.height());
    }

    @Override
    public Rect getPageSize(int pageIndex) {
        PageView view = this.pageRoot.getPageView(pageIndex);
        if (view != null) {
            this.pageSize.set(0, 0, view.getWidth(), view.getHeight());
        } else {
            IAttributeSet attr = this.pageRoot.getDocument().getSection(0L).getAttribute();
            int pageWidth = (int)((float)AttrManage.instance().getPageWidth(attr) * 0.06666667f);
            int pageHeight = (int)((float)AttrManage.instance().getPageHeight(attr) * 0.06666667f);
            this.pageSize.set(0, 0, pageWidth, pageHeight);
        }
        return this.pageSize;
    }

    @Override
    public void exportImage(final APageListItem pageItem, Bitmap srcBitmap) {
        if (this.getControl() == null || !(this.getParent() instanceof Word)) {
            return;
        }
        WPFind find = (WPFind)this.control.getFind();
        if (find.isSetPointToVisible()) {
            find.setSetPointToVisible(false);
            PageView pv = this.pageRoot.getPageView(pageItem.getPageIndex());
            if (pv == null) {
                return;
            }
            Rectangle rect = this.modelToView(((Word)this.getParent()).getHighlight().getSelectStart(), new Rectangle(), false);
            rect.x -= pv.getX();
            rect.y -= pv.getY();
            if (!this.listView.isPointVisibleOnScreen(rect.x, rect.y)) {
                this.listView.setItemPointVisibleOnScreen(rect.x, rect.y);
                return;
            }
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                try {
                    IOfficeToPicture otp = PrintWord.this.getControl().getOfficeToPicture();
                    if (otp != null && otp.getModeType() == 1) {
                        int rH;
                        int rW = Math.min(PrintWord.this.getWidth(), pageItem.getWidth());
                        Bitmap dstBitmap = otp.getBitmap(rW, rH = Math.min(PrintWord.this.getHeight(), pageItem.getHeight()));
                        if (dstBitmap == null) {
                            return;
                        }
                        if (PrintWord.this.getParent() instanceof Word) {
                            ((Word)PrintWord.this.getParent()).getHighlight().setPaintHighlight(false);
                        }
                        if (dstBitmap.getWidth() == rW && dstBitmap.getHeight() == rH) {
                            Canvas canvas = new Canvas(dstBitmap);
                            canvas.drawColor(-1);
                            float zoom = PrintWord.this.listView.getZoom();
                            PageView pv = PrintWord.this.pageRoot.getPageView(pageItem.getPageIndex());
                            if (pv != null) {
                                canvas.save();
                                canvas.translate((float)(-pv.getX()) * zoom, (float)(-pv.getY()) * zoom);
                                int left = pageItem.getLeft();
                                int top = pageItem.getTop();
                                pv.drawForPrintMode(canvas, -(Math.max(left, 0) - left), -(Math.max(top, 0) - top), zoom);
                                canvas.restore();
                                canvas.translate((float)(-(Math.max(left, 0) - left)), (float)(-(Math.max(top, 0) - top)));
                                PrintWord.this.control.getSysKit().getCalloutManager().drawPath(canvas, pageItem.getPageIndex(), zoom);
                            }
                        } else {
                            PageView pv = PrintWord.this.pageRoot.getPageView(pageItem.getPageIndex());
                            if (pv != null) {
                                float paintZoom = Math.min((float)dstBitmap.getWidth() / (float)rW, (float)dstBitmap.getHeight() / (float)rH);
                                float zoom = PrintWord.this.listView.getZoom() * paintZoom;
                                int left = (int)((float)pageItem.getLeft() * paintZoom);
                                int top = (int)((float)pageItem.getTop() * paintZoom);
                                Canvas canvas = new Canvas(dstBitmap);
                                canvas.save();
                                canvas.drawColor(-1);
                                canvas.translate((float)(-pv.getX()) * zoom, (float)(-pv.getY()) * zoom);
                                pv.drawForPrintMode(canvas, -(Math.max(left, 0) - left), -(Math.max(top, 0) - top), zoom);
                                canvas.restore();
                                canvas.translate((float)(-(Math.max(left, 0) - left)), (float)(-(Math.max(top, 0) - top)));
                                PrintWord.this.control.getSysKit().getCalloutManager().drawPath(canvas, pageItem.getPageIndex(), zoom);
                            }
                        }
                        if (PrintWord.this.getParent() instanceof Word) {
                            ((Word)PrintWord.this.getParent()).getHighlight().setPaintHighlight(true);
                        }
                        otp.callBack(dstBitmap);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public Bitmap getSnapshot(Bitmap dstBitmap) {
        APageListItem pageItem = this.getListView().getCurrentPageView();
        if (pageItem == null) {
            return null;
        }
        int rW = Math.min(this.getWidth(), pageItem.getWidth());
        int rH = Math.min(this.getHeight(), pageItem.getHeight());
        if (this.getParent() instanceof Word) {
            ((Word)this.getParent()).getHighlight().setPaintHighlight(false);
        }
        if (dstBitmap.getWidth() == rW && dstBitmap.getHeight() == rH) {
            Canvas canvas = new Canvas(dstBitmap);
            canvas.drawColor(-1);
            float zoom = this.listView.getZoom();
            PageView pv = this.pageRoot.getPageView(pageItem.getPageIndex());
            if (pv != null) {
                canvas.translate((float)(-pv.getX()) * zoom, (float)(-pv.getY()) * zoom);
                int left = pageItem.getLeft();
                int top = pageItem.getTop();
                pv.drawForPrintMode(canvas, -(Math.max(left, 0) - left), -(Math.max(top, 0) - top), zoom);
            }
        } else {
            PageView pv = this.pageRoot.getPageView(pageItem.getPageIndex());
            if (pv != null) {
                float paintZoom = Math.min((float)dstBitmap.getWidth() / (float)rW, (float)dstBitmap.getHeight() / (float)rH);
                float zoom = this.listView.getZoom() * paintZoom;
                int left = (int)((float)pageItem.getLeft() * paintZoom);
                int top = (int)((float)pageItem.getTop() * paintZoom);
                Canvas canvas = new Canvas(dstBitmap);
                canvas.drawColor(-1);
                canvas.translate((float)(-pv.getX()) * zoom, (float)(-pv.getY()) * zoom);
                pv.drawForPrintMode(canvas, -(Math.max(left, 0) - left), -(Math.max(top, 0) - top), zoom);
            }
        }
        if (this.getParent() instanceof Word) {
            ((Word)this.getParent()).getHighlight().setPaintHighlight(true);
        }
        return dstBitmap;
    }

    @Override
    public boolean isInit() {
        return true;
    }

    @Override
    public boolean isIgnoreOriginalSize() {
        return this.control.getMainFrame().isIgnoreOriginalSize();
    }

    @Override
    public byte getPageListViewMovingPosition() {
        return this.control.getMainFrame().getPageListViewMovingPosition();
    }

    @Override
    public Object getModel() {
        return this.pageRoot;
    }

    public IControl getControl() {
        return this.control;
    }

    @Override
    public boolean onEventMethod(View v, MotionEvent e1, MotionEvent e2, float velocityX, float velocityY, byte eventMethodType) {
        PageView pv;
        APageListItem item;
        if (eventMethodType == 3 && e1 != null && e1.getAction() == 1 && (item = this.listView.getCurrentPageView()) != null && (pv = this.pageRoot.getPageView(item.getPageIndex())) != null) {
            Hyperlink hylink;
            int hyID;
            IElement leaf;
            int y;
            float zoom = this.listView.getZoom();
            int x = (int)((e1.getX() - (float)item.getLeft()) / zoom) + pv.getX();
            long offset = pv.viewToModel(x, y = (int)((e1.getY() - (float)item.getTop()) / zoom) + pv.getY(), false);
            if (offset >= 0L && (leaf = pv.getDocument().getLeaf(offset)) != null && (hyID = AttrManage.instance().getHperlinkID(leaf.getAttribute())) >= 0 && (hylink = this.control.getSysKit().getHyperlinkManage().getHyperlink(hyID)) != null) {
                this.control.actionEvent(0x20000008, hylink);
            }
        }
        return this.control.getMainFrame().onEventMethod(v, e1, e2, velocityX, velocityY, eventMethodType);
    }

    @Override
    public void updateStutus(Object obj) {
        this.control.actionEvent(20, obj);
    }

    @Override
    public void resetSearchResult(APageListItem pageItem) {
        Word word;
        if (this.getParent() instanceof Word && (word = (Word)this.getParent()).getFind().getPageIndex() != pageItem.getPageIndex()) {
            word.getHighlight().removeHighlight();
        }
    }

    @Override
    public boolean isTouchZoom() {
        return this.control.getMainFrame().isTouchZoom();
    }

    @Override
    public boolean isShowZoomingMsg() {
        return this.control.getMainFrame().isShowZoomingMsg();
    }

    @Override
    public void changeZoom() {
        this.control.getMainFrame().changeZoom();
    }

    @Override
    public void setDrawPictrue(boolean isDrawPictrue) {
        PictureKit.instance().setDrawPictrue(isDrawPictrue);
    }

    public PageView getCurrentPageView() {
        APageListItem item = this.listView.getCurrentPageView();
        if (item != null) {
            return this.pageRoot.getPageView(item.getPageIndex());
        }
        return null;
    }

    private void drawPageNubmer(Canvas canvas) {
        if (this.control.getMainFrame().isDrawPageNumber()) {
            String pn = String.valueOf(this.listView.getCurrentPageNumber() + " / " + this.pageRoot.getChildCount());
            int w = (int)this.paint.measureText(pn);
            int h = (int)(this.paint.descent() - this.paint.ascent());
            int x = (this.getWidth() - w) / 2;
            int y = this.getHeight() - h - 20;
            Drawable drawable2 = SysKit.getPageNubmerDrawable();
            drawable2.setBounds(x - 10, y - 10, x + w + 10, y + h + 10);
            drawable2.draw(canvas);
            y = (int)((float)y - this.paint.ascent());
            canvas.drawText(pn, (float)x, (float)y, this.paint);
        }
        if (this.preShowPageIndex != this.listView.getCurrentPageNumber() || this.prePageCount != this.getPageCount()) {
            this.changePage();
            this.preShowPageIndex = this.listView.getCurrentPageNumber();
            this.prePageCount = this.getPageCount();
        }
    }

    public void changePage() {
        this.control.getMainFrame().changePage();
    }

    @Override
    public boolean isChangePage() {
        return this.control.getMainFrame().isChangePage();
    }

    public void dispose() {
        this.control = null;
        if (this.listView != null) {
            this.listView.dispose();
        }
        this.pageRoot = null;
        this.pageSize = null;
    }
}

