/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.control;

import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.Word;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageRoot;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.PageView;

public class ControlKit {
    private static ControlKit kit = new ControlKit();

    public static ControlKit instance() {
        return kit;
    }

    public void internetSearch(Word word) {
        IDocument doc = word.getDocument();
        long start = word.getHighlight().getSelectStart();
        long end = word.getHighlight().getSelectEnd();
        String str = "";
        if (start != end) {
            str = doc.getText(start, end);
        }
        word.getControl().getSysKit().internetSearch(str, word.getControl().getMainFrame().getActivity());
    }

    public void gotoOffset(Word word, long offset) {
        Rectangle rect = new Rectangle();
        if (word.getCurrentRootType() == 2) {
            IView root = word.getRoot(0);
            boolean invalidate = true;
            if (root != null && root.getType() == 0) {
                IView pv;
                for (pv = ((PageRoot)root).getViewContainer().getParagraph(offset, false); pv != null && pv.getType() != 4; pv = pv.getParentView()) {
                }
                if (pv != null) {
                    int pageIndex = ((PageView)pv).getPageNumber() - 1;
                    if (pageIndex != word.getCurrentPageNumber() - 1) {
                        word.showPage(pageIndex, -1);
                        invalidate = false;
                    } else {
                        rect.setBounds(0, 0, 0, 0);
                        word.modelToView(offset, rect, false);
                        rect.x -= pv.getX();
                        rect.y -= pv.getY();
                        if (!word.getPrintWord().getListView().isPointVisibleOnScreen(rect.x, rect.y)) {
                            word.getPrintWord().getListView().setItemPointVisibleOnScreen(rect.x, rect.y);
                            invalidate = false;
                        } else {
                            word.getPrintWord().exportImage(word.getPrintWord().getListView().getCurrentPageView(), null);
                        }
                    }
                }
            }
            if (invalidate) {
                word.postInvalidate();
            }
            return;
        }
        rect.setBounds(0, 0, 0, 0);
        word.modelToView(offset, rect, false);
        Rectangle vRect = word.getVisibleRect();
        float zoom = word.getZoom();
        int x = (int)((float)rect.x * zoom);
        int y = (int)((float)rect.y * zoom);
        if (!vRect.contains(x, y)) {
            if ((float)(x + vRect.width) > (float)word.getWordWidth() * zoom) {
                x = (int)((float)word.getWordWidth() * zoom) - vRect.width;
            }
            if ((float)(y + vRect.height) > (float)word.getWordHeight() * zoom) {
                y = (int)((float)word.getWordHeight() * zoom) - vRect.height;
            }
            word.scrollTo(x, y);
        } else {
            word.postInvalidate();
        }
        word.getControl().actionEvent(20, null);
        if (word.getCurrentRootType() != 2) {
            word.getControl().actionEvent(0x2000000A, null);
        }
    }
}

