/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.io;

import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.io.TaggedInputStream;
import java.io.IOException;

public abstract class Action {
    private int code;
    private String name;

    protected Action(int code) {
        this.code = code;
        this.name = this.getClass().getName();
        int dot = this.name.lastIndexOf(".");
        this.name = dot >= 0 ? this.name.substring(dot + 1) : this.name;
    }

    public abstract Action read(int var1, TaggedInputStream var2, int var3) throws IOException;

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Action " + this.getName() + " (" + this.getCode() + ")";
    }

    public static class Unknown
    extends Action {
        private int[] data;

        public Unknown() {
            super(0);
        }

        public Unknown(int actionCode) {
            super(actionCode);
        }

        @Override
        public Action read(int actionCode, TaggedInputStream input, int length) throws IOException {
            Unknown action = new Unknown(actionCode);
            action.data = input.readUnsignedByte(length);
            return action;
        }

        @Override
        public String toString() {
            return super.toString() + " UNKNOWN!, length " + this.data.length;
        }
    }
}

