/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.AffineTransform;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFConstants;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;
import java.io.IOException;

public class ModifyWorldTransform
extends EMFTag
implements EMFConstants {
    private AffineTransform transform;
    private int mode;

    public ModifyWorldTransform() {
        super(36, 1);
    }

    public ModifyWorldTransform(AffineTransform transform, int mode) {
        this();
        this.transform = transform;
        this.mode = mode;
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        return new ModifyWorldTransform(emf.readXFORM(), emf.readDWORD());
    }

    @Override
    public String toString() {
        return super.toString() + "\n  transform: " + this.transform + "\n  mode: " + this.mode;
    }

    @Override
    public void render(EMFRenderer renderer) {
        if (this.mode == 1) {
            if (renderer.getPath() != null) {
                renderer.setPathTransform(new AffineTransform());
            } else {
                renderer.resetTransformation();
            }
        } else if (this.mode == 2) {
            if (renderer.getPath() != null) {
                renderer.getPathTransform().concatenate(this.transform);
                renderer.transform(this.transform);
            } else {
                renderer.transform(this.transform);
            }
        } else if (this.mode != 3) {
            // empty if block
        }
    }
}

