/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFConstants;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.Gradient;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.GradientRectangle;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.GradientTriangle;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.TriVertex;
import java.io.IOException;

public class GradientFill
extends EMFTag
implements EMFConstants {
    private Rectangle bounds;
    private int mode;
    private TriVertex[] vertices;
    private Gradient[] gradients;

    public GradientFill() {
        super(118, 1);
    }

    public GradientFill(Rectangle bounds, int mode, TriVertex[] vertices, Gradient[] gradients) {
        this();
        this.bounds = bounds;
        this.mode = mode;
        this.vertices = vertices;
        this.gradients = gradients;
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        int i;
        Rectangle bounds = emf.readRECTL();
        TriVertex[] vertices = new TriVertex[emf.readDWORD()];
        Gradient[] gradients = new Gradient[emf.readDWORD()];
        int mode = emf.readULONG();
        for (i = 0; i < vertices.length; ++i) {
            vertices[i] = new TriVertex(emf);
        }
        for (i = 0; i < gradients.length; ++i) {
            gradients[i] = mode == 2 ? new GradientTriangle(emf) : new GradientRectangle(emf);
        }
        return new GradientFill(bounds, mode, vertices, gradients);
    }

    @Override
    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append(super.toString());
        s.append("\n");
        s.append("  bounds: ");
        s.append(this.bounds);
        s.append("\n");
        s.append("  mode: ");
        s.append(this.mode);
        s.append("\n");
        for (i = 0; i < this.vertices.length; ++i) {
            s.append("  vertex[");
            s.append(i);
            s.append("]: ");
            s.append(this.vertices[i]);
            s.append("\n");
        }
        for (i = 0; i < this.gradients.length; ++i) {
            s.append("  gradient[");
            s.append(i);
            s.append("]: ");
            s.append(this.gradients[i]);
            s.append("\n");
        }
        return s.toString();
    }
}

