/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.AbstractPen;
import java.io.IOException;

public class ExtLogPen
extends AbstractPen {
    private int penStyle;
    private int width;
    private int brushStyle;
    private Color color;
    private int hatch;
    private int[] style;

    public ExtLogPen(int penStyle, int width, int brushStyle, Color color2, int hatch, int[] style2) {
        this.penStyle = penStyle;
        this.width = width;
        this.brushStyle = brushStyle;
        this.color = color2;
        this.hatch = hatch;
        this.style = style2;
    }

    public ExtLogPen(EMFInputStream emf, int len) throws IOException {
        this.penStyle = emf.readDWORD();
        this.width = emf.readDWORD();
        this.brushStyle = emf.readUINT();
        this.color = emf.readCOLORREF();
        this.hatch = emf.readULONG();
        int nStyle = emf.readDWORD();
        if (nStyle == 0 && len > 44) {
            emf.readDWORD();
        }
        this.style = emf.readDWORD(nStyle);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("  ExtLogPen\n");
        s.append("    penStyle: ");
        s.append(Integer.toHexString(this.penStyle));
        s.append("\n");
        s.append("    width: ");
        s.append(this.width);
        s.append("\n");
        s.append("    brushStyle: ");
        s.append(this.brushStyle);
        s.append("\n");
        s.append("    color: ");
        s.append(this.color);
        s.append("\n");
        s.append("    hatch: ");
        s.append(this.hatch);
        s.append("\n");
        for (int i = 0; i < this.style.length; ++i) {
            s.append("      style[");
            s.append(i);
            s.append("]: ");
            s.append(this.style[i]);
            s.append("\n");
        }
        return s.toString();
    }

    @Override
    public void render(EMFRenderer renderer) {
        renderer.setUseCreatePen(false);
        renderer.setPenPaint(this.color);
        renderer.setPenStroke(this.createStroke(renderer, this.penStyle, this.style, this.width));
    }
}

