/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import android.graphics.Bitmap;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.AffineTransform;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.GeneralPath;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFConstants;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFImageLoader;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.BitmapInfo;
import java.io.IOException;

public class BitBlt
extends EMFTag
implements EMFConstants {
    private static final int size = 100;
    private Rectangle bounds;
    private int x;
    private int y;
    private int width;
    private int height;
    private int dwROP;
    private int xSrc;
    private int ySrc;
    private AffineTransform transform;
    private Color bkg;
    private int usage;
    private BitmapInfo bmi;
    private Bitmap image;

    public BitBlt() {
        super(76, 1);
    }

    public BitBlt(Rectangle bounds, int x, int y, int width, int height, AffineTransform transform, Bitmap image, Color bkg) {
        this();
        this.bounds = bounds;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.dwROP = 0xCC0020;
        this.xSrc = 0;
        this.ySrc = 0;
        this.transform = transform;
        this.bkg = bkg;
        this.usage = 0;
        this.image = image;
        this.bmi = null;
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        BitBlt tag = new BitBlt();
        tag.bounds = emf.readRECTL();
        tag.x = emf.readLONG();
        tag.y = emf.readLONG();
        tag.width = emf.readLONG();
        tag.height = emf.readLONG();
        tag.dwROP = emf.readDWORD();
        tag.xSrc = emf.readLONG();
        tag.ySrc = emf.readLONG();
        tag.transform = emf.readXFORM();
        tag.bkg = emf.readCOLORREF();
        tag.usage = emf.readDWORD();
        emf.readDWORD();
        int bmiSize = emf.readDWORD();
        emf.readDWORD();
        int bitmapSize = emf.readDWORD();
        tag.bmi = bmiSize > 0 ? new BitmapInfo(emf) : null;
        tag.image = bitmapSize > 0 && tag.bmi != null ? EMFImageLoader.readImage(tag.bmi.getHeader(), tag.width, tag.height, emf, bitmapSize, null) : null;
        return tag;
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  x, y, w, h: " + this.x + " " + this.y + " " + this.width + " " + this.height + "\n  dwROP: 0x" + Integer.toHexString(this.dwROP) + "\n  xSrc, ySrc: " + this.xSrc + " " + this.ySrc + "\n  transform: " + this.transform + "\n  bkg: " + this.bkg + "\n  usage: " + this.usage + "\n" + (this.bmi != null ? this.bmi.toString() : "  bitmap: null");
    }

    @Override
    public void render(EMFRenderer renderer) {
        if (this.image != null) {
            renderer.drawImage(this.image, this.transform);
        } else if (!this.bounds.isEmpty() && this.dwROP == 15728673) {
            this.bounds.x = this.x;
            this.bounds.y = this.y;
            renderer.fillShape(this.bounds);
        }
        GeneralPath currentFigure = renderer.getFigure();
        if (currentFigure != null) {
            renderer.fillAndDrawShape(currentFigure);
        }
    }
}

