/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Shape;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Stroke;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.AffineTransform;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.Area;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.GeneralPath;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.IllegalPathStateException;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.PathIterator;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.Font;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFHeader;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFTag;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.BasicStroke;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.GDIObject;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.io.Tag;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Logger;

public class EMFRenderer {
    private static final Logger logger = Logger.getLogger("com.wxiwei.office.thirdpart.emf");
    private EMFHeader header;
    public static double TWIP_SCALE = 0.1763888888888889;
    private GeneralPath figure = null;
    private Matrix initialMatrix;
    private Point windowOrigin = null;
    private Point viewportOrigin = null;
    private Dimension windowSize = null;
    private Dimension viewportSize = null;
    private boolean mapModeIsotropic = false;
    private AffineTransform mapModeTransform = AffineTransform.getScaleInstance(TWIP_SCALE, TWIP_SCALE);
    private Shape initialClip;
    private Canvas mCanvas;
    private GDIObject[] gdiObjects = new GDIObject[256];
    private Stroke penStroke = new BasicStroke();
    private Paint brushPaint = new Paint();
    private Paint penPaint = new Paint();
    private int textAlignMode = 0;
    private Color textColor = Color.BLACK;
    private int windingRule = 0;
    private int bkMode = 2;
    private boolean useCreatePen = true;
    private int meterLimit = 10;
    private int rop2 = 13;
    private int scaleMode = 4;
    private Point brushOrigin = new Point(0, 0);
    private Vector tags = new Vector(0);
    private GeneralPath path = null;
    private AffineTransform pathTransform = new AffineTransform();
    private Stack dcStack = new Stack();
    private int arcDirection = 1;
    private Area mCurrClip;
    private int escapement = 0;

    public EMFRenderer(EMFInputStream is) throws IOException {
        Tag tag;
        this.brushPaint.setColor(new Color(0, 0, 0, 0).getRGB());
        this.penPaint.setColor(Color.BLACK.getRGB());
        this.header = is.readHeader();
        while ((tag = is.readTag()) != null) {
            this.tags.add(tag);
        }
        is.close();
    }

    public Dimension getSize() {
        return this.header.getBounds().getSize();
    }

    public void paint(Canvas canvas) {
        this.mCanvas = canvas;
        Rect rect = canvas.getClipBounds();
        Matrix matrix = canvas.getMatrix();
        int[] cl = new int[]{-1, rect.top, rect.left, -2, rect.top, rect.right, -2, rect.bottom, rect.right, -2, rect.bottom, rect.left};
        this.mCurrClip = new Area(this.createShape(cl));
        this.penPaint.setAntiAlias(true);
        this.penPaint.setFilterBitmap(true);
        this.penPaint.setDither(true);
        this.initialMatrix = canvas.getMatrix();
        this.path = null;
        this.figure = null;
        this.meterLimit = 10;
        this.windingRule = 0;
        this.bkMode = 2;
        this.useCreatePen = true;
        this.scaleMode = 4;
        this.windowOrigin = null;
        this.viewportOrigin = null;
        this.windowSize = null;
        this.viewportSize = null;
        this.mapModeIsotropic = false;
        this.mapModeTransform = AffineTransform.getScaleInstance(TWIP_SCALE, TWIP_SCALE);
        this.resetMatrix(canvas);
        this.initialClip = this.mCurrClip;
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag tag = (Tag)this.tags.get(i);
            if (tag instanceof EMFTag) {
                ((EMFTag)this.tags.get(i)).render(this);
                continue;
            }
            logger.warning("unknown tag: " + tag);
        }
        this.penPaint.setAntiAlias(true);
        this.penPaint.setFilterBitmap(true);
        this.penPaint.setDither(true);
        canvas.setMatrix(matrix);
        this.setClip(this.initialClip);
    }

    private void resetMatrix(Canvas canvas) {
        if (this.initialMatrix != null) {
            canvas.setMatrix(this.initialMatrix);
        } else {
            canvas.setMatrix(new Matrix());
        }
        if (this.viewportSize != null && this.windowSize != null) {
            float scaleX = (float)(this.viewportSize.getWidth() / this.windowSize.getWidth());
            float scaleY = (float)(this.viewportSize.getHeight() / this.windowSize.getHeight());
            canvas.scale(scaleX, scaleY);
        }
    }

    public void saveDC() {
        DC dc = new DC();
        dc.paint = this.penPaint;
        dc.matrix = this.mCanvas.getMatrix();
        dc.clip = this.mCurrClip;
        dc.path = this.path;
        dc.meterLimit = this.meterLimit;
        dc.windingRule = this.windingRule;
        dc.bkMode = this.bkMode;
        dc.useCreatePen = this.useCreatePen;
        dc.scaleMode = this.scaleMode;
        this.dcStack.push(dc);
        this.mCanvas.save();
    }

    public void retoreDC() {
        if (!this.dcStack.empty()) {
            DC dc = (DC)this.dcStack.pop();
            this.meterLimit = dc.meterLimit;
            this.windingRule = dc.windingRule;
            this.path = dc.path;
            this.bkMode = dc.bkMode;
            this.useCreatePen = dc.useCreatePen;
            this.scaleMode = dc.scaleMode;
            this.pathTransform = dc.pathTransform;
            this.setStroke(this.penStroke);
            this.mCanvas.setMatrix(dc.matrix);
            this.setClip(dc.clip);
        }
        this.mCanvas.restore();
    }

    public void closeFigure() {
        if (this.figure == null) {
            return;
        }
        try {
            this.figure.closePath();
            this.appendToPath(this.figure);
            this.figure = null;
        }
        catch (IllegalPathStateException e) {
            logger.warning("no figure to close");
        }
    }

    public void appendFigure() {
        if (this.figure == null) {
            return;
        }
        try {
            this.appendToPath(this.figure);
            this.figure = null;
        }
        catch (IllegalPathStateException e) {
            logger.warning("no figure to append");
        }
    }

    public void fixViewportSize() {
        if (this.mapModeIsotropic && this.windowSize != null && this.viewportSize != null) {
            this.viewportSize.setSize(this.viewportSize.getWidth(), this.viewportSize.getWidth() * (this.windowSize.getHeight() / this.windowSize.getWidth()));
        }
    }

    private void fillAndDrawOrAppend(Canvas canvas, Shape s) {
        if (!this.appendToPath(s)) {
            if (this.useCreatePen) {
                if (this.bkMode == 2) {
                    this.fillShape(s);
                } else {
                    this.fillShape(s);
                }
            } else {
                this.fillShape(s);
            }
            this.drawShape(canvas, s);
        }
    }

    private void drawOrAppend(Canvas canvas, Shape s) {
        if (!this.appendToPath(s)) {
            this.drawShape(canvas, s);
        }
    }

    public void drawOrAppendText(String text, float x, float y) {
        Paint.Style tmp = this.penPaint.getStyle();
        this.penPaint.setColor(this.textColor.getRGB());
        this.penPaint.setStrokeWidth(0.0f);
        if (2700 == this.escapement) {
            for (int i = 0; i < text.length(); ++i) {
                this.mCanvas.drawText(String.valueOf(text.charAt(i)), x, y + (float)i * this.penPaint.getTextSize(), this.penPaint);
            }
        } else {
            if (0 == this.textAlignMode) {
                y += this.penPaint.getTextSize() - 3.0f;
            }
            this.mCanvas.drawText(text, x, y, this.penPaint);
        }
        this.penPaint.setStyle(tmp);
    }

    private boolean appendToPath(Shape s) {
        if (this.path != null) {
            if (this.pathTransform != null) {
                s = this.pathTransform.createTransformedShape(s);
            }
            this.path.append(s, false);
            return true;
        }
        return false;
    }

    public void closePath() {
        if (this.path != null) {
            try {
                this.path.closePath();
            }
            catch (IllegalPathStateException e) {
                logger.warning("no figure to close");
            }
        }
    }

    private void getCurrentSegment(PathIterator pi, Path path) {
        float[] coordinates = new float[6];
        int type = pi.currentSegment(coordinates);
        switch (type) {
            case 0: {
                path.moveTo(coordinates[0], coordinates[1]);
                break;
            }
            case 1: {
                path.lineTo(coordinates[0], coordinates[1]);
                break;
            }
            case 2: {
                path.quadTo(coordinates[0], coordinates[1], coordinates[2], coordinates[3]);
                break;
            }
            case 3: {
                path.cubicTo(coordinates[0], coordinates[1], coordinates[2], coordinates[3], coordinates[4], coordinates[5]);
                break;
            }
            case 4: {
                path.close();
                break;
            }
        }
    }

    private Path getPath(Shape s) {
        Path path = new Path();
        PathIterator pi = s.getPathIterator(null);
        while (!pi.isDone()) {
            this.getCurrentSegment(pi, path);
            pi.next();
        }
        return path;
    }

    private void setStroke(Stroke stroke) {
        BasicStroke bs = (BasicStroke)stroke;
        this.penPaint.setStyle(Paint.Style.STROKE);
        this.penPaint.setStrokeWidth(bs.getLineWidth());
        int cap = bs.getEndCap();
        if (cap == 0) {
            this.penPaint.setStrokeCap(Paint.Cap.BUTT);
        } else if (cap == 1) {
            this.penPaint.setStrokeCap(Paint.Cap.ROUND);
        } else if (cap == 2) {
            this.penPaint.setStrokeCap(Paint.Cap.SQUARE);
        }
        int join = bs.getLineJoin();
        if (join == 0) {
            this.penPaint.setStrokeJoin(Paint.Join.MITER);
        } else if (join == 1) {
            this.penPaint.setStrokeJoin(Paint.Join.ROUND);
        } else if (join == 2) {
            this.penPaint.setStrokeJoin(Paint.Join.BEVEL);
        }
        this.penPaint.setStrokeMiter(bs.getMiterLimit());
    }

    private void drawShape(Canvas canvas, Shape s) {
        this.setStroke(this.penStroke);
        if (this.rop2 == 1) {
            this.penPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
            this.penPaint.setColor(Color.black.getRGB());
        } else if (this.rop2 == 13) {
            this.penPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        } else if (this.rop2 == 11) {
            this.penPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        } else if (this.rop2 == 16) {
            this.penPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
            this.penPaint.setColor(Color.white.getRGB());
        } else if (this.rop2 == 4) {
            this.penPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER));
        } else if (this.rop2 == 7) {
            this.penPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.XOR));
        } else {
            logger.warning("got unsupported ROP" + this.rop2);
        }
        canvas.drawPath(this.getPath(s), this.penPaint);
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        Typeface tf = null;
        String nam = font.getName();
        int sty = font.getStyle();
        String aF = "";
        if (nam != null) {
            aF = nam.equalsIgnoreCase("Serif") || nam.equalsIgnoreCase("TimesRoman") ? "serif" : (nam.equalsIgnoreCase("SansSerif") || nam.equalsIgnoreCase("Helvetica") ? "sans-serif" : (nam.equalsIgnoreCase("Monospaced") || nam.equalsIgnoreCase("Courier") ? "monospace" : "sans-serif"));
        }
        switch (sty) {
            case 0: {
                tf = Typeface.create((String)aF, (int)0);
                break;
            }
            case 1: {
                tf = Typeface.create((String)aF, (int)1);
                break;
            }
            case 2: {
                tf = Typeface.create((String)aF, (int)2);
                break;
            }
            case 3: {
                tf = Typeface.create((String)aF, (int)3);
                break;
            }
            default: {
                tf = Typeface.DEFAULT;
            }
        }
        this.penPaint.setTextSize((float)font.getFontSize());
        this.penPaint.setTypeface(tf);
    }

    public void setEscapement(int escapement) {
        this.escapement = escapement;
    }

    public Matrix getMatrix() {
        return this.mCanvas.getMatrix();
    }

    public void transform(AffineTransform transform) {
        Matrix matrix = new Matrix();
        matrix.setValues(EMFRenderer.createMatrix(transform));
        this.mCanvas.concat(matrix);
    }

    public void resetTransformation() {
        this.resetMatrix(this.mCanvas);
    }

    public void setMatrix(Matrix matrix) {
        this.mCanvas.setMatrix(matrix);
    }

    public void setClip(Shape shape) {
        this.mCurrClip = new Area(shape);
    }

    public void clip(Shape shape) {
        this.mCanvas.clipPath(this.getPath(shape), Region.Op.REPLACE);
    }

    public Shape getClip() {
        return this.mCurrClip;
    }

    private Shape createShape(int[] arr) {
        GeneralPath s = new GeneralPath();
        block7: for (int i = 0; i < arr.length; ++i) {
            int type = arr[i];
            switch (type) {
                case -1: {
                    s.moveTo(arr[++i], arr[++i]);
                    continue block7;
                }
                case -2: {
                    s.lineTo(arr[++i], arr[++i]);
                    continue block7;
                }
                case -3: {
                    s.quadTo(arr[++i], arr[++i], arr[++i], arr[++i]);
                    continue block7;
                }
                case -4: {
                    s.curveTo(arr[++i], arr[++i], arr[++i], arr[++i], arr[++i], arr[++i]);
                    continue block7;
                }
                case -5: {
                    return s;
                }
            }
        }
        return s;
    }

    public static float[] createMatrix(AffineTransform Tx) {
        double[] at = new double[9];
        Tx.getMatrix(at);
        float[] f = new float[at.length];
        f[0] = (float)at[0];
        f[1] = (float)at[2];
        f[2] = (float)at[4];
        f[3] = (float)at[1];
        f[4] = (float)at[3];
        f[5] = (float)at[5];
        f[6] = 0.0f;
        f[7] = 0.0f;
        f[8] = 1.0f;
        return f;
    }

    public void drawImage(Bitmap bitmap, AffineTransform transform) {
        Matrix matrix = new Matrix();
        matrix.setValues(EMFRenderer.createMatrix(transform));
        this.mCanvas.drawBitmap(bitmap, matrix, this.penPaint);
    }

    public void drawImage(Bitmap bitmap, int x, int y, int width, int height) {
        Rect dst = new Rect(x, y, x + width, y + height);
        this.mCanvas.drawBitmap(bitmap, null, dst, null);
    }

    public void drawShape(Shape shape) {
        this.drawShape(this.mCanvas, shape);
    }

    public void fillShape(Shape shape) {
        Paint.Style tmp = this.brushPaint.getStyle();
        this.brushPaint.setStyle(Paint.Style.FILL);
        this.mCanvas.drawPath(this.getPath(shape), this.brushPaint);
        this.brushPaint.setStyle(tmp);
    }

    public void fillAndDrawShape(Shape shape) {
        Paint.Style tmp = this.brushPaint.getStyle();
        this.brushPaint.setStyle(Paint.Style.FILL);
        this.drawShape(this.mCanvas, shape);
        this.brushPaint.setStyle(tmp);
    }

    public void fillAndDrawOrAppend(Shape s) {
        this.fillAndDrawOrAppend(this.mCanvas, s);
    }

    public void drawOrAppend(Shape s) {
        this.drawOrAppend(this.mCanvas, s);
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public GeneralPath getFigure() {
        return this.figure;
    }

    public void setFigure(GeneralPath figure) {
        this.figure = figure;
    }

    public GeneralPath getPath() {
        return this.path;
    }

    public void setPath(GeneralPath path) {
        this.path = path;
    }

    public Shape getInitialClip() {
        return this.initialClip;
    }

    public AffineTransform getPathTransform() {
        return this.pathTransform;
    }

    public void setPathTransform(AffineTransform pathTransform) {
        this.pathTransform = pathTransform;
    }

    public void setWindingRule(int windingRule) {
        this.windingRule = windingRule;
    }

    public void setMapModeIsotropic(boolean mapModeIsotropic) {
        this.mapModeIsotropic = mapModeIsotropic;
    }

    public AffineTransform getMapModeTransform() {
        return this.mapModeTransform;
    }

    public void setMapModeTransform(AffineTransform mapModeTransform) {
        this.mapModeTransform = mapModeTransform;
    }

    public void setWindowOrigin(Point windowOrigin) {
        this.windowOrigin = windowOrigin;
        if (windowOrigin != null) {
            this.mCanvas.translate((float)(-windowOrigin.x), (float)(-windowOrigin.y));
        }
    }

    public void setViewportOrigin(Point viewportOrigin) {
        this.viewportOrigin = viewportOrigin;
        if (viewportOrigin != null) {
            this.mCanvas.translate((float)(-viewportOrigin.x), (float)(-viewportOrigin.y));
        }
    }

    public void setViewportSize(Dimension viewportSize) {
        this.viewportSize = viewportSize;
        this.fixViewportSize();
        this.resetTransformation();
    }

    public void setWindowSize(Dimension windowSize) {
        this.windowSize = windowSize;
        this.fixViewportSize();
        this.resetTransformation();
    }

    public GDIObject getGDIObject(int index) {
        return this.gdiObjects[index];
    }

    public void storeGDIObject(int index, GDIObject tag) {
        this.gdiObjects[index] = tag;
    }

    public void setUseCreatePen(boolean useCreatePen) {
        this.useCreatePen = useCreatePen;
    }

    public void setPenPaint(Color color2) {
        this.penPaint.setColor(color2.getRGB());
    }

    public Stroke getPenStroke() {
        return this.penStroke;
    }

    public void setPenStroke(Stroke penStroke) {
        this.penStroke = penStroke;
    }

    public void setBrushPaint(Color color2) {
        this.brushPaint.setColor(color2.getRGB());
    }

    public void setBrushPaint(Bitmap bitmap) {
        this.mCanvas.clipRect(0, 0, 16, 16);
        this.mCanvas.setBitmap(bitmap);
    }

    public float getMeterLimit() {
        return this.meterLimit;
    }

    public void setMeterLimit(int meterLimit) {
        this.meterLimit = meterLimit;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setTextBkColor() {
        this.setBrushPaint(this.textColor);
    }

    public void setRop2(int rop2) {
        this.rop2 = rop2;
    }

    public void setBkMode(int bkMode) {
        this.bkMode = bkMode;
    }

    public int getTextAlignMode() {
        return this.textAlignMode;
    }

    public void setTextAlignMode(int textAlignMode) {
        this.textAlignMode = textAlignMode;
    }

    public void setScaleMode(int scaleMode) {
        this.scaleMode = scaleMode;
    }

    public Point getBrushOrigin() {
        return this.brushOrigin;
    }

    public void setBrushOrigin(Point brushOrigin) {
        this.brushOrigin = brushOrigin;
    }

    public void setArcDirection(int arcDirection) {
        this.arcDirection = arcDirection;
    }

    public int getArcDirection() {
        return this.arcDirection;
    }

    private class DC {
        private Paint paint;
        private Stroke stroke;
        private AffineTransform transform;
        private Shape clip;
        private Matrix matrix;
        public GeneralPath path;
        public int bkMode;
        public int windingRule;
        public int meterLimit;
        public boolean useCreatePen;
        public int scaleMode;
        public AffineTransform pathTransform;

        private DC() {
        }
    }
}

