/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class MathHelper {
    public static final double NULL_VALUE = Double.MAX_VALUE;
    private static final NumberFormat FORMAT = NumberFormat.getNumberInstance();

    private MathHelper() {
    }

    public static double[] minmax(List<Double> values) {
        double min;
        if (values.size() == 0) {
            return new double[2];
        }
        double max = min = values.get(0).doubleValue();
        int length = values.size();
        for (int i = 1; i < length; ++i) {
            double value = values.get(i);
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        return new double[]{min, max};
    }

    public static List<Double> getLabels(double start, double end, int approxNumLabels) {
        FORMAT.setMaximumFractionDigits(5);
        ArrayList<Double> labels = new ArrayList<Double>();
        double[] labelParams = MathHelper.computeLabels(start, end, approxNumLabels);
        int numLabels = 1 + (int)((labelParams[1] - labelParams[0]) / labelParams[2]);
        for (int i = 0; i < numLabels; ++i) {
            double z = labelParams[0] + (double)i * labelParams[2];
            try {
                z = FORMAT.parse(FORMAT.format(z)).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            labels.add(z);
        }
        return labels;
    }

    private static double[] computeLabels(double start, double end, int approxNumLabels) {
        double s = start;
        double e = end;
        if (Math.abs(start - end) < (double)1.0E-7f) {
            double xStep = MathHelper.roundUp(s / (double)approxNumLabels);
            double xEnd = xStep * Math.ceil(e / xStep);
            return new double[]{xStep, xEnd, xStep};
        }
        boolean switched = false;
        if (s > e) {
            switched = true;
            double tmp = s;
            s = e;
            e = tmp;
        }
        double xStep = MathHelper.roundUp(Math.abs(s - e) / (double)approxNumLabels);
        double xStart = xStep * Math.floor(s / xStep);
        double xEnd = xStep * Math.ceil(e / xStep);
        if (switched) {
            return new double[]{xEnd, xStart, -1.0 * xStep};
        }
        return new double[]{xStart, xEnd, xStep};
    }

    private static double roundUp(double val) {
        int exponent = (int)Math.floor(Math.log10(val));
        double rval = val * Math.pow(10.0, -exponent);
        if (rval > 5.0) {
            rval = 10.0;
        } else if (rval > 2.0) {
            rval = 5.0;
        } else if (rval > 1.0) {
            rval = 2.0;
        }
        return rval *= Math.pow(10.0, exponent);
    }

    public static float[] getFloats(List<Float> values) {
        int length = values.size();
        float[] result = new float[length];
        for (int i = 0; i < length; ++i) {
            result[i] = values.get(i).floatValue();
        }
        return result;
    }
}

