/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.CategorySeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DefaultRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import java.util.ArrayList;

public abstract class RoundChart
extends AbstractChart {
    protected static final int SHAPE_WIDTH = 10;
    protected CategorySeries mDataset;
    protected DefaultRenderer mRenderer;

    public RoundChart(CategorySeries dataset, DefaultRenderer renderer) {
        this.mDataset = dataset;
        this.mRenderer = renderer;
    }

    @Override
    public void setZoomRate(float rate) {
        this.mRenderer.setZoomRate(rate);
    }

    @Override
    public float getZoomRate() {
        return this.mRenderer.getZoomRate();
    }

    @Override
    public void draw(Canvas canvas, IControl control, int x, int y, int width, int height, Paint paint) {
        Rect rect = new Rect(x, y, x + width, y + height);
        canvas.save();
        canvas.clipRect(rect);
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int legendSize = this.mRenderer.getLegendHeight();
        if (this.mRenderer.isShowLegend() && legendSize == 0) {
            legendSize = height / 5;
        }
        int left = x;
        int top = y;
        int right = x + width;
        int sLength = this.mDataset.getItemCount();
        double total = 0.0;
        String[] titles = new String[sLength];
        for (int i = 0; i < sLength; ++i) {
            total += this.mDataset.getValue(i);
            titles[i] = this.mDataset.getCategory(i);
        }
        if (this.mRenderer.isFitLegend()) {
            legendSize = this.drawLegend(canvas, this.mRenderer, titles, left, y, width, height, paint, true);
        }
        int bottom = y + height - legendSize;
        this.drawBackground(this.mRenderer, canvas, x, y, width, height, paint, false, 0);
        float currentAngle = 0.0f;
        int mRadius = Math.min(Math.abs(right - left), Math.abs(bottom - top));
        int radius = (int)((double)mRadius * 0.35 * (double)this.mRenderer.getScale());
        int centerX = (left + right) / 2;
        int centerY = (bottom + top) / 2;
        float shortRadius = (float)radius * 0.9f;
        float longRadius = (float)radius * 1.1f;
        RectF oval = new RectF((float)(centerX - radius), (float)(centerY - radius), (float)(centerX + radius), (float)(centerY + radius));
        ArrayList<RectF> prevLabelsBounds = new ArrayList<RectF>();
        for (int i = 0; i < sLength; ++i) {
            paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
            float value = (float)this.mDataset.getValue(i);
            float angle = (float)((double)value / total * 360.0);
            canvas.drawArc(oval, currentAngle, angle, true, paint);
            this.drawLabel(canvas, this.mDataset.getCategory(i), this.mRenderer, prevLabelsBounds, centerX, centerY, shortRadius, longRadius, currentAngle, angle, left, right, paint);
            currentAngle += angle;
        }
        prevLabelsBounds.clear();
        this.drawLegend(canvas, this.mRenderer, titles, left, y, width, height, paint, false);
        canvas.restore();
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return (int)this.getRenderer().getLegendTextSize();
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        float shapeWidth = (float)this.getLegendShapeWidth(0) * this.mRenderer.getZoomRate();
        float halfShapeWidth = shapeWidth / 2.0f;
        canvas.drawRect(x += halfShapeWidth, y - halfShapeWidth, x + shapeWidth, y + halfShapeWidth, paint);
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(-16777216);
        canvas.drawRect((float)Math.round(x), y - halfShapeWidth, x + shapeWidth, y + halfShapeWidth, paint);
        paint.setStyle(Paint.Style.FILL);
    }

    public DefaultRenderer getRenderer() {
        return this.mRenderer;
    }
}

