/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.ColumnBarChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYMultipleSeriesDataset;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYSeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;

public class RangeBarChart
extends ColumnBarChart {
    public static final String TYPE = "RangeBar";

    RangeBarChart() {
    }

    public RangeBarChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, ColumnBarChart.Type type) {
        super(dataset, renderer, type);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] points, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex) {
        int seriesNr = this.mDataset.getSeriesCount();
        int length = points.length;
        paint.setColor(seriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        float halfDiffX = this.getHalfDiffX(points, length, seriesNr);
        for (int i = 0; i < length; i += 4) {
            float xMin = points[i];
            float yMin = points[i + 1];
            float xMax = points[i + 2];
            float yMax = points[i + 3];
            this.drawBar(canvas, xMin, yMin, xMax, yMax, halfDiffX, seriesNr, seriesIndex, paint);
        }
        paint.setColor(seriesRenderer.getColor());
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries series, Paint paint, float[] points, int seriesIndex) {
        int seriesNr = this.mDataset.getSeriesCount();
        float halfDiffX = this.getHalfDiffX(points, points.length, seriesNr);
        for (int k = 0; k < points.length; k += 4) {
            float x = points[k];
            if (this.mType == ColumnBarChart.Type.DEFAULT) {
                x += (float)(seriesIndex * 2) * halfDiffX - ((float)seriesNr - 1.5f) * halfDiffX;
            }
            this.drawText(canvas, this.getLabel(series.getY(k / 2 + 1)), x, points[k + 3] - 3.0f, paint, 0.0f);
            this.drawText(canvas, this.getLabel(series.getY(k / 2)), x, points[k + 1] + 7.5f, paint, 0.0f);
        }
    }

    @Override
    protected float getCoeficient() {
        return 0.5f;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

