/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.RoundChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.CategorySeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DefaultRenderer;
import java.util.ArrayList;

public class PieChart
extends RoundChart {
    public PieChart(CategorySeries dataset, DefaultRenderer renderer) {
        super(dataset, renderer);
    }

    @Override
    public void draw(Canvas canvas, IControl control, int x, int y, int width, int height, Paint paint) {
        canvas.save();
        canvas.clipRect(x, y, x + width, y + height);
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        this.drawBackgroundAndFrame(this.mRenderer, canvas, control, new Rect(x, y, x + width, y + height), paint);
        int legendSize = this.mRenderer.getLegendHeight();
        if (this.mRenderer.isShowLegend() && legendSize == 0) {
            legendSize = height / 5;
        }
        int sLength = this.mDataset.getItemCount();
        double total = 0.0;
        String[] titles = new String[sLength];
        for (int i = 0; i < sLength; ++i) {
            total += this.mDataset.getValue(i);
            titles[i] = this.mDataset.getCategory(i);
        }
        Rectangle titleAreaSize = this.getTitleTextAreaSize(this.mRenderer, width, height, paint);
        int legendH = height;
        if (titleAreaSize != null) {
            legendH -= titleAreaSize.height;
        }
        Rectangle legendAreaSize = this.getLegendAutoSize(this.mRenderer, titles, width, legendH, paint);
        double[] margins = this.mRenderer.getMargins();
        int left = x + (int)(margins[1] * (double)width);
        int top = y + (int)(margins[0] * (double)height);
        if (titleAreaSize != null) {
            top += titleAreaSize.height;
        }
        int right = x + width - (int)(margins[3] * (double)width);
        if (legendAreaSize != null && (this.legendPos == 0 || this.legendPos == 2)) {
            right -= legendAreaSize.width;
        }
        int bottom = y + height - (int)(margins[2] * (double)height);
        if (legendAreaSize != null && (this.legendPos == 1 || this.legendPos == 3)) {
            bottom -= legendAreaSize.height;
        }
        float size = this.mRenderer.getLegendTextSize() * this.mRenderer.getZoomRate();
        paint.setTextSize(size);
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setFakeBoldText(true);
        if (this.mRenderer.isShowChartTitle()) {
            paint.setTextSize(this.mRenderer.getChartTitleTextSize() * this.mRenderer.getZoomRate());
            Rectangle maxTitleAreaSize = this.getMaxTitleAreaSize(width, height);
            this.drawTitle(canvas, this.mRenderer.getChartTitle(), 1.0f, x + width / 2, (float)y + this.mRenderer.getChartTitleTextSize() * this.mRenderer.getZoomRate() * 2.0f, maxTitleAreaSize.width, maxTitleAreaSize.height, paint, 0.0f);
        }
        paint.setFakeBoldText(false);
        bottom = y + height - legendSize;
        float currentAngle = 0.0f;
        int mRadius = Math.min(Math.abs(right - left), Math.abs(bottom - top));
        int radius = (int)((double)mRadius * 0.35 * (double)this.mRenderer.getScale());
        int centerX = (int)((double)left + margins[1] * (double)width + (double)right - margins[3] * (double)width) / 2;
        int centerY = (int)((double)bottom - margins[2] * (double)height + (double)top + margins[0] * (double)height) / 2;
        float shortRadius = (float)radius * 0.9f;
        float longRadius = (float)radius * 1.1f;
        RectF oval = new RectF((float)(centerX - radius), (float)(centerY - radius), (float)(centerX + radius), (float)(centerY + radius));
        ArrayList prevLabelsBounds = new ArrayList();
        for (int i = 0; i < sLength; ++i) {
            paint.setColor(this.mRenderer.getSeriesRendererAt(i).getColor());
            float value = (float)this.mDataset.getValue(i);
            float angle = (float)((double)value / total * 360.0);
            canvas.drawArc(oval, currentAngle - 90.0f, angle, true, paint);
            currentAngle += angle;
        }
        prevLabelsBounds.clear();
        if (this.mRenderer.isShowLegend()) {
            int legendWidth = legendAreaSize.width;
            int legendHeight = Math.min(height, legendAreaSize.height);
            int legendLeft = x;
            int legendTop = y;
            switch (this.getLegendPosition()) {
                case 0: 
                case 2: {
                    legendLeft = x + width - legendWidth - (int)(this.mRenderer.getLegendTextSize() * this.mRenderer.getZoomRate());
                    if (titleAreaSize != null) {
                        legendTop = y + (height + titleAreaSize.height) / 2;
                        break;
                    }
                    legendTop = y + (height - legendHeight) / 2;
                    break;
                }
                case 1: 
                case 3: {
                    legendLeft = x + (width - legendWidth) / 2;
                    legendTop = y + height - legendHeight;
                }
            }
            this.drawLegend(canvas, this.mRenderer, titles, legendLeft, legendTop, legendWidth, legendHeight, paint, false);
        }
        canvas.restore();
    }
}

