/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.GradientDrawable;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.XYChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYMultipleSeriesDataset;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYSeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;

public class ColumnBarChart
extends XYChart {
    public static final String TYPE = "Column Bar";
    protected Type mType = Type.DEFAULT;

    ColumnBarChart() {
    }

    public ColumnBarChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, Type type) {
        super(dataset, renderer);
        this.mType = type;
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] points, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex) {
        int seriesNr = this.mDataset.getSeriesCount();
        int length = points.length;
        paint.setColor(seriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        float halfDiffX = this.getHalfDiffX(points, length, seriesNr);
        for (int i = 0; i < length; i += 2) {
            float x = points[i];
            float y = points[i + 1];
            this.drawBar(canvas, x, yAxisValue, x, y, halfDiffX, seriesNr, seriesIndex, paint);
        }
        paint.setColor(seriesRenderer.getColor());
    }

    protected void drawBar(Canvas canvas, float xMin, float yMin, float xMax, float yMax, float halfDiffX, int seriesNr, int seriesIndex, Paint paint) {
        int scale = this.mDataset.getSeriesAt(seriesIndex).getScaleNumber();
        if (this.mType == Type.STACKED) {
            this.drawBar(canvas, xMin - halfDiffX, yMax, xMax + halfDiffX, yMin, scale, seriesIndex, paint);
        } else {
            float startX = xMin - (float)seriesNr * halfDiffX + (float)(seriesIndex * 2) * halfDiffX;
            this.drawBar(canvas, startX, yMax, startX + 2.0f * halfDiffX, yMin, scale, seriesIndex, paint);
        }
    }

    private void drawBar(Canvas canvas, float xMin, float yMin, float xMax, float yMax, int scale, int seriesIndex, Paint paint) {
        SimpleSeriesRenderer renderer = this.mRenderer.getSeriesRendererAt(seriesIndex);
        if (renderer.isGradientEnabled()) {
            float minY = (float)this.toScreenPoint(new double[]{0.0, renderer.getGradientStopValue()}, scale)[1];
            float maxY = (float)this.toScreenPoint(new double[]{0.0, renderer.getGradientStartValue()}, scale)[1];
            float gradientMinY = Math.max(minY, yMin);
            float gradientMaxY = Math.min(maxY, yMax);
            int gradientMinColor = renderer.getGradientStopColor();
            int gradientMaxColor = renderer.getGradientStartColor();
            int gradientStartColor = gradientMinColor;
            int gradientStopColor = gradientMaxColor;
            if (yMin < minY) {
                paint.setColor(gradientMaxColor);
                canvas.drawRect((float)Math.round(xMin), (float)Math.round(yMin), (float)Math.round(xMax), (float)Math.round(gradientMinY), paint);
            } else {
                gradientStopColor = this.getGradientPartialColor(gradientMaxColor, gradientMinColor, (maxY - gradientMinY) / (maxY - minY));
            }
            if (yMax > maxY) {
                paint.setColor(gradientMinColor);
                canvas.drawRect((float)Math.round(xMin), (float)Math.round(gradientMaxY), (float)Math.round(xMax), (float)Math.round(yMax), paint);
            } else {
                gradientStartColor = this.getGradientPartialColor(gradientMinColor, gradientMaxColor, (gradientMaxY - minY) / (maxY - minY));
            }
            GradientDrawable gradient = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{gradientStartColor, gradientStopColor});
            gradient.setBounds(Math.round(xMin), Math.round(gradientMinY), Math.round(xMax), Math.round(gradientMaxY));
            gradient.draw(canvas);
        } else {
            if (Math.abs(yMax - yMin) < 1.0E-7f) {
                return;
            }
            canvas.drawRect((float)Math.round(xMin), (float)Math.round(yMin), (float)Math.round(xMax), (float)Math.round(yMax), paint);
            int color2 = paint.getColor();
            paint.setColor(-16777216);
            paint.setStyle(Paint.Style.STROKE);
            canvas.drawRect((float)Math.round(xMin), (float)Math.round(yMin), (float)Math.round(xMax), (float)Math.round(yMax), paint);
            paint.setStyle(Paint.Style.FILL);
            paint.setColor(color2);
        }
    }

    private int getGradientPartialColor(int minColor, int maxColor, float fraction) {
        int alpha = Math.round(fraction * (float)Color.alpha((int)minColor) + (1.0f - fraction) * (float)Color.alpha((int)maxColor));
        int r = Math.round(fraction * (float)Color.red((int)minColor) + (1.0f - fraction) * (float)Color.red((int)maxColor));
        int g = Math.round(fraction * (float)Color.green((int)minColor) + (1.0f - fraction) * (float)Color.green((int)maxColor));
        int b = Math.round(fraction * (float)Color.blue((int)minColor) + (1.0f - fraction) * (float)Color.blue((int)maxColor));
        return Color.argb((int)alpha, (int)r, (int)g, (int)b);
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries series, Paint paint, float[] points, int seriesIndex) {
        int seriesNr = this.mDataset.getSeriesCount();
        float halfDiffX = this.getHalfDiffX(points, points.length, seriesNr);
        for (int k = 0; k < points.length; k += 2) {
            float x = points[k];
            if (this.mType == Type.DEFAULT) {
                x += (float)(seriesIndex * 2) * halfDiffX - ((float)seriesNr - 1.5f) * halfDiffX;
            }
            this.drawText(canvas, this.getLabel(series.getY(k / 2)), x, points[k + 1] - 3.5f, paint, 0.0f);
        }
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return (int)this.getRenderer().getLegendTextSize();
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        float shapeWidth = this.getRenderer().getLegendTextSize() * this.mRenderer.getZoomRate();
        float halfShapeWidth = shapeWidth / 2.0f;
        canvas.drawRect(x += halfShapeWidth, y - halfShapeWidth, x + shapeWidth, y + halfShapeWidth, paint);
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(-16777216);
        canvas.drawRect(x, y - halfShapeWidth, x + shapeWidth, y + halfShapeWidth, paint);
        paint.setStyle(Paint.Style.FILL);
    }

    protected float getHalfDiffX(float[] points, int length, int seriesNr) {
        float halfDiffX;
        int div = length;
        if (length > 2) {
            div = length - 2;
        }
        if ((halfDiffX = (points[length - 2] - points[0]) / (float)div) == 0.0f) {
            halfDiffX = this.getScreenR().width() / 2;
        }
        if (this.mType != Type.STACKED) {
            halfDiffX /= (float)(seriesNr + 1);
        }
        return (float)((double)halfDiffX / ((double)this.getCoeficient() * (1.0 + this.mRenderer.getBarSpacing())));
    }

    protected float getCoeficient() {
        return 1.0f;
    }

    @Override
    public double getDefaultMinimum() {
        return 0.0;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    public static enum Type {
        DEFAULT,
        STACKED;

    }
}

