/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine;

import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.BubbleChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.ColumnBarChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.CombinedXYChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.DialChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.DoughnutChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.LineChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.PieChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.RangeBarChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.ScatterChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.TimeChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.CategorySeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.MultipleCategorySeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYMultipleSeriesDataset;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DefaultRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DialRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;

public class ChartFactory {
    public static final String CHART = "chart";
    public static final String TITLE = "title";

    private ChartFactory() {
    }

    public static final AbstractChart getLineChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        ChartFactory.checkParameters(dataset, renderer);
        return new LineChart(dataset, renderer);
    }

    public static final AbstractChart getScatterChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        ChartFactory.checkParameters(dataset, renderer);
        return new ScatterChart(dataset, renderer);
    }

    public static final AbstractChart getBubbleChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        ChartFactory.checkParameters(dataset, renderer);
        return new BubbleChart(dataset, renderer);
    }

    public static final AbstractChart getTimeChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, String format) {
        ChartFactory.checkParameters(dataset, renderer);
        TimeChart chart = new TimeChart(dataset, renderer);
        chart.setDateFormat(format);
        return chart;
    }

    public static final AbstractChart getColumnBarChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, ColumnBarChart.Type type) {
        ChartFactory.checkParameters(dataset, renderer);
        return new ColumnBarChart(dataset, renderer, type);
    }

    public static final AbstractChart getRangeBarChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, ColumnBarChart.Type type) {
        ChartFactory.checkParameters(dataset, renderer);
        return new RangeBarChart(dataset, renderer, type);
    }

    public static final AbstractChart getCombinedXYChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, String[] types) {
        if (dataset == null || renderer == null || types == null || dataset.getSeriesCount() != types.length) {
            throw new IllegalArgumentException("Dataset, renderer and types should be not null and the datasets series count should be equal to the types length");
        }
        ChartFactory.checkParameters(dataset, renderer);
        return new CombinedXYChart(dataset, renderer, types);
    }

    public static final AbstractChart getPieChart(CategorySeries dataset, DefaultRenderer renderer) {
        ChartFactory.checkParameters(dataset, renderer);
        return new PieChart(dataset, renderer);
    }

    public static final AbstractChart getDialChartView(CategorySeries dataset, DialRenderer renderer) {
        ChartFactory.checkParameters(dataset, (DefaultRenderer)renderer);
        return new DialChart(dataset, renderer);
    }

    public static final AbstractChart getDoughnutChartView(MultipleCategorySeries dataset, DefaultRenderer renderer) {
        ChartFactory.checkParameters(dataset, renderer);
        return new DoughnutChart(dataset, renderer);
    }

    private static void checkParameters(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        if (dataset == null || renderer == null || dataset.getSeriesCount() != renderer.getSeriesRendererCount()) {
            throw new IllegalArgumentException("Dataset and renderer should be not null and should have the same number of series");
        }
    }

    private static void checkParameters(CategorySeries dataset, DefaultRenderer renderer) {
        if (dataset == null || renderer == null || dataset.getItemCount() != renderer.getSeriesRendererCount()) {
            throw new IllegalArgumentException("Dataset and renderer should be not null and the dataset number of items should be equal to the number of series renderers");
        }
    }

    private static void checkParameters(MultipleCategorySeries dataset, DefaultRenderer renderer) {
        if (dataset == null || renderer == null || !ChartFactory.checkMultipleSeriesItems(dataset, renderer.getSeriesRendererCount())) {
            throw new IllegalArgumentException("Titles and values should be not null and the dataset number of items should be equal to the number of series renderers");
        }
    }

    private static boolean checkMultipleSeriesItems(MultipleCategorySeries dataset, int value) {
        int count = dataset.getCategoriesCount();
        boolean equal = true;
        for (int k = 0; k < count && equal; ++k) {
            equal = dataset.getValues(k).length == dataset.getTitles(k).length;
        }
        return equal;
    }
}

