/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist;

import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.CalloutView;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.IExportListener;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.pagelist.APageListView;

public class APageListItem
extends ViewGroup
implements IExportListener {
    protected boolean mIsBlank;
    protected int pageIndex;
    protected int pageWidth;
    protected int pageHeight;
    protected APageListView listView;
    protected boolean isInit = true;
    protected IControl control;
    protected CalloutView callouts;

    public APageListItem(APageListView aListView, int pageWidth, int pageHeight) {
        super(aListView.getContext());
        this.listView = aListView;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.setBackgroundColor(-1);
    }

    public IControl getControl() {
        return this.control;
    }

    public void initCalloutView() {
        if (this.callouts == null) {
            this.callouts = new CalloutView(this.listView.getContext(), this.control, this);
            this.callouts.setIndex(this.pageIndex);
            this.addView(this.callouts, 0);
        }
    }

    @Override
    public void exportImage() {
        this.listView.postRepaint(this.listView.getCurrentPageView());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getMode((int)widthMeasureSpec) == 0 ? this.pageWidth : View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getMode((int)heightMeasureSpec) == 0 ? this.pageHeight : View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.callouts != null) {
            int w = right - left;
            int h = bottom - top;
            this.callouts.setZoom(this.listView.getZoom());
            this.callouts.layout(0, 0, w, h);
            this.callouts.bringToFront();
        }
    }

    public void setPageItemRawData(int pIndex, int pageWidth, int pageHeight) {
        this.mIsBlank = false;
        this.pageIndex = pIndex;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        if (this.callouts == null) {
            if (!this.control.getSysKit().getCalloutManager().isPathEmpty(pIndex)) {
                this.initCalloutView();
            }
        } else {
            this.callouts.setIndex(pIndex);
        }
    }

    public void releaseResources() {
        this.mIsBlank = true;
        this.pageIndex = 0;
        if (this.pageWidth == 0 || this.pageHeight == 0) {
            this.pageWidth = this.listView.getWidth();
            this.pageHeight = this.listView.getHeight();
        }
    }

    public void blank(int pageIndex) {
        this.mIsBlank = true;
        this.pageIndex = pageIndex;
        if (this.pageWidth == 0 || this.pageHeight == 0) {
            this.pageWidth = this.listView.getWidth();
            this.pageHeight = this.listView.getHeight();
        }
    }

    public void setLinkHighlighting(boolean vlaue) {
    }

    protected void addRepaintImageView(Bitmap bmp) {
    }

    protected void removeRepaintImageView() {
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public boolean isOpaque() {
        return true;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void dispose() {
        this.listView = null;
    }
}

