/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.PathInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CalloutManager {
    private int alpha = 255;
    private int color = -65536;
    private int width = 10;
    private int mode = 0;
    private IControl control;
    private HashMap<Integer, List<PathInfo>> mPathMap;

    public CalloutManager(IControl control) {
        this.control = control;
        this.mPathMap = new HashMap();
    }

    public void drawPath(Canvas canvas, int index, float zoom) {
        canvas.scale(zoom, zoom);
        List<PathInfo> pathList = this.mPathMap.get(index);
        Paint paint = PaintKit.instance().getPaint();
        if (pathList != null) {
            for (int i = 0; i < pathList.size(); ++i) {
                PathInfo pathInfo = pathList.get(i);
                paint.setStrokeWidth((float)pathInfo.width);
                paint.setColor(pathInfo.color);
                canvas.drawPath(pathInfo.path, paint);
            }
        }
    }

    public boolean isPathEmpty() {
        return this.mPathMap.size() == 0;
    }

    public boolean isPathEmpty(int index) {
        return this.mPathMap.get(index) == null;
    }

    public List<PathInfo> getPath(int index, boolean assignPath) {
        if (assignPath && this.mPathMap.get(index) == null) {
            this.mPathMap.put(index, new ArrayList());
        }
        return this.mPathMap.get(index);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color2) {
        this.color = color2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setDrawingMode(int mode) {
        if (mode < 0 || mode > 2) {
            return;
        }
        this.mode = mode;
    }

    public int getDrawingMode() {
        return this.mode;
    }

    public void dispose() {
        this.mPathMap.clear();
        this.mPathMap = null;
        this.control = null;
    }
}

