/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.system;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Toast;
import com.ahmadullahpk.alldocumentreader.xs.common.ICustomDialog;
import com.ahmadullahpk.alldocumentreader.xs.common.IOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.common.ISlideShow;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.doc.TXTKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.pdf.PDFLib;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGControl;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.ss.control.SSControl;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.system.AUncaughtExceptionHandler;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractControl;
import com.ahmadullahpk.alldocumentreader.xs.system.FileKit;
import com.ahmadullahpk.alldocumentreader.xs.system.FileReaderThread;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IFind;
import com.ahmadullahpk.alldocumentreader.xs.system.IMainFrame;
import com.ahmadullahpk.alldocumentreader.xs.system.IReader;
import com.ahmadullahpk.alldocumentreader.xs.system.SysKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.WPControl;

public class MainControl
extends AbstractControl {
    private IControl appControl;
    private ICustomDialog customDialog;
    private String filePath;
    private IMainFrame frame;
    private Handler handler;
    private boolean isAutoTest;
    private boolean isCancel;
    private boolean isDispose;
    private IOfficeToPicture officeToPicture;
    private DialogInterface.OnKeyListener onKeyListener;
    private ProgressDialog progressDialog;
    private IReader reader;
    private ISlideShow slideShow;
    private Toast toast;
    private AUncaughtExceptionHandler uncaught;
    private byte applicationType = (byte)-1;
    public SysKit sysKit = new SysKit(this);

    @Override
    public Dialog getDialog(Activity activity, int id2) {
        return null;
    }

    @Override
    public void layoutView(int x, int y, int w, int h) {
    }

    public MainControl(IMainFrame frame) {
        AUncaughtExceptionHandler aUncaughtExceptionHandler;
        this.frame = frame;
        this.uncaught = aUncaughtExceptionHandler = new AUncaughtExceptionHandler(this);
        Thread.setDefaultUncaughtExceptionHandler(aUncaughtExceptionHandler);
        this.init();
    }

    private void init() {
        this.initListener();
        boolean z = false;
        this.toast = Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)"", (int)0);
        String stringExtra = this.getActivity().getIntent().getStringExtra("autoTest");
        if (stringExtra != null && stringExtra.equals("true")) {
            z = true;
        }
        this.isAutoTest = z;
    }

    @SuppressLint(value={"HandlerLeak"})
    private void initListener() {
        this.onKeyListener = (dialog, keyCode, event) -> {
            if (keyCode != 4) {
                return false;
            }
            dialog.dismiss();
            this.isCancel = true;
            if (this.reader != null) {
                this.reader.abortReader();
                this.reader.dispose();
            }
            this.getActivity().onBackPressed();
            return true;
        };
        this.handler = new Handler(){

            public void handleMessage(Message msg) {
                if (!MainControl.this.isCancel) {
                    int i = msg.what;
                    if (i == 0) {
                        this.post(() -> {
                            try {
                                if (MainControl.this.getMainFrame().isShowProgressBar()) {
                                    MainControl.this.dismissProgressDialog();
                                } else if (MainControl.this.customDialog != null) {
                                    MainControl.this.customDialog.dismissDialog((byte)2);
                                }
                                MainControl.this.createApplication(msg.obj);
                            }
                            catch (Exception e) {
                                MainControl.this.sysKit.getErrorKit().writerLog(e, true);
                            }
                        });
                    } else if (i == 1) {
                        this.post(() -> {
                            MainControl.this.dismissProgressDialog();
                            if (msg.obj instanceof Throwable) {
                                MainControl.this.sysKit.getErrorKit().writerLog((Throwable)msg.obj, true);
                            }
                        });
                    } else if (i != 2) {
                        if (i == 3) {
                            this.post(MainControl.this::dismissProgressDialog);
                        } else if (i == 4) {
                            MainControl.this.reader = (IReader)msg.obj;
                        }
                    } else if (MainControl.this.getMainFrame().isShowProgressBar()) {
                        this.post(() -> {
                            MainControl.this.progressDialog = ProgressDialog.show((Context)MainControl.this.getActivity(), (CharSequence)MainControl.this.frame.getAppName(), (CharSequence)MainControl.this.frame.getLocalString("DIALOG_LOADING"), (boolean)false, (boolean)false, null);
                            MainControl.this.progressDialog.setOnKeyListener(MainControl.this.onKeyListener);
                        });
                    } else if (MainControl.this.customDialog != null) {
                        MainControl.this.customDialog.showDialog((byte)2);
                    }
                }
            }
        };
    }

    public void dismissProgressDialog() {
        Handler handler;
        ProgressDialog progressDialog = this.progressDialog;
        if (progressDialog != null) {
            progressDialog.dismiss();
            this.progressDialog = null;
        }
        if ((handler = this.handler) != null) {
            handler.removeCallbacksAndMessages(null);
        }
    }

    public void createApplication(Object obj) throws Exception {
        if (obj != null) {
            boolean z;
            Object viewBackground;
            byte b = this.applicationType;
            if (b == 0) {
                this.appControl = new WPControl(this, (IDocument)obj, this.filePath);
            } else if (b == 1) {
                this.appControl = new SSControl(this, (Workbook)obj, this.filePath);
            } else if (b == 2) {
                this.appControl = new PGControl(this, (PGModel)obj, this.filePath);
            }
            View view = this.appControl.getView();
            if (view != null && (viewBackground = this.frame.getViewBackground()) != null) {
                if (viewBackground instanceof Integer) {
                    view.setBackgroundColor(((Integer)viewBackground).intValue());
                } else if (viewBackground instanceof Drawable) {
                    view.setBackgroundDrawable((Drawable)viewBackground);
                }
            }
            boolean bl = z = this.applicationType == 3 && ((PDFLib)obj).hasPasswordSync();
            if (this.applicationType != 3) {
                this.frame.openFileFinish();
            } else if (!z) {
                this.frame.openFileFinish();
            }
            PictureKit.instance().setDrawPictrue(true);
            this.handler.post(() -> {
                if (Build.VERSION.SDK_INT >= 11) {
                    try {
                        View view2 = this.getView();
                        Object invoke = view2.getClass().getMethod("isHardwareAccelerated", null).invoke((Object)view2, null);
                        if (invoke != null && invoke instanceof Boolean && ((Boolean)invoke).booleanValue()) {
                            view2.getClass().getMethod("setLayerType", Integer.TYPE, Paint.class).invoke((Object)view2, view2.getClass().getField("LAYER_TYPE_SOFTWARE").getInt(null), null);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.actionEvent(26, false);
                this.actionEvent(19, null);
                if (this.applicationType != 3) {
                    this.frame.updateToolsbarStatus();
                } else if (!z) {
                    this.frame.updateToolsbarStatus();
                }
                this.getView().postInvalidate();
            });
            return;
        }
        throw new Exception("Document with password");
    }

    @Override
    public boolean openFile(String filePath) {
        this.filePath = filePath;
        String lowerCase = filePath.toLowerCase();
        this.applicationType = lowerCase.endsWith("doc") || lowerCase.endsWith("docx") || lowerCase.endsWith("txt") || lowerCase.endsWith("dot") || lowerCase.endsWith("dotx") || lowerCase.endsWith("dotm") ? (byte)0 : (lowerCase.endsWith("xls") || lowerCase.endsWith("xlsx") || lowerCase.endsWith("xlt") || lowerCase.endsWith("xltx") || lowerCase.endsWith("xltm") || lowerCase.endsWith("xlsm") ? (byte)1 : (lowerCase.endsWith("ppt") || lowerCase.endsWith("pptx") || lowerCase.endsWith("pot") || lowerCase.endsWith("pptm") || lowerCase.endsWith("potx") || lowerCase.endsWith("potm") ? (byte)2 : (lowerCase.endsWith("pdf") ? (byte)3 : (byte)0)));
        boolean isSupport = FileKit.instance().isSupport(lowerCase);
        if (lowerCase.endsWith("txt") || !isSupport) {
            TXTKit.instance().readText(this, this.handler, filePath);
        } else {
            new FileReaderThread(this, this.handler, filePath, null).start();
        }
        return true;
    }

    @Override
    public void actionEvent(int actionID, Object obj) {
        IMainFrame iMainFrame;
        if (actionID == 23 && this.reader != null) {
            IControl iControl = this.appControl;
            if (iControl != null) {
                iControl.actionEvent(actionID, obj);
            }
            this.reader.dispose();
            this.reader = null;
        }
        if ((iMainFrame = this.frame) != null && !iMainFrame.doActionEvent(actionID, obj)) {
            if (actionID == -268435456) {
                this.getView().postInvalidate();
            } else if (actionID == 0) {
                try {
                    Message message = new Message();
                    message.obj = obj;
                    this.reader.dispose();
                    message.what = 0;
                    this.handler.handleMessage(message);
                }
                catch (Throwable th) {
                    this.sysKit.getErrorKit().writerLog(th);
                }
            } else if (actionID == 26) {
                Handler handler = this.handler;
                if (handler != null) {
                    handler.post(() -> {
                        if (!this.isDispose) {
                            this.frame.showProgressBar((Boolean)obj);
                        }
                    });
                }
            } else if (actionID == 0x20000007) {
                this.appControl.actionEvent(actionID, obj);
                this.frame.updateToolsbarStatus();
            } else if (actionID == 0x20000009) {
                IReader iReader = this.reader;
                if (iReader != null) {
                    iReader.abortReader();
                }
            } else if (actionID != 17) {
                if (actionID == 18) {
                    this.toast.cancel();
                } else if (actionID == 23) {
                    Handler handler2 = this.handler;
                    if (handler2 != null) {
                        handler2.post(() -> {
                            if (!this.isDispose) {
                                this.frame.showProgressBar(false);
                            }
                        });
                    }
                } else if (actionID == 24) {
                    Handler handler3 = this.handler;
                    if (handler3 != null) {
                        handler3.post(() -> {
                            if (!this.isDispose) {
                                this.frame.showProgressBar(true);
                            }
                        });
                    }
                } else if (actionID == 0x7000000) {
                    TXTKit.instance().reopenFile(this, this.handler, this.filePath, (String)obj);
                } else if (actionID != 0x7000001) {
                    IControl iControl2 = this.appControl;
                    if (iControl2 != null) {
                        iControl2.actionEvent(actionID, obj);
                    }
                } else {
                    String[] strArr = (String[])obj;
                    if (strArr.length == 2) {
                        this.filePath = strArr[0];
                        this.applicationType = 0;
                        TXTKit.instance().reopenFile(this, this.handler, this.filePath, strArr[1]);
                    }
                }
            } else if (obj instanceof String) {
                this.toast.setText((CharSequence)((String)obj));
                this.toast.setGravity(17, 0, 0);
                this.toast.show();
            }
        }
    }

    @Override
    public IFind getFind() {
        return this.appControl.getFind();
    }

    @Override
    public Object getActionValue(int actionID, Object obj) {
        if (actionID == 1) {
            return this.filePath;
        }
        IControl iControl = this.appControl;
        if (iControl == null) {
            return null;
        }
        if (actionID != 0x20000010 && actionID != 0x30000003 && actionID != 536870931 && actionID != 0x50000003 && actionID != 1358954506) {
            return iControl.getActionValue(actionID, obj);
        }
        boolean isDrawPictrue = PictureKit.instance().isDrawPictrue();
        boolean isThumbnail = this.frame.isThumbnail();
        PictureKit.instance().setDrawPictrue(true);
        if (actionID == 0x20000010) {
            this.frame.setThumbnail(true);
        }
        Object actionValue = this.appControl.getActionValue(actionID, obj);
        if (actionID == 0x20000010) {
            this.frame.setThumbnail(isThumbnail);
        }
        PictureKit.instance().setDrawPictrue(isDrawPictrue);
        return actionValue;
    }

    @Override
    public View getView() {
        IControl iControl = this.appControl;
        if (iControl == null) {
            return null;
        }
        return iControl.getView();
    }

    @Override
    public boolean isAutoTest() {
        return this.isAutoTest;
    }

    @Override
    public IMainFrame getMainFrame() {
        return this.frame;
    }

    @Override
    public Activity getActivity() {
        return this.frame.getActivity();
    }

    @Override
    public IOfficeToPicture getOfficeToPicture() {
        return this.officeToPicture;
    }

    @Override
    public ICustomDialog getCustomDialog() {
        return this.customDialog;
    }

    @Override
    public ISlideShow getSlideShow() {
        return this.slideShow;
    }

    @Override
    public IReader getReader() {
        return this.reader;
    }

    @Override
    public byte getApplicationType() {
        return this.applicationType;
    }

    public void setOffictToPicture(IOfficeToPicture opt) {
        this.officeToPicture = opt;
    }

    public void setCustomDialog(ICustomDialog dlg) {
        this.customDialog = dlg;
    }

    public void setSlideShow(ISlideShow slideshow) {
        this.slideShow = slideshow;
    }

    @Override
    public SysKit getSysKit() {
        return this.sysKit;
    }

    @Override
    public int getCurrentViewIndex() {
        return this.appControl.getCurrentViewIndex();
    }

    @Override
    public void dispose() {
        AUncaughtExceptionHandler aUncaughtExceptionHandler;
        ProgressDialog progressDialog;
        IOfficeToPicture iOfficeToPicture;
        IReader iReader;
        this.isDispose = true;
        IControl iControl = this.appControl;
        if (iControl != null) {
            iControl.dispose();
            this.appControl = null;
        }
        if ((iReader = this.reader) != null) {
            iReader.dispose();
            this.reader = null;
        }
        if ((iOfficeToPicture = this.officeToPicture) != null) {
            iOfficeToPicture.dispose();
            this.officeToPicture = null;
        }
        if ((progressDialog = this.progressDialog) != null) {
            progressDialog.dismiss();
            this.progressDialog = null;
        }
        if (this.customDialog != null) {
            this.customDialog = null;
        }
        if (this.slideShow != null) {
            this.slideShow = null;
        }
        this.frame = null;
        Handler handler = this.handler;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
            this.handler = null;
        }
        if ((aUncaughtExceptionHandler = this.uncaught) != null) {
            aUncaughtExceptionHandler.dispose();
            this.uncaught = null;
        }
        this.onKeyListener = null;
        this.toast = null;
        this.filePath = null;
        System.gc();
        SysKit sysKit = this.sysKit;
        if (sysKit != null) {
            sysKit.dispose();
        }
    }
}

