/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.system;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import com.ahmadullahpk.alldocumentreader.xs.common.ICustomDialog;
import com.ahmadullahpk.alldocumentreader.xs.fc.OldFileFormatException;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.OfficeXmlFileException;
import com.ahmadullahpk.alldocumentreader.xs.system.AbortReaderError;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.SysKit;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ErrorUtil {
    public static final int INSUFFICIENT_MEMORY = 0;
    public static final int SYSTEM_CRASH = 1;
    public static final int BAD_FILE = 2;
    public static final int OLD_DOCUMENT = 3;
    public static final int PARSE_ERROR = 4;
    public static final int RTF_DOCUMENT = 5;
    public static final int PASSWORD_DOCUMENT = 6;
    public static final int PASSWORD_INCORRECT = 7;
    public static final int SD_CARD_ERROR = 8;
    public static final int SD_CARD_WRITEDENIED = 9;
    public static final int SD_CARD_NOSPACELEFT = 10;
    private static final SimpleDateFormat sdf_24 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String VERSION = "2.0.0.4";
    private File logFile;
    private AlertDialog message;
    private SysKit sysKit;

    public ErrorUtil(SysKit syskit) {
        this.sysKit = syskit;
        if (syskit.getControl().getMainFrame().isWriteLog()) {
            this.logFile = syskit.getControl().getMainFrame().getTemporaryDirectory();
            if (this.logFile == null || !this.logFile.exists() || !this.logFile.canWrite()) {
                return;
            }
            this.logFile = new File(this.logFile.getAbsolutePath() + File.separatorChar + "ASReader");
            if (!this.logFile.exists()) {
                this.logFile.mkdirs();
            }
            this.logFile = new File(this.logFile.getAbsolutePath() + File.separatorChar + "errorLog.txt");
        }
    }

    public void writerLog(Throwable ex) {
        this.writerLog(ex, false);
    }

    public void writerLog(Throwable ex, boolean isReaderFile) {
        this.writerLog(ex, isReaderFile, true);
    }

    public void writerLog(Throwable ex, boolean isReaderFile, boolean isShowErrorDialog) {
        try {
            if (ex instanceof AbortReaderError) {
                return;
            }
            if (this.logFile == null) {
                ex = new Throwable("SD CARD ERROR");
            } else if (this.logFile != null && this.logFile.exists() && !this.logFile.canWrite()) {
                ex = new Throwable("Write Permission denied");
            } else if (this.sysKit.getControl().getMainFrame().isWriteLog() && !(ex instanceof OutOfMemoryError)) {
                FileWriter info = new FileWriter(this.logFile, true);
                PrintWriter printWriter = new PrintWriter((Writer)info, true);
                printWriter.println();
                printWriter.println("--------------------------------------------------------------------------");
                printWriter.println("Exception occurs: " + sdf_24.format(Calendar.getInstance().getTime()) + "  " + VERSION);
                ex.printStackTrace(printWriter);
                info.close();
            }
            if (isShowErrorDialog) {
                this.processThrowable(ex, isReaderFile);
            }
        }
        catch (OutOfMemoryError e) {
            this.sysKit.getControl().getMainFrame().getActivity().onBackPressed();
        }
        catch (Exception eee) {
            return;
        }
    }

    private void processThrowable(final Throwable ex, final boolean isReaderFile) {
        final IControl control = this.sysKit.getControl();
        final Activity activity = control.getMainFrame().getActivity();
        if (control == null || activity == null) {
            return;
        }
        if (control.isAutoTest()) {
            System.exit(0);
        } else if (this.message == null) {
            control.getActivity().getWindow().getDecorView().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        String err = "";
                        String error = ex.toString();
                        int errorCode = 1;
                        if (error.contains("SD")) {
                            err = control.getMainFrame().getLocalString("SD_CARD");
                            errorCode = 8;
                        } else if (error.contains("Write Permission denied")) {
                            err = control.getMainFrame().getLocalString("SD_CARD_WRITEDENIED");
                            errorCode = 9;
                        } else if (error.contains("No space left on device")) {
                            err = control.getMainFrame().getLocalString("SD_CARD_NOSPACELEFT");
                            errorCode = 10;
                        } else if (ex instanceof OutOfMemoryError || error.contains("OutOfMemoryError")) {
                            err = control.getMainFrame().getLocalString("DIALOG_INSUFFICIENT_MEMORY");
                            errorCode = 0;
                        } else if (error.contains("no such entry") || error.contains("Format error") || error.contains("Unable to read entire header") || ex instanceof OfficeXmlFileException || error.contains("The text piece table is corrupted") || error.contains("Invalid header signature")) {
                            err = control.getMainFrame().getLocalString("DIALOG_FORMAT_ERROR");
                            errorCode = 2;
                        } else if (error.contains("The document is really a RTF file")) {
                            err = control.getMainFrame().getLocalString("DIALOG_RTF_FILE");
                            errorCode = 5;
                        } else if (ex instanceof OldFileFormatException) {
                            err = control.getMainFrame().getLocalString("DIALOG_OLD_DOCUMENT");
                            errorCode = 3;
                        } else if (error.contains("Cannot process encrypted office file")) {
                            err = control.getMainFrame().getLocalString("DIALOG_CANNOT_ENCRYPTED_FILE");
                            errorCode = 6;
                        } else if (error.contains("Password is incorrect")) {
                            err = control.getMainFrame().getLocalString("DIALOG_PASSWORD_INCORRECT");
                            errorCode = 7;
                        } else if (isReaderFile) {
                            err = control.getMainFrame().getLocalString("DIALOG_PARSE_ERROR");
                            errorCode = 4;
                        } else if (ex instanceof NullPointerException || ex instanceof IllegalArgumentException || ex instanceof ClassCastException) {
                            err = control.getMainFrame().getLocalString("DIALOG_SYSTEM_CRASH");
                            errorCode = 1;
                        } else if (ErrorUtil.this.sysKit.isDebug()) {
                            err = control.getMainFrame().getLocalString("DIALOG_SYSTEM_CRASH");
                        }
                        if (err.length() > 0) {
                            control.getMainFrame().error(errorCode);
                            control.actionEvent(0x20000009, true);
                            if (control.getMainFrame().isPopUpErrorDlg() && ErrorUtil.this.message == null) {
                                AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                                builder.setMessage((CharSequence)err);
                                builder.setCancelable(false);
                                builder.setTitle((CharSequence)control.getMainFrame().getAppName());
                                String ok = control.getMainFrame().getLocalString("BUTTON_OK");
                                builder.setPositiveButton((CharSequence)ok, (dialog, id2) -> {
                                    ErrorUtil.this.message = null;
                                    activity.onBackPressed();
                                });
                                ErrorUtil.this.message = builder.create();
                                ErrorUtil.this.message.show();
                            } else {
                                ICustomDialog dlgListener = control.getCustomDialog();
                                if (dlgListener != null) {
                                    dlgListener.showDialog((byte)3);
                                }
                            }
                        }
                    }
                    catch (Exception eee) {
                        eee.printStackTrace();
                    }
                }
            });
        }
    }

    public void dispose() {
        this.sysKit = null;
    }
}

