/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.SheetScroller;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.HeaderUtil;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;

public class RowHeader {
    private static final int EXTEDES_WIDTH = 10;
    private SheetView sheetview;
    private int rowHeaderWidth = 50;
    private float y;
    private Rect rect;

    public RowHeader(SheetView sheetView) {
        this.sheetview = sheetView;
    }

    public int getRowBottomBound(Canvas canvas, float zoom) {
        canvas.save();
        Rect clip = canvas.getClipBounds();
        Paint paint = PaintKit.instance().getPaint();
        paint.setTextSize(16.0f * zoom);
        this.y = 30.0f * zoom;
        this.layoutRowLine(canvas, 0, zoom, paint);
        canvas.restore();
        return Math.min((int)this.y, clip.bottom);
    }

    private void layoutRowLine(Canvas canvas, int rowStart, float zoom, Paint paint) {
        int maxSheetRows;
        int rowIndex;
        Rect clip = canvas.getClipBounds();
        float h = 0.0f;
        Sheet sheet = this.sheetview.getCurrentSheet();
        SheetScroller minRowAndColumnInformation = this.sheetview.getMinRowAndColumnInformation();
        int n = rowIndex = minRowAndColumnInformation.getMinRowIndex() > rowStart ? minRowAndColumnInformation.getMinRowIndex() : rowStart;
        if (!minRowAndColumnInformation.isRowAllVisible()) {
            ++rowIndex;
            this.y = (float)((double)this.y + minRowAndColumnInformation.getVisibleRowHeight() * (double)zoom);
        }
        int n2 = maxSheetRows = sheet.getWorkbook().isBefore07Version() ? 65536 : 0x100000;
        while (this.y <= (float)clip.bottom && rowIndex < maxSheetRows) {
            Row row = sheet.getRow(rowIndex);
            if (row != null && row.isZeroHeight()) {
                ++rowIndex;
                continue;
            }
            h = row == null ? (float)this.sheetview.getCurrentSheet().getDefaultRowHeight() : row.getRowPixelHeight();
            this.y += (h *= zoom);
            ++rowIndex;
        }
    }

    public void draw(Canvas canvas, int rightBound, float zoom) {
        canvas.save();
        Paint paint = PaintKit.instance().getPaint();
        int oldColor = paint.getColor();
        float oldTextSize = paint.getTextSize();
        paint.setTextSize(16.0f * zoom);
        this.y = 30.0f * zoom;
        this.rect = canvas.getClipBounds();
        this.rect.set(0, 0, this.rowHeaderWidth, this.rect.bottom);
        paint.setColor(-2894893);
        canvas.drawRect(this.rect, paint);
        this.drawRowLine(canvas, rightBound, 0, zoom, paint);
        paint.setColor(oldColor);
        paint.setTextSize(oldTextSize);
        canvas.restore();
    }

    private void drawFirstVisibleHeader(Canvas canvas, float rightBound, float zoom, Paint paint) {
        Paint.FontMetrics fm = paint.getFontMetrics();
        Rect clip = canvas.getClipBounds();
        float visibleRowHeight = 0.0f;
        SheetScroller minRowAndColumnInformation = this.sheetview.getMinRowAndColumnInformation();
        float rowHeight = minRowAndColumnInformation.getRowHeight() * zoom;
        visibleRowHeight = (float)(minRowAndColumnInformation.getVisibleRowHeight() * (double)zoom);
        if (HeaderUtil.instance().isActiveRow(this.sheetview.getCurrentSheet(), minRowAndColumnInformation.getMinRowIndex())) {
            paint.setColor(-3932316);
        } else {
            paint.setColor(-2894893);
        }
        this.rect.set(0, (int)this.y, this.rowHeaderWidth, (int)(this.y + visibleRowHeight));
        canvas.drawRect(this.rect, paint);
        paint.setColor(-3681831);
        canvas.drawRect(0.0f, this.y, rightBound, this.y + 1.0f, paint);
        paint.setColor(-9671571);
        canvas.drawRect(0.0f, this.y, (float)this.rowHeaderWidth, this.y + 1.0f, paint);
        canvas.save();
        canvas.clipRect(this.rect);
        paint.setColor(-16777216);
        String rowText = String.valueOf(minRowAndColumnInformation.getMinRowIndex() + 1);
        int textWidth = (int)paint.measureText(rowText);
        int textX = (this.rowHeaderWidth - textWidth) / 2;
        int textY = (int)((double)rowHeight - Math.ceil(fm.descent - fm.ascent));
        canvas.drawText(rowText, (float)textX, this.y + (float)textY - fm.ascent - (rowHeight - visibleRowHeight), paint);
        canvas.restore();
    }

    private void drawRowLine(Canvas canvas, int rightBound, int rowStart, float zoom, Paint paint) {
        int maxSheetRows;
        int rowIndex;
        Paint.FontMetrics fm = paint.getFontMetrics();
        Rect clip = canvas.getClipBounds();
        float h = 0.0f;
        Sheet sheet = this.sheetview.getCurrentSheet();
        SheetScroller minRowAndColumnInformation = this.sheetview.getMinRowAndColumnInformation();
        int n = rowIndex = minRowAndColumnInformation.getMinRowIndex() > rowStart ? minRowAndColumnInformation.getMinRowIndex() : rowStart;
        if (!minRowAndColumnInformation.isRowAllVisible()) {
            this.drawFirstVisibleHeader(canvas, rightBound, zoom, paint);
            ++rowIndex;
            this.y = (float)((double)this.y + minRowAndColumnInformation.getVisibleRowHeight() * (double)zoom);
        }
        int n2 = maxSheetRows = sheet.getWorkbook().isBefore07Version() ? 65536 : 0x100000;
        while (this.y <= (float)clip.bottom && rowIndex < maxSheetRows) {
            Row row = sheet.getRow(rowIndex);
            if (row != null && row.isZeroHeight()) {
                paint.setColor(-9671571);
                canvas.drawRect(0.0f, this.y - 1.0f, (float)this.rowHeaderWidth, this.y + 1.0f, paint);
                ++rowIndex;
                continue;
            }
            h = row == null ? (float)this.sheetview.getCurrentSheet().getDefaultRowHeight() : row.getRowPixelHeight();
            h *= zoom;
            if (HeaderUtil.instance().isActiveRow(this.sheetview.getCurrentSheet(), rowIndex)) {
                paint.setColor(-3932316);
            } else {
                paint.setColor(-2894893);
            }
            this.rect.set(0, (int)this.y, this.rowHeaderWidth, (int)(this.y + h));
            canvas.drawRect(this.rect, paint);
            paint.setColor(-3681831);
            canvas.drawRect(0.0f, this.y, (float)rightBound, this.y + 1.0f, paint);
            paint.setColor(-9671571);
            canvas.drawRect(0.0f, this.y, (float)this.rowHeaderWidth, this.y + 1.0f, paint);
            canvas.save();
            canvas.clipRect(this.rect);
            paint.setColor(-16777216);
            String rowText = String.valueOf(rowIndex + 1);
            int textWidth = (int)paint.measureText(rowText);
            int textX = (this.rowHeaderWidth - textWidth) / 2;
            int textY = (int)((double)h - Math.ceil(fm.descent - fm.ascent));
            canvas.drawText(rowText, (float)textX, this.y + (float)textY - fm.ascent, paint);
            canvas.restore();
            this.y += h;
            ++rowIndex;
        }
        paint.setColor(-3681831);
        canvas.drawRect(0.0f, this.y, (float)rightBound, this.y + 1.0f, paint);
        paint.setColor(-9671571);
        canvas.drawRect(0.0f, this.y, (float)this.rowHeaderWidth, this.y + 1.0f, paint);
        if (this.y < (float)clip.bottom) {
            paint.setColor(-2894893);
            this.rect.set(0, (int)(this.y + 1.0f), clip.right, clip.bottom);
            canvas.drawRect(this.rect, paint);
        }
        paint.setColor(-9671571);
        canvas.drawRect((float)this.rowHeaderWidth, 0.0f, (float)(this.rowHeaderWidth + 1), this.y, paint);
    }

    public void calculateRowHeaderWidth(float zoom) {
        Paint paint = PaintKit.instance().getPaint();
        paint.setTextSize(16.0f);
        this.rowHeaderWidth = Math.round(paint.measureText(String.valueOf(this.sheetview.getCurrentMinRow()))) + 10;
        this.rowHeaderWidth = Math.round((float)Math.max(this.rowHeaderWidth, 50) * zoom);
    }

    public int getRowHeaderWidth() {
        return this.rowHeaderWidth;
    }

    public void setRowHeaderWidth(int rowHeaderWidth) {
        this.rowHeaderWidth = rowHeaderWidth;
    }

    public void dispose() {
        this.sheetview = null;
        this.rect = null;
    }
}

