/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.view;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.AShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.LinearGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.PatternShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.TileShader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.RunAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.SchemeColorUtil;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.FontKit;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttributeSetImpl;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.CellLeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.STDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.STRoot;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTable;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTableCellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTableStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.TableStyleKit;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.DrawingCell;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.MergeCell;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.MergeCellMgr;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ModelUtil;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.format.NumericFormatter;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.CellBorderView;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class CellView {
    private SheetView sheetView = null;
    private CellBorderView cellBorderView;
    private float left;
    private float top;
    private MergeCell mergedCellSize = new MergeCell();
    private MergeCellMgr mergedCellMgr = new MergeCellMgr();
    private DrawingCell cellInfor;
    private RectF cellRect;
    private boolean numericCellAlignRight;
    private StringBuilder strBuilder = new StringBuilder();
    private TableStyleKit tableStyleKit = new TableStyleKit();

    public CellView(SheetView sheetView) {
        this.sheetView = sheetView;
        this.cellBorderView = new CellBorderView(sheetView);
        this.cellRect = new RectF();
    }

    private void redrawMergedCellBordersAndBackground(Canvas canvas, CellRangeAddress cr) {
        canvas.save();
        canvas.clipRect(this.left, this.top, this.left + this.mergedCellSize.getWidth() - this.mergedCellSize.getNovisibleWidth() - (this.cellInfor.getWidth() - this.cellInfor.getVisibleWidth()), this.top + this.mergedCellSize.getHeight() - this.mergedCellSize.getNoVisibleHeight() - (this.cellInfor.getHeight() - this.cellInfor.getVisibleHeight()));
        canvas.drawColor(-1);
        Paint paint = PaintKit.instance().getPaint();
        int oldColor = paint.getColor();
        Paint.Style oldStyle = paint.getStyle();
        paint.setColor(-3681831);
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawRect(this.left, this.top, this.left + this.mergedCellSize.getWidth() - this.mergedCellSize.getNovisibleWidth(), this.top + this.mergedCellSize.getHeight() - this.mergedCellSize.getNoVisibleHeight(), paint);
        paint.setStyle(oldStyle);
        int minRowIndex = this.sheetView.getMinRowAndColumnInformation().getMinRowIndex();
        int minColumnIndex = this.sheetView.getMinRowAndColumnInformation().getMinColumnIndex();
        if (this.mergedCellSize.isFrozenRow()) {
            minRowIndex = 0;
        }
        if (this.mergedCellSize.isFrozenColumn()) {
            minColumnIndex = 0;
        }
        if (minRowIndex >= cr.getFirstRow()) {
            paint.setColor(-9671571);
            canvas.drawRect(this.left, this.top, this.left + this.mergedCellSize.getWidth() - this.mergedCellSize.getNovisibleWidth(), this.top + 1.0f, paint);
        }
        if (minColumnIndex >= cr.getFirstColumn()) {
            paint.setColor(-9671571);
            canvas.drawRect(this.left, this.top, this.left + 1.0f, this.top + this.mergedCellSize.getHeight() - this.mergedCellSize.getNoVisibleHeight(), paint);
        }
        paint.setColor(oldColor);
        canvas.restore();
    }

    public void draw(Canvas canvas, Cell cell, DrawingCell cellInfor) {
        if (cell == null || this.sheetView.getSpreadsheet().isAbortDrawing()) {
            return;
        }
        Sheet sheet = this.sheetView.getCurrentSheet();
        this.cellInfor = cellInfor;
        this.left = cellInfor.getLeft();
        this.top = cellInfor.getTop();
        this.mergedCellSize.setWidth(cellInfor.getWidth());
        this.mergedCellSize.setHeight(cellInfor.getHeight());
        this.mergedCellSize.setNovisibleWidth(0.0f);
        this.mergedCellSize.setNoVisibleHeight(0.0f);
        if (cell.getRangeAddressIndex() >= 0) {
            CellRangeAddress cr = sheet.getMergeRange(cell.getRangeAddressIndex());
            if (this.mergedCellMgr.isDrawMergeCell(this.sheetView, cr, cellInfor.getRowIndex(), cellInfor.getColumnIndex())) {
                this.mergedCellSize = this.mergedCellMgr.getMergedCellSize(this.sheetView, cr, cellInfor.getRowIndex(), cellInfor.getColumnIndex());
                cell = sheet.getRow(cr.getFirstRow()).getCell(cr.getFirstColumn());
                this.redrawMergedCellBordersAndBackground(canvas, cr);
            } else {
                return;
            }
        }
        this.cellRect.set(this.left, this.top, this.left + this.mergedCellSize.getWidth() - this.mergedCellSize.getNovisibleWidth() - (cellInfor.getWidth() - cellInfor.getVisibleWidth()), this.top + this.mergedCellSize.getHeight() - this.mergedCellSize.getNoVisibleHeight() - (cellInfor.getHeight() - cellInfor.getVisibleHeight()));
        SSTable table = cell.getTableInfo();
        SSTableCellStyle tableCellStyle = null;
        if (table != null) {
            tableCellStyle = this.getTableCellStyle(table, this.sheetView.getCurrentSheet().getWorkbook(), cell.getRowNumber(), cell.getColNumber());
        }
        this.drawCellBackgroundAndBorder(canvas, cell, tableCellStyle);
        this.drawCellContents(canvas, cell, cellInfor, tableCellStyle);
    }

    public void drawActiveCellBorder(Canvas canvas, RectF rect, short activeCellType) {
        this.cellBorderView.drawActiveCellBorder(canvas, rect, activeCellType);
    }

    public void drawCellBackgroundAndBorder(Canvas canvas, Cell cell, SSTableCellStyle tableCellStyle) {
        Paint paint = PaintKit.instance().getPaint();
        int color2 = paint.getColor();
        CellStyle style2 = cell.getCellStyle();
        if (style2 != null && style2.getFillPatternType() == 0) {
            paint.setColor(style2.getFgColor());
            if (Math.abs(this.cellRect.left - (float)this.sheetView.getRowHeaderWidth()) < 1.0f) {
                canvas.drawRect(this.cellRect.left + 1.0f, this.cellRect.top, this.cellRect.right, this.cellRect.bottom, paint);
            } else {
                canvas.drawRect(this.cellRect, paint);
            }
        } else if (style2 != null && (style2.getFillPatternType() == 7 || style2.getFillPatternType() == 4)) {
            this.drawGradientAndTile(canvas, this.sheetView.getSpreadsheet().getControl(), this.sheetView.getSheetIndex(), style2.getFillPattern(), this.cellRect, this.sheetView.getZoom(), paint);
        } else if (tableCellStyle != null && tableCellStyle.getFillColor() != null) {
            int bg = tableCellStyle.getFillColor();
            paint.setColor(bg);
            if (Math.abs(this.cellRect.left - (float)this.sheetView.getRowHeaderWidth()) < 1.0f) {
                canvas.drawRect(this.cellRect.left + 1.0f, this.cellRect.top, this.cellRect.right, this.cellRect.bottom, paint);
            } else {
                canvas.drawRect(this.cellRect, paint);
            }
        }
        paint.setColor(color2);
        this.cellBorderView.draw(canvas, cell, this.cellRect, tableCellStyle);
    }

    private void drawGradientAndTile(Canvas canvas, IControl control, int viewIndex, BackgroundAndFill fill, RectF rect, float zoom, Paint paint) {
        AShader aShader = fill.getShader();
        if (aShader != null) {
            float r;
            Shader shader = aShader.getShader();
            if (shader == null && (shader = aShader.createShader(control, viewIndex, new Rect(Math.round(rect.left * (r = 1.0f / zoom)), Math.round(rect.top * r), Math.round(rect.right * r), Math.round(rect.bottom * r)))) == null) {
                return;
            }
            Matrix m = new Matrix();
            float offX = rect.left;
            float offY = rect.top;
            if (aShader instanceof TileShader) {
                TileShader tileShader = (TileShader)aShader;
                offX += (float)tileShader.getOffsetX() * zoom;
                offY += (float)tileShader.getOffsetY() * zoom;
                m.postScale(zoom, zoom);
            } else if (!(aShader instanceof PatternShader)) {
                if (aShader instanceof LinearGradientShader) {
                    LinearGradientShader gradient = (LinearGradientShader)aShader;
                    float focusX = 1.0f;
                    float focusY = 1.0f;
                    if (gradient.getAngle() == 90) {
                        switch (gradient.getFocus()) {
                            case 100: {
                                focusX = 0.0f;
                                focusY = 0.0f;
                                break;
                            }
                            case 0: {
                                focusX = 1.0f;
                                break;
                            }
                            case -50: {
                                focusX = 0.5f;
                                focusY = 0.5f;
                                break;
                            }
                            case 50: {
                                focusX = -0.5f;
                                focusY = -0.5f;
                            }
                        }
                    } else {
                        switch (gradient.getFocus()) {
                            case 100: {
                                focusX = 0.0f;
                                focusY = 0.0f;
                                break;
                            }
                            case 0: {
                                focusX = 1.0f;
                                break;
                            }
                            case 50: {
                                focusX = 0.5f;
                                focusY = 0.5f;
                                break;
                            }
                            case -50: {
                                focusX = -0.5f;
                                focusY = -0.5f;
                            }
                        }
                    }
                    offX += focusX * rect.width();
                    offY += focusY * rect.height();
                }
                m.postScale(rect.width() / 100.0f, rect.height() / 100.0f);
            }
            m.postTranslate(offX, offY);
            shader.setLocalMatrix(m);
            paint.setShader(shader);
            canvas.drawRect(rect, paint);
            paint.setShader(null);
        }
    }

    public SSTableCellStyle getTableCellStyle(SSTable table, Workbook book, int row, int col) {
        CellRangeAddress rangeAddr = table.getTableReference();
        SSTableStyle tableStyle = this.tableStyleKit.getTableStyle(table.getName(), SchemeColorUtil.getSchemeColor(book));
        if (tableStyle == null) {
            return null;
        }
        if (table.isHeaderRowShown()) {
            if (row == rangeAddr.getFirstRow()) {
                return tableStyle.getFirstRow();
            }
            if (table.isTotalRowShown() && row == rangeAddr.getLastRow()) {
                if (tableStyle.getLastRow() != null) {
                    return tableStyle.getLastRow();
                }
                if (table.isShowFirstColumn() && col == rangeAddr.getFirstColumn() && tableStyle.getFirstCol() != null) {
                    return tableStyle.getFirstCol();
                }
                if (table.isShowLastColumn() && col == rangeAddr.getLastColumn() && tableStyle.getLastCol() != null) {
                    return tableStyle.getLastCol();
                }
                return tableStyle.getBand2H();
            }
            if (table.isShowFirstColumn() && col == rangeAddr.getFirstColumn() && tableStyle.getFirstCol() != null) {
                return tableStyle.getFirstCol();
            }
            if (table.isShowLastColumn() && col == rangeAddr.getLastColumn() && tableStyle.getLastCol() != null) {
                return tableStyle.getLastCol();
            }
            if (table.isShowRowStripes()) {
                if ((row - rangeAddr.getFirstRow()) % 2 == 1) {
                    return tableStyle.getBand1V();
                }
                if (table.isShowColumnStripes() && (col - rangeAddr.getFirstColumn()) % 2 == 0) {
                    return tableStyle.getBand1H();
                }
                return tableStyle.getBand2V();
            }
            if (table.isShowColumnStripes()) {
                if ((col - rangeAddr.getFirstColumn()) % 2 == 0) {
                    return tableStyle.getBand1H();
                }
                return tableStyle.getBand2H();
            }
            return tableStyle.getBand2H();
        }
        if (table.isTotalRowShown() && row == rangeAddr.getLastRow()) {
            if (tableStyle.getLastRow() != null) {
                return tableStyle.getLastRow();
            }
            if (table.isShowFirstColumn() && col == rangeAddr.getFirstColumn() && tableStyle.getFirstCol() != null) {
                return tableStyle.getFirstCol();
            }
            if (table.isShowLastColumn() && col == rangeAddr.getLastColumn() && tableStyle.getLastCol() != null) {
                return tableStyle.getLastCol();
            }
            return tableStyle.getBand2H();
        }
        if (table.isShowFirstColumn() && col == rangeAddr.getFirstColumn() && tableStyle.getFirstCol() != null) {
            return tableStyle.getFirstCol();
        }
        if (table.isShowLastColumn() && col == rangeAddr.getLastColumn() && tableStyle.getLastCol() != null) {
            return tableStyle.getLastCol();
        }
        if (table.isShowRowStripes()) {
            if ((row - rangeAddr.getFirstRow()) % 2 == 0) {
                return tableStyle.getBand1V();
            }
            if (table.isShowColumnStripes() && (col - rangeAddr.getFirstColumn()) % 2 == 0) {
                return tableStyle.getBand1H();
            }
            return tableStyle.getBand2V();
        }
        if (table.isShowColumnStripes()) {
            if ((col - rangeAddr.getFirstColumn()) % 2 == 0) {
                return tableStyle.getBand1H();
            }
            return tableStyle.getBand2H();
        }
        return tableStyle.getBand2H();
    }

    private int getRotatedX(int x, int y, int degree) {
        double d = (double)((float)degree / 180.0f) * Math.PI;
        return (int)(Math.sin(d) * (double)y + Math.cos(d) * (double)x);
    }

    private int getRotatedY(int x, int y, int degree) {
        double d = (double)((float)degree / 180.0f) * Math.PI;
        return (int)(Math.cos(d) * (double)y - Math.sin(d) * (double)x);
    }

    private void drawCellContents(Canvas canvas, Cell cell, DrawingCell cellInfor, SSTableCellStyle tableCellStyle) {
        String content;
        Sheet sheet = this.sheetView.getCurrentSheet();
        if (cell.getExpandedRangeAddressIndex() >= 0) {
            Row row = sheet.getRow(cellInfor.getRowIndex());
            CellRangeAddress cr = row.getExpandedRangeAddress(cell.getExpandedRangeAddressIndex()).getRangedAddress();
            if (this.mergedCellMgr.isDrawMergeCell(this.sheetView, cr, cellInfor.getRowIndex(), cellInfor.getColumnIndex())) {
                this.mergedCellSize = this.mergedCellMgr.getMergedCellSize(this.sheetView, cr, cellInfor.getRowIndex(), cellInfor.getColumnIndex());
                cell = row.getExpandedRangeAddress(cell.getExpandedRangeAddressIndex()).getExpandedCell();
                this.cellRect.set(this.left, this.top, this.left + this.mergedCellSize.getWidth() - this.mergedCellSize.getNovisibleWidth() - (cellInfor.getWidth() - cellInfor.getVisibleWidth()), this.top + this.mergedCellSize.getHeight() - this.mergedCellSize.getNoVisibleHeight() - (cellInfor.getHeight() - cellInfor.getVisibleHeight()));
            } else {
                return;
            }
        }
        if ((content = ModelUtil.instance().getFormatContents(sheet.getWorkbook(), cell)) == null || content.length() == 0) {
            return;
        }
        Paint paint = FontKit.instance().getCellPaint(cell, sheet.getWorkbook(), tableCellStyle);
        float textSize = paint.getTextSize();
        paint.setTextSize(textSize * this.sheetView.getZoom());
        this.numericCellAlignRight = false;
        if (cell.getCellType() == 4 || cell.getCellType() == 0 && cell.getCellNumericType() != 11) {
            this.numericCellAlignRight = true;
        }
        if (this.numericCellAlignRight) {
            this.drawNumericCell(canvas, cell, content, paint);
        } else {
            this.drawNonNumericCell(canvas, cell, content, paint);
        }
        paint.setTextSize(textSize);
    }

    public static boolean isComplexText(Cell cell) {
        if (cell.getCellType() == 1 && cell.getStringCellValueIndex() >= 0) {
            Object value = cell.getSheet().getWorkbook().getSharedItem(cell.getStringCellValueIndex());
            return value instanceof SectionElement;
        }
        return false;
    }

    private void drawNonNumericCell(Canvas canvas, Cell cell, String contents, Paint paint) {
        if (CellView.isComplexText(cell)) {
            this.drawComplexTextCell(canvas, cell);
        } else if (cell.getCellStyle().isWrapText() && (contents.contains("\n") || paint.measureText(contents) + 4.0f > this.mergedCellSize.getWidth())) {
            canvas.save();
            canvas.clipRect(this.cellRect);
            this.drawWrapText(canvas, cell, contents);
            canvas.restore();
        } else {
            if (contents.length() > 1024) {
                contents = contents.substring(0, 1024);
            }
            this.drawNonWrapText(canvas, cell, contents, paint);
        }
    }

    private void drawComplexTextCell(Canvas canvas, Cell cell) {
        if (cell.getCellStyle().isWrapText()) {
            this.drawWrapComplexTextCell(canvas, cell);
        } else {
            this.drawNotWrapComplexTextCell(canvas, cell);
        }
    }

    private void drawWrapComplexTextCell(Canvas canvas, Cell cell) {
        canvas.save();
        canvas.clipRect(this.cellRect);
        STRoot root = cell.getSTRoot();
        if (root == null) {
            Rect rect = ModelUtil.instance().getCellAnchor(this.sheetView.getCurrentSheet(), cell.getRowNumber(), cell.getColNumber());
            SectionElement elem = (SectionElement)cell.getSheet().getWorkbook().getSharedItem(cell.getStringCellValueIndex());
            if (elem == null || elem.getEndOffset() - elem.getStartOffset() == 0L) {
                canvas.restore();
                return;
            }
            IAttributeSet attr = elem.getAttribute();
            AttrManage.instance().setPageWidth(attr, Math.round((float)rect.width() * 15.0f));
            AttrManage.instance().setPageHeight(attr, Math.round((float)rect.height() * 15.0f));
            STDocument doc = new STDocument();
            doc.appendSection(elem);
            root = new STRoot(this.sheetView.getSpreadsheet().getEditor(), doc);
            root.setWrapLine(true);
            root.doLayout();
            cell.setSTRoot(root);
        }
        root.draw(canvas, Math.round(this.left - this.mergedCellSize.getNovisibleWidth() - (this.cellInfor.getWidth() - this.cellInfor.getVisibleWidth())), Math.round(this.top - this.mergedCellSize.getNoVisibleHeight() - (this.cellInfor.getHeight() - this.cellInfor.getVisibleHeight())), this.sheetView.getZoom());
        canvas.restore();
    }

    private void drawNotWrapComplexTextCell(Canvas canvas, Cell cell) {
        canvas.save();
        canvas.clipRect(this.cellRect);
        CellStyle style2 = cell.getCellStyle();
        STRoot root = cell.getSTRoot();
        if (root == null) {
            canvas.restore();
            return;
        }
        IView view = root.getChildView();
        view = view.getChildView();
        int lineWidth = (int)((float)view.getLayoutSpan((byte)0) * this.sheetView.getZoom());
        int textHeight = (int)((float)view.getHeight() * this.sheetView.getZoom());
        int indent = this.sheetView.getIndentWidthWithZoom(style2.getIndent());
        if ((float)(indent + 4) >= this.mergedCellSize.getWidth()) {
            canvas.restore();
            return;
        }
        switch (style2.getHorizontalAlign()) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                this.left += 2.0f;
                this.mergedCellSize.setWidth(this.mergedCellSize.getWidth() - (float)indent);
                break;
            }
            case 3: {
                this.mergedCellSize.setWidth(this.mergedCellSize.getWidth() - (float)indent);
                this.left += this.mergedCellSize.getWidth() - (float)lineWidth - 2.0f;
                break;
            }
            case 2: {
                this.left += (this.mergedCellSize.getWidth() - (float)lineWidth) / 2.0f;
            }
        }
        switch (style2.getVerticalAlign()) {
            case 0: {
                this.top += 2.0f;
                break;
            }
            case 1: 
            case 3: {
                this.top += 2.0f;
                break;
            }
            case 2: {
                this.top += 2.0f;
            }
        }
        float x = this.left - this.mergedCellSize.getNovisibleWidth() - (this.cellInfor.getWidth() - this.cellInfor.getVisibleWidth());
        float y = this.top - this.mergedCellSize.getNoVisibleHeight() - (this.cellInfor.getHeight() - this.cellInfor.getVisibleHeight());
        if (cell.getExpandedRangeAddressIndex() >= 0) {
            this.sheetView.addExtendCell(cell, new RectF(this.cellRect), x, y, root);
        } else {
            root.draw(canvas, (int)x, (int)y, this.sheetView.getZoom());
        }
        canvas.restore();
    }

    private void drawAccountCell(Canvas canvas, Cell cell, String contents, Paint paint) {
        Paint.FontMetrics fm = paint.getFontMetrics();
        int textWidth = (int)paint.measureText(contents);
        int textHeight = (int)Math.ceil(fm.descent - fm.ascent);
        this.left += 2.0f;
        CellStyle style2 = cell.getCellStyle();
        int indent = this.sheetView.getIndentWidthWithZoom(style2.getIndent());
        canvas.save();
        canvas.clipRect(this.cellRect);
        if ((float)(textWidth + indent + 2) > this.mergedCellSize.getWidth()) {
            int charCnt = (int)((this.mergedCellSize.getWidth() - 4.0f) / paint.measureText("#"));
            this.strBuilder.delete(0, this.strBuilder.length());
            for (int i = 0; i < charCnt; ++i) {
                this.strBuilder.append('#');
            }
            contents = this.strBuilder.toString();
            textWidth = (int)paint.measureText(contents);
        } else {
            switch (style2.getHorizontalAlign()) {
                case 0: 
                case 1: {
                    this.left += (float)indent;
                    this.mergedCellSize.setWidth(this.mergedCellSize.getWidth() - (float)indent);
                    break;
                }
                case 3: {
                    this.mergedCellSize.setWidth(this.mergedCellSize.getWidth() - (float)indent);
                }
            }
            int index = contents.indexOf("*");
            if (index > -1) {
                String first = contents.substring(0, index);
                String end = contents.substring(index + 1, contents.length());
                int blackCnt = (int)((this.mergedCellSize.getWidth() - paint.measureText(first + end) - 4.0f) / paint.measureText(" "));
                this.strBuilder.delete(0, this.strBuilder.length());
                this.strBuilder.append(first);
                for (int i = 0; i < blackCnt; ++i) {
                    this.strBuilder.append(' ');
                }
                this.strBuilder.append(end);
                contents = this.strBuilder.toString();
            }
        }
        switch (cell.getCellStyle().getVerticalAlign()) {
            case 0: {
                this.top += 2.0f;
                break;
            }
            case 1: 
            case 3: {
                this.top += (this.mergedCellSize.getHeight() - (float)textHeight) / 2.0f;
                break;
            }
            case 2: {
                this.top += this.mergedCellSize.getHeight() - (float)textHeight;
            }
        }
        float x = this.left - this.mergedCellSize.getNovisibleWidth() - (this.cellInfor.getWidth() - this.cellInfor.getVisibleWidth());
        float y = this.top - fm.ascent - this.mergedCellSize.getNoVisibleHeight() - (this.cellInfor.getHeight() - this.cellInfor.getVisibleHeight());
        canvas.drawText(contents, x, y, paint);
        canvas.restore();
    }

    private String getScientificGeneralContents(String contents, Paint paint) {
        boolean replacedByChar;
        int lastChar;
        String endPart;
        String firstPart;
        block10: {
            firstPart = "";
            endPart = "";
            lastChar = 0;
            replacedByChar = false;
            int index = contents.indexOf(69);
            firstPart = contents.substring(0, index);
            endPart = contents.substring(index + 1);
            int e = Integer.parseInt(endPart);
            endPart = e > 0 ? (e < 10 ? "E+0".concat(endPart) : "E+".concat(endPart)) : (e > -10 ? "E-0".concat(String.valueOf(-e)) : "E".concat(endPart));
            if (paint.measureText(endPart) + 4.0f >= this.mergedCellSize.getWidth()) {
                replacedByChar = true;
            } else {
                while (true) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!((float)((int)paint.measureText(stringBuilder.append(firstPart).append(endPart).toString()) + 4) > this.mergedCellSize.getWidth())) break block10;
                    if (firstPart.length() < 1) break;
                    lastChar = firstPart.charAt(firstPart.length() - 1);
                    firstPart = firstPart.substring(0, firstPart.length() - 1);
                }
                replacedByChar = true;
            }
        }
        if (replacedByChar || firstPart.length() == 0 || firstPart.equals("-")) {
            contents = "";
            while (true) {
                StringBuilder stringBuilder = new StringBuilder();
                if (paint.measureText(stringBuilder.append(contents).append("#").toString()) + 4.0f < this.mergedCellSize.getWidth()) {
                    contents = contents + "#";
                    continue;
                }
                break;
            }
        } else if (firstPart.charAt(firstPart.length() - 1) == '.') {
            contents = firstPart.substring(0, firstPart.length() - 1) + endPart;
        } else {
            if (lastChar <= 57 && lastChar >= 53) {
                firstPart = this.ceilNumeric(firstPart);
            }
            contents = firstPart + endPart;
        }
        return contents;
    }

    private String ceilNumeric(String contents) {
        int index = contents.indexOf(46);
        if (index > 0) {
            int i;
            char[] chars = contents.toCharArray();
            for (i = chars.length - 1; i > index && chars[i] == '9'; --i) {
            }
            if (i > index) {
                int n = i;
                chars[n] = (char)(chars[n] + '\u0001');
                contents = String.valueOf(chars, 0, i + 1);
            } else {
                contents = String.valueOf((int)Double.parseDouble(contents) + 1);
            }
        } else if (contents.length() == 1) {
            contents = String.valueOf((int)Double.parseDouble(contents) + 1);
        }
        return contents;
    }

    private String getNonScientificGeneralContents(String contents, Paint paint) {
        String firstPart = "";
        String endPart = "";
        int step = 1;
        boolean replacedByChar = false;
        int textWidth = (int)paint.measureText(contents);
        char lastChar = '\u0000';
        if ((float)(textWidth + 4) > this.mergedCellSize.getWidth()) {
            if (contents.length() == 1) {
                return "";
            }
            double value = Double.parseDouble(contents);
            if ((int)value == 0 || (float)((int)paint.measureText(String.valueOf((int)value)) + 4) > this.mergedCellSize.getWidth()) {
                block24: {
                    int integerCnt = 0;
                    step = 10;
                    while ((int)Math.abs(value / (double)step) > 0) {
                        value /= (double)step;
                        ++integerCnt;
                    }
                    if (integerCnt > 0) {
                        endPart = "E+";
                        endPart = integerCnt < 10 ? endPart + "0" + String.valueOf(integerCnt) : endPart + String.valueOf(integerCnt);
                        firstPart = String.valueOf(value);
                    } else {
                        contents = String.valueOf(value);
                        int index = contents.indexOf(69);
                        if (index > 0) {
                            firstPart = contents.substring(0, index);
                            endPart = contents.substring(index);
                        } else {
                            integerCnt = 0;
                            while (Math.abs(value) < 1.0 && Math.abs(value * 2.147483647E9) > 0.0) {
                                value *= 10.0;
                                ++integerCnt;
                            }
                            firstPart = String.valueOf(value);
                            endPart = "E-".concat(String.valueOf(integerCnt));
                        }
                    }
                    if (paint.measureText(endPart) + 4.0f >= this.mergedCellSize.getWidth()) {
                        replacedByChar = true;
                    } else {
                        while (true) {
                            StringBuilder stringBuilder = new StringBuilder();
                            if (!((float)((int)paint.measureText(stringBuilder.append(firstPart).append(endPart).toString()) + 4) > this.mergedCellSize.getWidth())) break block24;
                            if (firstPart.length() < 1) break;
                            lastChar = firstPart.charAt(firstPart.length() - 1);
                            firstPart = firstPart.substring(0, firstPart.length() - 1);
                        }
                        replacedByChar = true;
                    }
                }
                if (replacedByChar || firstPart.length() == 0 || firstPart.equals("-")) {
                    contents = "";
                    while (true) {
                        StringBuilder stringBuilder = new StringBuilder();
                        if (paint.measureText(stringBuilder.append(contents).append("#").toString()) + 4.0f < this.mergedCellSize.getWidth()) {
                            contents = contents + "#";
                            continue;
                        }
                        break;
                    }
                } else if (firstPart.charAt(firstPart.length() - 1) == '.') {
                    contents = firstPart.substring(0, firstPart.length() - 1) + endPart;
                } else {
                    if (lastChar <= '9' && lastChar >= '5') {
                        firstPart = this.ceilNumeric(firstPart);
                    }
                    contents = firstPart + endPart;
                }
            } else {
                while ((float)((int)paint.measureText(contents) + 4) > this.mergedCellSize.getWidth()) {
                    lastChar = contents.charAt(contents.length() - 1);
                    contents = contents.substring(0, contents.length() - 1);
                }
                if (contents.charAt(contents.length() - 1) == '.') {
                    contents = contents.substring(0, contents.length() - 1);
                } else if (lastChar <= '9' && lastChar >= '5') {
                    contents = this.ceilNumeric(contents);
                }
                contents = this.trimInvalidateZero(contents);
            }
        }
        return contents;
    }

    private String trimInvalidateZero(String contents) {
        if (contents == null || contents.length() == 0) {
            return contents;
        }
        int index = contents.indexOf(46);
        if (index > 0) {
            char[] chars = contents.toCharArray();
            int i = chars.length - 1;
            while (i > index && chars[index] == '0') {
                --index;
            }
            if (chars[i] == '.') {
                --index;
            }
            return String.valueOf(chars, 0, i);
        }
        return contents;
    }

    private String adjustGeneralCellContent(String contents, Paint paint) {
        int index = (contents = this.scientificToNormal(contents)).indexOf(69);
        if (index > -1) {
            return this.getScientificGeneralContents(contents, paint);
        }
        return this.getNonScientificGeneralContents(contents, paint);
    }

    private boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isDouble(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isNumeric(String str) {
        return this.isInteger(str) || this.isDouble(str);
    }

    private void drawGeneralCell(Canvas canvas, Cell cell, String contents, Paint paint) {
        contents = this.adjustGeneralCellContent(contents, paint);
        Paint.FontMetrics fm = paint.getFontMetrics();
        int textHeight = (int)Math.ceil(fm.descent - fm.ascent);
        canvas.save();
        canvas.clipRect(this.cellRect);
        CellStyle cellStyle = cell.getCellStyle();
        switch (cellStyle.getVerticalAlign()) {
            case 0: {
                this.top += 2.0f;
                break;
            }
            case 1: 
            case 3: {
                this.top += (this.mergedCellSize.getHeight() - (float)textHeight) / 2.0f;
                break;
            }
            case 2: {
                this.top += this.mergedCellSize.getHeight() - (float)textHeight;
            }
        }
        CellStyle style2 = cell.getCellStyle();
        int indent = this.sheetView.getIndentWidthWithZoom(style2.getIndent());
        if ((float)(indent + 4) >= this.mergedCellSize.getWidth() && !this.isNumeric(contents)) {
            canvas.restore();
            return;
        }
        int textWidth = (int)paint.measureText(contents);
        if ((float)(textWidth + indent + 4) > this.mergedCellSize.getWidth()) {
            this.left += 2.0f;
            int charCnt = (int)((this.mergedCellSize.getWidth() - 4.0f) / paint.measureText("#"));
            this.strBuilder.delete(0, this.strBuilder.length());
            for (int i = 0; i < charCnt; ++i) {
                this.strBuilder.append('#');
            }
            contents = this.strBuilder.toString();
            textWidth = (int)paint.measureText(contents);
        } else {
            switch (style2.getHorizontalAlign()) {
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    this.left += (float)(indent + 2);
                    this.mergedCellSize.setWidth(this.mergedCellSize.getWidth() - (float)indent);
                    break;
                }
                case 2: {
                    this.left += (this.mergedCellSize.getWidth() - (float)textWidth) / 2.0f;
                    break;
                }
                case 0: 
                case 3: {
                    this.mergedCellSize.setWidth(this.mergedCellSize.getWidth() - (float)indent);
                    this.left += this.mergedCellSize.getWidth() - (float)((int)paint.measureText(contents)) - 2.0f;
                }
            }
        }
        float x = this.left - this.mergedCellSize.getNovisibleWidth() - (this.cellInfor.getWidth() - this.cellInfor.getVisibleWidth());
        float y = this.top - fm.ascent - this.mergedCellSize.getNoVisibleHeight() - (this.cellInfor.getHeight() - this.cellInfor.getVisibleHeight());
        canvas.drawText(contents, x, y, paint);
        canvas.restore();
    }

    private String scientificToNormal(String contents) {
        boolean negative;
        int index = contents.indexOf(69);
        if (index < 0) {
            return contents;
        }
        String firstPart = contents.substring(0, index);
        int endPart = Integer.parseInt(contents.substring(index + 1));
        boolean bl = negative = Double.parseDouble(firstPart) < 0.0;
        if (Math.abs(endPart) > 10) {
            return contents;
        }
        if (endPart < 0) {
            if (firstPart.charAt(firstPart.length() - 1) == '0') {
                firstPart = firstPart.substring(0, firstPart.length() - 1);
            }
            firstPart = firstPart.replace(".", "");
            this.strBuilder.delete(0, this.strBuilder.length());
            while (++endPart < 0) {
                this.strBuilder.append("0");
            }
            firstPart = !negative ? "0." + this.strBuilder.toString() + firstPart : "-0." + this.strBuilder.toString() + firstPart.replace("-", "");
        } else if (endPart <= 10) {
            index = firstPart.indexOf(46);
            int decimalPartLen = firstPart.length() - 2;
            if (negative) {
                decimalPartLen = firstPart.length() - 3;
            }
            if (decimalPartLen <= endPart) {
                firstPart = firstPart.replace(".", "");
                endPart -= decimalPartLen;
                while (endPart > 0) {
                    firstPart = firstPart + "0";
                    --endPart;
                }
            } else {
                char[] chars = firstPart.toCharArray();
                int i = index;
                index += endPart;
                while (i < index) {
                    chars[i] = chars[i + 1];
                    ++i;
                }
                chars[i] = 46;
                firstPart = String.valueOf(chars);
            }
        }
        return firstPart;
    }

    private void drawNumericCell(Canvas canvas, Cell cell, String content, Paint paint) {
        int oldColor = paint.getColor();
        if (content.length() > 0 && cell.getNumberValue() < 0.0) {
            paint.setColor(NumericFormatter.getNegativeColor(cell));
        }
        if (cell.getCellNumericType() == 8) {
            this.drawAccountCell(canvas, cell, content, paint);
            return;
        }
        if (cell.getCellNumericType() == 6) {
            this.drawGeneralCell(canvas, cell, content, paint);
            return;
        }
        Paint.FontMetrics fm = paint.getFontMetrics();
        int textHeight = (int)Math.ceil(fm.descent - fm.ascent);
        int textWidth = (int)paint.measureText(content);
        canvas.save();
        canvas.clipRect(this.cellRect);
        switch (cell.getCellStyle().getVerticalAlign()) {
            case 0: {
                this.top += 2.0f;
                break;
            }
            case 1: 
            case 3: {
                this.top += (this.mergedCellSize.getHeight() - (float)textHeight) / 2.0f;
                break;
            }
            case 2: {
                this.top += this.mergedCellSize.getHeight() - (float)textHeight;
            }
        }
        int indent = this.sheetView.getIndentWidthWithZoom(cell.getCellStyle().getIndent());
        if ((float)(textWidth + indent + 4) > this.mergedCellSize.getWidth()) {
            int charCnt = (int)((this.mergedCellSize.getWidth() - 4.0f) / paint.measureText("#"));
            this.strBuilder.delete(0, this.strBuilder.length());
            for (int i = 0; i < charCnt; ++i) {
                this.strBuilder.append('#');
            }
            content = this.strBuilder.toString();
            textWidth = (int)paint.measureText(content);
            this.left += 2.0f;
        } else {
            int hori = cell.getCellStyle().getHorizontalAlign();
            if (cell.getCellType() == 4 && hori == 0) {
                hori = 2;
            }
            switch (hori) {
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    this.left += (float)(indent + 2);
                    this.mergedCellSize.setWidth(this.mergedCellSize.getWidth() - (float)indent);
                    break;
                }
                case 0: 
                case 3: {
                    this.mergedCellSize.setWidth(this.mergedCellSize.getWidth() - (float)indent);
                    this.left += this.mergedCellSize.getWidth() - (float)textWidth - 2.0f;
                    break;
                }
                case 2: {
                    this.left += (this.mergedCellSize.getWidth() - (float)textWidth) / 2.0f;
                }
            }
        }
        float x = this.left - this.mergedCellSize.getNovisibleWidth() - (this.cellInfor.getWidth() - this.cellInfor.getVisibleWidth());
        float y = this.top - fm.ascent - this.mergedCellSize.getNoVisibleHeight() - (this.cellInfor.getHeight() - this.cellInfor.getVisibleHeight());
        if (this.mergedCellSize.isFrozenColumn()) {
            x = this.left - (this.cellInfor.getWidth() - this.cellInfor.getVisibleWidth());
        }
        if (this.mergedCellSize.isFrozenRow()) {
            y = this.top - fm.ascent - (this.cellInfor.getHeight() - this.cellInfor.getVisibleHeight());
        }
        canvas.drawText(content, x, y, paint);
        canvas.restore();
        paint.setColor(oldColor);
    }

    private void initPageProp(IAttributeSet attr, CellStyle style2, int width, int height) {
        byte verAlign = 0;
        switch (style2.getVerticalAlign()) {
            case 0: {
                verAlign = 0;
                break;
            }
            case 1: 
            case 3: {
                verAlign = 1;
                break;
            }
            case 2: {
                verAlign = 2;
            }
        }
        AttrManage.instance().setPageVerticalAlign(attr, verAlign);
        AttrManage.instance().setPageWidth(attr, Math.round((float)width * 15.0f));
        AttrManage.instance().setPageHeight(attr, Math.round((float)height * 15.0f));
        AttrManage.instance().setPageMarginLeft(attr, Math.round(30.0f));
        AttrManage.instance().setPageMarginRight(attr, Math.round(30.0f));
        AttrManage.instance().setPageMarginTop(attr, 0);
        AttrManage.instance().setPageMarginBottom(attr, 0);
    }

    private SectionElement convertToSectionElement(Cell cell, String content, int width, int height) {
        SectionElement secElem = new SectionElement();
        secElem.setStartOffset(0L);
        IAttributeSet attr = secElem.getAttribute();
        this.initPageProp(attr, cell.getCellStyle(), width, height);
        int pos = this.processParagraph(secElem, cell, content);
        secElem.setEndOffset(pos);
        return secElem;
    }

    private int processParagraph(SectionElement secElem, Cell cell, String text) {
        String[] ps;
        int offset = 0;
        for (String p : ps = text.split("\n")) {
            ParagraphElement paraElem = new ParagraphElement();
            paraElem.setStartOffset(offset);
            AttributeSetImpl attrLayout = new AttributeSetImpl();
            ParaAttr.instance().setParaAttribute(cell.getCellStyle(), paraElem.getAttribute(), attrLayout);
            offset = this.processRun(paraElem, cell, p, offset, attrLayout);
            paraElem.setEndOffset(offset);
            secElem.appendParagraph(paraElem, 0L);
        }
        return offset;
    }

    private int processRun(ParagraphElement paraElem, Cell cell, String p, int offset, IAttributeSet attrLayout) {
        LeafElement leaf = null;
        if (p.length() == 0) {
            leaf = new CellLeafElement(cell, 0, 0);
            ((CellLeafElement)leaf).appendNewlineFlag();
            RunAttr.instance().setRunAttribute(this.sheetView.getCurrentSheet(), cell, leaf.getAttribute(), attrLayout);
            leaf.setStartOffset(offset);
            leaf.setEndOffset(++offset);
            paraElem.appendLeaf(leaf);
            return offset;
        }
        int len = p.length();
        if (len > 0) {
            String content = cell.getSheet().getWorkbook().getSharedString(cell.getStringCellValueIndex());
            if (content == null) {
                leaf = new LeafElement(p);
            } else {
                int start = content.indexOf(p);
                leaf = new CellLeafElement(cell, start, start + p.length());
            }
            RunAttr.instance().setRunAttribute(this.sheetView.getCurrentSheet(), cell, leaf.getAttribute(), attrLayout);
            leaf.setStartOffset(offset);
            leaf.setEndOffset(offset += len);
            paraElem.appendLeaf(leaf);
        }
        if (leaf != null) {
            if (leaf instanceof CellLeafElement) {
                ((CellLeafElement)leaf).appendNewlineFlag();
                leaf.setEndOffset(++offset);
            } else {
                leaf.setText(leaf.getText(null) + "\n");
            }
        }
        return offset;
    }

    private void drawWrapText(Canvas canvas, Cell cell, String content) {
        STRoot root = cell.getSTRoot();
        if (root == null) {
            Rect rect = ModelUtil.instance().getCellAnchor(this.sheetView.getCurrentSheet(), cell.getRowNumber(), cell.getColNumber());
            SectionElement elem = this.convertToSectionElement(cell, content, rect.width(), rect.height());
            if (elem.getEndOffset() - elem.getStartOffset() == 0L) {
                return;
            }
            STDocument doc = new STDocument();
            doc.appendSection(elem);
            root = new STRoot(this.sheetView.getSpreadsheet().getEditor(), doc);
            root.setWrapLine(true);
            root.doLayout();
            cell.setSTRoot(root);
        }
        root.draw(canvas, Math.round(this.left - this.mergedCellSize.getNovisibleWidth() - (this.cellInfor.getWidth() - this.cellInfor.getVisibleWidth())), Math.round(this.top - this.mergedCellSize.getNoVisibleHeight() - (this.cellInfor.getHeight() - this.cellInfor.getVisibleHeight())), this.sheetView.getZoom());
    }

    private void drawNonWrapText(Canvas canvas, Cell cell, String contents, Paint paint) {
        Paint.FontMetrics fm = paint.getFontMetrics();
        int textWidth = (int)paint.measureText(contents);
        int textHeight = (int)Math.ceil(fm.descent - fm.ascent);
        CellStyle style2 = cell.getCellStyle();
        int indent = this.sheetView.getIndentWidthWithZoom(style2.getIndent());
        if ((float)(indent + 4) >= this.mergedCellSize.getWidth()) {
            canvas.restore();
            return;
        }
        if (cell.getCellNumericType() == 10 && (float)(textWidth + indent + 4) > this.mergedCellSize.getWidth()) {
            int charCnt = (int)((this.mergedCellSize.getWidth() - 4.0f) / paint.measureText("#"));
            this.strBuilder.delete(0, this.strBuilder.length());
            for (int i = 0; i < charCnt; ++i) {
                this.strBuilder.append('#');
            }
            contents = this.strBuilder.toString();
            textWidth = (int)paint.measureText(contents);
            indent = 0;
        }
        canvas.save();
        canvas.clipRect(this.cellRect);
        int horiAlign = style2.getHorizontalAlign();
        if (horiAlign == 0 && cell.getCellNumericType() == 10) {
            horiAlign = 3;
        }
        switch (horiAlign) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                this.left += (float)(indent + 2);
                this.mergedCellSize.setWidth(this.mergedCellSize.getWidth() - (float)indent);
                if (!((float)(textWidth + 2) > this.mergedCellSize.getWidth())) break;
                float[] widths = new float[contents.length()];
                paint.getTextWidths(contents, 0, contents.length(), widths);
                int s = 0;
                for (float sum = widths[0]; sum < this.mergedCellSize.getWidth() - 2.0f; sum += widths[++s]) {
                }
                contents = contents.substring(0, s);
                break;
            }
            case 3: {
                int s;
                this.mergedCellSize.setWidth(this.mergedCellSize.getWidth() - (float)indent);
                if ((float)(textWidth + 2) > this.mergedCellSize.getWidth()) {
                    float[] widths = new float[contents.length()];
                    paint.getTextWidths(contents, 0, contents.length(), widths);
                    s = contents.length();
                    for (float sum = 0.0f; sum < this.mergedCellSize.getWidth() - 2.0f; sum += widths[--s]) {
                    }
                    contents = contents.substring(s + 1, contents.length());
                    textWidth = (int)paint.measureText(contents);
                }
                this.left += this.mergedCellSize.getWidth() - (float)textWidth - 2.0f;
                break;
            }
            case 2: {
                this.left += (this.mergedCellSize.getWidth() - (float)textWidth) / 2.0f;
            }
        }
        switch (style2.getVerticalAlign()) {
            case 0: {
                this.top += 2.0f;
                break;
            }
            case 1: 
            case 3: {
                this.top += (this.mergedCellSize.getHeight() - (float)textHeight) / 2.0f;
                break;
            }
            case 2: {
                this.top += this.mergedCellSize.getHeight() - (float)textHeight;
            }
        }
        float x = this.left - this.mergedCellSize.getNovisibleWidth() - (this.cellInfor.getWidth() - this.cellInfor.getVisibleWidth());
        float y = this.top - fm.ascent - this.mergedCellSize.getNoVisibleHeight() - (this.cellInfor.getHeight() - this.cellInfor.getVisibleHeight());
        if (cell.getExpandedRangeAddressIndex() >= 0) {
            this.sheetView.addExtendCell(cell, new RectF(this.cellRect), x, y, contents);
        } else {
            canvas.drawText(contents, x, y, paint);
        }
        canvas.restore();
    }

    public void dispose() {
        this.sheetView = null;
        if (this.cellBorderView != null) {
            this.cellBorderView.dispose();
            this.cellBorderView = null;
        }
        this.cellRect = null;
        if (this.mergedCellSize != null) {
            this.mergedCellSize.dispose();
            this.mergedCellSize = null;
        }
        if (this.mergedCellMgr != null) {
            this.mergedCellMgr.dispose();
            this.mergedCellMgr = null;
        }
        this.cellInfor = null;
        this.strBuilder = null;
        if (this.tableStyleKit != null) {
            this.tableStyleKit.dispose();
            this.tableStyleKit = null;
        }
    }
}

