/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTableCellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;

public class CellBorderView {
    private SheetView sheetView;

    public CellBorderView(SheetView sheetView) {
        this.sheetView = sheetView;
    }

    public void draw(Canvas canvas, Cell cell, RectF rect, SSTableCellStyle tableCellStyle) {
        int colorIndex;
        Paint paint = PaintKit.instance().getPaint();
        int oldColor = paint.getColor();
        Workbook book = this.sheetView.getSpreadsheet().getWorkbook();
        canvas.save();
        if (rect.left > (float)this.sheetView.getRowHeaderWidth()) {
            colorIndex = this.LeftBorder(cell);
            if (colorIndex > -1) {
                paint.setColor(book.getColor(colorIndex));
                canvas.drawRect(rect.left, rect.top, rect.left + 1.0f, rect.bottom, paint);
            } else if (tableCellStyle != null && tableCellStyle.getBorderColor() != null) {
                paint.setColor(tableCellStyle.getBorderColor().intValue());
                canvas.drawRect(rect.left, rect.top, rect.left + 1.0f, rect.bottom, paint);
            }
        }
        if (rect.top > (float)this.sheetView.getColumnHeaderHeight()) {
            colorIndex = this.TopBorder(cell);
            if (colorIndex > -1) {
                paint.setColor(book.getColor(colorIndex));
                canvas.drawRect(rect.left, rect.top, rect.right, rect.top + 1.0f, paint);
            } else if (tableCellStyle != null && tableCellStyle.getBorderColor() != null) {
                paint.setColor(tableCellStyle.getBorderColor().intValue());
                canvas.drawRect(rect.left, rect.top, rect.right, rect.top + 1.0f, paint);
            }
        }
        if (rect.right > (float)this.sheetView.getRowHeaderWidth()) {
            colorIndex = this.RightBorder(cell);
            if (colorIndex > -1) {
                paint.setColor(book.getColor(colorIndex));
                canvas.drawRect(rect.right, rect.top, rect.right + 1.0f, rect.bottom, paint);
            } else if (tableCellStyle != null && tableCellStyle.getBorderColor() != null) {
                paint.setColor(tableCellStyle.getBorderColor().intValue());
                canvas.drawRect(rect.right, rect.top, rect.right + 1.0f, rect.bottom, paint);
            }
        }
        if (rect.bottom > (float)this.sheetView.getColumnHeaderHeight()) {
            colorIndex = this.BottomBorder(cell);
            if (colorIndex > -1) {
                paint.setColor(book.getColor(colorIndex));
                canvas.drawRect(rect.left, rect.bottom, rect.right, rect.bottom + 1.0f, paint);
            } else if (tableCellStyle != null && tableCellStyle.getBorderColor() != null) {
                paint.setColor(tableCellStyle.getBorderColor().intValue());
                canvas.drawRect(rect.left, rect.bottom, rect.right, rect.bottom + 1.0f, paint);
            }
        }
        paint.setColor(oldColor);
        canvas.restore();
    }

    private int LeftBorder(Cell cell) {
        CellRangeAddress cr;
        Cell tempCell;
        CellStyle style2 = cell.getCellStyle();
        Sheet sheet = this.sheetView.getCurrentSheet();
        if (cell.getRangeAddressIndex() >= 0 && (tempCell = sheet.getRow((cr = sheet.getMergeRange(cell.getRangeAddressIndex())).getFirstRow()).getCell(cr.getFirstColumn())) != null) {
            style2 = tempCell.getCellStyle();
            cell = tempCell;
        }
        boolean hasLeft = false;
        int color2 = -1;
        if (style2 != null && style2.getBorderLeft() > 0) {
            hasLeft = true;
            color2 = style2.getBorderLeftColorIdx();
        } else {
            Cell tempCell2 = sheet.getRowByColumnsStyle(cell.getRowNumber()).getCell(cell.getColNumber() - 1);
            if (tempCell2 != null) {
                CellRangeAddress cr2;
                style2 = tempCell2.getCellStyle();
                if (tempCell2.getRangeAddressIndex() >= 0 && (tempCell2 = sheet.getRow((cr2 = sheet.getMergeRange(tempCell2.getRangeAddressIndex())).getLastRow()).getCell(cr2.getLastColumn())) != null) {
                    style2 = tempCell2.getCellStyle();
                }
                if (style2 != null && style2.getBorderRight() > 0) {
                    hasLeft = true;
                    color2 = style2.getBorderRightColorIdx();
                }
            }
        }
        if (hasLeft && cell.getExpandedRangeAddressIndex() >= 0) {
            CellRangeAddress cr3 = sheet.getRow(cell.getRowNumber()).getExpandedRangeAddress(cell.getExpandedRangeAddressIndex()).getRangedAddress();
            if (cell.getColNumber() != cr3.getFirstColumn()) {
                hasLeft = false;
            }
        }
        if (hasLeft) {
            return color2;
        }
        return -1;
    }

    private int RightBorder(Cell cell) {
        CellRangeAddress cr;
        Cell tempCell;
        CellStyle style2 = cell.getCellStyle();
        Sheet sheet = this.sheetView.getCurrentSheet();
        if (cell.getRangeAddressIndex() >= 0 && (tempCell = sheet.getRow((cr = sheet.getMergeRange(cell.getRangeAddressIndex())).getLastRow()).getCell(cr.getLastColumn())) != null) {
            style2 = tempCell.getCellStyle();
            cell = tempCell;
        }
        boolean hasRight = false;
        int color2 = -1;
        if (style2 != null && style2.getBorderRight() > 0) {
            hasRight = true;
            color2 = style2.getBorderRightColorIdx();
        } else {
            Cell tempCell2 = sheet.getRowByColumnsStyle(cell.getRowNumber()).getCell(cell.getColNumber() + 1);
            if (tempCell2 != null) {
                CellRangeAddress cr2;
                style2 = tempCell2.getCellStyle();
                if (tempCell2.getRangeAddressIndex() >= 0 && (tempCell2 = sheet.getRow((cr2 = sheet.getMergeRange(tempCell2.getRangeAddressIndex())).getFirstRow()).getCell(cr2.getFirstColumn())) != null) {
                    style2 = tempCell2.getCellStyle();
                }
                if (style2 != null && style2.getBorderLeft() > 0) {
                    hasRight = true;
                    color2 = style2.getBorderLeftColorIdx();
                }
            }
        }
        if (hasRight && cell.getExpandedRangeAddressIndex() >= 0) {
            CellRangeAddress cr3 = sheet.getRow(cell.getRowNumber()).getExpandedRangeAddress(cell.getExpandedRangeAddressIndex()).getRangedAddress();
            if (cell.getColNumber() != cr3.getLastColumn()) {
                hasRight = false;
            }
        }
        if (hasRight) {
            return color2;
        }
        return -1;
    }

    private int TopBorder(Cell cell) {
        CellRangeAddress cr;
        Cell tempCell;
        CellStyle style2 = cell.getCellStyle();
        Sheet sheet = this.sheetView.getCurrentSheet();
        if (cell.getRangeAddressIndex() >= 0 && (tempCell = sheet.getRow((cr = sheet.getMergeRange(cell.getRangeAddressIndex())).getFirstRow()).getCell(cr.getFirstColumn())) != null) {
            style2 = tempCell.getCellStyle();
            cell = tempCell;
        }
        if (style2 != null && style2.getBorderTop() > 0) {
            return style2.getBorderTopColorIdx();
        }
        Row topRow = sheet.getRowByColumnsStyle(cell.getRowNumber() - 1);
        if (topRow != null && (cell = topRow.getCell(cell.getColNumber())) != null) {
            CellRangeAddress cr2;
            style2 = cell.getCellStyle();
            if (cell.getRangeAddressIndex() >= 0 && (cell = sheet.getRow((cr2 = sheet.getMergeRange(cell.getRangeAddressIndex())).getLastRow()).getCell(cr2.getLastColumn())) != null) {
                style2 = cell.getCellStyle();
            }
            if (style2 != null && style2.getBorderBottom() > 0) {
                return style2.getBorderBottomColorIdx();
            }
        }
        return -1;
    }

    private int BottomBorder(Cell cell) {
        CellRangeAddress cr;
        Cell tempCell;
        CellStyle style2 = cell.getCellStyle();
        Sheet sheet = this.sheetView.getCurrentSheet();
        if (cell.getRangeAddressIndex() >= 0 && (tempCell = sheet.getRow((cr = sheet.getMergeRange(cell.getRangeAddressIndex())).getLastRow()).getCell(cr.getLastColumn())) != null) {
            style2 = tempCell.getCellStyle();
            cell = tempCell;
        }
        if (style2 != null && style2.getBorderBottom() > 0) {
            return style2.getBorderBottomColorIdx();
        }
        Row topRow = sheet.getRowByColumnsStyle(cell.getRowNumber() + 1);
        if (topRow != null && (cell = topRow.getCell(cell.getColNumber())) != null) {
            CellRangeAddress cr2;
            style2 = cell.getCellStyle();
            if (cell.getRangeAddressIndex() >= 0 && (cell = sheet.getRow((cr2 = sheet.getMergeRange(cell.getRangeAddressIndex())).getFirstRow()).getCell(cr2.getFirstColumn())) != null) {
                style2 = cell.getCellStyle();
            }
            if (style2 != null && style2.getBorderTop() > 0) {
                return style2.getBorderTopColorIdx();
            }
        }
        return -1;
    }

    public void drawActiveCellBorder(Canvas canvas, RectF rect, short activeCellType) {
        Rect clipBounds = canvas.getClipBounds();
        clipBounds.left = this.sheetView.getRowHeaderWidth();
        clipBounds.top = this.sheetView.getColumnHeaderHeight();
        canvas.save();
        canvas.clipRect(clipBounds);
        Paint paint = PaintKit.instance().getPaint();
        int oldColor = paint.getColor();
        paint.setColor(-16777216);
        if (activeCellType == 0 && rect.left != rect.right && rect.top != rect.bottom) {
            canvas.drawRect(rect.left - 2.0f, rect.top - 2.0f, rect.left + 1.0f, rect.bottom + 2.0f, paint);
            canvas.drawRect(rect.left - 2.0f, rect.top - 2.0f, rect.right + 2.0f, rect.top + 1.0f, paint);
            canvas.drawRect(rect.right - 1.0f, rect.top - 2.0f, rect.right + 2.0f, rect.bottom + 2.0f, paint);
            canvas.drawRect(rect.left - 2.0f, rect.bottom - 1.0f, rect.right + 2.0f, rect.bottom + 2.0f, paint);
        } else if (activeCellType == 1 && rect.top != rect.bottom) {
            canvas.drawRect((float)(clipBounds.left - 2), rect.top - 2.0f, (float)(clipBounds.right + 10), rect.top + 1.0f, paint);
            canvas.drawRect((float)(clipBounds.left - 2), rect.bottom - 1.0f, (float)(clipBounds.right + 10), rect.bottom + 2.0f, paint);
        } else if (activeCellType == 2 && rect.left != rect.right) {
            canvas.drawRect(rect.left - 2.0f, (float)(clipBounds.top - 2), rect.left + 1.0f, (float)(clipBounds.bottom + 2), paint);
            canvas.drawRect(rect.right - 1.0f, (float)(clipBounds.top - 2), rect.right + 2.0f, (float)(clipBounds.bottom + 2), paint);
        }
        paint.setColor(oldColor);
        canvas.restore();
    }

    public void dispose() {
        this.sheetView = null;
    }
}

