/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.util.format;

import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.Font;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.format.AccountFormat;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.format.DateTimeFormat;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.format.FractionalFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumericFormatter {
    private static NumericFormatter cf = new NumericFormatter();
    private static final Pattern amPmPattern = Pattern.compile("((A|P)[M/P]*)", 2);
    private static final Pattern colorPattern = Pattern.compile("(\\[BLACK\\])|(\\[BLUE\\])|(\\[CYAN\\])|(\\[GREEN\\])|(\\[MAGENTA\\])|(\\[RED\\])|(\\[WHITE\\])|(\\[YELLOW\\])|(\\[COLOR\\s*\\d\\])|(\\[COLOR\\s*[0-5]\\d\\])", 2);
    private final Map<String, Format> formats = new HashMap<String, Format>();

    private NumericFormatter() {
        Format zipFormat = ZipPlusFourFormat.instance;
        this.addFormat("00000\\-0000", zipFormat);
        this.addFormat("00000-0000", zipFormat);
        Format phoneFormat = PhoneFormat.instance;
        this.addFormat("[<=9999999]###\\-####;\\(###\\)\\ ###\\-####", phoneFormat);
        this.addFormat("[<=9999999]###-####;(###) ###-####", phoneFormat);
        this.addFormat("###\\-####;\\(###\\)\\ ###\\-####", phoneFormat);
        this.addFormat("###-####;(###) ###-####", phoneFormat);
        this.addFormat("[<=9999999]000\\-0000;\\(000\\)\\ 000\\-0000", phoneFormat);
        this.addFormat("[<=9999999]000-0000;(000) 000-0000", phoneFormat);
        this.addFormat("000\\-0000;\\(000\\)\\ 000\\-0000", phoneFormat);
        this.addFormat("000-0000;(000) 000-0000", phoneFormat);
        Format ssnFormat = SSNFormat.instance;
        this.addFormat("000\\-00\\-0000", ssnFormat);
        this.addFormat("000-00-0000", ssnFormat);
    }

    public static NumericFormatter instance() {
        return cf;
    }

    public void addFormat(String excelFormatStr, Format format) {
        this.formats.put(excelFormatStr, format);
    }

    public short getNumericCellType(String formatString) {
        int cellType = -1;
        int len = formatString.length();
        cellType = formatString == null || formatString.length() == 0 || formatString.equalsIgnoreCase("General") ? 6 : ("@".equals(formatString) ? 11 : (formatString.replace("?/", "").length() < len ? 9 : (formatString.indexOf(42) > -1 ? 8 : ((formatString = this.validateDatePattern(formatString)) == null || formatString.length() == 0 || formatString.equalsIgnoreCase("General") ? 6 : (DateTimeFormat.isDateTimeFormat(formatString) ? 10 : 7)))));
        return (short)cellType;
    }

    private String validatePattern(String formatValue) {
        String format = formatValue.replace(";@", "");
        formatValue = "";
        String str = "";
        int s = format.indexOf(34);
        while (s >= 0) {
            str = format.substring(0, s);
            if ((s = (format = format.substring(s + 1, format.length())).indexOf(34)) >= 0) {
                str = this.deleteInvalidateChars(str);
            }
            formatValue = formatValue + str + format.substring(0, s);
            format = format.substring(s + 1, format.length());
            s = format.indexOf(34);
        }
        return formatValue + this.deleteInvalidateChars(format);
    }

    private String deleteInvalidateChars(String str) {
        if (str != null) {
            str = str.replaceAll("\\\\-", "-");
            str = str.replaceAll("\\\\,", ",");
            str = str.replaceAll("\\\\\\.", ".");
            str = str.replaceAll("\\\\ ", " ");
            str = str.replaceAll("\\\\/", "/");
            str = str.replaceAll("\"/\"", "/");
            str = str.replace("_-", " ");
            str = str.replace("_(", " ");
            str = str.replace("_)", "");
            str = str.replace("\\(", "(");
            str = str.replace("\\)", ")");
            str = str.replace("\\", "");
            str = str.replace("_", "");
        }
        return str;
    }

    private String validateDatePattern(String formatStr) {
        String format = this.validatePattern(formatStr);
        boolean hasAmPm = false;
        Matcher amPmMatcher = amPmPattern.matcher(format);
        while (amPmMatcher.find()) {
            hasAmPm = true;
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = format.toCharArray();
        boolean mIsMonth = true;
        ArrayList<Integer> ms = new ArrayList<Integer>();
        boolean isElapsed = false;
        for (int j = 0; j < chars.length; ++j) {
            char c = chars[j];
            if (c == '[' && !isElapsed) {
                isElapsed = true;
                mIsMonth = false;
                sb.append(c);
                continue;
            }
            if (c == ']' && isElapsed) {
                isElapsed = false;
                sb.append(c);
                continue;
            }
            if (isElapsed) {
                if (c == 'h' || c == 'H') {
                    sb.append('H');
                    continue;
                }
                if (c == 'm' || c == 'M') {
                    sb.append('m');
                    continue;
                }
                if (c == 's' || c == 'S') {
                    sb.append('s');
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == 'h' || c == 'H') {
                mIsMonth = false;
                if (hasAmPm) {
                    sb.append('h');
                    continue;
                }
                sb.append('H');
                continue;
            }
            if (c == 'm' || c == 'M') {
                if (mIsMonth) {
                    sb.append('M');
                    ms.add(sb.length() - 1);
                    continue;
                }
                sb.append('m');
                continue;
            }
            if (c == 's' || c == 'S') {
                sb.append('s');
                for (int i = 0; i < ms.size(); ++i) {
                    int index = (Integer)ms.get(i);
                    if (sb.charAt(index) != 'M') continue;
                    sb.replace(index, index + 1, "m");
                }
                mIsMonth = true;
                ms.clear();
                continue;
            }
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                mIsMonth = true;
                ms.clear();
                if (c == 'y' || c == 'Y') {
                    sb.append('y');
                    continue;
                }
                if (c == 'd' || c == 'D') {
                    sb.append('d');
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        format = sb.toString();
        int index = format.indexOf(91);
        while (index > -1) {
            int next = format.indexOf(93);
            format = format.substring(0, index) + format.substring(next + 1, format.length());
            index = format.indexOf(91);
        }
        return format;
    }

    public static int getNegativeColor(Cell cell) {
        String formatCode = cell.getCellStyle().getFormatCode();
        Workbook book = cell.getSheet().getWorkbook();
        Matcher colorM = colorPattern.matcher(formatCode);
        if (colorM.find()) {
            String color2 = colorM.group();
            int at = formatCode.indexOf(color2);
            if (at == -1) {
                return -16777216;
            }
            if (color2.equals("[Red]")) {
                return -65536;
            }
            if (color2.equals("[Blue]")) {
                return -16776961;
            }
            if (color2.equals("[Cyan]")) {
                return -16711681;
            }
            if (color2.equals("[Green]")) {
                return -16711936;
            }
            if (color2.equals("[Magenta]")) {
                return -65281;
            }
            if (color2.equals("[Black]")) {
                return -16777216;
            }
            if (color2.equals("[White]")) {
                return -1;
            }
            if (color2.equals("[Yellow]")) {
                return -256;
            }
            if (color2.equals("[Color n]")) {
                color2 = color2.replace("[Color ", "").replace("]", "");
                int index = Integer.parseInt(color2);
                return book.getColor(index + 8 - 1);
            }
        }
        Font font = book.getFont(cell.getCellStyle().getFontIndex());
        return book.getColor(font.getColorIndex());
    }

    private String getMoneySymbol(String formatString) {
        int index1 = formatString.indexOf("[");
        int index2 = formatString.indexOf("]");
        String moneysymbol = null;
        while (index1 >= 0 && index2 >= 0) {
            String removedStr = formatString.substring(index1, index2 + 1);
            if ((index1 = removedStr.indexOf("$")) >= 0) {
                index2 = removedStr.indexOf(45);
                if (index2 < 0) {
                    index2 = removedStr.indexOf("]");
                }
                if ((moneysymbol = removedStr.substring(index1 + 1, index2)) != null) {
                    return moneysymbol;
                }
            }
            formatString = formatString.replace(removedStr, "");
            index1 = formatString.indexOf("[");
            index2 = formatString.indexOf("]");
        }
        return null;
    }

    private boolean isNegativeFirst(String formatString) {
        String str;
        int index1 = formatString.indexOf("[");
        int index2 = formatString.indexOf("]");
        String moneySymbol = null;
        if (index1 >= 0 && index2 >= 0 && (index1 = (str = formatString.substring(index1, index2 + 1)).indexOf("$")) >= 0 && str.length() == 8) {
            moneySymbol = str;
        }
        return moneySymbol != null && (index1 = formatString.indexOf(59)) >= 0 && (index1 = (formatString = formatString.substring(index1)).indexOf(moneySymbol)) > 0 && formatString.charAt(index1 - 1) == '-';
    }

    private String processMoneyAndNegative(String formatString) {
        int index1 = formatString.indexOf("[");
        int index2 = formatString.indexOf("]");
        Object moneysymbol = null;
        while (index1 >= 0 && index2 >= 0) {
            String removedStr = formatString.substring(index1, index2 + 1);
            formatString = formatString.replace(removedStr, "");
            index1 = formatString.indexOf("[");
            index2 = formatString.indexOf("]");
        }
        return formatString;
    }

    public String getFormatContents(String formatString, Date date) {
        try {
            DateTimeFormat format = new DateTimeFormat(this.validateDatePattern(formatString));
            return format.format(date);
        }
        catch (Exception ex) {
            DateTimeFormat format = new DateTimeFormat("m/d/yy");
            return format.format(date);
        }
    }

    public String getFormatContents(String formatString, double value, short cellType) {
        Format format = this.formats.get(formatString);
        if (format != null) {
            return format.format(value);
        }
        formatString = this.validatePattern(formatString);
        String contents = "";
        try {
            switch (cellType) {
                case 6: 
                case 11: {
                    int index;
                    contents = String.valueOf(value);
                    if (!contents.contains("E") && (index = contents.indexOf(46)) > 0 && contents.length() - index > 10) {
                        contents = contents.substring(0, index + 10);
                    }
                    contents = this.delLastZero(contents);
                    break;
                }
                case 9: {
                    format = new FractionalFormat(formatString);
                    contents = format.format(value);
                    if (contents.length() != 0) break;
                    contents = String.valueOf(0);
                    break;
                }
                case 7: {
                    String[] formats;
                    String moneysymbol = this.getMoneySymbol(formatString);
                    boolean isNegativeFirst = this.isNegativeFirst(formatString);
                    formatString = this.processMoneyAndNegative(formatString);
                    if (value < 0.0 && (formats = formatString.split(";")).length == 2 && formats[0].equals(formats[1])) {
                        value = -value;
                    }
                    format = new DecimalFormat(formatString);
                    if (value > 0.0) {
                        value += 1.0E-9;
                    } else if (value < 0.0) {
                        value -= 1.0E-9;
                    }
                    contents = format.format(value);
                    if (moneysymbol == null) break;
                    if (contents.charAt(0) == '(') {
                        contents = "(" + moneysymbol + contents.substring(1);
                        break;
                    }
                    if (value < 0.0 && isNegativeFirst) {
                        contents = "-" + moneysymbol + contents.replace("-", "");
                        break;
                    }
                    contents = moneysymbol.concat(contents);
                    break;
                }
                case 8: {
                    String moneysymbol = this.getMoneySymbol(formatString);
                    boolean isNegativeFirst = this.isNegativeFirst(formatString);
                    formatString = this.processMoneyAndNegative(formatString);
                    if (value > 0.0) {
                        value += 1.0E-9;
                    } else if (value < 0.0) {
                        value -= 1.0E-9;
                    }
                    contents = AccountFormat.instance().format(formatString, value);
                    if (moneysymbol == null) break;
                    contents = value < 0.0 && isNegativeFirst ? "-" + moneysymbol + contents.replace("-", "") : moneysymbol.concat(contents);
                }
            }
        }
        catch (IllegalArgumentException e) {
            if (formatString.replace("0", "").replace("-", "").length() == 0) {
                format = new DecimalFormat(formatString.replace("-", ""));
                contents = format.format(value);
                StringBuilder strBuilder = new StringBuilder(contents);
                String[] ps = formatString.split("-");
                int cnt = 0;
                for (int i = ps.length - 1; i > 0; --i) {
                    strBuilder.insert(strBuilder.length() - (cnt += ps[i].length()), "-");
                    ++cnt;
                }
                contents = strBuilder.toString();
            }
            contents = String.valueOf(value);
        }
        return contents;
    }

    private String delLastZero(String contents) {
        int index;
        if (contents != null && contents.length() > 1 && !contents.contains("E") && contents.charAt(contents.length() - 1) == '0' && (index = contents.indexOf(46)) > 0) {
            int i;
            char[] chars = contents.toCharArray();
            for (i = chars.length - 1; i > index && chars[i] == '0'; --i) {
            }
            if (chars[i] == '.') {
                --i;
            }
            return String.valueOf(chars, 0, i + 1);
        }
        return contents;
    }

    static DecimalFormat createIntegerOnlyFormat(String fmt) {
        DecimalFormat result = new DecimalFormat(fmt);
        result.setParseIntegerOnly(true);
        return result;
    }

    private static final class ZipPlusFourFormat
    extends Format {
        public static final Format instance = new ZipPlusFourFormat();
        private static final DecimalFormat df = NumericFormatter.createIntegerOnlyFormat("000000000");

        private ZipPlusFourFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            sb.append(result.substring(0, 5)).append('-');
            sb.append(result.substring(5, 9));
            return sb.toString();
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(ZipPlusFourFormat.format((Number)obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class PhoneFormat
    extends Format {
        public static final Format instance = new PhoneFormat();
        private static final DecimalFormat df = NumericFormatter.createIntegerOnlyFormat("##########");

        private PhoneFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            int len = result.length();
            if (len <= 4) {
                return result;
            }
            String seg3 = result.substring(len - 4, len);
            String seg2 = result.substring(Math.max(0, len - 7), len - 4);
            String seg1 = result.substring(Math.max(0, len - 10), Math.max(0, len - 7));
            if (seg1 != null && seg1.trim().length() > 0) {
                sb.append('(').append(seg1).append(") ");
            }
            if (seg2 != null && seg2.trim().length() > 0) {
                sb.append(seg2).append('-');
            }
            sb.append(seg3);
            return sb.toString();
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(PhoneFormat.format((Number)obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class SSNFormat
    extends Format {
        public static final Format instance = new SSNFormat();
        private static final DecimalFormat df = NumericFormatter.createIntegerOnlyFormat("000000000");

        private SSNFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            sb.append(result.substring(0, 3)).append('-');
            sb.append(result.substring(3, 5)).append('-');
            sb.append(result.substring(5, 9));
            return sb.toString();
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(SSNFormat.format((Number)obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class ConstantStringFormat
    extends Format {
        private static final DecimalFormat df = NumericFormatter.createIntegerOnlyFormat("##########");
        private final String str;

        public ConstantStringFormat(String s) {
            this.str = s;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(this.str);
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }
}

