/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.util.format;

import com.ahmadullahpk.alldocumentreader.xs.ss.util.format.DateTimeFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeFormat {
    static final String patternChars = "GyMdkHmsSEDFwWahKzZ";
    private static final String datePatternChars = "GyMdEDFwWazZ";
    private static final String timePatternChars = "HhsSkK";
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int DAY_OF_WEEK_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;
    protected Calendar calendar;
    protected NumberFormat numberFormat;
    private String pattern;
    private DateTimeFormatSymbols dateTimeFormatData;
    private boolean ampm = false;

    public DateTimeFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    private DateTimeFormat(Locale locale) {
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setGroupingUsed(false);
        this.calendar = new GregorianCalendar(locale);
        this.calendar.add(1, -80);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String adjust(String template) {
        char[] chars;
        int index;
        if (template.contains("AM/PM") || template.contains("\u4e0a\u5348/\u4e0b\u5348")) {
            template = template.replace("AM/PM", "").replace("\u4e0a\u5348/\u4e0b\u5348", "");
            this.ampm = true;
        }
        boolean date = this.isDate(template);
        boolean time = this.isTime(template);
        if (time && date) {
            index = template.indexOf("mmm");
            chars = null;
        } else {
            if (date) {
                return template.replace('m', 'M');
            }
            if (this.ampm) return template;
            return template.replace('h', 'k');
        }
        while (index > -1) {
            chars = template.toCharArray();
            int first = index;
            int last = index + 3;
            while (template.charAt(last) == 'm') {
                ++last;
            }
            for (index = first; index < last; ++index) {
                chars[index] = 77;
            }
            template = String.valueOf(chars);
            index = template.indexOf("mmm");
        }
        chars = template.toCharArray();
        ArrayList indexList = new ArrayList();
        index = template.indexOf(109);
        if (index <= -1) return template;
        return template;
    }

    public DateTimeFormat(String template, Locale locale) {
        this(locale);
        template = this.adjust(template);
        this.validatePattern(template);
        this.pattern = template;
        this.dateTimeFormatData = new DateTimeFormatSymbols(locale);
    }

    private void validateFormat(char format) {
        int index = patternChars.indexOf(format);
        if (index == -1) {
            throw new IllegalArgumentException("invalidate char");
        }
    }

    private void validatePattern(String template) {
        boolean quote = false;
        int last = -1;
        int count = 0;
        int patternLength = template.length();
        for (int i = 0; i < patternLength; ++i) {
            int next = template.charAt(i);
            if (next == 39) {
                if (count > 0) {
                    this.validateFormat((char)last);
                    count = 0;
                }
                last = last == next ? -1 : next;
                quote = !quote;
                continue;
            }
            if (!quote && (last == next || next >= 97 && next <= 122 || next >= 65 && next <= 90)) {
                if (last == next) {
                    ++count;
                    continue;
                }
                if (count > 0) {
                    this.validateFormat((char)last);
                }
                last = next;
                count = 1;
                continue;
            }
            if (count > 0) {
                this.validateFormat((char)last);
                count = 0;
            }
            last = -1;
        }
        if (count > 0) {
            this.validateFormat((char)last);
        }
        if (quote) {
            throw new IllegalArgumentException("invalidate pattern");
        }
    }

    public String format(Date date) {
        return this.formatImpl(date, new StringBuffer()).toString();
    }

    private StringBuffer formatImpl(Date date, StringBuffer buffer) {
        boolean quote = false;
        int last = -1;
        int count = 0;
        this.calendar.setTime(date);
        int patternLength = this.pattern.length();
        for (int i = 0; i < patternLength; ++i) {
            int next = this.pattern.charAt(i);
            if (next == 39) {
                if (count > 0) {
                    this.append(buffer, (char)last, count);
                    count = 0;
                }
                if (last == next) {
                    buffer.append('\'');
                    last = -1;
                } else {
                    last = next;
                }
                quote = !quote;
                continue;
            }
            if (!quote && (last == next || next >= 97 && next <= 122 || next >= 65 && next <= 90)) {
                if (last == next) {
                    ++count;
                    continue;
                }
                if (count > 0) {
                    this.append(buffer, (char)last, count);
                }
                last = next;
                count = 1;
                continue;
            }
            if (count > 0) {
                this.append(buffer, (char)last, count);
                count = 0;
            }
            last = -1;
            buffer.append((char)next);
        }
        if (count > 0) {
            this.append(buffer, (char)last, count);
        }
        if (this.ampm) {
            String[] strAMPM = this.dateTimeFormatData.formatData.getAmPmStrings();
            buffer.append(strAMPM[this.calendar.get(9)]);
        }
        return buffer;
    }

    private void append(StringBuffer buffer, char format, int count) {
        int field = -1;
        int index = patternChars.indexOf(format);
        if (index == -1) {
            throw new IllegalArgumentException("invalidate char");
        }
        switch (index) {
            case 0: {
                String[] strERAS = this.dateTimeFormatData.formatData.getEras();
                buffer.append(strERAS[this.calendar.get(0)]);
                break;
            }
            case 1: {
                int year = this.calendar.get(1);
                if (count == 2) {
                    this.appendNumber(buffer, 2, year %= 100);
                    break;
                }
                this.appendNumber(buffer, count, year);
                break;
            }
            case 2: {
                int month = this.calendar.get(2);
                if (count <= 2) {
                    this.appendNumber(buffer, count, month + 1);
                    break;
                }
                if (count == 3) {
                    String[] strMonths = this.dateTimeFormatData.formatData.getShortMonths();
                    buffer.append(strMonths[month]);
                    break;
                }
                String[] strMonths = this.dateTimeFormatData.formatData.getMonths();
                buffer.append(strMonths[month]);
                break;
            }
            case 3: {
                int weekday = this.calendar.get(7);
                if (weekday >= this.dateTimeFormatData.stdShortWeekdays.length) break;
                if (count == 3) {
                    buffer.append(this.dateTimeFormatData.stdShortWeekdays[weekday]);
                    break;
                }
                if (count > 3) {
                    buffer.append(this.dateTimeFormatData.stdWeekdays[weekday]);
                    break;
                }
                field = 5;
                break;
            }
            case 4: {
                int hour = this.calendar.get(11);
                this.appendNumber(buffer, count, hour == 0 ? 24 : hour);
                break;
            }
            case 5: {
                if (this.ampm) {
                    int hour = this.calendar.get(10);
                    this.appendNumber(buffer, count, hour == 0 ? 12 : hour);
                    break;
                }
                int hour = this.calendar.get(11);
                this.appendNumber(buffer, count, hour);
                break;
            }
            case 6: {
                if (count == 3 || count > 5) {
                    buffer.append(this.dateTimeFormatData.stdShortMonths[this.calendar.get(2)]);
                    break;
                }
                if (count == 4) {
                    buffer.append(this.dateTimeFormatData.stdMonths[this.calendar.get(2)]);
                    break;
                }
                if (count == 5) {
                    buffer.append(this.dateTimeFormatData.stdShortestMonths[this.calendar.get(2)]);
                    break;
                }
                field = 12;
                break;
            }
            case 7: {
                field = 13;
                break;
            }
            case 8: {
                int value = this.calendar.get(14);
                this.appendNumber(buffer, count, value);
                break;
            }
            case 10: {
                field = 6;
                break;
            }
            case 11: {
                field = 8;
                break;
            }
            case 12: {
                field = 3;
                break;
            }
            case 13: {
                field = 4;
                break;
            }
            case 14: {
                int day = this.calendar.get(7);
                if (count == 3) {
                    String[] strWeekdays = this.dateTimeFormatData.formatData.getShortWeekdays();
                    buffer.append(strWeekdays[day]);
                    break;
                }
                if (count <= 3) break;
                String[] strWeekdays = this.dateTimeFormatData.formatData.getWeekdays();
                buffer.append(strWeekdays[day]);
                break;
            }
            case 15: {
                if (this.ampm) {
                    int hour = this.calendar.get(10);
                    this.appendNumber(buffer, count, hour == 0 ? 12 : hour);
                    break;
                }
                int hour = this.calendar.get(11);
                this.appendNumber(buffer, count, hour);
                break;
            }
            case 16: {
                field = 10;
                break;
            }
            case 17: {
                this.appendTimeZone(buffer, count, true);
                break;
            }
            case 18: {
                this.appendNumericTimeZone(buffer, false);
            }
        }
        if (field != -1) {
            this.appendNumber(buffer, count, this.calendar.get(field));
        }
    }

    private void appendTimeZone(StringBuffer buffer, int count, boolean generalTimeZone) {
        if (generalTimeZone) {
            TimeZone tz = this.calendar.getTimeZone();
            boolean daylight = this.calendar.get(16) != 0;
            int style2 = count < 4 ? 0 : 1;
            buffer.append(tz.getDisplayName(daylight, style2, Locale.getDefault()));
            return;
        }
        this.appendNumericTimeZone(buffer, generalTimeZone);
    }

    private void appendNumericTimeZone(StringBuffer buffer, boolean generalTimeZone) {
        int offset = this.calendar.get(15) + this.calendar.get(16);
        char sign = '+';
        if (offset < 0) {
            sign = '-';
            offset = -offset;
        }
        if (generalTimeZone) {
            buffer.append("GMT");
        }
        buffer.append(sign);
        this.appendNumber(buffer, 2, offset / 3600000);
        if (generalTimeZone) {
            buffer.append(':');
        }
        this.appendNumber(buffer, 2, offset % 3600000 / 60000);
    }

    private void appendNumber(StringBuffer buffer, int count, int value) {
        int minimumIntegerDigits = this.numberFormat.getMinimumIntegerDigits();
        this.numberFormat.setMinimumIntegerDigits(count);
        this.numberFormat.format((Object)value, buffer, new FieldPosition(0));
        this.numberFormat.setMinimumIntegerDigits(minimumIntegerDigits);
    }

    public static boolean isDateTimeFormat(String format) {
        format = format.replace("E+", "");
        int len = patternChars.length();
        boolean value = false;
        for (int index = 0; index < len; ++index) {
            if (format.indexOf(patternChars.charAt(index)) <= -1) continue;
            value = true;
            break;
        }
        return value;
    }

    private boolean isDate(String formatString) {
        String subString = formatString.replace("AM", "");
        subString = formatString.replace("PM", "");
        int len = datePatternChars.length();
        boolean value = false;
        for (int index = 0; index < len; ++index) {
            if (subString.indexOf(datePatternChars.charAt(index)) <= -1) continue;
            value = true;
            break;
        }
        return value;
    }

    private boolean isTime(String formatString) {
        int len = timePatternChars.length();
        boolean value = false;
        for (int index = 0; index < len; ++index) {
            if (formatString.indexOf(timePatternChars.charAt(index)) <= -1) continue;
            value = true;
            break;
        }
        return value;
    }

    public void dispose() {
        this.calendar = null;
        this.numberFormat = null;
        this.dateTimeFormatData.dispose();
        this.dateTimeFormatData = null;
    }
}

