/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.util;

import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;

public class HeaderUtil {
    private static HeaderUtil util = new HeaderUtil();

    public static HeaderUtil instance() {
        return util;
    }

    public String getColumnHeaderTextByIndex(int index) {
        String result = "";
        while (index >= 0) {
            result = (char)((char)(index % 26) + 65) + result;
            index = index / 26 - 1;
        }
        return result;
    }

    public int getColumnHeaderIndexByText(String text) {
        int index = 0;
        for (int i = 0; i < text.length(); ++i) {
            index = index * 26 + (text.charAt(i) - 65) + 1;
        }
        return index - 1;
    }

    public boolean isActiveRow(Sheet sheet, int row) {
        if (sheet.getActiveCellType() == 2) {
            return true;
        }
        if (sheet.getActiveCellType() == 1) {
            return sheet.getActiveCellRow() == row;
        }
        boolean active = false;
        Cell cell = sheet.getActiveCell();
        if (cell != null && cell.getRangeAddressIndex() >= 0) {
            CellRangeAddress cr = sheet.getMergeRange(cell.getRangeAddressIndex());
            if (cr.getFirstRow() <= row && cr.getLastRow() >= row) {
                active = true;
            }
        } else if (sheet.getActiveCellRow() == row) {
            active = true;
        }
        return active;
    }

    public boolean isActiveColumn(Sheet sheet, int col) {
        if (sheet.getActiveCellType() == 1) {
            return true;
        }
        if (sheet.getActiveCellType() == 2) {
            return sheet.getActiveCellColumn() == col;
        }
        boolean active = false;
        Cell cell = sheet.getActiveCell();
        if (cell != null && cell.getRangeAddressIndex() >= 0) {
            CellRangeAddress cr = sheet.getMergeRange(cell.getRangeAddressIndex());
            if (cr.getFirstColumn() <= col && cr.getLastColumn() >= col) {
                active = true;
            }
        } else if (sheet.getActiveCellColumn() == col) {
            active = true;
        }
        return active;
    }
}

