/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.other;

import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ModelUtil;

public class FindingMgr {
    private Sheet sheet;
    private String value;
    private Cell findedCell;

    public Cell findCell(Sheet sheet, String value) {
        if (value == null || sheet == null) {
            return null;
        }
        this.sheet = sheet;
        this.value = value;
        if (value != null && value.length() > 0) {
            String cellContent;
            int j;
            Row row;
            int i;
            for (i = sheet.getActiveCellRow(); i <= sheet.getLastRowNum(); ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                int n = j = i == sheet.getActiveCellRow() ? sheet.getActiveCellColumn() : row.getFirstCol();
                while (j <= row.getLastCol()) {
                    this.findedCell = row.getCell(j);
                    if (this.findedCell != null && (cellContent = ModelUtil.instance().getFormatContents(sheet.getWorkbook(), this.findedCell)) != null && cellContent.contains(value)) {
                        return this.findedCell;
                    }
                    ++j;
                }
            }
            for (i = sheet.getFirstRowNum(); i <= sheet.getActiveCellRow(); ++i) {
                row = sheet.getRow(i);
                if (row == null) continue;
                for (j = row.getFirstCol(); j <= row.getLastCol(); ++j) {
                    this.findedCell = row.getCell(j);
                    if (this.findedCell == null || (cellContent = ModelUtil.instance().getFormatContents(sheet.getWorkbook(), this.findedCell)) == null || !cellContent.contains(value)) continue;
                    return this.findedCell;
                }
            }
        }
        return null;
    }

    public Cell findBackward() {
        if (this.findedCell == null || this.value == null || this.sheet == null) {
            return null;
        }
        for (int i = this.findedCell.getRowNumber(); i >= this.sheet.getFirstRowNum(); --i) {
            int j;
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            int n = j = i == this.findedCell.getRowNumber() ? this.findedCell.getColNumber() - 1 : row.getLastCol();
            while (j >= 0) {
                String cellContent;
                Cell cell = row.getCell(j);
                if (cell != null && (cellContent = ModelUtil.instance().getFormatContents(this.sheet.getWorkbook(), cell)) != null && cellContent.contains(this.value)) {
                    this.findedCell = cell;
                    return this.findedCell;
                }
                --j;
            }
        }
        return null;
    }

    public Cell findForward() {
        if (this.findedCell == null || this.value == null || this.sheet == null) {
            return null;
        }
        for (int i = this.findedCell.getRowNumber(); i <= this.sheet.getLastRowNum(); ++i) {
            int j;
            Row row = this.sheet.getRow(i);
            if (row == null) continue;
            int n = j = i == this.findedCell.getRowNumber() ? this.findedCell.getColNumber() + 1 : row.getFirstCol();
            while (j <= row.getLastCol()) {
                String cellContent;
                Cell cell = row.getCell(j);
                if (cell != null && (cellContent = ModelUtil.instance().getFormatContents(this.sheet.getWorkbook(), cell)) != null && cellContent.contains(this.value)) {
                    this.findedCell = cell;
                    return this.findedCell;
                }
                ++j;
            }
        }
        return null;
    }

    public void dispose() {
        this.sheet = null;
        this.value = null;
        this.findedCell = null;
    }
}

