/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model.table;

import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTableCellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTableStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ColorUtil;
import java.util.Map;

public class TableStyleKit {
    private static String[] schemeClrName = new String[]{"accent1", "accent2", "accent3", "accent4", "accent5", "accent6"};
    private SSTableStyle tableStyleLight1_7;
    private SSTableStyle tableStyleLight8_14;
    private SSTableStyle tableStyleLight15_21;
    private SSTableStyle tableStyleMedium1_7;
    private SSTableStyle tableStyleMedium8_14;
    private SSTableStyle tableStyleMedium15_21;
    private SSTableStyle tableStyleMedium22_28;
    private SSTableStyle tableStyleDark1_7;
    private SSTableStyle tableStyleDark8;
    private SSTableStyle tableStyleDark9_11;

    public SSTableStyle getTableStyle(String tableName, Map<String, Integer> schemeColor) {
        try {
            if (tableName == null || tableName.length() == 0) {
                return null;
            }
            if (tableName.contains("Light")) {
                tableName = tableName.substring("TableStyleLight".length()).split(" ")[0];
                int id2 = Integer.parseInt(tableName);
                switch ((id2 - 1) / 7) {
                    case 0: {
                        return this.getTableStyleLight1_7(this.getSchemeColor(schemeColor, id2));
                    }
                    case 1: {
                        return this.getTableStyleLight8_14(this.getSchemeColor(schemeColor, id2));
                    }
                    case 2: {
                        return this.getTableStyleLight15_21(this.getSchemeColor(schemeColor, id2));
                    }
                }
            } else if (tableName.contains("Medium")) {
                tableName = tableName.substring("TableStyleMedium".length()).split(" ")[0];
                int id3 = Integer.parseInt(tableName);
                switch ((id3 - 1) / 7) {
                    case 0: {
                        return this.getTableStyleMedium1_7(this.getSchemeColor(schemeColor, id3));
                    }
                    case 1: {
                        return this.getTableStyleMedium8_14(this.getSchemeColor(schemeColor, id3));
                    }
                    case 2: {
                        return this.getTableStyleMedium15_21(this.getSchemeColor(schemeColor, id3));
                    }
                    case 3: {
                        return this.getTableStyleMedium22_28(this.getSchemeColor(schemeColor, id3));
                    }
                }
            } else {
                tableName = tableName.substring("TableStyleDark".length()).split(" ")[0];
                int id4 = Integer.parseInt(tableName);
                switch (id4) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return this.getTableStyleDark1_7(this.getSchemeColor(schemeColor, id4));
                    }
                    case 8: {
                        return this.getTableStyleDark8();
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        return this.getTableStyleDark9_11(this.getSchemeColor(schemeColor, (id4 - 8) * 2 + 1), this.getSchemeColor(schemeColor, (id4 - 8) * 2));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private int getSchemeColor(Map<String, Integer> schemeColor, int id2) {
        if ((id2 %= 7) == 1) {
            return -16777216;
        }
        return schemeColor.get(schemeClrName[(id2 - 2 + 7) % 7]);
    }

    private SSTableStyle getTableStyleLight1_7(int schemeColor) {
        if (this.tableStyleLight1_7 == null) {
            this.tableStyleLight1_7 = new SSTableStyle();
            SSTableCellStyle cellstyle = new SSTableCellStyle(-1);
            cellstyle.setFontColor(schemeColor);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight1_7.setFirstRow(cellstyle);
            this.tableStyleLight1_7.setLastRow(cellstyle);
            int color2 = ColorUtil.instance().getColorWithTint(schemeColor, 0.8f);
            cellstyle = new SSTableCellStyle(color2);
            cellstyle.setFontColor(schemeColor);
            this.tableStyleLight1_7.setBand1H(cellstyle);
            this.tableStyleLight1_7.setBand1V(cellstyle);
            cellstyle = new SSTableCellStyle(-1);
            cellstyle.setFontColor(schemeColor);
            this.tableStyleLight1_7.setBand2H(cellstyle);
            this.tableStyleLight1_7.setBand2V(cellstyle);
        } else {
            SSTableCellStyle cellstyle = this.tableStyleLight1_7.getFirstRow();
            cellstyle.setFontColor(schemeColor);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight1_7.setFirstRow(cellstyle);
            this.tableStyleLight1_7.setLastRow(cellstyle);
            int color3 = ColorUtil.instance().getColorWithTint(schemeColor, 0.8f);
            cellstyle = this.tableStyleLight1_7.getBand1H();
            cellstyle.setFillColor(color3);
            cellstyle.setFontColor(schemeColor);
            this.tableStyleLight1_7.setBand1H(cellstyle);
            this.tableStyleLight1_7.setBand1V(cellstyle);
            cellstyle = this.tableStyleLight1_7.getBand2H();
            cellstyle.setFontColor(schemeColor);
            this.tableStyleLight1_7.setBand2H(cellstyle);
            this.tableStyleLight1_7.setBand2V(cellstyle);
        }
        return this.tableStyleLight1_7;
    }

    private SSTableStyle getTableStyleLight8_14(int schemeColor) {
        if (this.tableStyleLight8_14 == null) {
            this.tableStyleLight8_14 = new SSTableStyle();
            SSTableCellStyle cellstyle = new SSTableCellStyle(schemeColor);
            cellstyle.setFontColor(-1);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight8_14.setFirstRow(cellstyle);
            cellstyle = new SSTableCellStyle(-1);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight8_14.setLastRow(cellstyle);
            this.tableStyleLight8_14.setBand1H(cellstyle);
            this.tableStyleLight8_14.setBand1V(cellstyle);
            this.tableStyleLight8_14.setBand2H(cellstyle);
            this.tableStyleLight8_14.setBand2V(cellstyle);
        } else {
            SSTableCellStyle cellstyle = this.tableStyleLight8_14.getFirstRow();
            cellstyle.setFillColor(schemeColor);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight8_14.setFirstRow(cellstyle);
            cellstyle = this.tableStyleLight8_14.getBand1H();
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight8_14.setLastRow(cellstyle);
            this.tableStyleLight8_14.setBand1H(cellstyle);
            this.tableStyleLight8_14.setBand1V(cellstyle);
            this.tableStyleLight8_14.setBand2H(cellstyle);
            this.tableStyleLight8_14.setBand2V(cellstyle);
        }
        return this.tableStyleLight8_14;
    }

    private SSTableStyle getTableStyleLight15_21(int schemeColor) {
        if (this.tableStyleLight15_21 == null) {
            this.tableStyleLight15_21 = new SSTableStyle();
            SSTableCellStyle cellstyle = new SSTableCellStyle(-1);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight15_21.setFirstRow(cellstyle);
            this.tableStyleLight15_21.setLastRow(cellstyle);
            int color2 = ColorUtil.instance().getColorWithTint(schemeColor, 0.8f);
            cellstyle = new SSTableCellStyle(color2);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight15_21.setBand1H(cellstyle);
            this.tableStyleLight15_21.setBand1V(cellstyle);
            cellstyle = new SSTableCellStyle(-1);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight15_21.setBand2H(cellstyle);
            this.tableStyleLight15_21.setBand2V(cellstyle);
        } else {
            SSTableCellStyle cellstyle = this.tableStyleLight15_21.getFirstRow();
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight15_21.setFirstRow(cellstyle);
            this.tableStyleLight15_21.setLastRow(cellstyle);
            int color3 = ColorUtil.instance().getColorWithTint(schemeColor, 0.8f);
            cellstyle = this.tableStyleLight15_21.getBand1H();
            cellstyle.setFillColor(color3);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight15_21.setBand1H(cellstyle);
            this.tableStyleLight15_21.setBand1V(cellstyle);
            cellstyle = this.tableStyleLight15_21.getBand2H();
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleLight15_21.setBand2H(cellstyle);
            this.tableStyleLight15_21.setBand2V(cellstyle);
        }
        return this.tableStyleLight15_21;
    }

    private SSTableStyle getTableStyleMedium1_7(int schemeColor) {
        if (this.tableStyleMedium1_7 == null) {
            this.tableStyleMedium1_7 = new SSTableStyle();
            SSTableCellStyle cellstyle = new SSTableCellStyle(schemeColor);
            cellstyle.setFontColor(-1);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleMedium1_7.setFirstRow(cellstyle);
            int color2 = ColorUtil.instance().getColorWithTint(schemeColor, 0.8f);
            cellstyle = new SSTableCellStyle(color2);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleMedium1_7.setBand1H(cellstyle);
            this.tableStyleMedium1_7.setBand1V(cellstyle);
            cellstyle = new SSTableCellStyle(-1);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleMedium1_7.setBand2H(cellstyle);
            this.tableStyleMedium1_7.setBand2V(cellstyle);
        } else {
            SSTableCellStyle cellstyle = this.tableStyleMedium1_7.getFirstRow();
            cellstyle.setFillColor(schemeColor);
            cellstyle.setBorderColor(schemeColor);
            cellstyle.setFontColor(-1);
            this.tableStyleMedium1_7.setFirstRow(cellstyle);
            int color3 = ColorUtil.instance().getColorWithTint(schemeColor, 0.8f);
            cellstyle = this.tableStyleMedium1_7.getBand1H();
            cellstyle.setFillColor(color3);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleMedium1_7.setBand1H(cellstyle);
            this.tableStyleMedium1_7.setBand1V(cellstyle);
            cellstyle = this.tableStyleMedium1_7.getBand2H();
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleMedium1_7.setBand2H(cellstyle);
            this.tableStyleMedium1_7.setBand2V(cellstyle);
        }
        return this.tableStyleMedium1_7;
    }

    private SSTableStyle getTableStyleMedium8_14(int schemeColor) {
        if (this.tableStyleMedium8_14 == null) {
            this.tableStyleMedium8_14 = new SSTableStyle();
            SSTableCellStyle cellstyle = new SSTableCellStyle(schemeColor);
            cellstyle.setBorderColor(-1);
            cellstyle.setFontColor(-1);
            this.tableStyleMedium8_14.setFirstRow(cellstyle);
            this.tableStyleMedium8_14.setFirstCol(cellstyle);
            this.tableStyleMedium8_14.setLastCol(cellstyle);
            this.tableStyleMedium8_14.setLastRow(cellstyle);
            int color2 = ColorUtil.instance().getColorWithTint(schemeColor, 0.6f);
            cellstyle = new SSTableCellStyle(color2);
            cellstyle.setBorderColor(-1);
            this.tableStyleMedium8_14.setBand1H(cellstyle);
            this.tableStyleMedium8_14.setBand1V(cellstyle);
            color2 = ColorUtil.instance().getColorWithTint(schemeColor, 0.8f);
            cellstyle = new SSTableCellStyle(color2);
            cellstyle.setBorderColor(-1);
            this.tableStyleMedium8_14.setBand2H(cellstyle);
            this.tableStyleMedium8_14.setBand2V(cellstyle);
        } else {
            SSTableCellStyle cellstyle = this.tableStyleMedium8_14.getFirstRow();
            cellstyle.setFillColor(schemeColor);
            cellstyle.setBorderColor(-1);
            cellstyle.setFontColor(-1);
            this.tableStyleMedium8_14.setFirstRow(cellstyle);
            this.tableStyleMedium8_14.setFirstCol(cellstyle);
            this.tableStyleMedium8_14.setLastCol(cellstyle);
            this.tableStyleMedium8_14.setLastRow(cellstyle);
            int color3 = ColorUtil.instance().getColorWithTint(schemeColor, 0.6f);
            cellstyle = this.tableStyleMedium8_14.getBand1H();
            cellstyle.setFillColor(color3);
            cellstyle.setBorderColor(-1);
            this.tableStyleMedium8_14.setBand1H(cellstyle);
            this.tableStyleMedium8_14.setBand1V(cellstyle);
            color3 = ColorUtil.instance().getColorWithTint(schemeColor, 0.8f);
            cellstyle = this.tableStyleMedium8_14.getBand2H();
            cellstyle.setFillColor(color3);
            cellstyle.setBorderColor(-1);
            this.tableStyleMedium8_14.setBand2H(cellstyle);
            this.tableStyleMedium8_14.setBand2V(cellstyle);
        }
        return this.tableStyleMedium8_14;
    }

    private SSTableStyle getTableStyleMedium15_21(int schemeColor) {
        if (this.tableStyleMedium15_21 == null) {
            this.tableStyleMedium15_21 = new SSTableStyle();
            SSTableCellStyle cellstyle = new SSTableCellStyle(schemeColor);
            cellstyle.setFontColor(-1);
            this.tableStyleMedium15_21.setFirstRow(cellstyle);
            this.tableStyleMedium15_21.setFirstCol(cellstyle);
            this.tableStyleMedium15_21.setLastCol(cellstyle);
            cellstyle = new SSTableCellStyle(-2565928);
            this.tableStyleMedium15_21.setBand1H(cellstyle);
            this.tableStyleMedium15_21.setBand1V(cellstyle);
            cellstyle = new SSTableCellStyle(-1);
            this.tableStyleMedium15_21.setBand2H(cellstyle);
            this.tableStyleMedium15_21.setBand2V(cellstyle);
        } else {
            SSTableCellStyle cellStyle = this.tableStyleMedium15_21.getFirstRow();
            cellStyle.setFillColor(schemeColor);
            this.tableStyleMedium15_21.setFirstCol(cellStyle);
            this.tableStyleMedium15_21.setLastCol(cellStyle);
        }
        return this.tableStyleMedium15_21;
    }

    private SSTableStyle getTableStyleMedium22_28(int schemeColor) {
        if (this.tableStyleMedium22_28 == null) {
            this.tableStyleMedium22_28 = new SSTableStyle();
            int color2 = ColorUtil.instance().getColorWithTint(schemeColor, 0.6f);
            SSTableCellStyle cellstyle = new SSTableCellStyle(color2);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleMedium22_28.setBand1H(cellstyle);
            this.tableStyleMedium22_28.setBand1V(cellstyle);
            color2 = ColorUtil.instance().getColorWithTint(schemeColor, 0.8f);
            cellstyle = new SSTableCellStyle(color2);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleMedium22_28.setFirstRow(cellstyle);
            this.tableStyleMedium22_28.setLastRow(cellstyle);
            this.tableStyleMedium22_28.setBand2H(cellstyle);
            this.tableStyleMedium22_28.setBand2V(cellstyle);
        } else {
            int color3 = ColorUtil.instance().getColorWithTint(schemeColor, 0.6f);
            SSTableCellStyle cellstyle = this.tableStyleMedium22_28.getBand1H();
            cellstyle.setFillColor(color3);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleMedium22_28.setBand1H(cellstyle);
            this.tableStyleMedium22_28.setBand1V(cellstyle);
            color3 = ColorUtil.instance().getColorWithTint(schemeColor, 0.8f);
            cellstyle = this.tableStyleMedium22_28.getFirstRow();
            cellstyle.setFillColor(color3);
            cellstyle.setBorderColor(schemeColor);
            this.tableStyleMedium22_28.setFirstRow(cellstyle);
            this.tableStyleMedium22_28.setLastRow(cellstyle);
            this.tableStyleMedium22_28.setBand2H(cellstyle);
            this.tableStyleMedium22_28.setBand2V(cellstyle);
        }
        return this.tableStyleMedium22_28;
    }

    private SSTableStyle getTableStyleDark1_7(int schemeColor) {
        if (this.tableStyleDark1_7 == null) {
            this.tableStyleDark1_7 = new SSTableStyle();
            SSTableCellStyle cellstyle = new SSTableCellStyle(-16777216);
            cellstyle.setFontColor(-1);
            cellstyle.setBorderColor(-1);
            this.tableStyleDark1_7.setFirstRow(cellstyle);
            int color2 = 0;
            color2 = (schemeColor & 0xFFFFFF) == 0 ? ColorUtil.instance().getColorWithTint(schemeColor, 0.15f) : ColorUtil.instance().getColorWithTint(schemeColor, -0.5);
            cellstyle = new SSTableCellStyle(color2);
            cellstyle.setFontColor(-1);
            cellstyle.setBorderColor(-1);
            this.tableStyleDark1_7.setLastRow(cellstyle);
            color2 = (schemeColor & 0xFFFFFF) == 0 ? ColorUtil.instance().getColorWithTint(schemeColor, 0.25) : ColorUtil.instance().getColorWithTint(schemeColor, -0.25);
            cellstyle = new SSTableCellStyle(color2);
            cellstyle.setFontColor(-1);
            this.tableStyleDark1_7.setBand1H(cellstyle);
            this.tableStyleDark1_7.setBand1V(cellstyle);
            color2 = (schemeColor & 0xFFFFFF) == 0 ? ColorUtil.instance().getColorWithTint(schemeColor, 0.5) : schemeColor;
            cellstyle = new SSTableCellStyle(color2);
            cellstyle.setFontColor(-1);
            this.tableStyleDark1_7.setBand2H(cellstyle);
            this.tableStyleDark1_7.setBand2V(cellstyle);
        } else {
            int color3 = 0;
            color3 = (schemeColor & 0xFFFFFF) == 0 ? ColorUtil.instance().getColorWithTint(schemeColor, 0.15f) : ColorUtil.instance().getColorWithTint(schemeColor, -0.5);
            SSTableCellStyle cellstyle = this.tableStyleDark1_7.getLastRow();
            cellstyle.setFillColor(color3);
            this.tableStyleDark1_7.setLastRow(cellstyle);
            color3 = (schemeColor & 0xFFFFFF) == 0 ? ColorUtil.instance().getColorWithTint(schemeColor, 0.25) : ColorUtil.instance().getColorWithTint(schemeColor, -0.25);
            cellstyle = this.tableStyleDark1_7.getBand1H();
            cellstyle.setFillColor(color3);
            this.tableStyleDark1_7.setBand1H(cellstyle);
            this.tableStyleDark1_7.setBand1V(cellstyle);
            color3 = (schemeColor & 0xFFFFFF) == 0 ? ColorUtil.instance().getColorWithTint(schemeColor, 0.5) : schemeColor;
            cellstyle = this.tableStyleDark1_7.getBand2H();
            cellstyle.setFillColor(color3);
            this.tableStyleDark1_7.setBand2H(cellstyle);
            this.tableStyleDark1_7.setBand2V(cellstyle);
        }
        return this.tableStyleDark1_7;
    }

    private SSTableStyle getTableStyleDark8() {
        if (this.tableStyleDark8 == null) {
            this.tableStyleDark8 = new SSTableStyle();
            SSTableCellStyle cellstyle = new SSTableCellStyle(-16777216);
            cellstyle.setFontColor(-1);
            this.tableStyleDark8.setFirstRow(cellstyle);
            cellstyle = new SSTableCellStyle(-5921371);
            this.tableStyleDark8.setBand1H(cellstyle);
            this.tableStyleDark8.setBand1V(cellstyle);
            cellstyle = new SSTableCellStyle(-2565928);
            this.tableStyleDark8.setBand2H(cellstyle);
            this.tableStyleDark8.setBand2V(cellstyle);
        }
        return this.tableStyleDark8;
    }

    private SSTableStyle getTableStyleDark9_11(int headerColor, int bodyColor) {
        if (this.tableStyleDark9_11 == null) {
            this.tableStyleDark9_11 = new SSTableStyle();
            SSTableCellStyle cellstyle = new SSTableCellStyle(headerColor);
            cellstyle.setFontColor(-1);
            this.tableStyleDark9_11.setFirstRow(cellstyle);
            int color2 = ColorUtil.instance().getColorWithTint(bodyColor, 0.6f);
            cellstyle = new SSTableCellStyle(color2);
            this.tableStyleDark9_11.setBand1H(cellstyle);
            this.tableStyleDark9_11.setBand1V(cellstyle);
            color2 = ColorUtil.instance().getColorWithTint(bodyColor, 0.8f);
            cellstyle = new SSTableCellStyle(color2);
            this.tableStyleDark9_11.setBand2H(cellstyle);
            this.tableStyleDark9_11.setBand2V(cellstyle);
        } else {
            SSTableCellStyle cellstyle = this.tableStyleDark9_11.getFirstRow();
            cellstyle.setFillColor(headerColor);
            this.tableStyleDark9_11.setFirstRow(cellstyle);
            int color3 = ColorUtil.instance().getColorWithTint(bodyColor, 0.6f);
            cellstyle = this.tableStyleDark9_11.getBand1H();
            cellstyle.setFillColor(color3);
            this.tableStyleDark9_11.setBand1H(cellstyle);
            this.tableStyleDark9_11.setBand1V(cellstyle);
            color3 = ColorUtil.instance().getColorWithTint(bodyColor, 0.8f);
            cellstyle = this.tableStyleDark9_11.getBand2H();
            cellstyle.setFillColor(color3);
            this.tableStyleDark9_11.setBand2H(cellstyle);
            this.tableStyleDark9_11.setBand2V(cellstyle);
        }
        return this.tableStyleDark9_11;
    }

    public void dispose() {
    }
}

