/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel;

import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.STRoot;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.interfacePart.IReaderListener;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty.ColumnInfo;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty.PaneInformation;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Sheet {
    public static final short TYPE_WORKSHEET = 0;
    public static final short TYPE_CHARTSHEET = 1;
    public static final int INITIAL_CAPACITY = 20;
    public static final short ACTIVECELL_SINGLE = 0;
    public static final short ACTIVECELL_ROW = 1;
    public static final short ACTIVECELL_COLUMN = 2;
    public static final short State_NotAccomplished = 0;
    public static final short State_Reading = 1;
    public static final short State_Accomplished = 2;
    protected Workbook book;
    private boolean isGridsPrinted;
    private int firstRow;
    private int lastRow;
    private int activeCellRow;
    private int activeCellColumn;
    private float maxScrollX = 2.1474836E9f;
    private float maxScrollY = 2.1474836E9f;
    private int scrollX;
    private int scrollY;
    private short type;
    private short activeCellType = 0;
    private float zoom = 1.0f;
    private String sheetName;
    private Cell activeCell;
    protected Map<Integer, Row> rows = new HashMap<Integer, Row>();
    private List<CellRangeAddress> merges = new ArrayList<CellRangeAddress>();
    private PaneInformation paneInformation;
    private List<ColumnInfo> columnInfoList;
    protected List<IShape> shapesList = new ArrayList<IShape>();
    private int defaultRowHeight = 18;
    private int defaultColWidth = 72;
    private short state;
    private IReaderListener iReaderListener;
    private List<STRoot> rootViewMap;
    private List<SSTable> tableList;

    public void setWorkbook(Workbook book) {
        this.book = book;
    }

    public Workbook getWorkbook() {
        return this.book;
    }

    public void addRow(Row row) {
        if (row == null) {
            return;
        }
        this.rows.put(row.getRowNumber(), row);
        if (this.rows.size() == 1) {
            this.firstRow = row.getRowNumber();
            this.lastRow = row.getRowNumber();
        } else {
            this.firstRow = Math.min(this.firstRow, row.getRowNumber());
            this.lastRow = Math.max(this.lastRow, row.getRowNumber());
        }
    }

    public int addMergeRange(CellRangeAddress range) {
        this.merges.add(range);
        return this.merges.size();
    }

    public int getMergeRangeCount() {
        return this.merges.size();
    }

    public CellRangeAddress getMergeRange(int index) {
        if (index < 0 || index >= this.merges.size()) {
            return null;
        }
        return this.merges.get(index);
    }

    public Row getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public Row getRowByColumnsStyle(int rowIndex) {
        Row row = this.rows.get(rowIndex);
        if (row != null) {
            return row;
        }
        if (this.columnInfoList == null || this.columnInfoList.size() == 0) {
            return null;
        }
        int index = 0;
        while (index < this.columnInfoList.size()) {
            ColumnInfo columnInfo;
            CellStyle cellStyle;
            if ((cellStyle = this.book.getCellStyle((columnInfo = this.columnInfoList.get(index++)).getStyle())) == null || (cellStyle.getFillPatternType() != 0 || (cellStyle.getFgColor() & 0xFFFFFF) == 0xFFFFFF) && cellStyle.getBorderLeft() <= 0 && cellStyle.getBorderTop() <= 0 && cellStyle.getBorderRight() <= 0 && cellStyle.getBorderBottom() <= 0) continue;
            row = new Row(1);
            row.setRowNumber(rowIndex);
            row.setRowPixelHeight(this.defaultRowHeight);
            row.setSheet(this);
            row.completed();
            this.rows.put(rowIndex, row);
            return row;
        }
        return null;
    }

    public int getPhysicalNumberOfRows() {
        return this.rows.size();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public float getMaxScrollX() {
        return this.maxScrollX;
    }

    public float getMaxScrollY() {
        return this.maxScrollY;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public void setScrollX(int scrollX) {
        this.scrollX = scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(int scrollY) {
        this.scrollY = scrollY;
    }

    public void setScroll(int scrollX, int scrollY) {
        this.scrollX = scrollX;
        this.scrollY = scrollY;
    }

    public int getFirstRowNum() {
        return this.firstRow;
    }

    public void setFirstRowNum(int firstRow) {
        this.firstRow = firstRow;
    }

    public int getLastRowNum() {
        return this.lastRow;
    }

    public void setLastRowNum(int lastRow) {
        this.lastRow = lastRow;
    }

    public void addColumnInfo(ColumnInfo columnInfo) {
        if (this.columnInfoList == null) {
            this.columnInfoList = new ArrayList<ColumnInfo>();
        }
        this.columnInfoList.add(columnInfo);
    }

    public int getColumnStyle(int column) {
        if (this.columnInfoList != null) {
            int index = 0;
            while (index < this.columnInfoList.size()) {
                ColumnInfo columnInfo;
                if ((columnInfo = this.columnInfoList.get(index++)).getFirstCol() > column || columnInfo.getLastCol() < column) continue;
                return columnInfo.getStyle();
            }
        }
        return 0;
    }

    public void setColumnPixelWidth(int column, int width) {
        if (this.columnInfoList != null) {
            int index = 0;
            while (index < this.columnInfoList.size()) {
                ColumnInfo columnInfo;
                if ((columnInfo = this.columnInfoList.get(index++)).getFirstCol() == column && columnInfo.getLastCol() == column) {
                    columnInfo.setColWidth(width);
                    return;
                }
                if (columnInfo.getFirstCol() == column) {
                    ColumnInfo columnInfo3 = new ColumnInfo(column + 1, columnInfo.getLastCol(), columnInfo.getColWidth(), columnInfo.getStyle(), columnInfo.isHidden());
                    columnInfo.setColWidth(width);
                    columnInfo.setLastCol(column);
                    this.columnInfoList.add(columnInfo3);
                    return;
                }
                if (columnInfo.getLastCol() == column) {
                    ColumnInfo columnInfo1 = new ColumnInfo(columnInfo.getFirstCol(), column - 1, columnInfo.getColWidth(), columnInfo.getStyle(), columnInfo.isHidden());
                    columnInfo.setColWidth(width);
                    columnInfo.setFirstCol(column);
                    this.columnInfoList.add(columnInfo1);
                    return;
                }
                if (columnInfo.getFirstCol() >= column || columnInfo.getLastCol() <= column) continue;
                ColumnInfo columnInfo1 = new ColumnInfo(columnInfo.getFirstCol(), column - 1, columnInfo.getColWidth(), columnInfo.getStyle(), columnInfo.isHidden());
                ColumnInfo columnInfo2 = new ColumnInfo(column + 1, columnInfo.getLastCol(), columnInfo.getColWidth(), columnInfo.getStyle(), columnInfo.isHidden());
                columnInfo.setFirstCol(column);
                columnInfo.setLastCol(column);
                columnInfo.setColWidth(width);
                this.columnInfoList.add(columnInfo1);
                this.columnInfoList.add(columnInfo2);
                return;
            }
            this.columnInfoList.add(new ColumnInfo(column, column, width, 0, false));
        } else {
            this.columnInfoList = new ArrayList<ColumnInfo>();
            this.columnInfoList.add(new ColumnInfo(column, column, width, 0, false));
        }
    }

    public float getColumnPixelWidth(int column) {
        if (this.columnInfoList != null) {
            int index = 0;
            while (index < this.columnInfoList.size()) {
                ColumnInfo columnInfo;
                if ((columnInfo = this.columnInfoList.get(index++)).getFirstCol() > column || columnInfo.getLastCol() < column) continue;
                return columnInfo.getColWidth();
            }
        }
        return this.defaultColWidth;
    }

    public ColumnInfo getColumnInfo(int column) {
        if (this.columnInfoList != null) {
            int index = 0;
            while (index < this.columnInfoList.size()) {
                ColumnInfo columnInfo;
                if ((columnInfo = this.columnInfoList.get(index++)).getFirstCol() > column || columnInfo.getLastCol() < column) continue;
                return columnInfo;
            }
        }
        return null;
    }

    public boolean isGridsPrinted() {
        return this.isGridsPrinted;
    }

    public void setGridsPrinted(boolean isGridsPrinted) {
        this.isGridsPrinted = isGridsPrinted;
    }

    public PaneInformation getPaneInformation() {
        return null;
    }

    public void setPaneInformation(PaneInformation paneInformation) {
        this.paneInformation = paneInformation;
    }

    public boolean isColumnHidden(int column) {
        if (this.columnInfoList != null) {
            int index = 0;
            while (index < this.columnInfoList.size()) {
                ColumnInfo columnInfo;
                if ((columnInfo = this.columnInfoList.get(index++)).getFirstCol() > column || columnInfo.getLastCol() < column) continue;
                return columnInfo.isHidden();
            }
        }
        return false;
    }

    public void setColumnHidden(int columnNumber, boolean isColumnHidden) {
    }

    public void setActiveCellType(short type) {
        this.activeCellType = type;
    }

    public short getActiveCellType() {
        return this.activeCellType;
    }

    private void checkActiveRowAndColumnBounds() {
        if (this.book.isBefore07Version()) {
            this.activeCellRow = Math.min(this.activeCellRow, 65535);
            this.activeCellColumn = Math.min(this.activeCellColumn, 255);
        } else {
            this.activeCellRow = Math.min(this.activeCellRow, 1048575);
            this.activeCellColumn = Math.min(this.activeCellColumn, 16383);
        }
    }

    public void setActiveCellRow(int activeCellRow) {
        this.activeCellRow = activeCellRow;
        this.checkActiveRowAndColumnBounds();
    }

    public int getActiveCellRow() {
        return this.activeCellRow;
    }

    public void setActiveCellColumn(int activeCellColumn) {
        this.activeCellColumn = activeCellColumn;
        this.checkActiveRowAndColumnBounds();
    }

    public int getActiveCellColumn() {
        return this.activeCellColumn;
    }

    public void setActiveCellRowCol(int row, int col) {
        this.activeCellType = 0;
        this.activeCellRow = row;
        this.activeCellColumn = col;
        this.checkActiveRowAndColumnBounds();
        int index = 0;
        while (index < this.merges.size()) {
            CellRangeAddress cellRangeAddress;
            if (!(cellRangeAddress = this.merges.get(index++)).isInRange(row, col)) continue;
            this.activeCellRow = cellRangeAddress.getFirstRow();
            this.activeCellColumn = cellRangeAddress.getFirstColumn();
        }
        this.activeCell = this.getRow(row) != null ? this.getRow(row).getCell(col) : null;
    }

    public Cell getActiveCell() {
        return this.activeCell;
    }

    public void setActiveCell(Cell activeCell) {
        this.activeCell = activeCell;
        if (activeCell != null) {
            this.activeCellRow = activeCell.getRowNumber();
            this.activeCellColumn = activeCell.getColNumber();
        } else {
            this.activeCellRow = -1;
            this.activeCellColumn = -1;
        }
    }

    public void appendShapes(IShape shape) {
        this.shapesList.add(shape);
    }

    public IShape[] getShapes() {
        return this.shapesList.toArray(new IShape[this.shapesList.size()]);
    }

    public int getShapeCount() {
        return this.shapesList.size();
    }

    public IShape getShape(int index) {
        if (index < 0 || index >= this.shapesList.size()) {
            return null;
        }
        return this.shapesList.get(index);
    }

    public void setDefaultRowHeight(int defaultRowHeight) {
        this.defaultRowHeight = defaultRowHeight;
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultColWidth(int defaultColWidth) {
        this.defaultColWidth = defaultColWidth;
    }

    public int getDefaultColWidth() {
        return this.defaultColWidth;
    }

    public void setSheetType(short type) {
        this.type = type;
    }

    public short getSheetType() {
        return this.type;
    }

    public void setState(short state) {
        this.state = state;
        if (state == 2 && this.iReaderListener != null) {
            this.iReaderListener.OnReadingFinished();
        }
        this.maxScrollX = 0.0f;
        this.maxScrollY = 0.0f;
        int columnsCnt = 0;
        if (this.columnInfoList != null) {
            for (ColumnInfo info : this.columnInfoList) {
                columnsCnt += info.getLastCol() - info.getFirstCol() + 1;
                if (info.isHidden()) continue;
                this.maxScrollX += info.getColWidth() * (float)(info.getLastCol() - info.getFirstCol() + 1);
            }
        }
        int rowCnt = this.rows.size();
        Iterator<Row> iter = this.rows.values().iterator();
        while (iter.hasNext()) {
            this.maxScrollY += iter.next().getRowPixelHeight();
        }
        if (!this.book.isBefore07Version()) {
            this.maxScrollX += (float)((16384 - columnsCnt) * this.defaultColWidth);
            this.maxScrollY += (float)((0x100000 - rowCnt) * this.defaultRowHeight);
        } else {
            this.maxScrollX += (float)((256 - columnsCnt) * this.defaultColWidth);
            this.maxScrollY += (float)((65536 - rowCnt) * this.defaultRowHeight);
        }
    }

    public synchronized short getState() {
        return this.state;
    }

    public boolean isAccomplished() {
        return this.state == 2;
    }

    public void setReaderListener(IReaderListener iReaderListener) {
        this.iReaderListener = iReaderListener;
    }

    public int addSTRoot(STRoot root) {
        if (this.rootViewMap == null) {
            this.rootViewMap = new ArrayList<STRoot>();
        }
        int id2 = this.rootViewMap.size();
        this.rootViewMap.add(id2, root);
        return id2;
    }

    public STRoot getSTRoot(int id2) {
        if (id2 < 0 || id2 >= this.rootViewMap.size()) {
            return null;
        }
        return this.rootViewMap.get(id2);
    }

    public void removeSTRoot() {
        if (this.rootViewMap != null) {
            int cnt = this.rootViewMap.size();
            int index = 0;
            while (index < cnt) {
                STRoot root;
                if ((root = this.rootViewMap.get(index++)) == null) continue;
                root.dispose();
            }
            this.rootViewMap.clear();
        }
        int rowIndex = this.firstRow;
        while (rowIndex <= this.lastRow) {
            Row row;
            if ((row = this.getRow(rowIndex++)) == null || row != null && row.isZeroHeight()) continue;
            row.setInitExpandedRangeAddress(false);
            Iterator<Cell> iter = row.cellCollection().iterator();
            while (iter.hasNext()) {
                iter.next().removeSTRoot();
            }
        }
    }

    public void addTable(SSTable table) {
        if (this.tableList == null) {
            this.tableList = new ArrayList<SSTable>();
        }
        this.tableList.add(table);
    }

    public SSTable[] getTables() {
        if (this.tableList != null) {
            return this.tableList.toArray(new SSTable[this.tableList.size()]);
        }
        return null;
    }

    public void dispose() {
        Iterator<Object> iter;
        this.book = null;
        this.sheetName = null;
        this.paneInformation = null;
        this.iReaderListener = null;
        if (this.activeCell != null) {
            this.activeCell.dispose();
            this.activeCell = null;
        }
        if (this.rows != null) {
            Collection<Row> rowCollection = this.rows.values();
            for (Row row : rowCollection) {
                row.dispose();
            }
            this.rows.clear();
            this.rows = null;
        }
        if (this.merges != null) {
            iter = this.merges.iterator();
            while (iter.hasNext()) {
                iter.next().dispose();
            }
            this.merges.clear();
            this.merges = null;
        }
        if (this.columnInfoList != null) {
            this.columnInfoList.clear();
            this.columnInfoList = null;
        }
        if (this.shapesList != null) {
            iter = this.shapesList.iterator();
            while (iter.hasNext()) {
                ((IShape)iter.next()).dispose();
            }
            this.shapesList.clear();
            this.shapesList = null;
        }
        if (this.rootViewMap != null) {
            this.removeSTRoot();
            this.rootViewMap = null;
        }
        if (this.tableList != null) {
            this.tableList.clear();
            this.tableList = null;
        }
    }
}

