/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel;

import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.RowProperty;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.other.ExpandedCellRangeAddress;
import java.util.Collection;
import java.util.Hashtable;

public class Row {
    protected Sheet sheet;
    protected int firstCol;
    protected int lastCol;
    protected int rowNumber;
    protected int styleIndex;
    private float rowPixelHeight = 18.0f;
    private RowProperty rowProp;
    protected Hashtable<Integer, Cell> cells;

    public Row(int capacity) {
        this.lastCol = capacity;
        this.cells = new Hashtable(capacity);
        this.rowProp = new RowProperty();
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    private Cell retrieveCell(int cellIndex, boolean style2) {
        try {
            if (cellIndex < 0) {
                return null;
            }
            Cell cell = this.cells.get(cellIndex);
            if (cell == null && style2 && (cell = this.createCellByStyle(this.styleIndex, cellIndex)) == null) {
                cell = this.createCellByStyle(this.sheet.getColumnStyle(cellIndex), cellIndex);
            }
            return cell;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Cell createCellByStyle(int styleIndex, int column) {
        Cell cell = null;
        CellStyle cellStyle = this.sheet.getWorkbook().getCellStyle(styleIndex);
        if (cellStyle != null && (cellStyle.getFillPatternType() == 0 && (cellStyle.getFgColor() & 0xFFFFFF) != 0xFFFFFF || cellStyle.getBorderLeft() > 0 || cellStyle.getBorderTop() > 0 || cellStyle.getBorderRight() > 0 || cellStyle.getBorderBottom() > 0)) {
            cell = new Cell(0);
            cell.setColNumber(column);
            cell.setRowNumber(this.rowNumber);
            cell.setCellStyle(styleIndex);
            cell.setSheet(this.sheet);
            this.cells.put(column, cell);
        }
        return cell;
    }

    public Cell getCell(int cellnum) {
        return this.retrieveCell(cellnum, true);
    }

    public Cell getCell(int cellnum, boolean style2) {
        return this.retrieveCell(cellnum, style2);
    }

    public Collection<Cell> cellCollection() {
        return this.cells.values();
    }

    public void addCell(Cell cell) {
        int column = cell.getColNumber();
        this.cells.put(column, cell);
        this.firstCol = Math.min(this.firstCol, column);
        this.lastCol = Math.max(this.lastCol, column + 1);
    }

    public int getFirstCol() {
        return this.firstCol;
    }

    public void setFirstCol(int firstCol) {
        this.firstCol = firstCol;
    }

    public int getLastCol() {
        return this.lastCol;
    }

    public void setLastCol(int lastCol) {
        this.lastCol = lastCol;
    }

    public int getRowStyle() {
        return this.styleIndex;
    }

    public void setRowStyle(int styleIndex) {
        this.styleIndex = styleIndex;
    }

    public float getRowPixelHeight() {
        return this.rowPixelHeight;
    }

    public void setRowPixelHeight(float rowPixelHeight) {
        this.rowPixelHeight = rowPixelHeight;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public boolean isEmpty() {
        return this.cells.size() == 0;
    }

    public boolean isZeroHeight() {
        return this.rowProp.isZeroHeight();
    }

    public void setZeroHeight(boolean zeroHeight) {
        this.rowProp.setRowProperty((short)0, zeroHeight);
    }

    public int getPhysicalNumberOfCells() {
        return this.cells.size();
    }

    public void removeAllCells() {
        Collection<Cell> cellCollection = this.cells.values();
        for (Cell cell : cellCollection) {
            cell.dispose();
        }
        this.cells.clear();
    }

    public void removeCellsForHiddenRow() {
        if (!this.rowProp.isZeroHeight()) {
            return;
        }
        Collection<Cell> cellCollection = this.cells.values();
        for (Cell cell : cellCollection) {
            if (cell.getRangeAddressIndex() >= 0) continue;
            cell.dispose();
        }
    }

    public void completed() {
        this.rowProp.setRowProperty((short)1, true);
    }

    public boolean isCompleted() {
        return this.rowProp.isCompleted();
    }

    public void setInitExpandedRangeAddress(boolean init) {
        this.rowProp.setRowProperty((short)2, init);
    }

    public boolean isInitExpandedRangeAddress() {
        return this.rowProp.isInitExpandedRangeAddr();
    }

    public void addExpandedRangeAddress(int index, ExpandedCellRangeAddress addr) {
        this.rowProp.setRowProperty((short)3, addr);
    }

    public int getExpandedCellCount() {
        return this.rowProp.getExpandedCellCount();
    }

    public ExpandedCellRangeAddress getExpandedRangeAddress(int index) {
        return this.rowProp.getExpandedCellRangeAddr(index);
    }

    public void dispose() {
        this.removeAllCells();
        if (this.rowProp != null) {
            this.rowProp.dispose();
            this.rowProp = null;
        }
        this.sheet = null;
        this.cells = null;
    }
}

