/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel;

import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.STRoot;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.CellProperty;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.style.CellStyle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class Cell {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;
    private static final long DAY_MILLISECONDS = 86400000L;
    public static final short CELL_TYPE_NUMERIC = 0;
    public static final short CELL_TYPE_STRING = 1;
    public static final short CELL_TYPE_FORMULA = 2;
    public static final short CELL_TYPE_BLANK = 3;
    public static final short CELL_TYPE_BOOLEAN = 4;
    public static final short CELL_TYPE_ERROR = 5;
    public static final short CELL_TYPE_NUMERIC_GENERAL = 6;
    public static final short CELL_TYPE_NUMERIC_DECIMAL = 7;
    public static final short CELL_TYPE_NUMERIC_ACCOUNTING = 8;
    public static final short CELL_TYPE_NUMERIC_FRACTIONAL = 9;
    public static final short CELL_TYPE_NUMERIC_SIMPLEDATE = 10;
    public static final short CELL_TYPE_NUMERIC_STRING = 11;
    private static Calendar CALENDAR = new GregorianCalendar();
    protected Sheet sheet;
    protected short cellType;
    protected int rowNumber;
    protected int colNumber;
    protected int styleIndex;
    protected Object value;
    private CellProperty prop;

    public Cell(short cellType) {
        this.cellType = cellType;
        this.prop = new CellProperty();
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setCellType(short cellType) {
        this.cellType = cellType;
    }

    public short getCellType() {
        return this.cellType;
    }

    public void setCellNumericType(short numericType) {
        if (this.cellType == 0) {
            this.prop.setCellProp((short)0, numericType);
        }
    }

    public short getCellNumericType() {
        return this.prop.getCellNumericType();
    }

    public void setCellValue(Object value) {
        this.value = value;
    }

    public int getStringCellValueIndex() {
        if (this.cellType == 1 && this.value != null) {
            return (Integer)this.value;
        }
        return -1;
    }

    public double getNumberValue() {
        if (this.cellType == 0 && this.value != null) {
            return (Double)this.value;
        }
        return Double.NaN;
    }

    public int getErrorValue() {
        if (this.cellType == 5 && this.value != null) {
            return ((Byte)this.value).byteValue();
        }
        return -1;
    }

    public byte getErrorCodeValue() {
        if (this.cellType == 5 && this.value != null) {
            return (Byte)this.value;
        }
        return -128;
    }

    public String getCellFormulaValue() {
        if (this.cellType == 2 && this.value != null) {
            return (String)this.value;
        }
        return null;
    }

    public boolean getBooleanValue() {
        if (this.cellType == 4 && this.value != null) {
            return (Boolean)this.value;
        }
        return false;
    }

    public Date getDateCellValue(boolean use1904windowing) {
        if (this.cellType == 0 && this.value != null) {
            int startYear;
            double date = (Double)this.value;
            int wholeDays = (int)Math.floor(date);
            int millisecondsInDay = (int)((date - (double)wholeDays) * 8.64E7 + 0.5);
            int n = startYear = use1904windowing ? 1904 : 1900;
            int dayAdjust = use1904windowing ? 1 : (wholeDays < 61 ? 0 : -1);
            CALENDAR.clear();
            CALENDAR.set(startYear, 0, wholeDays + dayAdjust, 0, 0, 0);
            CALENDAR.set(14, millisecondsInDay);
            return CALENDAR.getTime();
        }
        return null;
    }

    public int getRangeAddressIndex() {
        return this.prop.getCellMergeRangeAddressIndex();
    }

    public void setRangeAddressIndex(int rangeAddressIndex) {
        this.prop.setCellProp((short)1, rangeAddressIndex);
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getColNumber() {
        return this.colNumber;
    }

    public void setColNumber(int colNumber) {
        this.colNumber = colNumber;
    }

    public Hyperlink getHyperLink() {
        return this.prop.getCellHyperlink();
    }

    public void setHyperLink(Hyperlink link) {
        this.prop.setCellProp((short)3, link);
    }

    public CellStyle getCellStyle() {
        return this.sheet.getWorkbook().getCellStyle(this.styleIndex);
    }

    public void setCellStyle(int styleIndex) {
        this.styleIndex = styleIndex;
    }

    public boolean hasValidValue() {
        return this.value != null;
    }

    public void setSTRoot(STRoot root) {
        if (this.sheet.getState() == 2) {
            this.prop.setCellProp((short)4, this.sheet.addSTRoot(root));
        }
    }

    public STRoot getSTRoot() {
        return this.sheet.getSTRoot(this.prop.getCellSTRoot());
    }

    public void removeSTRoot() {
        this.prop.removeCellSTRoot();
    }

    public void setExpandedRangeAddressIndex(int index) {
        this.prop.setCellProp((short)2, index);
    }

    public int getExpandedRangeAddressIndex() {
        return this.prop.getExpandCellRangeAddressIndex();
    }

    public void setTableInfo(SSTable table) {
        this.prop.setCellProp((short)5, table);
    }

    public SSTable getTableInfo() {
        return this.prop.getTableInfo();
    }

    public void dispose() {
        this.sheet = null;
        this.value = null;
        if (this.prop != null) {
            this.prop.dispose();
            this.prop = null;
        }
    }
}

