/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel;

import android.graphics.Path;
import android.graphics.PointF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ExtendPath;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.ArrowPathAndTail;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfoFactory;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AChart;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.ArbitraryPolygonShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.GroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.LineShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.BlankRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CellValueRecordInterface;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.EscherAggregate;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.HyperlinkRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordBase;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RowRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFChart;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFChildAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFClientAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFFreeform;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFLine;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFPatriarch;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFPicture;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFPictureData;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFRichTextString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShapeGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFTextbox;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.util.HSSFPaneInformation;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.HSSFCellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.ChartConverter;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ACell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ARow;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.drawing.AnchorPoint;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.drawing.CellAnchor;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty.ColumnInfo;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty.PaneInformation;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ModelUtil;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.SectionElementFactory;
import com.ahmadullahpk.alldocumentreader.xs.system.AbortReaderError;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractReader;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.RoundChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.XYChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DefaultRenderer;
import java.util.Iterator;
import java.util.List;

public class ASheet
extends Sheet
implements com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Sheet {
    private InternalSheet sheet;
    private boolean initRowFinished;

    protected ASheet(AWorkbook workbook, InternalSheet sheet) {
        List<com.ahmadullahpk.alldocumentreader.xs.fc.hssf.util.ColumnInfo> hssfColumnInfoList;
        this.sheet = sheet;
        this.book = workbook;
        int count = sheet.getNumMergedRegions();
        for (int i = 0; i < count; ++i) {
            HSSFCellRangeAddress range = sheet.getMergedRegionAt(i);
            this.addMergeRange(new CellRangeAddress(range.getFirstRow(), range.getFirstColumn(), range.getLastRow(), range.getLastColumn()));
        }
        HSSFPaneInformation pane = sheet.getPaneInformation();
        if (pane != null) {
            this.setPaneInformation(new PaneInformation(pane.getHorizontalSplitTopRow(), pane.getVerticalSplitLeftColumn(), pane.isFreezePane()));
        }
        if ((hssfColumnInfoList = sheet.getColumnInfo()) != null) {
            for (com.ahmadullahpk.alldocumentreader.xs.fc.hssf.util.ColumnInfo hssfColumnInfo : hssfColumnInfoList) {
                ColumnInfo columnInfo = new ColumnInfo(hssfColumnInfo.getFirstCol(), hssfColumnInfo.getLastCol(), (int)((double)hssfColumnInfo.getColWidth() / 256.0 * 6.0 * 1.3333333730697632), hssfColumnInfo.getStyle(), hssfColumnInfo.isHidden());
                this.addColumnInfo(columnInfo);
            }
        }
    }

    public void processSheet(AbstractReader iAbortListener) {
        if (this.getSheetType() != 1 && !this.initRowFinished) {
            this.processRowsAndCells(this.sheet, iAbortListener);
            this.processMergedCells();
            this.processHyperlinkfromSheet(this.sheet);
            this.initRowFinished = true;
        }
    }

    private void processHyperlinkfromSheet(InternalSheet sheet) {
        try {
            for (RecordBase rec : sheet.getRecords()) {
                Cell cell;
                if (!(rec instanceof HyperlinkRecord)) continue;
                HyperlinkRecord linkRec = (HyperlinkRecord)rec;
                Hyperlink link = new Hyperlink();
                if (linkRec.isFileLink()) {
                    link.setLinkType(4);
                } else if (linkRec.isDocumentLink()) {
                    link.setLinkType(2);
                } else if (linkRec.getAddress() != null && linkRec.getAddress().startsWith("mailto:")) {
                    link.setLinkType(3);
                } else {
                    link.setLinkType(1);
                }
                link.setAddress(linkRec.getAddress());
                link.setTitle(linkRec.getLabel());
                Row row = this.getRow(linkRec.getFirstRow());
                if (row == null) {
                    RowRecord rowRec = new RowRecord(linkRec.getFirstRow());
                    row = new ARow(this.book, this, rowRec);
                    row.setRowPixelHeight(18.0f);
                    this.rows.put(linkRec.getFirstRow(), row);
                }
                if ((cell = row.getCell(linkRec.getFirstColumn())) == null) {
                    BlankRecord brec = new BlankRecord();
                    brec.setRow(linkRec.getFirstRow());
                    brec.setColumn((short)linkRec.getFirstColumn());
                    brec.setXFIndex((short)row.getRowStyle());
                    cell = new ACell(this, brec);
                    row.addCell(cell);
                }
                cell.setHyperLink(link);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processRowsAndCells(InternalSheet sheet, AbstractReader iAbortListener) {
        boolean rowRecordsAlreadyPresent;
        RowRecord row = sheet.getNextRow();
        boolean bl = rowRecordsAlreadyPresent = row != null;
        while (row != null) {
            if (iAbortListener.isAborted()) {
                throw new AbortReaderError("abort Reader");
            }
            this.createValidateRowFromRecord(row);
            row = sheet.getNextRow();
        }
        Iterator<CellValueRecordInterface> iter = sheet.getCellValueIterator();
        Row lastrow = null;
        while (iter.hasNext()) {
            if (iAbortListener.isAborted()) {
                throw new AbortReaderError("abort Reader");
            }
            CellValueRecordInterface cval = iter.next();
            iter.remove();
            Row hrow = lastrow;
            if (hrow == null || hrow.getRowNumber() != cval.getRow()) {
                if (lastrow != null) {
                    lastrow.completed();
                }
                lastrow = hrow = (ARow)this.getRow(cval.getRow());
                if (hrow == null) {
                    RowRecord rowRec = new RowRecord(cval.getRow());
                    hrow = this.createRowFromRecord(rowRec);
                }
            }
            ((ARow)hrow).createCellFromRecord(cval);
        }
        if (lastrow != null) {
            lastrow.completed();
        }
    }

    private boolean isValidateRow(RowRecord row) {
        if (row.getFirstCol() != row.getLastCol() || row.getHeight() != 255) {
            return true;
        }
        int styleIndex = row.getXFIndex();
        if (styleIndex > this.book.getNumStyles()) {
            styleIndex &= 0xFF;
        }
        return Workbook.isValidateStyle(this.book.getCellStyle(styleIndex));
    }

    private ARow createValidateRowFromRecord(RowRecord rowRec) {
        Row row = this.getRow(rowRec.getRowNumber());
        if (row != null) {
            return (ARow)row;
        }
        if (this.isValidateRow(rowRec)) {
            ARow hrow = new ARow(this.book, this, rowRec);
            this.addRow(hrow);
            return hrow;
        }
        return null;
    }

    private ARow createRowFromRecord(RowRecord rowRec) {
        Row row = this.getRow(rowRec.getRowNumber());
        if (row != null) {
            return (ARow)row;
        }
        ARow hrow = new ARow(this.book, this, rowRec);
        this.addRow(hrow);
        return hrow;
    }

    private void processMergedCells() {
        int count = this.getMergeRangeCount();
        for (int i = 0; i < count; ++i) {
            CellRangeAddress cr = this.getMergeRange(i);
            if (cr.getLastRow() - cr.getFirstRow() == 65535 || cr.getLastColumn() - cr.getFirstColumn() == 255) continue;
            for (int j = cr.getFirstRow(); j <= cr.getLastRow(); ++j) {
                Row row = this.getRow(j);
                if (row == null) {
                    RowRecord rowRec = new RowRecord(j);
                    row = new ARow(this.book, this, rowRec);
                    row.setRowPixelHeight(18.0f);
                    this.addRow(row);
                }
                for (int k = cr.getFirstColumn(); k <= cr.getLastColumn(); ++k) {
                    Cell cell = row.getCell(k);
                    if (cell == null) {
                        BlankRecord brec = new BlankRecord();
                        brec.setRow(j);
                        brec.setColumn((short)k);
                        brec.setXFIndex((short)row.getRowStyle());
                        cell = new ACell(this, brec);
                        row.addCell(cell);
                    }
                    cell.setRangeAddressIndex(i);
                }
            }
        }
    }

    public EscherAggregate getDrawingEscherAggregate(InternalSheet sheet) {
        InternalWorkbook internalWorkbook = ((AWorkbook)this.book).getInternalWorkbook();
        internalWorkbook.findDrawingGroup();
        if (internalWorkbook.getDrawingManager() == null) {
            return null;
        }
        int found = sheet.aggregateDrawingRecords(internalWorkbook.getDrawingManager(), false);
        if (found == -1) {
            return null;
        }
        EscherAggregate agg = (EscherAggregate)sheet.findFirstRecordBySid((short)9876);
        return agg;
    }

    public HSSFPatriarch getDrawingPatriarch(InternalSheet sheet) {
        EscherAggregate agg = this.getDrawingEscherAggregate(sheet);
        if (agg == null) {
            return null;
        }
        HSSFPatriarch patriarch = new HSSFPatriarch(this, agg);
        agg.setPatriarch(patriarch);
        agg.convertRecordsToUserModel(this.getAWorkbook());
        return patriarch;
    }

    public Iterator<Row> rowIterator() {
        Iterator<Row> result = this.rows.values().iterator();
        return result;
    }

    private BackgroundAndFill converFill(HSSFShape shape, IControl control) {
        BackgroundAndFill bgFill = null;
        if (shape != null) {
            if (shape.isGradientTile()) {
                return shape.getGradientTileBackground((AWorkbook)this.book, control);
            }
            int type = shape.getFillType();
            if (type == 3) {
                byte[] picData = shape.getBGPictureData();
                if (picData != null) {
                    Picture pic = new Picture();
                    pic.setData(picData);
                    int picIndex = control.getSysKit().getPictureManage().addPicture(pic);
                    bgFill = new BackgroundAndFill();
                    bgFill.setFillType((byte)3);
                    bgFill.setPictureIndex(picIndex);
                }
            } else {
                bgFill = new BackgroundAndFill();
                bgFill.setFillType((byte)0);
                bgFill.setForegroundColor(shape.getFillColor());
            }
        }
        return bgFill;
    }

    public void processRotationAndFlip(HSSFShape shape, IShape autoShape) {
        float angle = shape.getRotation();
        if (shape.getFlipH()) {
            autoShape.setFlipHorizontal(true);
            angle = -angle;
        }
        if (shape.getFlipV()) {
            autoShape.setFlipVertical(true);
            angle = -angle;
        }
        if (!(!(autoShape instanceof LineShape) || angle != 45.0f && angle != 135.0f && angle != 225.0f || autoShape.getFlipHorizontal() || autoShape.getFlipVertical())) {
            angle -= 90.0f;
        }
        autoShape.setRotation(angle);
    }

    public void processSheetShapes(IControl control) {
        short type = this.getSheetType();
        if (type == 0) {
            HSSFPatriarch patriarch = this.getDrawingPatriarch(this.sheet);
            if (patriarch != null) {
                List<HSSFShape> shapeList = patriarch.getChildren();
                for (HSSFShape shape : shapeList) {
                    if (((AWorkbook)this.book).getAbstractReader().isAborted()) {
                        throw new AbortReaderError("abort Reader");
                    }
                    this.processShape(control, null, null, shape, null);
                }
                patriarch.dispose();
                patriarch = null;
            }
            this.sheet = null;
        } else if (type == 1) {
            if (((AWorkbook)this.book).getAbstractReader().isAborted()) {
                throw new AbortReaderError("abort Reader");
            }
            HSSFChart chart = this.sheet.getChart();
            AChart achart = new AChart();
            AbstractChart abstractChart = ChartConverter.instance().converter(this, chart);
            if (abstractChart != null) {
                DefaultRenderer renderer = null;
                if (abstractChart instanceof XYChart) {
                    renderer = ((XYChart)abstractChart).getRenderer();
                } else if (abstractChart instanceof RoundChart) {
                    renderer = ((RoundChart)abstractChart).getRenderer();
                }
                if (renderer != null && !chart.isNoBorder()) {
                    renderer.setChartFrame(chart.getLine());
                }
                achart.setAChart(abstractChart);
                this.shapesList.add(achart);
            }
        }
    }

    private CellAnchor ClientAnchorToTwoCellAnchor(HSSFClientAnchor anchor) {
        AnchorPoint from = new AnchorPoint();
        AnchorPoint end = new AnchorPoint();
        from.setColumn(anchor.getCol1());
        from.setRow(anchor.getRow1());
        end.setRow(anchor.getRow2());
        end.setColumn(anchor.getCol2());
        float colWidth = this.getColumnPixelWidth(anchor.getCol1());
        from.setDX(Math.round((float)anchor.getDx1() / 1024.0f * colWidth));
        colWidth = this.getColumnPixelWidth(anchor.getCol2());
        end.setDX(Math.round((float)anchor.getDx2() / 1024.0f * colWidth));
        Row row = this.getRow(anchor.getRow1());
        float rowHeight = row == null ? (float)this.getDefaultRowHeight() : row.getRowPixelHeight();
        from.setDY(Math.round((float)anchor.getDy1() / 256.0f * rowHeight));
        row = this.getRow(anchor.getRow2());
        rowHeight = row == null ? (float)this.getDefaultRowHeight() : row.getRowPixelHeight();
        end.setDY(Math.round((float)anchor.getDy2() / 256.0f * rowHeight));
        CellAnchor cellAnchor = new CellAnchor(1);
        cellAnchor.setStart(from);
        cellAnchor.setEnd(end);
        return cellAnchor;
    }

    private void processShape(IControl control, GroupShape parent, HSSFShapeGroup hssfParent, HSSFShape shape, Rectangle parentRect) {
        Rectangle rect = null;
        if (this.getSheetType() == 0) {
            if (parent == null) {
                anchor = (HSSFClientAnchor)shape.getAnchor();
                if (anchor == null) {
                    return;
                }
                rect = ModelUtil.instance().getCellAnchor(this, this.ClientAnchorToTwoCellAnchor((HSSFClientAnchor)anchor));
                if (rect != null) {
                    rect = ModelUtil.processRect(rect, shape.getRotation());
                }
            } else {
                anchor = (HSSFChildAnchor)shape.getAnchor();
                if (anchor == null) {
                    return;
                }
                rect = new Rectangle();
                rect.x = parentRect.x + Math.round((float)(anchor.getDx1() - hssfParent.getX1()) / (float)(hssfParent.getX2() - hssfParent.getX1()) * (float)parentRect.width);
                rect.y = parentRect.y + Math.round((float)(anchor.getDy1() - hssfParent.getY1()) / (float)(hssfParent.getY2() - hssfParent.getY1()) * (float)parentRect.height);
                rect.width = Math.round((float)(anchor.getDx2() - anchor.getDx1()) / (float)(hssfParent.getX2() - hssfParent.getX1()) * (float)parentRect.width);
                rect.height = Math.round((float)(anchor.getDy2() - anchor.getDy1()) / (float)(hssfParent.getY2() - hssfParent.getY1()) * (float)parentRect.height);
                rect = ModelUtil.processRect(rect, shape.getRotation());
            }
            int type = shape.getShapeType();
            if (type != 20 && type != 32 && (rect.width == 0 || rect.height == 0)) {
                return;
            }
        }
        if (shape instanceof HSSFShapeGroup) {
            GroupShape groupShape = new GroupShape();
            groupShape.setBounds(rect);
            List<HSSFShape> shapes = ((HSSFShapeGroup)shape).getChildren();
            for (HSSFShape item : shapes) {
                this.processShape(control, groupShape, (HSSFShapeGroup)shape, item, rect);
            }
            if (parent == null) {
                this.shapesList.add(groupShape);
            } else {
                parent.appendShapes(groupShape);
            }
        } else {
            this.processSingleShape(control, parent, shape, rect);
        }
    }

    private void processSingleShape(IControl control, GroupShape parent, HSSFShape shape, Rectangle rect) {
        if (shape instanceof HSSFPicture) {
            HSSFPicture picture = (HSSFPicture)shape;
            HSSFPictureData picData = picture.getPictureData();
            if (picData != null) {
                byte[] data = picData.getData();
                if (data != null) {
                    Picture pic = new Picture();
                    pic.setData(data);
                    byte type = 6;
                    switch (picData.getFormat()) {
                        case 2: {
                            type = 2;
                            break;
                        }
                        case 3: {
                            type = 3;
                        }
                    }
                    pic.setPictureType(type);
                    int picIndex = control.getSysKit().getPictureManage().addPicture(pic);
                    PictureShape picShape = new PictureShape();
                    picShape.setPictureIndex(picIndex);
                    picShape.setBounds(rect);
                    picShape.setPictureEffectInfor(PictureEffectInfoFactory.getPictureEffectInfor(picture.getEscherOptRecord()));
                    this.processRotationAndFlip(shape, picShape);
                    if (!shape.isNoBorder()) {
                        picShape.setLine(shape.getLine());
                    }
                    if (!shape.isNoFill()) {
                        picShape.setBackgroundAndFill(this.converFill(shape, control));
                    }
                    if (parent == null) {
                        this.shapesList.add(picShape);
                    } else {
                        parent.appendShapes(picShape);
                    }
                }
            } else if (!shape.isNoBorder() || !shape.isNoFill()) {
                AutoShape autoShape = new AutoShape(1);
                autoShape.setAuotShape07(false);
                autoShape.setBounds(rect);
                if (!shape.isNoBorder()) {
                    autoShape.setLine(shape.getLine());
                }
                if (!shape.isNoFill()) {
                    autoShape.setBackgroundAndFill(this.converFill(shape, control));
                }
                this.processRotationAndFlip(shape, autoShape);
                if (parent == null) {
                    this.shapesList.add(autoShape);
                } else {
                    parent.appendShapes(autoShape);
                }
            }
        } else if (shape instanceof HSSFChart) {
            HSSFChart chart = (HSSFChart)shape;
            AChart achart = new AChart();
            achart.setBounds(rect);
            AbstractChart abstractChart = ChartConverter.instance().converter(this, chart);
            if (abstractChart != null) {
                DefaultRenderer renderer = null;
                if (abstractChart instanceof XYChart) {
                    renderer = ((XYChart)abstractChart).getRenderer();
                } else if (abstractChart instanceof RoundChart) {
                    renderer = ((RoundChart)abstractChart).getRenderer();
                }
                if (renderer != null) {
                    if (!chart.isNoBorder()) {
                        renderer.setChartFrame(chart.getLine());
                    }
                    if (!chart.isNoFill()) {
                        renderer.setBackgroundAndFill(this.converFill(chart, control));
                    }
                }
                achart.setAChart(abstractChart);
                if (parent == null) {
                    this.shapesList.add(achart);
                } else {
                    parent.appendShapes(achart);
                }
            }
        } else if (shape instanceof HSSFLine) {
            if (!shape.isNoBorder()) {
                LineShape lineShape = new LineShape();
                lineShape.setAuotShape07(false);
                lineShape.setShapeType(shape.getShapeType());
                lineShape.setBounds(rect);
                lineShape.setLine(shape.getLine());
                Float[] adj = ((HSSFLine)shape).getAdjustmentValue();
                if (lineShape.getShapeType() == 33 && adj == null) {
                    lineShape.setAdjustData(new Float[]{Float.valueOf(1.0f)});
                } else {
                    lineShape.setAdjustData(adj);
                }
                if (((HSSFLine)shape).getStartArrowType() > 0) {
                    lineShape.createStartArrow((byte)shape.getStartArrowType(), shape.getStartArrowWidth(), shape.getStartArrowLength());
                }
                if (((HSSFLine)shape).getEndArrowType() > 0) {
                    lineShape.createEndArrow((byte)shape.getEndArrowType(), shape.getEndArrowWidth(), shape.getEndArrowLength());
                }
                this.processRotationAndFlip(shape, lineShape);
                if (parent == null) {
                    this.shapesList.add(lineShape);
                } else {
                    parent.appendShapes(lineShape);
                }
            }
        } else if (shape instanceof HSSFFreeform) {
            if (!shape.isNoBorder() || !shape.isNoFill()) {
                ArrowPathAndTail arrowPathAndTail;
                int endArrowType;
                ArrowPathAndTail arrowPathAndTail2;
                ArbitraryPolygonShape arbitraryPolygonShape = new ArbitraryPolygonShape();
                arbitraryPolygonShape.setShapeType(233);
                arbitraryPolygonShape.setBounds(rect);
                Line line = shape.getLine();
                PointF startArrowTailCenter = null;
                PointF endArrowTailCenter = null;
                int startArrowType = ((HSSFFreeform)shape).getStartArrowType();
                if (startArrowType > 0 && (arrowPathAndTail2 = ((HSSFFreeform)shape).getStartArrowPath(rect)) != null && arrowPathAndTail2.getArrowPath() != null) {
                    startArrowTailCenter = arrowPathAndTail2.getArrowTailCenter();
                    ExtendPath pathExtend = new ExtendPath();
                    pathExtend.setPath(arrowPathAndTail2.getArrowPath());
                    pathExtend.setArrowFlag(true);
                    if (startArrowType != 5) {
                        BackgroundAndFill fill = null;
                        if (shape.isNoFill()) {
                            fill = new BackgroundAndFill();
                            fill.setFillType((byte)0);
                            fill.setForegroundColor(shape.getLineStyleColor());
                        } else if (line != null) {
                            fill = line.getBackgroundAndFill();
                        }
                        pathExtend.setBackgroundAndFill(fill);
                    } else {
                        pathExtend.setLine(line);
                    }
                    arbitraryPolygonShape.appendPath(pathExtend);
                }
                if ((endArrowType = ((HSSFFreeform)shape).getEndArrowType()) > 0 && (arrowPathAndTail = ((HSSFFreeform)shape).getEndArrowPath(rect)) != null && arrowPathAndTail.getArrowPath() != null) {
                    endArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                    ExtendPath pathExtend = new ExtendPath();
                    pathExtend.setPath(arrowPathAndTail.getArrowPath());
                    pathExtend.setArrowFlag(true);
                    if (endArrowType != 5) {
                        BackgroundAndFill fill = null;
                        if (shape.isNoFill()) {
                            fill = new BackgroundAndFill();
                            fill.setFillType((byte)0);
                            fill.setForegroundColor(shape.getLineStyleColor());
                        } else if (line != null) {
                            fill = line.getBackgroundAndFill();
                        }
                        pathExtend.setBackgroundAndFill(fill);
                    } else {
                        pathExtend.setLine(line);
                    }
                    arbitraryPolygonShape.appendPath(pathExtend);
                }
                Path[] paths = ((HSSFFreeform)shape).getFreeformPath(rect, startArrowTailCenter, (byte)startArrowType, endArrowTailCenter, (byte)endArrowType);
                for (int i = 0; i < paths.length; ++i) {
                    ExtendPath pathExtend = new ExtendPath();
                    pathExtend.setPath(paths[i]);
                    if (!shape.isNoBorder()) {
                        pathExtend.setLine(line);
                    }
                    if (!shape.isNoFill()) {
                        pathExtend.setBackgroundAndFill(this.converFill(shape, control));
                    }
                    arbitraryPolygonShape.appendPath(pathExtend);
                }
                this.processRotationAndFlip(shape, arbitraryPolygonShape);
                if (parent == null) {
                    this.shapesList.add(arbitraryPolygonShape);
                } else {
                    parent.appendShapes(arbitraryPolygonShape);
                }
            }
        } else if (shape instanceof HSSFAutoShape) {
            String str;
            HSSFTextbox textbox;
            HSSFRichTextString richTextString;
            AutoShape autoShape = null;
            if (!shape.isNoBorder() || !shape.isNoFill()) {
                autoShape = new AutoShape(shape.getShapeType());
                autoShape.setAuotShape07(false);
                autoShape.setBounds(rect);
                if (!shape.isNoBorder()) {
                    autoShape.setLine(shape.getLine());
                }
                if (!shape.isNoFill()) {
                    autoShape.setBackgroundAndFill(this.converFill(shape, control));
                }
                if (shape.getShapeType() != 202) {
                    autoShape.setAdjustData(((HSSFAutoShape)shape).getAdjustmentValue());
                }
                this.processRotationAndFlip(shape, autoShape);
                if (parent == null) {
                    this.shapesList.add(autoShape);
                } else {
                    parent.appendShapes(autoShape);
                }
            }
            if ((richTextString = (textbox = (HSSFTextbox)shape).getString()) != null && (str = richTextString.getString()) != null && str.length() > 0) {
                TextBox tb = new TextBox();
                tb.setElement(SectionElementFactory.getSectionElement(this.book, textbox, rect));
                tb.setWrapLine(textbox.isTextboxWrapLine());
                tb.setBounds(rect);
                this.processRotationAndFlip(shape, tb);
                if (parent == null) {
                    this.shapesList.add(tb);
                } else {
                    parent.appendShapes(tb);
                }
            }
        }
    }

    public AWorkbook getAWorkbook() {
        return (AWorkbook)this.book;
    }

    public InternalSheet getInternalSheet() {
        return this.sheet;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.sheet.dispose();
        this.sheet = null;
    }
}

