/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CellValueRecordInterface;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RowRecord;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.ACell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import java.util.Iterator;

public class ARow
extends Row {
    public static final int INITIAL_CAPACITY = 5;

    public ARow(Workbook book, Sheet sheet, RowRecord record) {
        super(record.getLastCol() - record.getFirstCol() + 5);
        this.setSheet(sheet);
        record.setEmpty();
        this.rowNumber = record.getRowNumber();
        this.firstCol = record.getFirstCol();
        this.lastCol = Math.max(this.lastCol, record.getLastCol());
        this.styleIndex = record.getXFIndex();
        int t = 0;
        while ((this.styleIndex & 65535 >> t) > book.getNumStyles()) {
            ++t;
        }
        this.styleIndex &= 65535 >> t;
        this.setZeroHeight(record.getZeroHeight());
        int height = record.getHeight();
        height = (height & 0x8000) != 0 ? 255 : (int)((short)(height & Short.MAX_VALUE));
        this.setRowPixelHeight((int)((float)(height / 20) * 1.3333334f));
    }

    private boolean isValidateCell(CellValueRecordInterface cval) {
        int cellType = ACell.determineType(cval);
        if (cellType != 3) {
            return true;
        }
        Workbook book = this.sheet.getWorkbook();
        return Workbook.isValidateStyle(book.getCellStyle(cval.getXFIndex())) || Workbook.isValidateStyle(book.getCellStyle(this.getRowStyle())) || Workbook.isValidateStyle(book.getCellStyle(this.sheet.getColumnStyle(cval.getColumn())));
    }

    ACell createCellFromRecord(CellValueRecordInterface cellRec) {
        Cell cell = (Cell)this.cells.get(cellRec.getColumn());
        if (cell != null) {
            return (ACell)cell;
        }
        if (this.isValidateCell(cellRec)) {
            ACell acell = new ACell(this.sheet, cellRec);
            short colIx = cellRec.getColumn();
            if (colIx < this.firstCol) {
                this.firstCol = colIx;
            } else if (colIx > this.lastCol) {
                this.lastCol = colIx;
            }
            this.addCell(acell);
            return acell;
        }
        return null;
    }

    public Iterator<Cell> cellIterator() {
        Iterator<Cell> result = this.cells.values().iterator();
        return result;
    }
}

