/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.simpletext.model;

import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElementCollection;

public class ElementCollectionImpl
implements IElementCollection {
    public static final int CAPACITY = 5;
    private int size;
    protected IElement[] elems;

    public ElementCollectionImpl(int capacity) {
        this.elems = new IElement[capacity];
    }

    public void addElement(IElement element) {
        if (this.size >= this.elems.length) {
            this.ensureCapacity();
        }
        this.elems[this.size] = element;
        ++this.size;
    }

    public void insertElementForIndex(IElement element, int index) {
        if (this.size + 1 >= this.elems.length) {
            this.ensureCapacity();
        }
        for (int i = this.size; i >= index; --i) {
            this.elems[i] = this.elems[i - 1];
        }
        this.elems[index] = element;
        ++this.size;
    }

    public void removeElement(long offset) {
        int index = this.getIndex(offset);
        if (index < 0) {
            return;
        }
        this.removeElement(index);
    }

    public void removeElementForIndex(int index) {
        if (index < 0) {
            return;
        }
        IElement e = this.elems[index];
        for (int i = index + 1; i < this.size; ++i) {
            this.elems[i - 1] = this.elems[i];
        }
        this.elems[this.size] = null;
        --this.size;
        e.dispose();
    }

    @Override
    public IElement getElement(long offset) {
        return this.getElementForIndex(this.getIndex(offset));
    }

    @Override
    public IElement getElementForIndex(int index) {
        if (index >= 0 && index < this.size) {
            return this.elems[index];
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected int getIndex(long offset) {
        if (this.size == 0 || offset < 0L || offset >= this.elems[this.size - 1].getEndOffset()) {
            return -1;
        }
        int max = this.size;
        int min = 0;
        int mid = -1;
        while (true) {
            mid = (max + min) / 2;
            IElement element = this.elems[mid];
            long start = element.getStartOffset();
            long end = element.getEndOffset();
            if (offset >= start && offset < end) break;
            if (start > offset) {
                max = mid - 1;
                continue;
            }
            if (end > offset) continue;
            min = mid + 1;
        }
        return mid;
    }

    private void ensureCapacity() {
        int len = this.size + 5;
        IElement[] e = new IElement[len];
        System.arraycopy(this.elems, 0, e, 0, this.size);
        this.elems = e;
    }

    @Override
    public void dispose() {
        if (this.elems != null) {
            for (int i = 0; i < this.size; ++i) {
                this.elems[i].dispose();
                this.elems[i] = null;
            }
            this.elems = null;
        }
        this.size = 0;
    }
}

