/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.model;

import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.SmartArt;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TableCell;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TableShape;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectanglef;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.ShapeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGNotes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PGSlide {
    public static final byte Slide_Master = 0;
    public static final byte Slide_Layout = 1;
    public static final byte Slide_Normal = 2;
    private boolean hasTable;
    private int slideNo;
    private int slideType;
    private int shapeCountForFind = -1;
    private List<IShape> shapes;
    private List<IShape> shapesForFind;
    private PGNotes notes;
    private BackgroundAndFill bgFill;
    private int[] masterIndexs = new int[]{-1, -1};
    private boolean hasTransition;
    private Map<Integer, List<Integer>> grpShapeLst;
    private List<ShapeAnimation> shapeAnimLst;
    private Map<String, SmartArt> smartArtList;
    private boolean showMasterHeadersFooters;
    private int geometryType;

    public PGSlide() {
        this.shapes = new ArrayList<IShape>();
        this.showMasterHeadersFooters = true;
        this.geometryType = -1;
    }

    public PGSlide(int slideNo, PGNotes notes) {
        this.slideNo = slideNo;
        this.notes = notes;
        this.shapes = new ArrayList<IShape>();
        this.showMasterHeadersFooters = true;
        this.geometryType = -1;
    }

    public void setSlideNo(int slideNo) {
        this.slideNo = slideNo;
    }

    public int getSlideNo() {
        return this.slideNo;
    }

    public int getSlideType() {
        return this.slideType;
    }

    public void setSlideType(int slideType) {
        this.slideType = slideType;
    }

    public void appendShapes(IShape shape) {
        if (shape == null) {
            return;
        }
        if (!this.hasTable) {
            this.hasTable = shape.getType() == 6;
        }
        this.shapes.add(shape);
    }

    public IShape[] getShapes() {
        return this.shapes.toArray(new IShape[this.shapes.size()]);
    }

    public int getShapeCount() {
        return this.shapes.size();
    }

    public int getShapeCountForFind() {
        if (!this.hasTable) {
            return this.getShapeCount();
        }
        if (this.shapeCountForFind > 0) {
            return this.shapeCountForFind;
        }
        this.shapesForFind = new ArrayList<IShape>();
        int count = 0;
        for (IShape shape : this.shapes) {
            if (shape.getType() == 6) {
                for (int i = 0; i < ((TableShape)shape).getCellCount(); ++i) {
                    TableCell cell = ((TableShape)shape).getCell(i);
                    if (cell == null || cell.getText() == null) continue;
                    this.shapesForFind.add(cell.getText());
                    ++count;
                }
                continue;
            }
            this.shapesForFind.add(shape);
            ++count;
        }
        this.shapeCountForFind = count;
        return this.shapeCountForFind;
    }

    public IShape getShape(int index) {
        if (index < 0 || index >= this.shapes.size()) {
            return null;
        }
        return this.shapes.get(index);
    }

    public IShape getShapeForFind(int index) {
        if (!this.hasTable) {
            return this.getShape(index);
        }
        if (index < 0 || index >= this.shapesForFind.size()) {
            return null;
        }
        return this.shapesForFind.get(index);
    }

    public IShape getShape(float x, float y) {
        for (IShape shape : this.shapes) {
            Rectangle rect = shape.getBounds();
            if (shape.getType() == 6) {
                TableShape table = (TableShape)shape;
                int count = table.getCellCount();
                for (int i = 0; i < count; ++i) {
                    Rectanglef r;
                    TableCell cell = table.getCell(i);
                    if (cell == null || !(r = cell.getBounds()).contains(x, y)) continue;
                    return cell.getText();
                }
                continue;
            }
            if (!rect.contains(x, y)) continue;
            return shape;
        }
        return null;
    }

    public void setNotes(PGNotes notes) {
        this.notes = notes;
    }

    public PGNotes getNotes() {
        return this.notes;
    }

    public BackgroundAndFill getBackgroundAndFill() {
        return this.bgFill;
    }

    public void setBackgroundAndFill(BackgroundAndFill bgFill) {
        this.bgFill = bgFill;
    }

    public void setMasterSlideIndex(int index) {
        this.masterIndexs[0] = index;
    }

    public void setLayoutSlideIndex(int index) {
        this.masterIndexs[1] = index;
    }

    public int[] getMasterIndexs() {
        return this.masterIndexs;
    }

    public IShape getShape(int x, int y) {
        for (IShape shape : this.shapes) {
            Rectangle rect = shape.getBounds();
            if (shape.getType() == 6) {
                TableShape table = (TableShape)shape;
                int count = table.getCellCount();
                for (int i = 0; i < count; ++i) {
                    Rectanglef r;
                    TableCell cell = table.getCell(i);
                    if (cell == null || !(r = cell.getBounds()).contains(x, y)) continue;
                    return cell.getText();
                }
                continue;
            }
            if (!rect.contains(x, y)) continue;
            return shape;
        }
        return null;
    }

    public IShape getTextboxShape(int x, int y) {
        int shapeCnt = this.shapes.size();
        for (int i = shapeCnt - 1; i >= 0; --i) {
            IShape shape = this.shapes.get(i);
            Rectangle rect = shape.getBounds();
            if (shape.getType() == 6) {
                TableShape table = (TableShape)shape;
                int count = table.getCellCount();
                for (int j = 0; j < count; ++j) {
                    Rectanglef r;
                    TableCell cell = table.getCell(j);
                    if (cell == null || !(r = cell.getBounds()).contains(x, y)) continue;
                    return cell.getText();
                }
                continue;
            }
            if (!rect.contains(x, y) || shape.getType() != 1) continue;
            return shape;
        }
        return null;
    }

    public void setTransition(boolean transition) {
        this.hasTransition = transition;
    }

    public boolean hasTransition() {
        return this.hasTransition;
    }

    public void addShapeAnimation(ShapeAnimation shapeAnim) {
        if (this.shapeAnimLst == null) {
            this.shapeAnimLst = new ArrayList<ShapeAnimation>();
        }
        if (shapeAnim != null) {
            this.shapeAnimLst.add(shapeAnim);
        }
    }

    public List<ShapeAnimation> getSlideShowAnimation() {
        return this.shapeAnimLst;
    }

    public void addGroupShape(int grpShapeID, List<Integer> childShapes) {
        if (this.grpShapeLst == null) {
            this.grpShapeLst = new HashMap<Integer, List<Integer>>();
        }
        Integer[] arr = new Integer[childShapes.size()];
        childShapes.toArray(arr);
        for (Integer id2 : arr) {
            if (!this.grpShapeLst.containsKey(id2)) continue;
            List<Integer> subShapes = this.grpShapeLst.remove(id2);
            childShapes.remove(id2);
            childShapes.addAll(subShapes);
        }
        this.grpShapeLst.put(grpShapeID, childShapes);
    }

    public Map<Integer, List<Integer>> getGroupShape() {
        return this.grpShapeLst;
    }

    public void addSmartArt(String id2, SmartArt smartArt) {
        if (this.smartArtList == null) {
            this.smartArtList = new HashMap<String, SmartArt>();
        }
        this.smartArtList.put(id2, smartArt);
    }

    public SmartArt getSmartArt(String id2) {
        if (id2 != null && this.smartArtList != null) {
            return this.smartArtList.remove(id2);
        }
        return null;
    }

    public IShape getTextboxByPlaceHolderID(int placeHolderID) {
        int shapeCnt = this.shapes.size();
        for (int i = 0; i < shapeCnt; ++i) {
            IShape shape = this.shapes.get(i);
            if (shape.getType() != 1 || shape.getPlaceHolderID() != placeHolderID) continue;
            return shape;
        }
        return null;
    }

    public boolean isShowMasterHeadersFooter() {
        return this.showMasterHeadersFooters;
    }

    public void setShowMasterHeadersFooters(boolean showMasterHeadersFooters) {
        this.showMasterHeadersFooters = showMasterHeadersFooters;
    }

    public int getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(int geometryType) {
        this.geometryType = geometryType;
    }

    public void dispose() {
        if (this.notes != null) {
            this.notes.dispose();
            this.notes = null;
        }
        if (this.shapesForFind != null) {
            this.shapesForFind.clear();
            this.shapesForFind = null;
        }
        if (this.shapes != null) {
            for (IShape shape : this.shapes) {
                shape.dispose();
            }
            this.shapes.clear();
            this.shapes = null;
        }
        if (this.bgFill != null) {
            this.bgFill.dispose();
            this.bgFill = null;
        }
        if (this.shapeAnimLst != null) {
            this.shapeAnimLst.clear();
            this.shapeAnimLst = null;
        }
    }
}

