/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.model;

import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.tableStyle.TableStyle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.STDocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PGModel {
    private IDocument doc = new STDocument();
    private List<PGSlide> slides = new ArrayList<PGSlide>();
    private Dimension pageSize;
    private List<PGSlide> slideMasters = new ArrayList<PGSlide>();
    private int total = 0;
    private Map<String, TableStyle> tableStyleMap;
    private int slideNumberOffset = 0;
    private boolean omitTitleSlide = false;

    public synchronized void appendSlide(PGSlide slide) {
        if (this.slides == null) {
            return;
        }
        this.slides.add(slide);
    }

    public PGSlide getSlide(int index) {
        if (index < 0 || index >= this.slides.size()) {
            return null;
        }
        return this.slides.get(index);
    }

    public PGSlide getSlideForSlideNo(int slideNo) {
        for (PGSlide slide : this.slides) {
            if (slide.getSlideNo() != slideNo) continue;
            return slide;
        }
        return null;
    }

    public int getRealSlideCount() {
        if (this.slides != null) {
            return this.slides.size();
        }
        return 0;
    }

    public int getSlideCount() {
        return this.total;
    }

    public void setSlideCount(int total) {
        this.total = total;
    }

    public IDocument getRenderersDoc() {
        return this.doc;
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Dimension pageSize) {
        this.pageSize = pageSize;
    }

    public int appendSlideMaster(PGSlide master) {
        int size = this.slideMasters.size();
        this.slideMasters.add(master);
        return size;
    }

    public PGSlide getSlideMaster(int index) {
        if (index < 0 || index >= this.slideMasters.size()) {
            return null;
        }
        return this.slideMasters.get(index);
    }

    public int getSlideMasterCount() {
        if (this.slideMasters == null) {
            return 0;
        }
        return this.slideMasters.size();
    }

    public void putTableStyle(String styleID, TableStyle tableStyle) {
        if (this.tableStyleMap == null) {
            this.tableStyleMap = new HashMap<String, TableStyle>();
        }
        if (styleID != null && tableStyle != null) {
            this.tableStyleMap.put(styleID, tableStyle);
        }
    }

    public TableStyle getTableStyle(String styleID) {
        if (this.tableStyleMap != null && styleID != null) {
            return this.tableStyleMap.get(styleID);
        }
        return null;
    }

    public int getSlideNumberOffset() {
        return this.slideNumberOffset;
    }

    public void setSlideNumberOffset(int slideNumberOffset) {
        this.slideNumberOffset = slideNumberOffset;
    }

    public boolean isOmitTitleSlide() {
        return this.omitTitleSlide;
    }

    public void setOmitTitleSlide(boolean omitTitleSlide) {
        this.omitTitleSlide = omitTitleSlide;
    }

    public synchronized void dispose() {
        if (this.doc != null) {
            this.doc.dispose();
            this.doc = null;
        }
        if (this.slides != null) {
            for (PGSlide slide : this.slides) {
                slide.dispose();
            }
            this.slides.clear();
            this.slides = null;
        }
        if (this.slideMasters != null) {
            for (PGSlide master : this.slideMasters) {
                master.dispose();
            }
            this.slideMasters.clear();
            this.slideMasters = null;
        }
        if (this.tableStyleMap != null) {
            this.tableStyleMap.clear();
            this.tableStyleMap = null;
        }
    }
}

