/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.control;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.ClipboardManager;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.xs.common.ICustomDialog;
import com.ahmadullahpk.alldocumentreader.xs.common.IOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.common.ISlideShow;
import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.Presentation;
import com.ahmadullahpk.alldocumentreader.xs.pg.dialog.NotesDialog;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IFind;
import com.ahmadullahpk.alldocumentreader.xs.system.IMainFrame;
import com.ahmadullahpk.alldocumentreader.xs.system.SysKit;
import java.util.List;
import java.util.Vector;

public class PGControl
extends AbstractControl {
    private boolean isDispose;
    private Presentation pgView;
    private IControl mainControl;
    private boolean isShowingProgressDlg;
    private ProgressDialog progressDialog;

    public PGControl(IControl mainControl, PGModel pgModel, String filePath) {
        this.mainControl = mainControl;
        this.pgView = new Presentation(this.getMainFrame().getActivity(), pgModel, this);
    }

    @Override
    public void layoutView(int x, int y, int w, int h) {
    }

    @Override
    public void actionEvent(int actionID, final Object obj) {
        switch (actionID) {
            case 26: {
                if (this.pgView.getParent() == null) break;
                this.pgView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!PGControl.this.isDispose) {
                            PGControl.this.mainControl.getMainFrame().showProgressBar((Boolean)obj);
                        }
                    }
                });
                break;
            }
            case 27: {
                if (this.pgView.getParent() != null) {
                    this.pgView.post(new Runnable(){

                        @Override
                        public void run() {
                            if (!PGControl.this.isDispose) {
                                PGControl.this.mainControl.getMainFrame().updateViewImages((List)obj);
                            }
                        }
                    });
                    break;
                }
                new Thread(){

                    @Override
                    public void run() {
                        if (!PGControl.this.isDispose) {
                            PGControl.this.mainControl.getMainFrame().updateViewImages((List)obj);
                        }
                    }
                }.start();
                break;
            }
            case 19: {
                this.pgView.init();
                break;
            }
            case -268435456: 
            case 0x50000001: {
                this.pgView.postInvalidate();
                break;
            }
            case 20: {
                this.pgView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!PGControl.this.isDispose && PGControl.this.getMainFrame() != null) {
                            PGControl.this.getMainFrame().updateToolsbarStatus();
                        }
                    }
                });
                break;
            }
            case 0x2000000D: {
                if (this.pgView.isSlideShow()) {
                    this.pgView.slideShow((byte)4);
                    break;
                }
                if (this.pgView.getCurrentIndex() <= 0) break;
                this.pgView.showSlide(this.pgView.getCurrentIndex() - 1, false);
                break;
            }
            case 0x2000000E: {
                if (this.pgView.isSlideShow()) {
                    this.pgView.slideShow((byte)5);
                    break;
                }
                if (this.pgView.getCurrentIndex() >= this.pgView.getRealSlideCount() - 1) break;
                this.pgView.showSlide(this.pgView.getCurrentIndex() + 1, false);
                break;
            }
            case 0x50000002: {
                if (this.pgView.isSlideShow()) break;
                this.showSlide((Integer)obj);
                break;
            }
            case 0x20000005: {
                if (this.pgView.isSlideShow()) break;
                int[] params = (int[])obj;
                this.pgView.setZoom((float)params[0] / 10000.0f, params[1], params[2]);
                this.pgView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!PGControl.this.isDispose) {
                            PGControl.this.getMainFrame().changeZoom();
                        }
                    }
                });
                break;
            }
            case 0x50000000: {
                String text = this.pgView.getCurrentSlide().getNotes().getNotes();
                Vector<Object> vector = new Vector<Object>();
                vector.add(text);
                new NotesDialog(this, (Context)this.getMainFrame().getActivity(), null, vector, 8).show();
                break;
            }
            case 0x10000002: {
                ClipboardManager clip = (ClipboardManager)this.getMainFrame().getActivity().getSystemService("clipboard");
                clip.setText((CharSequence)this.pgView.getSelectedText());
                break;
            }
            case 0x20000008: {
                String addr = ((Hyperlink)obj).getAddress();
                if (addr == null) break;
                try {
                    Intent hyIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)addr));
                    this.getMainFrame().getActivity().startActivity(hyIntent);
                }
                catch (Exception exception) {}
                break;
            }
            case 22: {
                if (!this.isAutoTest()) break;
                this.getMainFrame().getActivity().onBackPressed();
                break;
            }
            case 0x2000000A: {
                this.pgView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!PGControl.this.isDispose) {
                            PGControl.this.pgView.createPicture();
                        }
                    }
                });
                break;
            }
            case 1358954503: {
                this.pgView.setAnimationDuration((Integer)obj);
                break;
            }
            case 0x51000001: {
                this.getMainFrame().fullScreen(true);
                this.pgView.beginSlideShow(obj == null ? this.pgView.getCurrentIndex() + 1 : (Integer)obj);
                break;
            }
            case 1358954498: {
                this.pgView.endSlideShow();
                break;
            }
            case 1358954499: {
                this.pgView.slideShow((byte)2);
                break;
            }
            case 1358954500: {
                this.pgView.slideShow((byte)3);
                break;
            }
            case 0x2000000F: {
                this.pagesCountChanged();
                break;
            }
            case 536870933: {
                this.pgView.setFitSize((Integer)obj);
                break;
            }
            case 536870942: {
                this.pgView.initCalloutView();
                break;
            }
        }
    }

    private void pagesCountChanged() {
        if (this.isShowingProgressDlg && this.pgView.showLoadingSlide()) {
            this.isShowingProgressDlg = false;
            this.pgView.post(new Runnable(){

                @Override
                public void run() {
                    if (PGControl.this.getMainFrame().isShowProgressBar()) {
                        if (PGControl.this.progressDialog != null) {
                            PGControl.this.progressDialog.dismiss();
                            PGControl.this.progressDialog = null;
                        }
                    } else {
                        ICustomDialog dlgListener = PGControl.this.mainControl.getCustomDialog();
                        if (dlgListener != null) {
                            dlgListener.dismissDialog((byte)2);
                        }
                    }
                }
            });
        }
    }

    private void showSlide(int slideIndex) {
        if (slideIndex < 0 || slideIndex >= this.pgView.getSlideCount()) {
            return;
        }
        this.isShowingProgressDlg = false;
        if (slideIndex >= this.pgView.getRealSlideCount()) {
            this.isShowingProgressDlg = true;
            if (this.getMainFrame().isShowProgressBar()) {
                final PGControl own = this;
                this.pgView.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (PGControl.this.isShowingProgressDlg) {
                            PGControl.this.progressDialog = ProgressDialog.show((Context)PGControl.this.getActivity(), (CharSequence)own.getMainFrame().getAppName(), (CharSequence)own.getMainFrame().getLocalString("DIALOG_LOADING"), (boolean)false, (boolean)false, null);
                            PGControl.this.progressDialog.show();
                        }
                    }
                }, 200L);
            } else {
                ICustomDialog dlgListener = this.mainControl.getCustomDialog();
                if (dlgListener != null) {
                    dlgListener.showDialog((byte)2);
                }
            }
        }
        this.pgView.showSlide(slideIndex, false);
    }

    @Override
    public Object getActionValue(int actionID, Object obj) {
        switch (actionID) {
            case 0x20000005: {
                return Float.valueOf(this.pgView.getZoom());
            }
            case 0x2000000B: {
                return this.pgView.getSlideCount();
            }
            case 536870935: {
                return this.pgView.getRealSlideCount();
            }
            case 0x2000000C: {
                return this.pgView.getCurrentIndex() + 1;
            }
            case 0x20000006: {
                return Float.valueOf(this.pgView.getFitZoom());
            }
            case 0x50000003: {
                return this.pgView.slideToImage((Integer)obj);
            }
            case 536870931: {
                int[] paraArr;
                if (!(obj instanceof int[]) || (paraArr = (int[])obj) == null || paraArr.length != 7) break;
                return this.pgView.slideAreaToImage(paraArr[0], paraArr[1], paraArr[2], paraArr[3], paraArr[4], paraArr[5], paraArr[6]);
            }
            case 0x50000004: {
                return this.pgView.getSldieNote((Integer)obj);
            }
            case 0x50000005: {
                int index = (Integer)obj;
                if (index <= 0 || index > this.pgView.getSlideCount()) {
                    return null;
                }
                Dimension d = this.pgView.getPageSize();
                return new Rectangle(0, 0, d.width, d.height);
            }
            case 0x51000000: {
                return this.pgView.isSlideShow();
            }
            case 0x2000000D: {
                return this.pgView.hasPreviousSlide_Slideshow();
            }
            case 0x2000000E: {
                return this.pgView.hasNextSlide_Slideshow();
            }
            case 0x51000005: {
                return this.pgView.hasPreviousAction_Slideshow();
            }
            case 1358954502: {
                return this.pgView.hasNextAction_Slideshow();
            }
            case 0x20000010: {
                if (!(obj instanceof int[])) break;
                int[] a = (int[])obj;
                if (a.length < 2 || a[1] <= 0) {
                    return null;
                }
                return this.pgView.getThumbnail(a[0], (float)a[1] / 10000.0f);
            }
            case 1358954504: {
                return (Integer)obj <= this.pgView.getRealSlideCount();
            }
            case 1358954505: {
                return this.pgView.getSlideAnimationSteps((Integer)obj);
            }
            case 1358954506: {
                if (!(obj instanceof int[])) break;
                int[] a = (int[])obj;
                if (a.length < 2 || a[1] <= 0) {
                    return null;
                }
                return this.pgView.getSlideshowToImage(a[0], a[1]);
            }
            case 536870934: {
                if (this.pgView == null) break;
                return this.pgView.getFitSizeState();
            }
            case 536870936: {
                if (this.pgView == null) break;
                return this.pgView.getSnapshot((Bitmap)obj);
            }
        }
        return null;
    }

    @Override
    public int getCurrentViewIndex() {
        return this.pgView.getCurrentIndex() + 1;
    }

    @Override
    public View getView() {
        return this.pgView;
    }

    @Override
    public Dialog getDialog(Activity activity, int id2) {
        return null;
    }

    @Override
    public IMainFrame getMainFrame() {
        return this.mainControl.getMainFrame();
    }

    @Override
    public Activity getActivity() {
        return this.mainControl.getMainFrame().getActivity();
    }

    @Override
    public IFind getFind() {
        return this.pgView.getFind();
    }

    @Override
    public boolean isAutoTest() {
        return this.mainControl.isAutoTest();
    }

    @Override
    public IOfficeToPicture getOfficeToPicture() {
        return this.mainControl.getOfficeToPicture();
    }

    @Override
    public ICustomDialog getCustomDialog() {
        return this.mainControl.getCustomDialog();
    }

    @Override
    public boolean isSlideShow() {
        return this.pgView.isSlideShow();
    }

    @Override
    public ISlideShow getSlideShow() {
        return this.mainControl.getSlideShow();
    }

    @Override
    public byte getApplicationType() {
        return 2;
    }

    @Override
    public SysKit getSysKit() {
        return this.mainControl.getSysKit();
    }

    @Override
    public void dispose() {
        this.isDispose = true;
        this.pgView.dispose();
        this.pgView = null;
        this.mainControl = null;
    }
}

