/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.animate;

import com.ahmadullahpk.alldocumentreader.xs.pg.animate.IAnimation;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.ITimerListener;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.ATimer;

public class AnimationManager
implements ITimerListener {
    private IAnimation animation;
    private ATimer timer;
    private int actionIndex;
    private IControl control;

    public AnimationManager(IControl control) {
        this.control = control;
    }

    public void setAnimation(IAnimation animation) {
        if (this.animation != null && this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.animation.stop();
        }
        this.animation = animation;
    }

    public void beginAnimation(int delay) {
        if (this.timer == null) {
            this.timer = new ATimer(delay, this);
        }
        if (this.animation != null) {
            this.actionIndex = 0;
            this.animation.start();
            this.timer.start();
            if (this.control.getOfficeToPicture() != null) {
                this.control.getOfficeToPicture().setModeType((byte)0);
            }
        }
    }

    public void restartAnimationTimer() {
        if (this.timer != null) {
            this.timer.restart();
        }
    }

    public void killAnimationTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void stopAnimation() {
        if (this.animation != null) {
            if (this.timer != null) {
                this.timer.stop();
            }
            if (this.animation != null) {
                this.animation.stop();
            }
            if (this.control.getOfficeToPicture() != null) {
                this.control.getOfficeToPicture().setModeType((byte)1);
            }
            this.control.actionEvent(0x50000001, null);
        }
    }

    @Override
    public void actionPerformed() {
        if (this.animation != null && this.animation.getAnimationStatus() != 2) {
            this.animation.animation(++this.actionIndex);
            this.control.actionEvent(0x50000001, null);
            if (this.timer != null) {
                this.timer.restart();
            }
        } else {
            if (this.timer != null) {
                this.timer.stop();
            }
            if (this.control.getOfficeToPicture() != null) {
                this.control.getOfficeToPicture().setModeType((byte)1);
            }
            this.control.actionEvent(0x2000000A, null);
        }
    }

    public boolean hasStoped() {
        if (this.animation != null) {
            return this.animation.getAnimationStatus() == 2;
        }
        return true;
    }

    public void dispose() {
        this.control = null;
        this.animation = null;
        if (this.timer != null) {
            this.timer.dispose();
            this.timer = null;
        }
    }
}

