/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.officereader.settings;

import android.content.Context;
import android.content.res.Configuration;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ahmadullahpk.alldocumentreader.R;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IDialogAction;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.ADialog;
import java.util.Vector;

public class SetRecentCountDialog
extends ADialog {
    public static final int RECENT_COUNT_MIN = 1;
    public static final int RECENT_COUNT_MAX = 20;
    private TextWatcher watcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            int maxCount;
            if (s.length() > 0 && s.length() < 3 && (maxCount = Integer.parseInt(s.toString())) >= 1 && maxCount <= 20) {
                SetRecentCountDialog.this.ok.setEnabled(true);
                return;
            }
            SetRecentCountDialog.this.ok.setEnabled(false);
        }

        public void afterTextChanged(Editable s) {
        }
    };
    protected EditText editText;

    public SetRecentCountDialog(IControl control, Context context, IDialogAction action, Vector<Object> model, int dialogID, int titleResID) {
        super(control, context, action, model, dialogID, titleResID);
        this.init(context);
    }

    public void init(Context context) {
        int mWidth = this.getContext().getResources().getDisplayMetrics().widthPixels - 60;
        TextView textView = new TextView(context);
        textView.setGravity(48);
        if (this.model != null) {
            textView.setText((CharSequence)((String)this.model.get(0)));
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.leftMargin = 5;
        params.rightMargin = 5;
        params.topMargin = 5;
        params.bottomMargin = 5;
        params.gravity = 17;
        this.dialogFrame.addView((View)textView, (ViewGroup.LayoutParams)params);
        this.editText = new EditText(context);
        this.editText.setGravity(48);
        if (this.model != null) {
            this.editText.setText((CharSequence)((String)this.model.get(1)));
        }
        this.editText.setSingleLine();
        this.editText.setKeyListener((KeyListener)new DigitsKeyListener(false, false));
        this.editText.addTextChangedListener(this.watcher);
        params = new LinearLayout.LayoutParams(mWidth, -2);
        params.leftMargin = 5;
        params.rightMargin = 5;
        this.dialogFrame.addView((View)this.editText, (ViewGroup.LayoutParams)params);
        LinearLayout linearLayoutBtn = new LinearLayout(context);
        linearLayoutBtn.setGravity(17);
        linearLayoutBtn.setOrientation(0);
        params = new LinearLayout.LayoutParams(mWidth / 2, -2);
        this.ok = new Button(context);
        this.ok.setText(R.string.sys_button_ok);
        this.ok.setOnClickListener((View.OnClickListener)this);
        this.ok.setEnabled(true);
        linearLayoutBtn.addView((View)this.ok, (ViewGroup.LayoutParams)params);
        this.cancel = new Button(context);
        this.cancel.setText(R.string.sys_button_cancel);
        this.cancel.setOnClickListener((View.OnClickListener)this);
        linearLayoutBtn.addView((View)this.cancel, (ViewGroup.LayoutParams)params);
        this.dialogFrame.addView((View)linearLayoutBtn);
    }

    @Override
    public void onClick(View v) {
        if (v == this.ok) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(Integer.parseInt(this.editText.getText().toString()));
            this.action.doAction(this.dialogID, vector);
        }
        this.dismiss();
    }

    @Override
    public void doLayout() {
        int mWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        mWidth = this.control.getSysKit().isVertical(this.getContext()) ? (mWidth -= 60) : (mWidth -= 240);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(mWidth, -2);
        params.leftMargin = 5;
        params.rightMargin = 5;
        this.editText.setLayoutParams((ViewGroup.LayoutParams)params);
        params = new LinearLayout.LayoutParams(mWidth / 2, -2);
        this.ok.setLayoutParams((ViewGroup.LayoutParams)params);
        this.cancel.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.doLayout();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.editText = null;
    }
}

