/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.officereader.beans;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.MotionEvent;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.officereader.beans.AImageButton;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class AImageCheckButton
extends AImageButton {
    public static final short DISABLE = 0;
    public static final short CHECK = 1;
    public static final short UNCHECK = 2;
    protected Bitmap uncheckBitmap;
    private short state;
    protected String uncheckTips;

    public AImageCheckButton(Context context, IControl control, String checkTips, String uncheckTips, int checkIconResID, int uncheckIconResID, int iconResIdDisable, int actionID) {
        super(context, control, checkTips, checkIconResID, iconResIdDisable, actionID);
        this.uncheckTips = uncheckTips;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inDensity = context.getResources().getDisplayMetrics().densityDpi;
        opts.inTargetDensity = context.getResources().getDisplayMetrics().densityDpi;
        this.uncheckBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)uncheckIconResID, (BitmapFactory.Options)opts);
    }

    @Override
    public void onDraw(Canvas canvas) {
        Paint paint = PaintKit.instance().getPaint();
        switch (this.state) {
            case 0: {
                canvas.drawBitmap(this.bitmapDisable, (float)((this.getWidth() - this.bitmapDisable.getWidth()) / 2), (float)((this.getHeight() - this.bitmapDisable.getHeight()) / 2), paint);
                break;
            }
            case 1: {
                canvas.drawBitmap(this.bitmap, (float)((this.getWidth() - this.bitmap.getWidth()) / 2), (float)((this.getHeight() - this.bitmap.getHeight()) / 2), paint);
                break;
            }
            case 2: {
                canvas.drawBitmap(this.uncheckBitmap, (float)((this.getWidth() - this.uncheckBitmap.getWidth()) / 2), (float)((this.getHeight() - this.uncheckBitmap.getHeight()) / 2), paint);
            }
        }
    }

    @Override
    public void onLongPress(MotionEvent e) {
        this.longPressed = true;
        switch (this.state) {
            case 1: {
                this.control.actionEvent(17, this.toolstip);
                break;
            }
            case 2: {
                this.control.actionEvent(17, this.uncheckTips);
            }
        }
    }

    @Override
    public void onClick(View v) {
        if (this.longPressed) {
            this.longPressed = false;
            return;
        }
        switch (this.state) {
            case 1: {
                this.setState((short)2);
                break;
            }
            case 2: {
                this.setState((short)1);
            }
        }
        this.control.actionEvent(((AImageButton)v).getActionID(), this.state == 1);
        this.postInvalidate();
        this.longPressed = false;
    }

    public void setState(short state) {
        this.state = state;
        this.setEnabled(state != 0);
    }

    public short getState() {
        return this.state;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.uncheckBitmap != null) {
            this.uncheckBitmap.recycle();
            this.uncheckBitmap = null;
        }
    }
}

