/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.officereader.beans;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class AImageButton
extends View
implements GestureDetector.OnGestureListener,
View.OnClickListener {
    protected int actionID;
    protected int normalBgResID = -1;
    protected int pushBgResID = -1;
    protected int focusBgResID = -1;
    protected String toolstip;
    protected Bitmap bitmap;
    protected Bitmap bitmapDisable;
    protected GestureDetector gesture;
    protected IControl control;
    protected boolean longPressed;

    public AImageButton(Context context, IControl control, String toolstip, int iconResID, int iconResIdDisable, int actionID) {
        super(context);
        this.control = control;
        this.toolstip = toolstip;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inDensity = context.getResources().getDisplayMetrics().densityDpi;
        opts.inTargetDensity = context.getResources().getDisplayMetrics().densityDpi;
        this.bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)iconResID, (BitmapFactory.Options)opts);
        if (iconResIdDisable != -1) {
            this.bitmapDisable = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)iconResIdDisable, (BitmapFactory.Options)opts);
        }
        this.actionID = actionID;
        this.gesture = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.setFocusable(true);
        this.setClickable(true);
        this.setLongClickable(true);
        this.setOnClickListener(this);
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        int id2;
        int n = id2 = gainFocus ? this.focusBgResID : this.normalBgResID;
        if (id2 != -1) {
            this.setBackgroundResource(id2);
        }
    }

    public void onClick(View v) {
        if (!this.longPressed && v instanceof AImageButton) {
            this.control.actionEvent(((AImageButton)v).getActionID(), null);
        }
        this.longPressed = false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.gesture.onTouchEvent(event);
        int action = event.getAction();
        if (!this.isEnabled()) {
            if (event.getAction() == 1) {
                this.control.actionEvent(18, null);
            }
            return true;
        }
        switch (action) {
            case 0: 
            case 2: {
                if (this.pushBgResID == -1) break;
                this.setBackgroundResource(this.pushBgResID);
                break;
            }
            case 1: 
            case 3: {
                if (this.normalBgResID == -1) {
                    this.setBackgroundDrawable(null);
                } else {
                    this.setBackgroundResource(this.normalBgResID);
                }
                this.control.actionEvent(18, null);
            }
        }
        return super.onTouchEvent(event);
    }

    public void onDraw(Canvas canvas) {
        if (this.bitmap == null) {
            return;
        }
        if (this.isEnabled()) {
            canvas.drawBitmap(this.bitmap, (float)((this.getWidth() - this.bitmap.getWidth()) / 2), (float)((this.getHeight() - this.bitmap.getHeight()) / 2), PaintKit.instance().getPaint());
        } else if (this.bitmapDisable != null) {
            canvas.drawBitmap(this.bitmapDisable, (float)((this.getWidth() - this.bitmapDisable.getWidth()) / 2), (float)((this.getHeight() - this.bitmapDisable.getHeight()) / 2), PaintKit.instance().getPaint());
        }
    }

    public boolean onDown(MotionEvent e) {
        return false;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        return false;
    }

    public void onLongPress(MotionEvent e) {
        this.longPressed = true;
        if (this.toolstip != null && this.toolstip.length() > 0) {
            this.control.actionEvent(17, this.toolstip);
        }
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }

    public int getActionID() {
        return this.actionID;
    }

    public String getToolstip() {
        return this.toolstip;
    }

    public void setFocusBgResID(int focusBgResID) {
        this.focusBgResID = focusBgResID;
    }

    public void setPushBgResID(int pushBgResID) {
        this.pushBgResID = pushBgResID;
    }

    public void setNormalBgResID(int normalBgResID) {
        this.setBackgroundResource(normalBgResID);
        this.normalBgResID = normalBgResID;
    }

    public int getIconWidth() {
        return this.bitmap == null ? 0 : this.bitmap.getWidth();
    }

    public int getIconHeight() {
        return this.bitmap == null ? 0 : this.bitmap.getHeight();
    }

    public void dispose() {
        this.toolstip = null;
        this.control = null;
        if (this.bitmap != null) {
            this.bitmap.recycle();
            this.bitmap = null;
        }
        if (this.bitmapDisable != null) {
            this.bitmapDisable.recycle();
            this.bitmapDisable = null;
        }
        this.gesture = null;
    }
}

