/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.java.awt;

public class Rectanglef {
    private float x;
    private float y;
    private float width;
    private float height;

    public Rectanglef() {
    }

    public Rectanglef(float x, float y, float w, float h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(float w, float h) {
        this.width = w;
        this.height = h;
    }

    public void setBounds(float x, float y, float w, float h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public void translate(float newX, float newY) {
        this.x += newX;
        this.y += newY;
    }

    public boolean contains(float X, float Y) {
        float w = this.width;
        float h = this.height;
        if (w < 0.0f || h < 0.0f) {
            return false;
        }
        if (X < this.x || Y < this.y) {
            return false;
        }
        return ((w += this.x) < this.x || w > X) && ((h += this.y) < this.y || h > Y);
    }

    public boolean contains(float X, float Y, float W, float H) {
        float w = this.width;
        float h = this.height;
        if (w < 0.0f || W < 0.0f || h < 0.0f || H < 0.0f) {
            return false;
        }
        if (X < this.x || Y < this.y) {
            return false;
        }
        w += this.x;
        if ((W += X) <= X ? w >= this.x || W > w : w >= this.x && W > w) {
            return false;
        }
        h += this.y;
        return !((H += Y) <= Y ? h >= this.y || H > h : h >= this.y && H > h);
    }

    public void add(float newx, float newy) {
        float x1 = Math.min(this.x, newx);
        float x2 = Math.max(this.x + this.width, newx);
        float y1 = Math.min(this.y, newy);
        float y2 = Math.max(this.y + this.height, newy);
        this.x = x1;
        this.y = y1;
        this.width = x2 - x1;
        this.height = y2 - y1;
    }

    public void grow(float h, float v) {
        this.x -= h;
        this.y -= v;
        this.width += h * 2.0f;
        this.height += v * 2.0f;
    }

    public boolean isEmpty() {
        return this.width <= 0.0f || this.height <= 0.0f;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectanglef) {
            Rectanglef r = (Rectanglef)obj;
            return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }
}

