/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.drawing;

import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeDataKit;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfo;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfoFactory;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AChart;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.GroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.SmartArt;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationshipCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.RunAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.SectionAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.PictureReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.SchemeColorUtil;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.drawing.ChartReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.drawing.SmartArtReader;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.Font;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttributeSetImpl;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.drawing.AnchorPoint;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.drawing.CellAnchor;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.drawing.TextParagraph;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ModelUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DrawingReader {
    private static DrawingReader reader = new DrawingReader();
    private Sheet sheet;
    private Map<String, Integer> drawingList;
    private Map<String, AbstractChart> chartList;
    private Map<String, SmartArt> smartArtList;
    private int offset;

    public static DrawingReader instance() {
        return reader;
    }

    public void read(IControl control, ZipPackage zipPackage, PackagePart drawingPart, Sheet sheet) throws Exception {
        PackagePart part;
        this.sheet = sheet;
        Map<String, Integer> schemeColor = SchemeColorUtil.getSchemeColor(sheet.getWorkbook());
        PackageRelationshipCollection chartRelCollection = drawingPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/chart");
        this.chartList = new HashMap<String, AbstractChart>();
        for (PackageRelationship rel : chartRelCollection) {
            part = zipPackage.getPart(rel.getTargetURI());
            this.chartList.put(rel.getId(), ChartReader.instance().read(control, zipPackage, part, schemeColor, (byte)1));
        }
        this.smartArtList = new HashMap<String, SmartArt>();
        PackageRelationshipCollection smartArtDataCollection = drawingPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData");
        if (smartArtDataCollection != null && smartArtDataCollection.size() > 0) {
            int cnt = smartArtDataCollection.size();
            for (int i = 0; i < cnt; ++i) {
                PackageRelationship rel;
                rel = smartArtDataCollection.getRelationship(i);
                this.smartArtList.put(rel.getId(), SmartArtReader.instance().read(control, zipPackage, drawingPart, zipPackage.getPart(rel.getTargetURI()), schemeColor, sheet));
            }
        }
        PackageRelationshipCollection imageRelCollection = drawingPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
        this.drawingList = new HashMap<String, Integer>(10);
        for (PackageRelationship rel : imageRelCollection) {
            part = zipPackage.getPart(rel.getTargetURI());
            this.drawingList.put(rel.getId(), control.getSysKit().getPictureManage().addPicture(part));
        }
        SAXReader saxreader = new SAXReader();
        InputStream in = drawingPart.getInputStream();
        Document drawingDoc = saxreader.read(in);
        in.close();
        this.getCellAnchors(control, zipPackage, drawingPart, drawingDoc.getRootElement());
        this.dispose();
    }

    private void getCellAnchors(IControl control, ZipPackage zipPackage, PackagePart drawingPart, Element root) throws Exception {
        if (root == null || !root.hasContent()) {
            return;
        }
        Iterator iter = root.elementIterator();
        CellAnchor anchor = null;
        while (iter.hasNext()) {
            Element shapeElement = (Element)iter.next();
            if (shapeElement.getName().equalsIgnoreCase("twoCellAnchor")) {
                anchor = this.getTwoCellAnchor(shapeElement);
            } else if (shapeElement.getName().equalsIgnoreCase("oneCellAnchor")) {
                anchor = this.getOneCellAnchor(shapeElement);
            }
            Iterator it = shapeElement.elementIterator();
            while (it.hasNext()) {
                this.processShape(control, zipPackage, drawingPart, (Element)it.next(), null, 1.0f, 1.0f, ModelUtil.instance().getCellAnchor(this.sheet, anchor));
            }
        }
    }

    private AnchorPoint getCellAnchor(Element cellAnchorElement) {
        if (cellAnchorElement == null) {
            return null;
        }
        AnchorPoint cellAnchor = new AnchorPoint();
        Element ele = cellAnchorElement.element("col");
        int val = Integer.parseInt(ele.getText());
        cellAnchor.setColumn((short)val);
        ele = cellAnchorElement.element("colOff");
        long off = Long.parseLong(ele.getText());
        cellAnchor.setDX((int)((float)off * 96.0f / 914400.0f));
        ele = cellAnchorElement.element("row");
        val = Integer.parseInt(ele.getText());
        cellAnchor.setRow(val);
        ele = cellAnchorElement.element("rowOff");
        off = Long.parseLong(ele.getText());
        cellAnchor.setDY((int)((float)off * 96.0f / 914400.0f));
        return cellAnchor;
    }

    private CellAnchor getTwoCellAnchor(Element cellAnchor) {
        CellAnchor anchor = new CellAnchor(1);
        anchor.setStart(this.getCellAnchor(cellAnchor.element("from")));
        anchor.setEnd(this.getCellAnchor(cellAnchor.element("to")));
        return anchor;
    }

    private CellAnchor getOneCellAnchor(Element cellAnchor) {
        AnchorPoint from = this.getCellAnchor(cellAnchor.element("from"));
        CellAnchor anchor = new CellAnchor(0);
        anchor.setStart(from);
        Element ext = cellAnchor.element("ext");
        anchor.setWidth((int)((float)Long.parseLong(ext.attributeValue("cx")) * 96.0f / 914400.0f));
        anchor.setHeight((int)((float)Long.parseLong(ext.attributeValue("cy")) * 96.0f / 914400.0f));
        return anchor;
    }

    private TextBox getTextBoxData(IControl control, Element sp, Rectangle rect) {
        TextBox tb = new TextBox();
        SectionElement secElem = new SectionElement();
        secElem.setStartOffset(0L);
        tb.setElement(secElem);
        IAttributeSet attr = secElem.getAttribute();
        AttrManage.instance().setPageWidth(attr, Math.round((float)rect.width * 15.0f));
        AttrManage.instance().setPageHeight(attr, Math.round((float)rect.height * 15.0f));
        Element temp = sp.element("txBody");
        if (temp != null) {
            AttributeSetImpl attrLayout = new AttributeSetImpl();
            AttrManage.instance().setPageMarginLeft(attrLayout, Math.round(144.0f));
            AttrManage.instance().setPageMarginRight(attrLayout, Math.round(144.0f));
            AttrManage.instance().setPageMarginTop(attrLayout, Math.round(72.0f));
            AttrManage.instance().setPageMarginBottom(attrLayout, Math.round(72.0f));
            Element bodyPr = temp.element("bodyPr");
            SectionAttr.instance().setSectionAttribute(bodyPr, attr, attrLayout, null, false);
            if (bodyPr != null) {
                String value = bodyPr.attributeValue("wrap");
                tb.setWrapLine(value == null || "square".equalsIgnoreCase(value));
            }
            int offset = this.processParagraph(control, secElem, temp);
            secElem.setEndOffset(offset);
        }
        tb.setBounds(rect);
        if (tb.getElement() != null && tb.getElement().getText(null) != null && tb.getElement().getText(null).length() > 0 && !"\n".equals(tb.getElement().getText(null))) {
            ReaderKit.instance().processRotation(sp.element("spPr"), tb);
            return tb;
        }
        return null;
    }

    private int processParagraph(IControl control, SectionElement secElem, Element txBody) {
        this.offset = 0;
        List ps = txBody.elements("p");
        for (Element p : ps) {
            Element pPr = p.element("pPr");
            ParagraphElement paraElem = new ParagraphElement();
            paraElem.setStartOffset(this.offset);
            IAttributeSet attrLayout = null;
            ParaAttr.instance().setParaAttribute(control, pPr, paraElem.getAttribute(), attrLayout, -1, -1, 0, false, false);
            paraElem = this.processRun(control, secElem, paraElem, p, attrLayout);
            paraElem.setEndOffset(this.offset);
            secElem.appendParagraph(paraElem, 0L);
        }
        return this.offset;
    }

    private ParagraphElement processRun(IControl control, SectionElement secElem, ParagraphElement paraElem, Element p, IAttributeSet attrLayout) {
        List rs = p.elements("r");
        LeafElement leaf = null;
        if (rs.size() == 0) {
            leaf = new LeafElement("\n");
            Element ele = p.element("pPr");
            if (ele != null && (ele = ele.element("rPr")) != null) {
                RunAttr.instance().setRunAttribute(this.sheet, ele, leaf.getAttribute(), attrLayout);
            }
            leaf.setStartOffset(this.offset);
            ++this.offset;
            leaf.setEndOffset(this.offset);
            paraElem.appendLeaf(leaf);
            return paraElem;
        }
        for (Element r : rs) {
            if (r.getName().equalsIgnoreCase("r")) {
                String text;
                int len;
                Element t = r.element("t");
                if (t == null || (len = (text = t.getText()).length()) < 0) continue;
                leaf = new LeafElement(text);
                RunAttr.instance().setRunAttribute(this.sheet, r.element("rPr"), leaf.getAttribute(), attrLayout);
                leaf.setStartOffset(this.offset);
                this.offset += len;
                leaf.setEndOffset(this.offset);
                paraElem.appendLeaf(leaf);
                continue;
            }
            if (!r.getName().equalsIgnoreCase("br")) continue;
            if (leaf != null) {
                leaf.setText(leaf.getText(null) + "\n");
                ++this.offset;
            }
            paraElem.setEndOffset(this.offset);
            secElem.appendParagraph(paraElem, 0L);
            paraElem = new ParagraphElement();
            paraElem.setStartOffset(this.offset);
            attrLayout = null;
            Element pPr = p.element("pPr");
            ParaAttr.instance().setParaAttribute(control, pPr, paraElem.getAttribute(), attrLayout, -1, -1, 0, false, false);
        }
        if (leaf != null) {
            leaf.setText(leaf.getText(null) + "\n");
            ++this.offset;
        }
        return paraElem;
    }

    public static short getVerticalByString(String anchor) {
        if (anchor == null || anchor.equalsIgnoreCase("ctr")) {
            return 1;
        }
        if (anchor.equalsIgnoreCase("t")) {
            return 0;
        }
        if (anchor.equalsIgnoreCase("b")) {
            return 2;
        }
        if (anchor.equalsIgnoreCase("just")) {
            return 3;
        }
        if (anchor.equalsIgnoreCase("dist")) {
            return 3;
        }
        return 1;
    }

    public static short getHorizontalByString(String algn) {
        if (algn == null || algn.equalsIgnoreCase("l")) {
            return 1;
        }
        if (algn.equalsIgnoreCase("ctr")) {
            return 2;
        }
        if (algn.equalsIgnoreCase("r")) {
            return 3;
        }
        if (algn.equalsIgnoreCase("just")) {
            return 5;
        }
        return 0;
    }

    private static Font getFont(Element rPr) {
        Element solidFill;
        Font font = new Font();
        if (rPr.attributeValue("sz") != null) {
            font.setFontSize(Integer.parseInt(rPr.attributeValue("sz")) / 100);
        }
        if (rPr.attributeValue("b") != null && Integer.parseInt(rPr.attributeValue("b")) != 0) {
            font.setBold(true);
        }
        if (rPr.attributeValue("i") != null && Integer.parseInt(rPr.attributeValue("i")) != 0) {
            font.setItalic(true);
        }
        if (rPr.attributeValue("u") != null) {
            if (rPr.attributeValue("u").equalsIgnoreCase("sng")) {
                font.setUnderline(1);
            } else if (rPr.attributeValue("u").equalsIgnoreCase("dbl")) {
                font.setUnderline(2);
            }
        }
        if (rPr.attributeValue("strike") != null && !rPr.attributeValue("strike").equalsIgnoreCase("noStrike")) {
            font.setStrikeline(true);
        }
        if ((solidFill = rPr.element("solidFill")) != null) {
            // empty if block
        }
        font.setColorIndex(8);
        return font;
    }

    public static TextParagraph getTextParagraph(Element paragraph) {
        TextParagraph textParagraph = new TextParagraph();
        Element ele = paragraph.element("pPr");
        if (ele != null) {
            textParagraph.setHorizontalAlign(DrawingReader.getHorizontalByString(ele.attributeValue("algn")));
        }
        Iterator iter = paragraph.elements("r").iterator();
        Font font = null;
        String run = "";
        while (iter.hasNext()) {
            Element textRun = (Element)iter.next();
            if (font == null && (ele = textRun.element("rPr")) != null) {
                font = DrawingReader.getFont(ele);
            }
            if (textRun.element("t") == null) continue;
            run = run + textRun.element("t").getText();
        }
        textParagraph.setFont(font);
        textParagraph.setTextRun(run);
        return textParagraph;
    }

    private PictureShape getImageData(Element sp, Rectangle rect) {
        String id2;
        Element ele = sp.element("blipFill");
        if (ele == null) {
            return null;
        }
        PictureEffectInfo effectInfor = PictureEffectInfoFactory.getPictureEffectInfor(ele);
        if ((ele = ele.element("blip")) != null && ele.attributeValue("embed") != null && (id2 = ele.attributeValue("embed")) != null && this.drawingList.get(ele.attributeValue("embed")) != null) {
            PictureShape picShape = new PictureShape();
            int index = this.drawingList.get(ele.attributeValue("embed"));
            picShape.setBounds(rect);
            picShape.setPictureIndex(index);
            picShape.setPictureEffectInfor(effectInfor);
            ReaderKit.instance().processRotation(sp.element("spPr"), picShape);
            return picShape;
        }
        return null;
    }

    private AChart getChart(Element chart, Rectangle rect) {
        String id2;
        if (chart != null && (id2 = chart.attributeValue("id")) != null) {
            AChart chartData = new AChart();
            chartData.setBounds(rect);
            chartData.setAChart(this.chartList.get(id2));
            return chartData;
        }
        return null;
    }

    private SmartArt getSmartArt(Element graphicData, Rectangle rect) {
        try {
            if (graphicData != null) {
                Element relIds = graphicData.element("relIds");
                String cs = relIds.attributeValue("dm");
                int id2 = Integer.parseInt(cs.substring("rId".length()));
                if (cs != null) {
                    SmartArt smartArt = this.smartArtList.get(cs);
                    smartArt.setBounds(rect);
                    return smartArt;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void processShape(IControl control, ZipPackage zipPackage, PackagePart drawingPart, Element sp, GroupShape parent, float zoomX, float zoomY, Rectangle rect2) throws Exception {
        Rectangle rect = null;
        String name = sp.getName();
        if (name.equals("grpSp")) {
            AbstractShape groupShape = null;
            float[] zoomXY = null;
            Element grpSpPr = sp.element("grpSpPr");
            if (grpSpPr != null) {
                Rectangle childRect = null;
                rect = ReaderKit.instance().getShapeAnchor(grpSpPr.element("xfrm"), zoomX, zoomY);
                if (rect.width == 0 || rect.height == 0) {
                    return;
                }
                rect = this.processGrpSpRect(parent, rect);
                zoomXY = ReaderKit.instance().getAnchorFitZoom(grpSpPr.element("xfrm"));
                childRect = ReaderKit.instance().getChildShapeAnchor(grpSpPr.element("xfrm"), zoomXY[0] * zoomX, zoomXY[1] * zoomY);
                groupShape = new GroupShape();
                groupShape.setBounds(rect);
                ((GroupShape)groupShape).setOffPostion(rect.x - childRect.x, rect.y - childRect.y);
                ReaderKit.instance().processRotation(grpSpPr, groupShape);
            }
            Rectangle groupshapeRect = null;
            if (parent == null) {
                groupshapeRect = rect2;
            } else {
                groupshapeRect = new Rectangle();
                Rectangle parRect = parent.getBounds();
                groupshapeRect.x = rect2.x + (rect.x - parRect.x) * rect2.width / parRect.width;
                groupshapeRect.y = rect2.y + (rect.y - parRect.y) * rect2.height / parRect.height;
                groupshapeRect.width = rect2.width * rect.width / parRect.width;
                groupshapeRect.height = rect2.height * rect.height / parRect.height;
            }
            Iterator it = sp.elementIterator();
            while (it.hasNext()) {
                this.processShape(control, zipPackage, drawingPart, (Element)it.next(), (GroupShape)groupShape, (float)(zoomXY[0] * zoomX), zoomXY[1] * zoomY, groupshapeRect);
            }
            groupShape.setBounds(groupshapeRect);
            if (parent == null) {
                this.sheet.appendShapes(groupShape);
            } else {
                parent.appendShapes(groupShape);
            }
        } else if (name.equals("AlternateContent")) {
            Element choice = sp.element("Choice");
            if (choice != null) {
                Iterator it = choice.elementIterator();
                while (it.hasNext()) {
                    this.processShape(control, zipPackage, drawingPart, (Element)it.next(), parent, zoomX, zoomY, null);
                }
            }
        } else {
            Element graphicData;
            Element graphic;
            AbstractShape shape = null;
            if (parent == null) {
                rect = rect2;
            } else {
                Element temp = sp.element("spPr");
                if (temp == null) {
                    return;
                }
                rect = ReaderKit.instance().getShapeAnchor(temp.element("xfrm"), zoomX, zoomY);
                rect = this.processGrpSpRect(parent, rect);
                Rectangle parRect = parent.getBounds();
                rect.x = rect2.x + (rect.x - parRect.x) * rect2.width / parRect.width;
                rect.y = rect2.y + (rect.y - parRect.y) * rect2.height / parRect.height;
                rect.width = rect2.width * rect.width / parRect.width;
                rect.height = rect2.height * rect.height / parRect.height;
            }
            if (this.sheet.getSheetType() == 0 && rect == null) {
                return;
            }
            if (name.equals("sp") || name.equals("cxnSp")) {
                TextBox textBox;
                shape = AutoShapeDataKit.getAutoShape(control, zipPackage, drawingPart, sp, rect, SchemeColorUtil.getSchemeColor(this.sheet.getWorkbook()), 1);
                if (shape != null) {
                    if (parent == null) {
                        this.sheet.appendShapes(shape);
                    } else {
                        parent.appendShapes(shape);
                    }
                }
                if ((textBox = this.getTextBoxData(control, sp, rect)) != null) {
                    if (parent == null) {
                        this.sheet.appendShapes(textBox);
                    } else {
                        parent.appendShapes(textBox);
                    }
                }
            } else if (name.equals("pic")) {
                shape = this.getImageData(sp, rect);
                if (shape != null) {
                    AutoShapeDataKit.processPictureShape(control, zipPackage, drawingPart, sp.element("spPr"), SchemeColorUtil.getSchemeColor(this.sheet.getWorkbook()), (PictureShape)shape);
                    if (parent == null) {
                        this.sheet.appendShapes(shape);
                    } else {
                        parent.appendShapes(shape);
                    }
                }
            } else if (name.equals("graphicFrame") && (graphic = sp.element("graphic")) != null && (graphicData = graphic.element("graphicData")) != null && graphicData.attribute("uri") != null) {
                String uri = graphicData.attributeValue("uri");
                if (uri.equals("http://schemas.openxmlformats.org/drawingml/2006/chart")) {
                    shape = this.getChart(graphicData.element("chart"), rect);
                } else if (uri.equals("http://schemas.openxmlformats.org/drawingml/2006/diagram")) {
                    shape = this.getSmartArt(graphicData, rect);
                }
                if (shape != null) {
                    ReaderKit.instance().processRotation(sp.element("spPr"), shape);
                    if (parent == null) {
                        this.sheet.appendShapes(shape);
                    } else {
                        parent.appendShapes(shape);
                    }
                }
            }
            if (shape != null && Math.abs(shape.getRotation()) > 1.0f) {
                rect = ModelUtil.processRect(shape.getBounds(), shape.getRotation());
                shape.setBounds(rect);
            }
        }
    }

    private Rectangle processGrpSpRect(GroupShape parent, Rectangle rect) {
        if (parent != null) {
            rect.x += parent.getOffX();
            rect.y += parent.getOffY();
        }
        return rect;
    }

    public void processOLEPicture(IControl control, ZipPackage zipPackage, PackagePart sheetPart, Sheet sheet, Element oleObjects) throws Exception {
        this.sheet = sheet;
        if (oleObjects != null) {
            List oles = oleObjects.elements("oleObject");
            for (Element oleObject : oles) {
                CellAnchor anchor;
                PackagePart picPart;
                String spid = oleObject.attributeValue("shapeId");
                if (spid == null || (picPart = PictureReader.instance().getOLEPart(zipPackage, sheetPart, spid, true)) == null || (anchor = PictureReader.instance().getExcelShapeAnchor(spid)) == null) continue;
                PictureShape picShape = new PictureShape();
                picShape.setPictureIndex(control.getSysKit().getPictureManage().addPicture(picPart));
                picShape.setBounds(ModelUtil.instance().getCellAnchor(sheet, anchor));
                sheet.appendShapes(picShape);
            }
        }
    }

    private void dispose() {
        this.sheet = null;
        if (this.drawingList != null) {
            this.drawingList.clear();
            this.drawingList = null;
        }
        if (this.chartList != null) {
            this.chartList.clear();
            this.chartList = null;
        }
        if (this.smartArtList != null) {
            this.smartArtList.clear();
            this.smartArtList = null;
        }
    }
}

