/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ss.util;

import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ICell;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.IRow;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.CellUtil;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.HSSFCellRangeAddress;

public final class RegionUtil {
    private RegionUtil() {
    }

    public static void setBorderLeft(int border, HSSFCellRangeAddress region, Sheet sheet, Workbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getFirstColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderLeft", border);
        for (int i = rowStart; i <= rowEnd; ++i) {
            cps.setProperty(CellUtil.getRow(i, sheet), column);
        }
    }

    public static void setLeftBorderColor(int color2, HSSFCellRangeAddress region, Sheet sheet, Workbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getFirstColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "leftBorderColor", color2);
        for (int i = rowStart; i <= rowEnd; ++i) {
            cps.setProperty(CellUtil.getRow(i, sheet), column);
        }
    }

    public static void setBorderRight(int border, HSSFCellRangeAddress region, Sheet sheet, Workbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getLastColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderRight", border);
        for (int i = rowStart; i <= rowEnd; ++i) {
            cps.setProperty(CellUtil.getRow(i, sheet), column);
        }
    }

    public static void setRightBorderColor(int color2, HSSFCellRangeAddress region, Sheet sheet, Workbook workbook) {
        int rowStart = region.getFirstRow();
        int rowEnd = region.getLastRow();
        int column = region.getLastColumn();
        CellPropertySetter cps = new CellPropertySetter(workbook, "rightBorderColor", color2);
        for (int i = rowStart; i <= rowEnd; ++i) {
            cps.setProperty(CellUtil.getRow(i, sheet), column);
        }
    }

    public static void setBorderBottom(int border, HSSFCellRangeAddress region, Sheet sheet, Workbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getLastRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderBottom", border);
        IRow row = CellUtil.getRow(rowIndex, sheet);
        for (int i = colStart; i <= colEnd; ++i) {
            cps.setProperty(row, i);
        }
    }

    public static void setBottomBorderColor(int color2, HSSFCellRangeAddress region, Sheet sheet, Workbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getLastRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "bottomBorderColor", color2);
        IRow row = CellUtil.getRow(rowIndex, sheet);
        for (int i = colStart; i <= colEnd; ++i) {
            cps.setProperty(row, i);
        }
    }

    public static void setBorderTop(int border, HSSFCellRangeAddress region, Sheet sheet, Workbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getFirstRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "borderTop", border);
        IRow row = CellUtil.getRow(rowIndex, sheet);
        for (int i = colStart; i <= colEnd; ++i) {
            cps.setProperty(row, i);
        }
    }

    public static void setTopBorderColor(int color2, HSSFCellRangeAddress region, Sheet sheet, Workbook workbook) {
        int colStart = region.getFirstColumn();
        int colEnd = region.getLastColumn();
        int rowIndex = region.getFirstRow();
        CellPropertySetter cps = new CellPropertySetter(workbook, "topBorderColor", color2);
        IRow row = CellUtil.getRow(rowIndex, sheet);
        for (int i = colStart; i <= colEnd; ++i) {
            cps.setProperty(row, i);
        }
    }

    private static final class CellPropertySetter {
        private final Workbook _workbook;
        private final String _propertyName;
        private final Short _propertyValue;

        public CellPropertySetter(Workbook workbook, String propertyName, int value) {
            this._workbook = workbook;
            this._propertyName = propertyName;
            this._propertyValue = (short)value;
        }

        public void setProperty(IRow row, int column) {
            ICell cell = CellUtil.getCell(row, column);
            CellUtil.setCellStyleProperty(cell, this._workbook, this._propertyName, this._propertyValue);
        }
    }
}

