/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ss.util;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.HSSFCellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianByteArrayOutputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianOutput;
import java.util.ArrayList;
import java.util.List;

public class CellRangeAddressList {
    protected final List _list = new ArrayList();

    public CellRangeAddressList() {
    }

    public CellRangeAddressList(int firstRow, int lastRow, int firstCol, int lastCol) {
        this();
        this.addCellRangeAddress(firstRow, firstCol, lastRow, lastCol);
    }

    public CellRangeAddressList(RecordInputStream in) {
        this();
        int nItems = in.readUShort();
        for (int k = 0; k < nItems; ++k) {
            this._list.add(new HSSFCellRangeAddress(in));
        }
    }

    public int countRanges() {
        return this._list.size();
    }

    public void addCellRangeAddress(int firstRow, int firstCol, int lastRow, int lastCol) {
        HSSFCellRangeAddress region = new HSSFCellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        this.addCellRangeAddress(region);
    }

    public void addCellRangeAddress(HSSFCellRangeAddress cra) {
        this._list.add(cra);
    }

    public HSSFCellRangeAddress remove(int rangeIndex) {
        if (this._list.isEmpty()) {
            throw new RuntimeException("List is empty");
        }
        if (rangeIndex < 0 || rangeIndex >= this._list.size()) {
            throw new RuntimeException("Range index (" + rangeIndex + ") is outside allowable range (0.." + (this._list.size() - 1) + ")");
        }
        return (HSSFCellRangeAddress)this._list.remove(rangeIndex);
    }

    public HSSFCellRangeAddress getCellRangeAddress(int index) {
        return (HSSFCellRangeAddress)this._list.get(index);
    }

    public int getSize() {
        return CellRangeAddressList.getEncodedSize(this._list.size());
    }

    public static int getEncodedSize(int numberOfRanges) {
        return 2 + HSSFCellRangeAddress.getEncodedSize(numberOfRanges);
    }

    public int serialize(int offset, byte[] data) {
        int totalSize = this.getSize();
        this.serialize(new LittleEndianByteArrayOutputStream(data, offset, totalSize));
        return totalSize;
    }

    public void serialize(LittleEndianOutput out) {
        int nItems = this._list.size();
        out.writeShort(nItems);
        for (int k = 0; k < nItems; ++k) {
            HSSFCellRangeAddress region = (HSSFCellRangeAddress)this._list.get(k);
            region.serialize(out);
        }
    }

    public CellRangeAddressList copy() {
        CellRangeAddressList result = new CellRangeAddressList();
        int nItems = this._list.size();
        for (int k = 0; k < nItems; ++k) {
            HSSFCellRangeAddress region = (HSSFCellRangeAddress)this._list.get(k);
            result.addCellRangeAddress(region.copy());
        }
        return result;
    }

    public HSSFCellRangeAddress[] getCellRangeAddresses() {
        HSSFCellRangeAddress[] result = new HSSFCellRangeAddress[this._list.size()];
        this._list.toArray(result);
        return result;
    }
}

