/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.ShapeManage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.BackgroundReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.StyleReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ThemeReader;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGMaster;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGPlaceholderUtil;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;

public class MasterReader {
    private static MasterReader masterReader = new MasterReader();
    private int styleIndex = 10;

    public static MasterReader instance() {
        return masterReader;
    }

    public PGMaster getMasterData(IControl control, ZipPackage zipPackage, PackagePart masterPart, PGModel pgModel) throws Exception {
        SAXReader saxreader = new SAXReader();
        InputStream in = masterPart.getInputStream();
        Document poiMaster = saxreader.read(in);
        Element master = poiMaster.getRootElement();
        PGMaster pgMaster = null;
        if (master != null) {
            pgMaster = new PGMaster();
            this.processClrMap(pgMaster, zipPackage, masterPart, master);
            this.processStyle(control, pgMaster, master);
            Element cSld = master.element("cSld");
            if (cSld != null) {
                this.processBackgroundAndFill(control, pgMaster, zipPackage, masterPart, cSld);
                Element spTree = cSld.element("spTree");
                if (spTree != null) {
                    this.processTextStyle(control, pgMaster, spTree);
                    PGSlide pgSlide = new PGSlide();
                    pgSlide.setSlideType(0);
                    Iterator it = spTree.elementIterator();
                    while (it.hasNext()) {
                        ShapeManage.instance().processShape(control, zipPackage, masterPart, null, pgMaster, null, null, pgSlide, (byte)0, (Element)it.next(), null, 1.0f, 1.0f);
                    }
                    if (pgSlide.getShapeCount() > 0) {
                        pgMaster.setSlideMasterIndex(pgModel.appendSlideMaster(pgSlide));
                    }
                }
            }
        }
        in.close();
        return pgMaster;
    }

    private void processClrMap(PGMaster pgMaster, ZipPackage zipPackage, PackagePart masterPart, Element master) throws Exception {
        PackagePart themePart;
        PackageRelationship themeShip = masterPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme").getRelationship(0);
        if (themeShip != null && (themePart = zipPackage.getPart(themeShip.getTargetURI())) != null) {
            Map<String, Integer> themeColor = ThemeReader.instance().getThemeColorMap(themePart);
            Element clrMap = master.element("clrMap");
            if (clrMap != null) {
                for (int i = 0; i < clrMap.attributeCount(); ++i) {
                    String value;
                    String name = clrMap.attribute(i).getName();
                    if (!name.equals(value = clrMap.attributeValue(name))) {
                        pgMaster.addColor(value, themeColor.get(value));
                    }
                    pgMaster.addColor(name, themeColor.get(value));
                }
            }
        }
    }

    private void processBackgroundAndFill(IControl control, PGMaster pgMaster, ZipPackage zipPackage, PackagePart masterPart, Element cSld) throws Exception {
        Element bg = cSld.element("bg");
        if (bg != null) {
            pgMaster.setBackgroundAndFill(BackgroundReader.instance().getBackground(control, zipPackage, masterPart, pgMaster, bg));
        }
    }

    private void processTextStyle(IControl control, PGMaster pgMaster, Element spTree) throws Exception {
        Iterator it = spTree.elementIterator();
        while (it.hasNext()) {
            Element sp = (Element)it.next();
            String type = ReaderKit.instance().getPlaceholderType(sp);
            type = PGPlaceholderUtil.instance().checkTypeName(type);
            int idx = ReaderKit.instance().getPlaceholderIdx(sp);
            Element txBody = sp.element("txBody");
            if (txBody == null) continue;
            Element lstStyle = txBody.element("lstStyle");
            StyleReader.instance().setStyleIndex(this.styleIndex);
            if (!PGPlaceholderUtil.instance().isBody(type)) {
                pgMaster.addStyleByType(type, StyleReader.instance().getStyles(control, pgMaster, sp, lstStyle));
            } else if (idx > 0) {
                pgMaster.addStyleByIdx(idx, StyleReader.instance().getStyles(control, pgMaster, sp, lstStyle));
            }
            this.styleIndex = StyleReader.instance().getStyleIndex();
        }
    }

    private void processStyle(IControl control, PGMaster pgMaster, Element master) {
        Element txStyles = master.element("txStyles");
        if (txStyles != null) {
            StyleReader.instance().setStyleIndex(this.styleIndex);
            Element style2 = txStyles.element("titleStyle");
            pgMaster.setTitleStyle(StyleReader.instance().getStyles(control, pgMaster, null, style2));
            style2 = txStyles.element("bodyStyle");
            pgMaster.setBodyStyle(StyleReader.instance().getStyles(control, pgMaster, null, style2));
            style2 = txStyles.element("otherStyle");
            pgMaster.setDefaultStyle(StyleReader.instance().getStyles(control, pgMaster, null, style2));
            this.styleIndex = StyleReader.instance().getStyleIndex();
        }
    }

    public void dispose() {
        this.styleIndex = 10;
    }
}

