/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt;

import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementHandler;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementPath;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationshipCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.ShapeManage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.attribute.RunAttr;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.bulletnumber.BulletNumberManage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.BackgroundReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.HyperlinkReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.LayoutReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.MasterReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.PictureReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.SmartArtReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.StyleReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.TableStyleReader;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.ShapeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGLayout;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGMaster;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGNotes;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGStyle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.Style;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.StyleManage;
import com.ahmadullahpk.alldocumentreader.xs.system.AbortReaderError;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractReader;
import com.ahmadullahpk.alldocumentreader.xs.system.BackReaderThread;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.StopReaderError;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PPTXReader
extends AbstractReader {
    public static final int FIRST_READ_SLIDE_NUM = 2;
    private int slideNum = 1;
    private int currentReaderIndex;
    private PGModel pgModel;
    private String filePath;
    private ZipPackage zipPackage;
    private PackagePart packagePart;
    private Map<String, PGLayout> nameLayout = new Hashtable<String, PGLayout>();
    private Map<String, PGMaster> nameMaster = new Hashtable<String, PGMaster>();
    private List<String> sldIds;
    private PGStyle defaultStyle;
    private PackagePart slidePart;
    private PGMaster pgMaster;
    private PGLayout pgLayout;
    private PGSlide pgSlide;
    private String key;
    private boolean searched;
    private boolean note;
    private boolean showMasterSp;

    public PPTXReader(IControl control, String filePath) {
        this.control = control;
        this.filePath = filePath;
    }

    @Override
    public Object getModel() throws Exception {
        if (this.pgModel != null) {
            return this.pgModel;
        }
        this.initPackagePart();
        this.pgModel = new PGModel();
        this.processPresentation();
        return this.pgModel;
    }

    public void initPackagePart() throws Exception {
        this.zipPackage = new ZipPackage(this.filePath);
        PackageRelationship coreRel = this.zipPackage.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        if (coreRel == null || !coreRel.getTargetURI().toString().equals("/ppt/presentation.xml")) {
            throw new Exception("Format error");
        }
        this.packagePart = this.zipPackage.getPart(coreRel);
    }

    private void processPresentation() throws Exception {
        SAXReader saxreader = new SAXReader();
        try {
            PackagePart tableStylePackagePart;
            String val;
            InputStream in = this.packagePart.getInputStream();
            PresentationSaxHandler preSaxHandler = new PresentationSaxHandler();
            saxreader.addHandler("/presentation/sldMasterIdLst", preSaxHandler);
            saxreader.addHandler("/presentation/defaultTextStyle", preSaxHandler);
            saxreader.addHandler("/presentation/sldSz", preSaxHandler);
            saxreader.addHandler("/presentation/sldIdLst/sldId", preSaxHandler);
            Document poi = saxreader.read(in);
            Element root = poi.getRootElement();
            if (root != null && root.attribute("firstSlideNum") != null && (val = root.attributeValue("firstSlideNum")) != null && val.length() > 0) {
                this.pgModel.setSlideNumberOffset(Integer.valueOf(val) - 1);
            }
            in.close();
            if (this.sldIds == null) {
                throw new Exception("Format error");
            }
            this.pgModel.setSlideCount(this.sldIds.size());
            ArrayList<PackagePart> tableStyleParts = this.zipPackage.getPartsByContentType("application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml");
            if (tableStyleParts.size() > 0 && (tableStylePackagePart = tableStyleParts.get(0)) != null) {
                Style style2 = StyleManage.instance().getStyle(this.defaultStyle.getStyle(1));
                int fontsize = 12;
                if (style2 != null && (fontsize = style2.getAttrbuteSet().getAttribute((short)1)) < 0) {
                    fontsize = 12;
                }
                TableStyleReader.instance().read(this.pgModel, tableStylePackagePart, fontsize);
            }
            this.processSlidePart();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            saxreader.resetHandlers();
        }
    }

    private void processDefaultFontColor(Element style2, int lvl) {
        if (style2 != null) {
            String val = null;
            Element temp = style2.element("defRPr");
            if (temp != null && (temp = temp.element("solidFill")) != null && (temp = temp.element("schemeClr")) != null && temp.attribute("val") != null && (val = temp.attributeValue("val")) != null && val.length() > 0) {
                this.defaultStyle.addDefaultFontColor(lvl, val);
            }
        }
    }

    private void processDefaultTextStyle(Element defaultTextStyle) {
        Iterator<String> iter;
        if (this.nameMaster != null && (iter = this.nameMaster.keySet().iterator()).hasNext()) {
            StyleReader.instance().setStyleIndex(1);
            this.defaultStyle = StyleReader.instance().getStyles(this.control, this.nameMaster.get(iter.next()), null, defaultTextStyle);
        }
        if (defaultTextStyle != null && this.defaultStyle != null) {
            Element temp = defaultTextStyle.element("lvl1pPr");
            if (temp != null) {
                this.processDefaultFontColor(temp, 1);
            }
            if ((temp = defaultTextStyle.element("lvl2pPr")) != null) {
                this.processDefaultFontColor(temp, 2);
            }
            if ((temp = defaultTextStyle.element("lvl3pPr")) != null) {
                this.processDefaultFontColor(temp, 3);
            }
            if ((temp = defaultTextStyle.element("lvl4pPr")) != null) {
                this.processDefaultFontColor(temp, 4);
            }
            if ((temp = defaultTextStyle.element("lvl5pPr")) != null) {
                this.processDefaultFontColor(temp, 5);
            }
            if ((temp = defaultTextStyle.element("lvl6pPr")) != null) {
                this.processDefaultFontColor(temp, 6);
            }
            if ((temp = defaultTextStyle.element("lvl7pPr")) != null) {
                this.processDefaultFontColor(temp, 7);
            }
            if ((temp = defaultTextStyle.element("lvl8pPr")) != null) {
                this.processDefaultFontColor(temp, 8);
            }
            if ((temp = defaultTextStyle.element("lvl9pPr")) != null) {
                this.processDefaultFontColor(temp, 9);
            }
        }
    }

    public void processMasterPart(Element masterIdLst) throws Exception {
        List masterIds = masterIdLst.elements("sldMasterId");
        if (masterIds.size() > 0) {
            Element masterId = (Element)masterIds.get(0);
            if (this.abortReader) {
                return;
            }
            int index = 0;
            if (masterId.attributeCount() > 1) {
                index = 1;
            }
            PackagePart masterPart = this.zipPackage.getPart(this.packagePart.getRelationship(masterId.attribute(index).getValue()).getTargetURI());
            this.nameMaster.put(masterPart.getPartName().getName(), MasterReader.instance().getMasterData(this.control, this.zipPackage, masterPart, this.pgModel));
        }
    }

    private void addSlideID(Element slideId) {
        if (this.sldIds == null) {
            this.sldIds = new ArrayList<String>();
        }
        this.sldIds.add(slideId.attribute(1).getValue());
    }

    public void processSlidePart() throws Exception {
        if (this.sldIds.size() > 0) {
            int len = Math.min(this.sldIds.size(), 2);
            for (int i = 0; i < len && !this.abortReader; ++i) {
                this.processSlide(this.sldIds.get(this.currentReaderIndex++));
            }
            if (!this.isReaderFinish()) {
                new BackReaderThread(this, this.control).start();
            }
        } else {
            throw new Exception("Format error");
        }
    }

    @Override
    public boolean isReaderFinish() {
        if (this.pgModel != null && this.sldIds != null) {
            return this.abortReader || this.pgModel.getSlideCount() == 0 || this.currentReaderIndex >= this.sldIds.size();
        }
        return true;
    }

    @Override
    public void backReader() throws Exception {
        try {
            this.processSlide(this.sldIds.get(this.currentReaderIndex++));
            this.control.actionEvent(0x2000000F, null);
        }
        catch (Error e) {
            this.control.getSysKit().getErrorKit().writerLog(e, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSlide(String sldId) throws Exception {
        this.showMasterSp = true;
        this.slidePart = this.zipPackage.getPart(this.packagePart.getRelationship(sldId).getTargetURI());
        PackageRelationship layoutShip = this.slidePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideLayout").getRelationship(0);
        PackagePart layoutPart = this.zipPackage.getPart(layoutShip.getTargetURI());
        PackageRelationship ship = layoutPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideMaster").getRelationship(0);
        this.pgMaster = this.nameMaster.get(ship.getTargetURI().toString());
        if (this.pgMaster == null) {
            PackagePart masterPart = this.zipPackage.getPart(ship.getTargetURI());
            this.pgMaster = MasterReader.instance().getMasterData(this.control, this.zipPackage, masterPart, this.pgModel);
            this.nameMaster.put(masterPart.getPartName().getName(), this.pgMaster);
        }
        this.pgLayout = this.nameLayout.get(layoutPart.getPartName().getName());
        if (this.pgLayout == null) {
            this.pgLayout = LayoutReader.instance().getLayouts(this.control, this.zipPackage, layoutPart, this.pgModel, this.pgMaster, null);
            this.nameLayout.put(layoutPart.getPartName().getName(), this.pgLayout);
        }
        this.pgSlide = new PGSlide();
        this.pgSlide.setSlideType(2);
        PackageRelationshipCollection smartArtDataCollection = this.slidePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData");
        if (smartArtDataCollection != null && smartArtDataCollection.size() > 0) {
            int cnt = smartArtDataCollection.size();
            PackageRelationship rel = null;
            for (int i = 0; i < cnt; ++i) {
                rel = smartArtDataCollection.getRelationship(i);
                this.pgSlide.addSmartArt(rel.getId(), SmartArtReader.instance().read(this.control, this.zipPackage, this.pgModel, this.pgMaster, this.pgLayout, this.pgSlide, this.slidePart, this.zipPackage.getPart(rel.getTargetURI())));
            }
        }
        HyperlinkReader.instance().getHyperlinkList(this.control, this.slidePart);
        SAXReader saxreader = new SAXReader();
        try {
            InputStream in = this.slidePart.getInputStream();
            SlideSaxHandler slideSaxHandler = new SlideSaxHandler();
            saxreader.addHandler("/sld/cSld/bg", slideSaxHandler);
            saxreader.addHandler("/sld/cSld/spTree/sp", slideSaxHandler);
            saxreader.addHandler("/sld/cSld/spTree/cxnSp", slideSaxHandler);
            saxreader.addHandler("/sld/cSld/spTree/pic", slideSaxHandler);
            saxreader.addHandler("/sld/cSld/spTree/graphicFrame", slideSaxHandler);
            saxreader.addHandler("/sld/cSld/spTree/grpSp", slideSaxHandler);
            saxreader.addHandler("/sld/cSld/spTree/AlternateContent", slideSaxHandler);
            saxreader.addHandler("/sld/timing/tnLst/par/cTn/childTnLst/seq/cTn/childTnLst/par", slideSaxHandler);
            saxreader.addHandler("/sld/timing/bldLst/bldP", slideSaxHandler);
            saxreader.addHandler("/sld/transition", slideSaxHandler);
            saxreader.addHandler("/sld/AlternateContent/Choice/transition", slideSaxHandler);
            saxreader.addHandler("/sld", slideSaxHandler);
            saxreader.read(in);
            in.close();
            this.processBackground(this.slidePart, this.pgMaster, this.pgLayout, this.pgSlide, null);
            this.processGroupShape(this.pgSlide);
            this.pgSlide.setSlideNo(this.slideNum++);
            this.processNotes(this.slidePart, this.pgSlide);
            if (this.showMasterSp && this.pgLayout.isAddShapes()) {
                this.pgSlide.setMasterSlideIndex(this.pgMaster.getSlideMasterIndex());
            }
            this.pgSlide.setLayoutSlideIndex(this.pgLayout.getSlideMasterIndex());
            this.pgModel.appendSlide(this.pgSlide);
            this.pgSlide = null;
            this.pgLayout = null;
            this.pgMaster = null;
            this.slidePart = null;
            PictureReader.instance().dispose();
            HyperlinkReader.instance().disposs();
        }
        finally {
            saxreader.resetHandlers();
        }
    }

    private void processGroupShape(PGSlide pgSlide) {
        Map<Integer, List<Integer>> grpShape = pgSlide.getGroupShape();
        if (grpShape == null) {
            return;
        }
        int count = pgSlide.getShapeCount();
        for (int i = 0; i < count; ++i) {
            IShape shape = pgSlide.getShape(i);
            int grpSpID = this.getGroupShapeID(shape.getShapeID(), grpShape);
            shape.setGroupShapeID(grpSpID);
        }
    }

    private int getGroupShapeID(int shapeID, Map<Integer, List<Integer>> grpShape) {
        for (int grpID : grpShape.keySet()) {
            List<Integer> childShape = grpShape.get(grpID);
            if (childShape == null || !childShape.contains(shapeID)) continue;
            return grpID;
        }
        return -1;
    }

    private void processGroupShapeID(Map<Integer, List<Integer>> grpShape) {
        boolean repeat = false;
        Iterator<Integer> grpIDIter = grpShape.keySet().iterator();
        ArrayList<Integer> removeGrpID = null;
        while (grpIDIter.hasNext()) {
            int grpID = grpIDIter.next();
            List<Integer> childShape = grpShape.get(grpID);
            int grpCnt = childShape.size();
            ArrayList<Integer> ids = null;
            for (int i = 0; i < grpCnt; ++i) {
                List<Integer> childchildShape = grpShape.get(childShape.get(i));
                if (childchildShape == null || childchildShape.size() <= 0) continue;
                if (ids == null) {
                    ids = new ArrayList<Integer>();
                }
                ids.addAll(childchildShape);
            }
            if (ids != null && ids.size() > 0) {
                repeat = true;
                childShape.addAll((Collection<Integer>)ids);
                continue;
            }
            if (removeGrpID == null) {
                removeGrpID = new ArrayList<Integer>();
            }
            removeGrpID.add(grpID);
        }
        if (repeat) {
            for (int i = 0; i < removeGrpID.size(); ++i) {
                grpShape.remove(removeGrpID.get(i));
            }
            this.processGroupShapeID(grpShape);
        }
    }

    private void processBackground(PackagePart slidePart, PGMaster pgMaster, PGLayout pgLayout, PGSlide pgSlide, Element bg) throws Exception {
        BackgroundAndFill bgFill = null;
        if (bg == null && pgSlide.getBackgroundAndFill() == null) {
            bgFill = pgLayout.getBackgroundAndFill();
            if (bgFill == null) {
                bgFill = pgMaster.getBackgroundAndFill();
            }
            pgSlide.setBackgroundAndFill(bgFill);
        } else if (bg != null) {
            bgFill = BackgroundReader.instance().getBackground(this.control, this.zipPackage, slidePart, pgMaster, bg);
            pgSlide.setBackgroundAndFill(bgFill);
        }
    }

    public void setPageSize(Element slideSize) {
        float pgx = 0.0f;
        float pgy = 0.0f;
        if (slideSize != null) {
            pgx = Float.parseFloat(slideSize.attributeValue("cx")) * 96.0f / 914400.0f;
            pgy = Float.parseFloat(slideSize.attributeValue("cy")) * 96.0f / 914400.0f;
        }
        this.pgModel.setPageSize(new Dimension((int)pgx, (int)pgy));
    }

    private void processNotes(PackagePart slidePart, PGSlide pgSlide) throws Exception {
        PackageRelationship notesShip = slidePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/notesSlide").getRelationship(0);
        if (notesShip != null) {
            String notes;
            SAXReader saxreader = new SAXReader();
            PackagePart notesPart = this.zipPackage.getPart(notesShip.getTargetURI());
            InputStream in = notesPart.getInputStream();
            Document poiNote = saxreader.read(in);
            Element root = poiNote.getRootElement();
            if (root != null && (notes = ReaderKit.instance().getNotes(root)) != null) {
                PGNotes pgNotes = new PGNotes(notes);
                pgSlide.setNotes(pgNotes);
            }
            in.close();
        }
    }

    private void processSlideShow(PGSlide pgSlide, Element elem) {
        try {
            List elements = elem.element("cTn").element("childTnLst").elements("par");
            if (elements.size() >= 1) {
                for (Element item : elements) {
                    List elementList = item.element("cTn").element("childTnLst").elements("par");
                    for (Element e : elementList) {
                        elem = e.element("cTn");
                        this.processAnimation(pgSlide, elem);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processAnimation(PGSlide pgSlide, Element elem) {
        String sType = elem.attributeValue("presetClass");
        if ((elem = elem.element("childTnLst")).element("set") != null) {
            elem = elem.element("set").element("cBhvr").element("tgtEl").element("spTgt");
        } else {
            elem = (Element)elem.elements().get(0);
            elem = elem.element("cBhvr").element("tgtEl").element("spTgt");
        }
        String shapeID = elem.attributeValue("spid");
        byte nType = 1;
        if (sType.equals("entr")) {
            nType = 0;
        } else if (sType.equals("emph")) {
            nType = 1;
        } else if (sType.equals("exit")) {
            nType = 2;
        } else {
            return;
        }
        if (elem.element("txEl") != null && elem.element("txEl").element("pRg") != null) {
            elem = elem.element("txEl").element("pRg");
            String s = elem.attributeValue("st");
            String e = elem.attributeValue("end");
            pgSlide.addShapeAnimation(new ShapeAnimation(Integer.parseInt(shapeID), nType, Integer.parseInt(s), Integer.parseInt(e)));
        } else if (elem.element("bg") != null) {
            pgSlide.addShapeAnimation(new ShapeAnimation(Integer.parseInt(shapeID), nType, -1, -1));
        } else {
            pgSlide.addShapeAnimation(new ShapeAnimation(Integer.parseInt(shapeID), nType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean searchContent(File file, String key) throws Exception {
        this.searched = false;
        this.key = key;
        this.zipPackage = new ZipPackage(file.getAbsolutePath());
        PackageRelationship coreRel = this.zipPackage.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        this.packagePart = this.zipPackage.getPart(coreRel);
        SAXReader saxreader = new SAXReader();
        try {
            InputStream in = this.packagePart.getInputStream();
            PresentationSaxHandler_Search preSaxHandler = new PresentationSaxHandler_Search();
            saxreader.addHandler("/presentation/sldIdLst/sldId", preSaxHandler);
            saxreader.read(in);
            in.close();
        }
        catch (StopReaderError stopReaderError) {
        }
        finally {
            saxreader.resetHandlers();
        }
        this.key = null;
        this.zipPackage = null;
        this.packagePart = null;
        return this.searched;
    }

    public boolean searchContentForText(Element elem, String key) {
        block7: {
            String name;
            block6: {
                name = elem.getName();
                if (!name.equals("sp")) break block6;
                StringBuilder sb = new StringBuilder();
                if (this.note && !"body".equals(ReaderKit.instance().getPlaceholderType(elem))) {
                    return false;
                }
                Element txBody = elem.element("txBody");
                if (txBody == null) break block7;
                List ps = txBody.elements("p");
                for (Element p : ps) {
                    List rs = p.elements("r");
                    for (Element r : rs) {
                        Element t = r.element("t");
                        if (t == null) continue;
                        sb.append(t.getText());
                    }
                    if (sb.indexOf(key) >= 0) {
                        this.key = null;
                        this.zipPackage = null;
                        this.packagePart = null;
                        this.searched = true;
                        return true;
                    }
                    sb.delete(0, sb.length());
                }
                break block7;
            }
            if (name.equals("grpSp")) {
                Iterator it = elem.elementIterator();
                while (it.hasNext()) {
                    if (!this.searchContentForText((Element)it.next(), key)) continue;
                    this.key = null;
                    this.zipPackage = null;
                    this.packagePart = null;
                    this.searched = true;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this.isReaderFinish()) {
            super.dispose();
            if (this.abortReader && this.pgModel != null && this.pgModel.getSlideCount() < 2 && this.sldIds != null && this.sldIds.size() > 0) {
                this.pgModel.dispose();
            }
            this.pgModel = null;
            this.filePath = null;
            this.zipPackage = null;
            this.packagePart = null;
            if (this.nameLayout != null) {
                Iterator<String> iter = this.nameLayout.keySet().iterator();
                while (iter.hasNext()) {
                    this.nameLayout.get(iter.next()).disposs();
                }
                this.nameLayout.clear();
                this.nameLayout = null;
            }
            if (this.nameMaster != null) {
                this.nameMaster.clear();
                this.nameMaster = null;
            }
            if (this.sldIds != null) {
                this.sldIds.clear();
                this.sldIds = null;
            }
            if (this.defaultStyle != null) {
                this.defaultStyle.dispose();
                this.defaultStyle = null;
            }
            this.key = null;
            this.pgSlide = null;
            this.pgLayout = null;
            this.pgMaster = null;
            this.slidePart = null;
            HyperlinkReader.instance().disposs();
            PictureReader.instance().dispose();
            LayoutReader.instance().dispose();
            MasterReader.instance().dispose();
            RunAttr.instance().dispose();
            BulletNumberManage.instance().dispose();
        }
    }

    class PresentationSaxHandler
    implements ElementHandler {
        PresentationSaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            if (PPTXReader.this.abortReader) {
                throw new AbortReaderError("abort Reader");
            }
            Element elem = elementPath.getCurrent();
            String name = elem.getName();
            try {
                if (name.equals("sldMasterIdLst")) {
                    PPTXReader.this.processMasterPart(elem);
                } else if (name.equals("defaultTextStyle")) {
                    PPTXReader.this.processDefaultTextStyle(elem);
                } else if (name.equals("sldSz")) {
                    PPTXReader.this.setPageSize(elem);
                } else if (name.equals("sldId")) {
                    PPTXReader.this.addSlideID(elem);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            elem.detach();
        }
    }

    class SlideSaxHandler
    implements ElementHandler {
        SlideSaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            if (PPTXReader.this.abortReader) {
                throw new AbortReaderError("abort Reader");
            }
            Element elem = elementPath.getCurrent();
            try {
                if ("bg".equals(elem.getName())) {
                    PPTXReader.this.processBackground(PPTXReader.this.slidePart, PPTXReader.this.pgMaster, PPTXReader.this.pgLayout, PPTXReader.this.pgSlide, elem);
                } else if ("sld".equals(elem.getName())) {
                    String val;
                    if (elem.attribute("showMasterSp") != null && (val = elem.attributeValue("showMasterSp")) != null && val.length() > 0 && Integer.valueOf(val) == 0) {
                        PPTXReader.this.showMasterSp = false;
                    }
                } else if ("par".equals(elem.getName())) {
                    PPTXReader.this.processSlideShow(PPTXReader.this.pgSlide, elem);
                } else if ("transition".equals(elem.getName())) {
                    PPTXReader.this.pgSlide.setTransition(elem.elements().size() > 0);
                } else {
                    ShapeManage.instance().processShape(PPTXReader.this.control, PPTXReader.this.zipPackage, PPTXReader.this.slidePart, PPTXReader.this.pgModel, PPTXReader.this.pgMaster, PPTXReader.this.pgLayout, PPTXReader.this.defaultStyle, PPTXReader.this.pgSlide, (byte)2, elem, null, 1.0f, 1.0f);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            elem.detach();
        }
    }

    class PresentationSaxHandler_Search
    implements ElementHandler {
        PresentationSaxHandler_Search() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEnd(ElementPath elementPath) {
            if (PPTXReader.this.abortReader) {
                throw new AbortReaderError("abort Reader");
            }
            Element elem = elementPath.getCurrent();
            if ("sldId".equals(elem.getName())) {
                PPTXReader.this.note = false;
                PackagePart slidePart = PPTXReader.this.zipPackage.getPart(PPTXReader.this.packagePart.getRelationship(elem.attribute(1).getValue()).getTargetURI());
                if (slidePart != null) {
                    SAXReader saxreader = new SAXReader();
                    try {
                        InputStream in = slidePart.getInputStream();
                        SlideNoteSaxHandler_Search slideSaxHandler = new SlideNoteSaxHandler_Search();
                        saxreader.addHandler("/sld/cSld/spTree/sp", slideSaxHandler);
                        saxreader.addHandler("/sld/cSld/spTree/grpSp", slideSaxHandler);
                        saxreader.read(in);
                        in.close();
                        PackageRelationship notesShip = slidePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/notesSlide").getRelationship(0);
                        if (notesShip != null) {
                            PackagePart notesPart = PPTXReader.this.zipPackage.getPart(notesShip.getTargetURI());
                            PPTXReader.this.note = true;
                            in = notesPart.getInputStream();
                            saxreader.resetHandlers();
                            saxreader.addHandler("/notes/cSld/spTree/sp", slideSaxHandler);
                            saxreader.read(in);
                            in.close();
                        }
                    }
                    catch (StopReaderError e) {
                        elem.detach();
                        throw new StopReaderError("stop");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        saxreader.resetHandlers();
                    }
                }
            }
            elem.detach();
        }
    }

    class SlideNoteSaxHandler_Search
    implements ElementHandler {
        SlideNoteSaxHandler_Search() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            if (PPTXReader.this.abortReader) {
                throw new AbortReaderError("abort Reader");
            }
            Element elem = elementPath.getCurrent();
            PPTXReader.this.searchContentForText(elem, PPTXReader.this.key);
            elem.detach();
            if (PPTXReader.this.searched) {
                throw new StopReaderError("stop");
            }
        }
    }
}

