/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt;

import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ExtendPath;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.ArrowPathAndTail;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.Gradient;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.LinearGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.RadialGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.TileShader;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfoFactory;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.ArbitraryPolygonShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.GroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.LineShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.TableShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.FCKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.HSLFSlideShow;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Fill;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Freeform;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.HeadersFooters;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.MasterSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Notes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Picture;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Shape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.ShapeGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.SimpleShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.SlideMaster;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Table;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TableCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TitleMaster;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.BinaryTagDataBlob;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ClientVisualElementContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.DocumentAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.OEPlaceholderAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PositionDependentRecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideProgBinaryTagContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideProgTagsContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideShowSlideInfoAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TextRulerAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeAnimateBehaviorContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeBehaviorContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeColorBehaviorContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeCommandBehaviorContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeEffectBehaviorContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeMotionBehaviorContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeNodeAttributeContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeNodeContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeRotationBehaviorContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeScaleBehaviorContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeSetBehaviorContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TimeVariant;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.VisualShapeAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.PictureData;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.RichTextRun;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.SlideShow;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.bulletnumber.BulletNumberManage;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectanglef;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.Rectangle2D;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.ShapeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGNotes;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.FontTypefaceManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.format.NumericFormatter;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractReader;
import com.ahmadullahpk.alldocumentreader.xs.system.BackReaderThread;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PPTReader
extends AbstractReader {
    public static final int FIRST_READ_SLIDE_NUM = 2;
    public static final float POINT_PER_LINE_PER_FONTSIZE = 1.2f;
    public static final int DEFAULT_CELL_WIDTH = 100;
    public static final int DEFAULT_CELL_HEIGHT = 40;
    private int number = 1;
    private int currentReaderIndex;
    private String filePath;
    private PGModel model;
    private SlideShow poiSlideShow;
    private int maxFontSize;
    private Map<Integer, Integer> slideMasterIndexs;
    private Map<Integer, Integer> titleMasterIndexs;
    private int offset;
    private boolean tableShape;
    private boolean isGetThumbnail;
    private HeadersFooters poiHeadersFooters;
    private boolean hasProcessedMasterSlideNumber;
    private boolean hasProcessedMasterFooter;
    private boolean hasProcessedMasterDateTime;

    public PPTReader(IControl control, String filePath) {
        this(control, filePath, false);
    }

    public PPTReader(IControl control, String filePath, boolean isGetThumbnail) {
        this.filePath = filePath;
        this.control = control;
        this.isGetThumbnail = isGetThumbnail;
    }

    @Override
    public Object getModel() throws Exception {
        if (this.model != null) {
            return this.model;
        }
        this.poiSlideShow = new SlideShow(new HSLFSlideShow(this.control, this.filePath), this.isGetThumbnail);
        this.model = new PGModel();
        Dimension d = this.poiSlideShow.getPageSize();
        d.width = (int)((float)d.width * 1.3333334f);
        d.height = (int)((float)d.height * 1.3333334f);
        this.model.setPageSize(d);
        DocumentAtom docAtom = this.poiSlideShow.getDocumentRecord().getDocumentAtom();
        if (docAtom != null) {
            this.model.setSlideNumberOffset(docAtom.getFirstSlideNum() - 1);
            this.model.setOmitTitleSlide(docAtom.getOmitTitlePlace());
        }
        int count = this.poiSlideShow.getSlideCount();
        this.model.setSlideCount(count);
        if (count == 0) {
            throw new Exception("Format error");
        }
        this.poiHeadersFooters = this.poiSlideShow.getSlideHeadersFooters();
        int len = Math.min(count, 2);
        for (int i = 0; i < len && !this.abortReader; ++i) {
            this.processSlide(this.poiSlideShow.getSlide(this.currentReaderIndex++));
        }
        if (!this.isReaderFinish() && !this.isGetThumbnail) {
            new BackReaderThread(this, this.control).start();
        }
        return this.model;
    }

    @Override
    public boolean isReaderFinish() {
        if (this.model != null && this.poiSlideShow != null) {
            return this.abortReader || this.model.getSlideCount() == 0 || this.currentReaderIndex >= this.poiSlideShow.getSlideCount();
        }
        return true;
    }

    @Override
    public void backReader() throws Exception {
        this.processSlide(this.poiSlideShow.getSlide(this.currentReaderIndex++));
        if (!this.isGetThumbnail) {
            this.control.actionEvent(0x2000000F, null);
        }
    }

    private boolean isTitleSlide(Slide slide) {
        int geometry = 0;
        SlideAtom sa = slide.getSlideRecord().getSlideAtom();
        if (sa != null && sa.getSSlideLayoutAtom() != null) {
            geometry = sa.getSSlideLayoutAtom().getGeometryType();
        }
        if (geometry == 0) {
            return true;
        }
        if (geometry == 16) {
            Shape[] shapes;
            for (Shape shape : shapes = slide.getShapes()) {
                int placeHolderID;
                if (!(shape instanceof TextShape)) {
                    return false;
                }
                OEPlaceholderAtom placeHolder = ((TextShape)shape).getPlaceholderAtom();
                if (placeHolder == null || (placeHolderID = placeHolder.getPlaceholderId()) == 15 || placeHolderID == 16 || placeHolderID == -1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void resetFlag() {
        this.hasProcessedMasterDateTime = false;
        this.hasProcessedMasterFooter = false;
        this.hasProcessedMasterSlideNumber = false;
    }

    private void processSlide(Slide slide) {
        Shape[] shapes;
        PGSlide pgSlide = new PGSlide();
        pgSlide.setSlideType(2);
        pgSlide.setSlideNo(this.number++);
        if (slide.getBackground() != null) {
            pgSlide.setBackgroundAndFill(this.converFill(pgSlide, slide.getBackground().getFill()));
        }
        this.processMaster(pgSlide, slide);
        SlideAtom sa = slide.getSlideRecord().getSlideAtom();
        if (sa != null && sa.getSSlideLayoutAtom() != null) {
            pgSlide.setGeometryType(sa.getSSlideLayoutAtom().getGeometryType());
        }
        this.resetFlag();
        for (Shape shape : shapes = slide.getShapes()) {
            this.processShape(pgSlide, null, shape, 2);
        }
        if (!this.model.isOmitTitleSlide() || !this.isTitleSlide(slide)) {
            com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox tempShape = null;
            PGSlide masterSlide = this.model.getSlideMaster(pgSlide.getMasterIndexs()[0]);
            if (masterSlide != null) {
                HeadersFooters slideHeadersFooters = slide.getSlideHeadersFooters();
                if (slideHeadersFooters != null) {
                    pgSlide.setShowMasterHeadersFooters(false);
                    if (slideHeadersFooters.isSlideNumberVisible() && !this.hasProcessedMasterSlideNumber && (tempShape = (com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox)masterSlide.getTextboxByPlaceHolderID(8)) != null) {
                        tempShape = this.processCurrentSlideHeadersFooters(tempShape, String.valueOf(pgSlide.getSlideNo() + this.model.getSlideNumberOffset()));
                        pgSlide.appendShapes(tempShape);
                    }
                    if (!this.hasProcessedMasterFooter && slideHeadersFooters.isFooterVisible() && slideHeadersFooters.getFooterText() != null && (tempShape = (com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox)masterSlide.getTextboxByPlaceHolderID(9)) != null) {
                        tempShape = this.processCurrentSlideHeadersFooters(tempShape, slideHeadersFooters.getFooterText());
                        pgSlide.appendShapes(tempShape);
                    }
                    if (!this.hasProcessedMasterDateTime && slideHeadersFooters.isUserDateVisible() && slideHeadersFooters.getDateTimeText() != null) {
                        tempShape = (com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox)masterSlide.getTextboxByPlaceHolderID(7);
                        if (tempShape != null) {
                            tempShape = this.processCurrentSlideHeadersFooters(tempShape, slideHeadersFooters.getDateTimeText());
                            pgSlide.appendShapes(tempShape);
                        }
                    } else if (!this.hasProcessedMasterDateTime && slideHeadersFooters.isDateTimeVisible()) {
                        String val = NumericFormatter.instance().getFormatContents("yyyy/m/d", new Date(System.currentTimeMillis()));
                        tempShape = (com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox)masterSlide.getTextboxByPlaceHolderID(7);
                        if (tempShape != null && tempShape.getElement() != null) {
                            tempShape = this.processCurrentSlideHeadersFooters(tempShape, val);
                            pgSlide.appendShapes(tempShape);
                        }
                    }
                } else {
                    if (!this.hasProcessedMasterSlideNumber && this.poiHeadersFooters.isSlideNumberVisible() && (tempShape = (com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox)masterSlide.getTextboxByPlaceHolderID(8)) != null) {
                        tempShape = this.processCurrentSlideHeadersFooters(tempShape, String.valueOf(pgSlide.getSlideNo() + this.model.getSlideNumberOffset()));
                        pgSlide.appendShapes(tempShape);
                    }
                    if (!this.hasProcessedMasterFooter && this.poiHeadersFooters.isFooterVisible() && this.poiHeadersFooters.getFooterText() != null && (tempShape = (com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox)masterSlide.getTextboxByPlaceHolderID(9)) != null) {
                        pgSlide.appendShapes(tempShape);
                    }
                    if (!this.hasProcessedMasterDateTime && (this.poiHeadersFooters.getDateTimeText() != null && this.poiHeadersFooters.isUserDateVisible() || this.poiHeadersFooters.isDateTimeVisible()) && (tempShape = (com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox)masterSlide.getTextboxByPlaceHolderID(7)) != null) {
                        pgSlide.appendShapes(tempShape);
                    }
                }
            }
        }
        this.processNotes(pgSlide, slide.getNotesSheet());
        this.processGroupShape(pgSlide);
        SlideShowSlideInfoAtom slideInfotAtom = slide.getSlideShowSlideInfoAtom();
        pgSlide.setTransition(slideInfotAtom != null && slideInfotAtom.isValidateTransition());
        this.processSlideshow(pgSlide, slide.getSlideProgTagsContainer());
        this.model.appendSlide(pgSlide);
        if (this.abortReader || this.model.getSlideCount() == 0 || this.currentReaderIndex >= this.poiSlideShow.getSlideCount()) {
            this.slideMasterIndexs.clear();
            this.slideMasterIndexs = null;
            this.titleMasterIndexs.clear();
            this.titleMasterIndexs = null;
        }
    }

    private com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox processCurrentSlideHeadersFooters(com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox styleShape, String text) {
        if (styleShape != null && text != null && text.length() > 0 && styleShape.getElement() != null && styleShape.getElement().getEndOffset() - styleShape.getElement().getStartOffset() > 0L) {
            com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox textShape = new com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox();
            textShape.setBounds(styleShape.getBounds());
            textShape.setWrapLine(styleShape.isWrapLine());
            SectionElement secElem = new SectionElement();
            secElem.setStartOffset(0L);
            secElem.setEndOffset(text.length());
            secElem.setAttribute(styleShape.getElement().getAttribute().clone());
            textShape.setElement(secElem);
            ParagraphElement paraElem = (ParagraphElement)styleShape.getElement().getParaCollection().getElementForIndex(0);
            ParagraphElement paraElemNew = new ParagraphElement();
            paraElemNew.setStartOffset(0L);
            paraElemNew.setEndOffset(text.length());
            paraElemNew.setAttribute(paraElem.getAttribute().clone());
            secElem.appendParagraph(paraElemNew, 0L);
            LeafElement leafElem = (LeafElement)paraElem.getElementForIndex(0);
            String str = leafElem.getText(null);
            if (str != null && str.contains("*")) {
                text = str.replace("*", text);
            }
            LeafElement leafElemNew = new LeafElement(text);
            leafElemNew.setStartOffset(0L);
            leafElemNew.setEndOffset(text.length());
            leafElemNew.setAttribute(leafElem.getAttribute().clone());
            paraElemNew.appendLeaf(leafElemNew);
            return textShape;
        }
        return null;
    }

    private void processGroupShape(PGSlide pgSlide) {
        Map<Integer, List<Integer>> grpShape = pgSlide.getGroupShape();
        if (grpShape == null) {
            return;
        }
        int count = pgSlide.getShapeCount();
        for (int i = 0; i < count; ++i) {
            IShape shape = pgSlide.getShape(i);
            int grpSpID = this.getGroupShapeID(shape.getShapeID(), grpShape);
            shape.setGroupShapeID(grpSpID);
        }
    }

    private int getGroupShapeID(int shapeID, Map<Integer, List<Integer>> grpShape) {
        for (int grpID : grpShape.keySet()) {
            List<Integer> childShape = grpShape.get(grpID);
            if (childShape == null || !childShape.contains(shapeID)) continue;
            return grpID;
        }
        return -1;
    }

    private void processSlideshow(PGSlide pgSlide, SlideProgTagsContainer propTagsContainer) {
        try {
            if (propTagsContainer == null) {
                return;
            }
            Record[] records = propTagsContainer.getChildRecords();
            if (records == null || records.length < 1 || !(records[0] instanceof SlideProgBinaryTagContainer)) {
                return;
            }
            Record rec = ((SlideProgBinaryTagContainer)records[0]).findFirstOfType(BinaryTagDataBlob.RECORD_ID);
            if (rec == null) {
                return;
            }
            if ((rec = ((BinaryTagDataBlob)rec).findFirstOfType(TimeNodeContainer.RECORD_ID)) == null) {
                return;
            }
            if ((rec = ((TimeNodeContainer)rec).findFirstOfType(TimeNodeContainer.RECORD_ID)) == null) {
                return;
            }
            records = ((TimeNodeContainer)rec).getChildRecords();
            if (records != null) {
                for (Record record : records) {
                    List<ShapeAnimation> animations;
                    if (!(record instanceof TimeNodeContainer) || (animations = this.processAnimation(pgSlide, (TimeNodeContainer)record)) == null) continue;
                    for (ShapeAnimation anim2 : animations) {
                        pgSlide.addShapeAnimation(anim2);
                    }
                }
            }
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
        }
    }

    private List<ShapeAnimation> processAnimation(PGSlide pgSlide, TimeNodeContainer timeNodeContainer) {
        try {
            ArrayList<ShapeAnimation> animations = new ArrayList<ShapeAnimation>();
            Record[] childRecords = timeNodeContainer.getChildRecords();
            if (childRecords == null) {
                return null;
            }
            ArrayList<TimeNodeContainer> timeNodeContainerList = new ArrayList<TimeNodeContainer>();
            for (int i = 0; i < childRecords.length; ++i) {
                if (!(childRecords[i] instanceof TimeNodeContainer)) continue;
                timeNodeContainerList.add((TimeNodeContainer)childRecords[i]);
            }
            if (timeNodeContainerList.size() > 1) {
                for (TimeNodeContainer container : timeNodeContainerList) {
                    ShapeAnimation shapeAnim;
                    Record record = container.findFirstOfType(TimeNodeContainer.RECORD_ID);
                    if (record == null || (shapeAnim = this.processSingleAnimation(pgSlide, (TimeNodeContainer)record)) == null) continue;
                    animations.add(shapeAnim);
                }
            } else if (timeNodeContainerList.size() == 1) {
                timeNodeContainer = (TimeNodeContainer)timeNodeContainerList.get(0);
                timeNodeContainerList.clear();
                childRecords = timeNodeContainer.getChildRecords();
                for (int i = 0; i < childRecords.length; ++i) {
                    if (!(childRecords[i] instanceof TimeNodeContainer)) continue;
                    timeNodeContainerList.add((TimeNodeContainer)childRecords[i]);
                }
                if (timeNodeContainerList.size() == 1) {
                    ShapeAnimation shapeAnim = this.processSingleAnimation(pgSlide, (TimeNodeContainer)timeNodeContainerList.get(0));
                    if (shapeAnim != null) {
                        animations.add(shapeAnim);
                    }
                } else if (timeNodeContainerList.size() > 1) {
                    for (TimeNodeContainer container : timeNodeContainerList) {
                        ShapeAnimation shapeAnim = this.processSingleAnimation(pgSlide, container);
                        if (shapeAnim == null) continue;
                        animations.add(shapeAnim);
                    }
                }
            }
            return animations;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ShapeAnimation processSingleAnimation(PGSlide pgSlide, TimeNodeContainer timeNodeContainer) {
        try {
            Record[] records;
            byte type = -1;
            TimeNodeAttributeContainer timeNodeAttrContainer = (TimeNodeAttributeContainer)timeNodeContainer.findFirstOfType(TimeNodeAttributeContainer.RECORD_ID);
            block12: for (Record record : records = timeNodeAttrContainer.getChildRecords()) {
                if (!(record instanceof TimeVariant) || ((TimeVariant)record).getAttributeType() != 11) continue;
                int t = (Integer)((TimeVariant)record).getValue();
                switch (t) {
                    case 1: {
                        type = 0;
                        break block12;
                    }
                    case 2: {
                        type = 2;
                        break block12;
                    }
                    case 3: {
                        type = 1;
                        break block12;
                    }
                    default: {
                        return null;
                    }
                }
            }
            timeNodeContainer = (TimeNodeContainer)timeNodeContainer.findFirstOfType(TimeNodeContainer.RECORD_ID);
            for (Record record : records = timeNodeContainer.getChildRecords()) {
                if (record.getRecordType() != TimeAnimateBehaviorContainer.RECORD_ID && record.getRecordType() != TimeColorBehaviorContainer.RECORD_ID && record.getRecordType() != TimeEffectBehaviorContainer.RECORD_ID && record.getRecordType() != TimeMotionBehaviorContainer.RECORD_ID && record.getRecordType() != TimeRotationBehaviorContainer.RECORD_ID && record.getRecordType() != TimeScaleBehaviorContainer.RECORD_ID && record.getRecordType() != TimeSetBehaviorContainer.RECORD_ID && record.getRecordType() != TimeCommandBehaviorContainer.RECORD_ID) continue;
                TimeBehaviorContainer behaviorContainer = (TimeBehaviorContainer)((PositionDependentRecordContainer)record).findFirstOfType(TimeBehaviorContainer.RECORD_ID);
                ClientVisualElementContainer clientVisualElement = (ClientVisualElementContainer)behaviorContainer.findFirstOfType(ClientVisualElementContainer.RECORD_ID);
                VisualShapeAtom visualElementAtom = (VisualShapeAtom)clientVisualElement.findFirstOfType(VisualShapeAtom.RECORD_ID);
                switch (visualElementAtom.getTargetElementType()) {
                    case 0: {
                        return new ShapeAnimation(visualElementAtom.getTargetElementID(), type, -2, -2);
                    }
                    case 6: {
                        return new ShapeAnimation(visualElementAtom.getTargetElementID(), type, -1, -1);
                    }
                    case 2: {
                        int paraID = this.getParaIndex(pgSlide, visualElementAtom);
                        return new ShapeAnimation(visualElementAtom.getTargetElementID(), type, paraID, paraID);
                    }
                }
                break;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private int getParaIndex(PGSlide pgSlide, VisualShapeAtom visualElementAtom) {
        IShape[] shapes = pgSlide.getShapes();
        int cnt = shapes.length;
        ParagraphElement element = null;
        for (int i = 0; i < cnt; ++i) {
            if (!(shapes[i] instanceof com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox) || shapes[i].getShapeID() != visualElementAtom.getTargetElementID()) continue;
            long offset = 0L;
            int paraID = 0;
            SectionElement sec = ((com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox)shapes[i]).getElement();
            element = (ParagraphElement)sec.getElement(offset);
            while (element != null) {
                offset = element.getEndOffset();
                if (element.getStartOffset() == (long)visualElementAtom.getData1() && (offset == (long)visualElementAtom.getData2() || offset == (long)(visualElementAtom.getData2() - 1))) {
                    return paraID;
                }
                ++paraID;
                element = (ParagraphElement)sec.getElement(offset);
            }
            break;
        }
        return -2;
    }

    public void processMaster(PGSlide pgSlide, Slide slide) {
        TitleMaster[] titleMaster;
        if (this.slideMasterIndexs == null) {
            this.slideMasterIndexs = new HashMap<Integer, Integer>();
        }
        if (this.titleMasterIndexs == null) {
            this.titleMasterIndexs = new HashMap<Integer, Integer>();
        }
        Object sheet = null;
        SlideAtom sa = slide.getSlideRecord().getSlideAtom();
        if (!sa.getFollowMasterObjects()) {
            return;
        }
        int masterId = sa.getMasterID();
        SlideMaster[] master = this.poiSlideShow.getSlidesMasters();
        for (int i = 0; i < master.length; ++i) {
            if (masterId != master[i]._getSheetNumber()) continue;
            Integer index = this.slideMasterIndexs.get(masterId);
            if (index != null) {
                pgSlide.setMasterSlideIndex(index);
                return;
            }
            PGSlide slideMaster = new PGSlide();
            slideMaster.setSlideType(0);
            slideMaster.setBackgroundAndFill(pgSlide.getBackgroundAndFill());
            Shape[] sh = master[i].getShapes();
            for (int j = 0; j < sh.length; ++j) {
                this.processShape(slideMaster, null, sh[j], 0);
            }
            if (slideMaster.getShapeCount() <= 0) break;
            index = this.model.appendSlideMaster(slideMaster);
            pgSlide.setMasterSlideIndex(index);
            this.slideMasterIndexs.put(masterId, index);
            break;
        }
        if (sheet == null && (titleMaster = this.poiSlideShow.getTitleMasters()) != null) {
            for (int i = 0; i < titleMaster.length; ++i) {
                if (masterId != titleMaster[i]._getSheetNumber()) continue;
                Integer index = this.titleMasterIndexs.get(masterId);
                if (index != null) {
                    pgSlide.setLayoutSlideIndex(index);
                    break;
                }
                PGSlide slideMaster = new PGSlide();
                slideMaster.setSlideType(0);
                slideMaster.setBackgroundAndFill(pgSlide.getBackgroundAndFill());
                Shape[] sh = titleMaster[i].getShapes();
                for (int j = 0; j < sh.length; ++j) {
                    this.processShape(slideMaster, null, sh[j], 0);
                }
                if (slideMaster.getShapeCount() <= 0) break;
                index = this.model.appendSlideMaster(slideMaster);
                pgSlide.setLayoutSlideIndex(index);
                this.titleMasterIndexs.put(masterId, index);
                break;
            }
        }
    }

    private Line getShapeLine(SimpleShape shape) {
        return this.getShapeLine(shape, false);
    }

    private Line getShapeLine(SimpleShape shape, boolean isTableCellLine) {
        Line line = null;
        if (shape != null && shape.hasLine()) {
            int lineWidth = (int)Math.round(shape.getLineWidth() * 1.3333333730697632);
            boolean dash = shape.getLineDashing() > 0;
            Color color2 = shape.getLineColor();
            if (color2 != null) {
                line = new Line();
                BackgroundAndFill lineFill = new BackgroundAndFill();
                lineFill.setForegroundColor(this.converterColor(color2));
                line.setBackgroundAndFill(lineFill);
                line.setDash(dash);
                line.setLineWidth(lineWidth);
            }
        } else if (isTableCellLine) {
            line = new Line();
            BackgroundAndFill lineFill = new BackgroundAndFill();
            lineFill.setForegroundColor(-16777216);
            line.setBackgroundAndFill(lineFill);
        }
        return line;
    }

    private BackgroundAndFill converFill(PGSlide pgSlide, Fill fill) {
        BackgroundAndFill bgFill = null;
        if (fill != null) {
            int type = fill.getFillType();
            if (type == 9) {
                bgFill = pgSlide.getBackgroundAndFill();
            } else if (type == 0) {
                if (fill.getForegroundColor() != null) {
                    bgFill = new BackgroundAndFill();
                    bgFill.setFillType((byte)0);
                    bgFill.setForegroundColor(this.converterColor(fill.getForegroundColor()));
                }
            } else if (type == 7 || type == 4 || type == 5 || type == 6) {
                int angle = fill.getFillAngle();
                switch (angle) {
                    case -90: 
                    case 0: {
                        angle += 90;
                        break;
                    }
                    case -45: {
                        angle = 135;
                        break;
                    }
                    case -135: {
                        angle = 45;
                    }
                }
                int focus = fill.getFillFocus();
                Color fillColor = fill.getForegroundColor();
                Color fillbackColor = fill.getFillbackColor();
                int[] colors = null;
                float[] positions = null;
                if (fill.isShaderPreset()) {
                    colors = fill.getShaderColors();
                    positions = fill.getShaderPositions();
                }
                if (colors == null) {
                    colors = new int[]{fillColor == null ? -1 : fillColor.getRGB(), fillbackColor == null ? -1 : fillbackColor.getRGB()};
                }
                if (positions == null) {
                    positions = new float[]{0.0f, 1.0f};
                }
                Gradient gradient = null;
                if (type == 7) {
                    gradient = new LinearGradientShader(angle, colors, positions);
                } else if (type == 4 || type == 5 || type == 6) {
                    gradient = new RadialGradientShader(fill.getRadialGradientPositionType(), colors, positions);
                }
                if (gradient != null) {
                    gradient.setFocus(focus);
                }
                bgFill = new BackgroundAndFill();
                bgFill.setFillType((byte)type);
                bgFill.setShader(gradient);
            } else if (type == 2) {
                bgFill = new BackgroundAndFill();
                bgFill.setFillType((byte)2);
                PictureData pData = fill.getPictureData();
                if (pData != null) {
                    int index = this.control.getSysKit().getPictureManage().addPicture(pData);
                    bgFill.setShader(new TileShader(this.control.getSysKit().getPictureManage().getPicture(index), 0, 1.0f, 1.0f));
                }
            } else if (type == 3) {
                PictureData pData = fill.getPictureData();
                if (pData != null) {
                    bgFill = new BackgroundAndFill();
                    bgFill.setFillType((byte)3);
                    bgFill.setPictureIndex(this.control.getSysKit().getPictureManage().addPicture(pData));
                }
            } else if (type == 1 && fill.getFillbackColor() != null) {
                bgFill = new BackgroundAndFill();
                bgFill.setFillType((byte)0);
                bgFill.setForegroundColor(this.converterColor(fill.getFillbackColor()));
            }
        }
        return bgFill;
    }

    private void processNotes(PGSlide pgSlide, Notes notes) {
        if (notes != null) {
            String note = "";
            for (Shape shape : notes.getShapes()) {
                String text;
                OEPlaceholderAtom phAtom;
                if (this.abortReader) break;
                if (!(shape instanceof com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.AutoShape) && !(shape instanceof TextBox) || (phAtom = ((TextShape)shape).getPlaceholderAtom()) == null || phAtom.getPlaceholderId() != 12 || (text = ((TextShape)shape).getText()) == null || text.length() <= 0) continue;
                note = note + text;
                note = note + '\n';
            }
            if (note.trim().length() > 0) {
                PGNotes pgNotes = new PGNotes(note.trim());
                pgSlide.setNotes(pgNotes);
            }
        }
    }

    private void processShape(PGSlide pgSlide, GroupShape parent, Shape shape, int slideType) {
        boolean addShape = true;
        int placeHolderID = -1;
        this.tableShape = false;
        if (this.abortReader || shape.isHidden()) {
            return;
        }
        Rectangle2D rect2D = null;
        rect2D = shape instanceof ShapeGroup ? ((ShapeGroup)shape).getClientAnchor2D(shape) : shape.getLogicalAnchor2D();
        if (rect2D == null) {
            return;
        }
        Rectangle rect = new Rectangle();
        rect.x = (int)(rect2D.getX() * 1.3333333730697632);
        rect.y = (int)(rect2D.getY() * 1.3333333730697632);
        rect.width = (int)(rect2D.getWidth() * 1.3333333730697632);
        rect.height = (int)(rect2D.getHeight() * 1.3333333730697632);
        BackgroundAndFill fill = null;
        Line line = null;
        if (shape instanceof SimpleShape) {
            IShape masterShape = null;
            if (slideType == 2) {
                int masterShapeID = shape.getMasterShapeID();
                int[] indexs = pgSlide.getMasterIndexs();
                PGSlide master = this.model.getSlideMaster(indexs[0]);
                if (master != null) {
                    int count = master.getShapeCount();
                    for (int i = 0; i < count; ++i) {
                        IShape item = master.getShape(i);
                        if (item.getShapeID() != masterShapeID) continue;
                        masterShape = item;
                        break;
                    }
                }
            }
            if ((fill = this.converFill(pgSlide, shape.getFill())) == null && masterShape != null && masterShape instanceof AbstractShape) {
                fill = ((AbstractShape)masterShape).getBackgroundAndFill();
            }
            if ((line = this.getShapeLine((SimpleShape)shape)) == null && masterShape != null && masterShape instanceof AbstractShape) {
                line = ((AbstractShape)masterShape).getLine();
            }
        }
        if (shape instanceof com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Line || shape instanceof Freeform || shape instanceof com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.AutoShape || shape instanceof TextBox || shape instanceof Picture) {
            if (shape instanceof com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Line) {
                if (line != null) {
                    LineShape lineShape = new LineShape();
                    lineShape.setShapeType(shape.getShapeType());
                    lineShape.setBounds(rect);
                    lineShape.setBackgroundAndFill(fill);
                    lineShape.setLine(line);
                    Float[] adj = ((com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Line)shape).getAdjustmentValue();
                    if (lineShape.getShapeType() == 33 && adj == null) {
                        lineShape.setAdjustData(new Float[]{Float.valueOf(1.0f)});
                    } else {
                        lineShape.setAdjustData(adj);
                    }
                    int type = shape.getStartArrowType();
                    if (type > 0) {
                        lineShape.createStartArrow((byte)type, shape.getStartArrowWidth(), shape.getStartArrowLength());
                    }
                    if ((type = ((com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Line)shape).getEndArrowType()) > 0) {
                        lineShape.createEndArrow((byte)type, shape.getEndArrowWidth(), shape.getEndArrowLength());
                    }
                    this.processGrpRotation((SimpleShape)shape, lineShape);
                    lineShape.setShapeID(shape.getShapeId());
                    if (parent == null) {
                        pgSlide.appendShapes(lineShape);
                    } else {
                        parent.appendShapes(lineShape);
                    }
                }
            } else if (shape instanceof Freeform) {
                if (fill != null || line != null) {
                    ArrowPathAndTail arrowPathAndTail;
                    int endArrowType;
                    ArrowPathAndTail arrowPathAndTail2;
                    ArbitraryPolygonShape arbitraryPolygonShape = new ArbitraryPolygonShape();
                    arbitraryPolygonShape.setShapeType(233);
                    arbitraryPolygonShape.setBounds(rect);
                    PointF startArrowTailCenter = null;
                    PointF endArrowTailCenter = null;
                    int startArrowType = shape.getStartArrowType();
                    if (startArrowType > 0 && (arrowPathAndTail2 = ((Freeform)shape).getStartArrowPathAndTail(rect)) != null && arrowPathAndTail2.getArrowPath() != null) {
                        startArrowTailCenter = arrowPathAndTail2.getArrowTailCenter();
                        ExtendPath pathExtend = new ExtendPath();
                        pathExtend.setPath(arrowPathAndTail2.getArrowPath());
                        pathExtend.setArrowFlag(true);
                        if (startArrowType != 5) {
                            if (line == null || line.getBackgroundAndFill() == null) {
                                Color color2 = ((SimpleShape)shape).getLineColor();
                                if (color2 != null) {
                                    BackgroundAndFill arrowFill = new BackgroundAndFill();
                                    arrowFill.setFillType((byte)0);
                                    arrowFill.setForegroundColor(this.converterColor(color2));
                                    pathExtend.setBackgroundAndFill(arrowFill);
                                }
                            } else {
                                pathExtend.setBackgroundAndFill(line.getBackgroundAndFill());
                            }
                        } else {
                            pathExtend.setLine(line);
                        }
                        arbitraryPolygonShape.appendPath(pathExtend);
                    }
                    if ((endArrowType = shape.getEndArrowType()) > 0 && (arrowPathAndTail = ((Freeform)shape).getEndArrowPathAndTail(rect)) != null && arrowPathAndTail.getArrowPath() != null) {
                        endArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                        ExtendPath pathExtend = new ExtendPath();
                        pathExtend.setPath(arrowPathAndTail.getArrowPath());
                        pathExtend.setArrowFlag(true);
                        if (endArrowType != 5) {
                            if (line == null || line.getBackgroundAndFill() == null) {
                                Color color3 = ((SimpleShape)shape).getLineColor();
                                if (color3 != null) {
                                    BackgroundAndFill arrowFill = new BackgroundAndFill();
                                    arrowFill.setFillType((byte)0);
                                    arrowFill.setForegroundColor(this.converterColor(color3));
                                    pathExtend.setBackgroundAndFill(arrowFill);
                                }
                            } else {
                                pathExtend.setBackgroundAndFill(line.getBackgroundAndFill());
                            }
                        } else {
                            pathExtend.setLine(line);
                        }
                        arbitraryPolygonShape.appendPath(pathExtend);
                    }
                    Path[] paths = ((Freeform)shape).getFreeformPath(rect, startArrowTailCenter, (byte)startArrowType, endArrowTailCenter, (byte)endArrowType);
                    for (int i = 0; paths != null && i < paths.length; ++i) {
                        ExtendPath pathExtend = new ExtendPath();
                        pathExtend.setPath(paths[i]);
                        if (line != null) {
                            pathExtend.setLine(line);
                        }
                        if (fill != null) {
                            pathExtend.setBackgroundAndFill(fill);
                        }
                        arbitraryPolygonShape.appendPath(pathExtend);
                    }
                    this.processGrpRotation((SimpleShape)shape, arbitraryPolygonShape);
                    arbitraryPolygonShape.setShapeID(shape.getShapeId());
                    if (parent == null) {
                        pgSlide.appendShapes(arbitraryPolygonShape);
                    } else {
                        parent.appendShapes(arbitraryPolygonShape);
                    }
                }
            } else if (shape instanceof com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.AutoShape || shape instanceof TextBox) {
                placeHolderID = ((TextShape)shape).getPlaceholderId();
                AbstractShape autoShape = null;
                if (fill != null || line != null) {
                    int shapeType = shape.getShapeType();
                    if (shapeType == 20 || shapeType == 32 || shapeType == 33 || shapeType == 34 || shapeType == 35 || shapeType == 36 || shapeType == 37 || shapeType == 38 || shapeType == 39 || shapeType == 40) {
                        LineShape lineShape = new LineShape();
                        lineShape.setShapeType(shape.getShapeType());
                        lineShape.setBounds(rect);
                        lineShape.setLine(line);
                        Float[] adj = shape.getAdjustmentValue();
                        if (lineShape.getShapeType() == 33 && adj == null) {
                            lineShape.setAdjustData(new Float[]{Float.valueOf(1.0f)});
                        } else {
                            lineShape.setAdjustData(adj);
                        }
                        int type = shape.getStartArrowType();
                        if (type > 0) {
                            lineShape.createStartArrow((byte)type, shape.getStartArrowWidth(), shape.getStartArrowLength());
                        }
                        if ((type = shape.getEndArrowType()) > 0) {
                            lineShape.createEndArrow((byte)type, shape.getEndArrowWidth(), shape.getEndArrowLength());
                        }
                        autoShape = lineShape;
                    } else {
                        autoShape = new AutoShape(shape.getShapeType());
                        ((AutoShape)autoShape).setAuotShape07(false);
                        autoShape.setBounds(rect);
                        autoShape.setBackgroundAndFill(fill);
                        if (line != null) {
                            autoShape.setLine(line);
                        }
                        if (shape.getShapeType() != 202) {
                            ((AutoShape)autoShape).setAdjustData(shape.getAdjustmentValue());
                        }
                    }
                    this.processGrpRotation((SimpleShape)shape, autoShape);
                    autoShape.setShapeID(shape.getShapeId());
                    autoShape.setPlaceHolderID(placeHolderID);
                    if (parent == null) {
                        pgSlide.appendShapes(autoShape);
                    } else {
                        parent.appendShapes(autoShape);
                    }
                }
                com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox tb = new com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox();
                byte mcType = ((TextShape)shape).getMetaCharactersType();
                tb.setMCType(mcType);
                this.processTextShape(tb, (TextShape)shape, rect, slideType, placeHolderID);
                if (tb.getElement() != null) {
                    if (tb.isWordArt() && autoShape != null) {
                        autoShape.setBackgroundAndFill(null);
                    }
                    this.processGrpRotation((SimpleShape)shape, tb);
                    tb.setShapeID(shape.getShapeId());
                    tb.setPlaceHolderID(placeHolderID);
                    if (slideType == 2) {
                        if (placeHolderID == 9) {
                            this.hasProcessedMasterFooter = true;
                        } else if (placeHolderID == 7 && (mcType == 2 || mcType == 3 || mcType == 5)) {
                            this.hasProcessedMasterDateTime = true;
                        } else if (placeHolderID == 8 && mcType == 1) {
                            this.hasProcessedMasterSlideNumber = true;
                        }
                    }
                    if (parent == null || slideType == 0 && MasterSheet.isPlaceholder(shape)) {
                        pgSlide.appendShapes(tb);
                    } else {
                        parent.appendShapes(tb);
                    }
                }
            } else if (shape instanceof Picture) {
                Picture poiPic = (Picture)shape;
                PictureData pData = poiPic.getPictureData();
                if (pData != null) {
                    PictureShape pictureShape = new PictureShape();
                    pictureShape.setPictureIndex(this.control.getSysKit().getPictureManage().addPicture(pData));
                    pictureShape.setBounds(rect);
                    this.processGrpRotation((SimpleShape)shape, pictureShape);
                    pictureShape.setShapeID(shape.getShapeId());
                    pictureShape.setPictureEffectInfor(PictureEffectInfoFactory.getPictureEffectInfor(poiPic.getEscherOptRecord()));
                    pictureShape.setBackgroundAndFill(fill);
                    pictureShape.setLine(line);
                    if (parent == null) {
                        pgSlide.appendShapes(pictureShape);
                    } else {
                        parent.appendShapes(pictureShape);
                    }
                } else if (fill != null || line != null) {
                    AutoShape autoShape = new AutoShape(1);
                    autoShape.setAuotShape07(false);
                    autoShape.setBounds(rect);
                    autoShape.setBackgroundAndFill(fill);
                    autoShape.setLine(line);
                    if (parent == null) {
                        pgSlide.appendShapes(autoShape);
                    } else {
                        parent.appendShapes(autoShape);
                    }
                }
            }
        } else if (shape instanceof Table) {
            Table poiTable = (Table)shape;
            if (poiTable != null) {
                this.processTable(pgSlide, poiTable, parent, slideType);
            }
        } else if (shape instanceof ShapeGroup) {
            ShapeGroup shapeGroup = (ShapeGroup)shape;
            GroupShape groupShape = new GroupShape();
            groupShape.setBounds(rect);
            groupShape.setShapeID(shape.getShapeId());
            groupShape.setFlipHorizontal(shapeGroup.getFlipHorizontal());
            groupShape.setFlipVertical(shapeGroup.getFlipVertical());
            groupShape.setParent(parent);
            this.processGrpRotation(shape, groupShape);
            Shape[] sh = ((ShapeGroup)shape).getShapes();
            ArrayList<Integer> childShapeLst = new ArrayList<Integer>(sh.length);
            for (int i = 0; i < sh.length; ++i) {
                this.processShape(pgSlide, groupShape, sh[i], slideType);
                childShapeLst.add(sh[i].getShapeId());
            }
            if (parent == null) {
                pgSlide.appendShapes(groupShape);
            } else {
                parent.appendShapes(groupShape);
            }
            pgSlide.addGroupShape(shape.getShapeId(), childShapeLst);
        }
    }

    private void processTable(PGSlide pgSlide, Table poiTable, GroupShape parent, int slideType) {
        com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Line[] borders;
        Rectangle2D clientAnchor = poiTable.getClientAnchor2D(poiTable);
        Rectangle2D spgrAnchor = poiTable.getCoordinates();
        this.tableShape = true;
        int rows = poiTable.getNumberOfRows();
        int columns = poiTable.getNumberOfColumns();
        TableShape table = new TableShape(rows, columns);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                Rectangle2D anchor;
                if (this.abortReader) {
                    return;
                }
                TableCell poiCell = poiTable.getCell(i, j);
                if (poiCell == null || (anchor = poiCell.getLogicalAnchor2D()) == null) continue;
                double scalex = spgrAnchor.getWidth() / clientAnchor.getWidth();
                double scaley = spgrAnchor.getHeight() / clientAnchor.getHeight();
                double x = clientAnchor.getX() + (anchor.getX() - spgrAnchor.getX()) / scalex;
                double y = clientAnchor.getY() + (anchor.getY() - spgrAnchor.getY()) / scaley;
                double width = anchor.getWidth() / scalex;
                double height = anchor.getHeight() / scaley;
                Rectanglef rect = new Rectanglef();
                rect.setX((float)(x * 1.3333333730697632));
                rect.setY((float)(y * 1.3333333730697632));
                rect.setWidth((float)(width * 1.3333333730697632));
                rect.setHeight((float)(height * 1.3333333730697632));
                com.ahmadullahpk.alldocumentreader.xs.common.shape.TableCell cell = new com.ahmadullahpk.alldocumentreader.xs.common.shape.TableCell();
                cell.setBounds(rect);
                cell.setLeftLine(this.getShapeLine(poiCell.getBorderLeft(), true));
                cell.setRightLine(this.getShapeLine(poiCell.getBorderRight(), true));
                cell.setTopLine(this.getShapeLine(poiCell.getBorderTop(), true));
                cell.setBottomLine(this.getShapeLine(poiCell.getBorderBottom(), true));
                cell.setBackgroundAndFill(this.converFill(pgSlide, poiCell.getFill()));
                String text = poiCell.getText();
                if (text != null && text.trim().length() > 0) {
                    com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox textBox = new com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox();
                    Rectangle r = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
                    this.processTextShape(textBox, poiCell, r, slideType, -1);
                    if (textBox.getElement() != null) {
                        this.processGrpRotation(poiCell, textBox);
                        cell.setText(textBox);
                    }
                }
                table.addCell(i * columns + j, cell);
            }
        }
        for (com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Line line : borders = poiTable.getTableBorders()) {
            Line aLine = this.getShapeLine(line, true);
            if (aLine == null) continue;
            Rectangle2D rect2D = line.getLogicalAnchor2D();
            if (rect2D == null) {
                return;
            }
            Rectangle rect = new Rectangle();
            rect.x = (int)(rect2D.getX() * 1.3333333730697632);
            rect.y = (int)(rect2D.getY() * 1.3333333730697632);
            rect.width = (int)(rect2D.getWidth() * 1.3333333730697632);
            rect.height = (int)(rect2D.getHeight() * 1.3333333730697632);
            LineShape lineShape = new LineShape();
            lineShape.setShapeType(line.getShapeType());
            lineShape.setBounds(rect);
            lineShape.setLine(aLine);
            Float[] adj = line.getAdjustmentValue();
            if (lineShape.getShapeType() == 33 && adj == null) {
                lineShape.setAdjustData(new Float[]{Float.valueOf(1.0f)});
            } else {
                lineShape.setAdjustData(null);
            }
            this.processGrpRotation(line, lineShape);
            lineShape.setShapeID(line.getShapeId());
            pgSlide.appendShapes(lineShape);
        }
        Rectangle rect = new Rectangle();
        rect.x = (int)(clientAnchor.getX() * 1.3333333730697632);
        rect.y = (int)(clientAnchor.getY() * 1.3333333730697632);
        rect.width = (int)(clientAnchor.getWidth() * 1.3333333730697632);
        rect.height = (int)(clientAnchor.getHeight() * 1.3333333730697632);
        table.setBounds(rect);
        table.setShapeID(poiTable.getShapeId());
        table.setTable07(false);
        if (parent == null) {
            pgSlide.appendShapes(table);
        } else {
            parent.appendShapes(table);
        }
        this.tableShape = false;
    }

    private int getBorderColor(com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Line line) {
        Color color2;
        if (line != null && (color2 = line.getLineColor()) != null) {
            return this.converterColor(color2);
        }
        return -16777216;
    }

    private void processTextShape(com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox tb, TextShape ts, Rectangle rect, int slideType, int placeHolderID) {
        if (rect == null) {
            Rectangle2D rect2D = ts.getLogicalAnchor2D();
            if (rect2D == null) {
                return;
            }
            rect = new Rectangle();
            rect.x = (int)(rect2D.getX() * 1.3333333730697632);
            rect.y = (int)(rect2D.getY() * 1.3333333730697632);
            rect.width = (int)(rect2D.getWidth() * 1.3333333730697632);
            rect.height = (int)(rect2D.getHeight() * 1.3333333730697632);
        }
        tb.setBounds(rect);
        tb.setWrapLine(ts.getWordWrap() == 0);
        String text = ts.getText();
        if (text != null) {
            this.processNormalTextShape(tb, ts, rect, slideType, placeHolderID);
        } else {
            text = ts.getUnicodeGeoText();
            if (text != null && text.length() > 0) {
                tb.setWordArt(true);
                this.processWordArtTextShape(tb, ts, text, rect, slideType, placeHolderID);
            }
        }
    }

    private void processNormalTextShape(com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox tb, TextShape ts, Rectangle rect, int slideType, int placeHolderID) {
        String text = ts.getText();
        if (text != null && text.trim().length() > 0) {
            SectionElement secElem = new SectionElement();
            tb.setElement(secElem);
            IAttributeSet attr = secElem.getAttribute();
            AttrManage.instance().setPageWidth(attr, (int)((float)rect.width * 15.0f));
            AttrManage.instance().setPageHeight(attr, (int)((float)rect.height * 15.0f));
            AttrManage.instance().setPageMarginLeft(attr, (int)(ts.getMarginLeft() * 20.0f));
            AttrManage.instance().setPageMarginRight(attr, (int)(ts.getMarginRight() * 20.0f));
            AttrManage.instance().setPageMarginTop(attr, (int)(ts.getMarginTop() * 20.0f));
            AttrManage.instance().setPageMarginBottom(attr, (int)(ts.getMarginBottom() * 20.0f));
            byte verAlign = 0;
            int align = ts.getVerticalAlignment();
            switch (align) {
                case 0: 
                case 3: 
                case 6: 
                case 8: {
                    verAlign = 0;
                    break;
                }
                case 1: 
                case 4: {
                    verAlign = 1;
                    break;
                }
                case 2: 
                case 5: 
                case 7: 
                case 9: {
                    verAlign = 2;
                    break;
                }
            }
            if (align == 3 || align == 8 || align == 4 || align == 5 || align == 9) {
                AttrManage.instance().setPageHorizontalAlign(attr, (byte)1);
            }
            AttrManage.instance().setPageVerticalAlign(attr, verAlign);
            this.offset = 0;
            secElem.setStartOffset(this.offset);
            int len = text.length();
            Hyperlink[] links = ts.getTextRun().getHyperlinks();
            int start = 0;
            if (ts.getTextRun().getRunType() != 0) {
                for (int i = 0; i < len && !this.abortReader; ++i) {
                    if (text.charAt(i) != '\n') continue;
                    if (i + 1 >= len) break;
                    this.processParagraph(secElem, ts, text, links, start, i + 1, placeHolderID);
                    start = i + 1;
                }
            }
            this.processParagraph(secElem, ts, text, links, start, len, placeHolderID);
            secElem.setEndOffset(this.offset);
            BulletNumberManage.instance().clearData();
        }
    }

    private void processWordArtTextShape(com.ahmadullahpk.alldocumentreader.xs.common.shape.TextBox tb, TextShape ts, String text, Rectangle rect, int slideType, int placeHolderID) {
        if (placeHolderID == 9 && text.contains("*")) {
            if (slideType == 0) {
                if (this.poiHeadersFooters.getFooterText() != null) {
                    text = this.poiHeadersFooters.getFooterText();
                }
            } else if (slideType == 2) {
                text = null;
                if (this.poiHeadersFooters.getFooterText() != null) {
                    text = this.poiHeadersFooters.getFooterText();
                }
            }
        } else if (placeHolderID == 7 && text.contains("*")) {
            if (slideType == 0) {
                if (this.poiHeadersFooters.getDateTimeText() != null) {
                    text = this.poiHeadersFooters.getDateTimeText();
                }
            } else if (slideType == 2) {
                text = null;
                if (this.poiHeadersFooters.getDateTimeText() != null) {
                    text = this.poiHeadersFooters.getDateTimeText();
                }
            }
        }
        SectionElement secElem = new SectionElement();
        tb.setElement(secElem);
        IAttributeSet attr = secElem.getAttribute();
        AttrManage.instance().setPageWidth(attr, (int)((float)rect.width * 15.0f));
        AttrManage.instance().setPageHeight(attr, (int)((float)rect.height * 15.0f));
        AttrManage.instance().setPageMarginLeft(attr, (int)(ts.getMarginLeft() * 20.0f));
        AttrManage.instance().setPageMarginRight(attr, (int)(ts.getMarginRight() * 20.0f));
        AttrManage.instance().setPageMarginTop(attr, (int)(ts.getMarginTop() * 20.0f));
        AttrManage.instance().setPageMarginBottom(attr, (int)(ts.getMarginBottom() * 20.0f));
        AttrManage.instance().setPageHorizontalAlign(attr, (byte)1);
        AttrManage.instance().setPageVerticalAlign(attr, (byte)1);
        int width = (int)((float)rect.width - (ts.getMarginLeft() + ts.getMarginRight()) * 1.3333334f);
        int height = (int)((float)rect.height - (ts.getMarginTop() + ts.getMarginBottom()) * 1.3333334f);
        this.offset = 0;
        secElem.setStartOffset(this.offset);
        Fill fill = ts.getFill();
        int type = fill.getFillType();
        int fontColor = -16777216;
        if (type == 0) {
            if (fill.getForegroundColor() != null) {
                fontColor = this.converterColor(fill.getForegroundColor());
            }
        } else if (type == 7 || type == 4 || type == 5 || type == 6) {
            Color fillColor = fill.getForegroundColor();
            int[] colors = null;
            if (fill.isShaderPreset()) {
                colors = fill.getShaderColors();
                if (colors != null) {
                    fontColor = colors[0];
                } else if (fillColor != null) {
                    fontColor = fillColor.getRGB();
                }
            }
        }
        this.processWordArtParagraph(secElem, text, width, height, fontColor);
        secElem.setEndOffset(this.offset);
        BulletNumberManage.instance().clearData();
    }

    private void processParagraph(SectionElement secElem, TextShape ts, String text, Hyperlink[] links, int start, int end, int placeHolderID) {
        RichTextRun run;
        ParagraphElement paraElem = new ParagraphElement();
        paraElem.setStartOffset(this.offset);
        IAttributeSet attr = paraElem.getAttribute();
        RichTextRun rt = ts.getTextRun().getRichTextRunAt(start);
        AttrManage.instance().setParaHorizontalAlign(attr, rt.getAlignment());
        int temp = rt.getLineSpacing();
        if (temp >= 0) {
            if (temp == 0) {
                temp = 100;
            }
            AttrManage.instance().setParaLineSpaceType(attr, 5);
            AttrManage.instance().setParaLineSpace(attr, (float)temp / 100.0f);
        } else {
            AttrManage.instance().setParaLineSpaceType(attr, 4);
            AttrManage.instance().setParaLineSpace(attr, (int)((float)(-temp / 8) * 20.0f));
        }
        if (this.tableShape) {
            if (start == 0) {
                AttrManage.instance().setParaBefore(paraElem.getAttribute(), 0);
            }
            if (end == text.length()) {
                AttrManage.instance().setParaAfter(paraElem.getAttribute(), 0);
            }
        }
        int bulletOffset = (int)((float)rt.getTextOffset() * 20.0f);
        int textOffset = (int)((float)rt.getBulletOffset() * 20.0f);
        int indent = rt.getIndentLevel();
        TextRulerAtom ruler = ts.getTextRun().getTextRuler();
        if (ruler != null) {
            temp = ruler.getBulletOffsets()[indent];
            if (temp >= 0) {
                bulletOffset = (int)((float)temp * 72.0f / 576.0f * 20.0f);
            }
            if ((temp = ruler.getTextOffsets()[indent]) >= 0) {
                textOffset = (int)((float)temp * 72.0f / 576.0f * 20.0f);
            }
        }
        temp = textOffset - bulletOffset;
        AttrManage.instance().setParaSpecialIndent(attr, temp);
        if (temp < 0) {
            AttrManage.instance().setParaIndentLeft(attr, textOffset);
        } else {
            AttrManage.instance().setParaIndentLeft(attr, bulletOffset);
        }
        if (rt.isBullet() && !"\n".equals(text.substring(start, end)) && (temp = BulletNumberManage.instance().addBulletNumber(this.control, indent, ts.getTextRun().getNumberingType(start), ts.getTextRun().getNumberingStart(start), rt.getBulletChar())) >= 0) {
            AttrManage.instance().setPGParaBulletID(attr, temp);
        }
        boolean handleReturn = false;
        if (ts.getTextRun().getRunType() == 0) {
            handleReturn = true;
        }
        while (start < end && !this.abortReader && (run = ts.getTextRun().getRichTextRunAt(start)) != null) {
            int rtEnd = run.getEndIndex();
            if (rtEnd > end) {
                rtEnd = end;
            }
            if (links != null) {
                boolean hasHyperlink = false;
                for (int i = 0; i < links.length; ++i) {
                    int linkStart = links[i].getStartIndex();
                    int linkEnd = links[i].getEndIndex();
                    if (linkStart >= start && linkStart <= rtEnd) {
                        temp = this.control.getSysKit().getHyperlinkManage().addHyperlink(links[i].getAddress(), 1);
                        this.processRun(ts, run, paraElem, text.substring(start, linkStart), -1, start, linkStart, handleReturn);
                        if (linkEnd <= rtEnd) {
                            this.processRun(ts, run, paraElem, text.substring(linkStart, linkEnd), temp, linkStart, linkEnd, handleReturn);
                            start = linkEnd;
                        } else {
                            this.processRun(ts, run, paraElem, text.substring(linkStart, rtEnd), temp, linkStart, rtEnd, handleReturn);
                            start = rtEnd;
                        }
                        hasHyperlink = true;
                        break;
                    }
                    if (start <= linkStart || linkEnd <= start) continue;
                    temp = this.control.getSysKit().getHyperlinkManage().addHyperlink(links[i].getAddress(), 1);
                    if (rtEnd <= linkEnd) {
                        this.processRun(ts, run, paraElem, text.substring(start, rtEnd), temp, start, rtEnd, handleReturn);
                        start = rtEnd;
                    } else {
                        this.processRun(ts, run, paraElem, text.substring(start, linkEnd), temp, start, linkEnd, handleReturn);
                        start = linkEnd;
                    }
                    hasHyperlink = true;
                    break;
                }
                if (hasHyperlink) continue;
            }
            if (placeHolderID == 7 || placeHolderID == 9) {
                this.processRun(ts, run, paraElem, text, -1, start, rtEnd, handleReturn);
                start = end;
                continue;
            }
            this.processRun(ts, run, paraElem, text.substring(start, rtEnd), -1, start, rtEnd, handleReturn);
            start = rtEnd;
        }
        temp = rt.getSpaceBefore();
        if (temp > 0) {
            AttrManage.instance().setParaBefore(attr, (int)((float)temp / 100.0f * (float)this.maxFontSize * 1.2f * 20.0f));
        } else if (temp < 0) {
            AttrManage.instance().setParaBefore(attr, (int)((float)(-temp / 8) * 20.0f));
        }
        temp = rt.getSpaceAfter();
        if (temp >= 0) {
            AttrManage.instance().setParaAfter(attr, (int)((float)temp / 100.0f * (float)this.maxFontSize * 1.2f * 20.0f));
        } else if (temp < 0) {
            AttrManage.instance().setParaAfter(attr, (int)((float)(-temp / 8) * 20.0f));
        }
        paraElem.setEndOffset(this.offset);
        secElem.appendParagraph(paraElem, 0L);
    }

    private void processWordArtParagraph(SectionElement secElem, String text, int width, int height, int fontColor) {
        ParagraphElement paraElem = new ParagraphElement();
        paraElem.setStartOffset(this.offset);
        IAttributeSet paraAttr = paraElem.getAttribute();
        AttrManage.instance().setParaHorizontalAlign(paraAttr, 1);
        LeafElement leaf = new LeafElement(text);
        IAttributeSet attr = leaf.getAttribute();
        int fontsize = 12;
        Paint paint = PaintKit.instance().getPaint();
        paint.setTextSize((float)fontsize);
        Paint.FontMetrics fm = paint.getFontMetrics();
        while ((int)paint.measureText(text) < width && (int)Math.ceil(fm.descent - fm.ascent) < height) {
            paint.setTextSize((float)(++fontsize));
            fm = paint.getFontMetrics();
        }
        AttrManage.instance().setFontSize(leaf.getAttribute(), (int)((float)(fontsize - 1) * 0.75f));
        AttrManage.instance().setFontColor(attr, fontColor);
        this.setMaxFontSize(18);
        leaf.setStartOffset(this.offset);
        this.offset += text.length();
        leaf.setEndOffset(this.offset);
        paraElem.appendLeaf(leaf);
        paraElem.setEndOffset(this.offset);
        secElem.appendParagraph(paraElem, 0L);
    }

    private void processRun(TextShape ts, RichTextRun run, ParagraphElement paraElem, String text, int linkIndex, int start, int end, boolean handleReturn) {
        Sheet sheet = ts.getSheet();
        byte mcType = ts.getMetaCharactersType();
        text = text.replace('\u00a0', ' ');
        int pos = 0;
        if (handleReturn) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c != '\n') continue;
                this.processRun(ts, run, paraElem, text.substring(pos, i), linkIndex, start + pos, start + i, false);
                this.processRun(ts, run, paraElem, String.valueOf('\u000b'), linkIndex, start + i, start + i + 1, false);
                pos = i + 1;
            }
            if (pos < text.length()) {
                this.processRun(ts, run, paraElem, text.substring(pos, text.length()), linkIndex, start + pos, start + text.length(), false);
                pos = text.length();
            }
        }
        this.maxFontSize = 0;
        if (end <= (start += pos)) {
            return;
        }
        if (text.length() > end) {
            text = text.substring(start, end);
        }
        if (text.contains("*")) {
            if (mcType == 2 || mcType == 3 || mcType == 5) {
                String val = NumericFormatter.instance().getFormatContents("yyyy/m/d", new Date(System.currentTimeMillis()));
                text = text.replace("*", val);
            } else if (mcType == 4 && this.poiHeadersFooters.getFooterText() != null) {
                text = this.poiHeadersFooters.getFooterText();
            }
        }
        LeafElement leaf = new LeafElement(text);
        IAttributeSet attr = leaf.getAttribute();
        int temp = run.getFontSize();
        AttrManage.instance().setFontSize(attr, temp > 0 ? temp : 18);
        this.setMaxFontSize(run.getFontSize());
        if (!"\n".equals(text)) {
            if (run.getFontName() != null && (temp = FontTypefaceManage.instance().addFontName(run.getFontName())) >= 0) {
                AttrManage.instance().setFontName(attr, temp);
            }
            AttrManage.instance().setFontColor(attr, this.converterColor(run.getFontColor()));
            AttrManage.instance().setFontBold(attr, run.isBold());
            AttrManage.instance().setFontItalic(attr, run.isItalic());
            AttrManage.instance().setFontUnderline(attr, run.isUnderlined() ? 1 : 0);
            AttrManage.instance().setFontStrike(attr, run.isStrikethrough());
            temp = run.getSuperscript();
            if (temp != 0) {
                AttrManage.instance().setFontScript(attr, temp > 0 ? 1 : 2);
            }
            if (linkIndex >= 0) {
                int color2 = -16776961;
                if (sheet != null) {
                    color2 = FCKit.BGRtoRGB(sheet.getColorScheme().getAccentAndHyperlinkColourRGB());
                }
                AttrManage.instance().setFontColor(attr, color2);
                AttrManage.instance().setFontUnderline(attr, 1);
                AttrManage.instance().setFontUnderlineColr(attr, color2);
                AttrManage.instance().setHyperlinkID(attr, linkIndex);
            }
        }
        leaf.setStartOffset(this.offset);
        this.offset += text.length();
        leaf.setEndOffset(this.offset);
        paraElem.appendLeaf(leaf);
    }

    @Override
    public boolean searchContent(File file, String key) throws Exception {
        Slide[] slides;
        SlideShow slideShow = new SlideShow(new HSLFSlideShow(this.control, this.filePath));
        for (Slide slide : slides = slideShow.getSlides()) {
            Shape[] shapes;
            for (Shape shape : shapes = slide.getShapes()) {
                if (!this.searchShape(shape, key)) continue;
                return true;
            }
            Notes notes = slide.getNotesSheet();
            if (notes == null) continue;
            for (Shape shape : notes.getShapes()) {
                OEPlaceholderAtom phAtom;
                if (!(shape instanceof com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.AutoShape) && !(shape instanceof TextBox) || (phAtom = ((TextShape)shape).getPlaceholderAtom()) == null || phAtom.getPlaceholderId() != 12 || !this.searchShape(shape, key)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean searchShape(Shape shape, String key) {
        StringBuilder sb = new StringBuilder();
        if (shape instanceof com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.AutoShape || shape instanceof TextBox) {
            sb.append(((TextShape)shape).getText());
            if (sb.indexOf(key) >= 0) {
                return true;
            }
            sb.delete(0, sb.length());
        } else if (shape instanceof ShapeGroup) {
            Shape[] sh = ((ShapeGroup)shape).getShapes();
            for (int i = 0; i < sh.length; ++i) {
                if (!this.searchShape(sh[i], key)) continue;
                return true;
            }
        }
        return false;
    }

    private int converterColor(Color color2) {
        return color2.getRGB();
    }

    public void setMaxFontSize(int size) {
        if (size > this.maxFontSize) {
            this.maxFontSize = size;
        }
    }

    public boolean isRectangle(TextShape ts) {
        int type = ts.getShapeType();
        return type == 1 || type == 2 || type == 202;
    }

    public void processGrpRotation(Shape shape, IShape autoShape) {
        float angle = shape.getRotation();
        if (shape.getFlipHorizontal()) {
            autoShape.setFlipHorizontal(true);
            angle = -angle;
        }
        if (shape.getFlipVertical()) {
            autoShape.setFlipVertical(true);
            angle = -angle;
        }
        if (!(!(autoShape instanceof LineShape) || angle != 45.0f && angle != 135.0f && angle != 225.0f || autoShape.getFlipHorizontal() || autoShape.getFlipVertical())) {
            angle -= 90.0f;
        }
        autoShape.setRotation(angle);
    }

    @Override
    public void dispose() {
        if (this.isReaderFinish()) {
            super.dispose();
            if (this.abortReader && this.model != null && this.model.getSlideCount() < 2 && this.poiSlideShow.getSlideCount() > 0) {
                this.model.dispose();
            }
            this.model = null;
            this.filePath = null;
            if (this.poiSlideShow != null) {
                try {
                    this.poiSlideShow.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.poiSlideShow = null;
            }
            if (this.slideMasterIndexs != null) {
                this.slideMasterIndexs.clear();
                this.slideMasterIndexs = null;
            }
            if (this.titleMasterIndexs != null) {
                this.titleMasterIndexs.clear();
                this.titleMasterIndexs = null;
            }
            BulletNumberManage.instance().dispose();
            System.gc();
        }
    }
}

